/* wptKeyManager.h - Key manager
 *	Copyright (C) 2001-2005 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * as published by the Free Software Foundation; either version 2 
 * of the License, or (at your option) any later version.
 *  
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 */

#ifndef WPT_KEYMANAGER_H
#define WPT_KEYMANAGER_H

#define send_cmd_id( hwnd, id ) \
    PostMessage ((hwnd), WM_COMMAND, MAKEWPARAM ((id), 0), NULL)


enum {
    KM_FLAG_REVOKED  = 0x01,
    KM_FLAG_EXPIRED  = 0x02,
    KM_FLAG_DISABLED = 0x04,
};


enum {
    KM_KS_REFRESH = 0x01
};

struct km_group_s {
    gpg_optfile_t   gh;
    HWND	    tree;
    unsigned int    need_sync:1;
};
typedef struct km_group_s * km_group_t;

struct km_group_cb_s {
    km_group_s *    gc;
    char	    name[256];
    int		    use_name;
};

/*-- wptFileManager.cpp --*/
int overwrite_file( const char * fname );

/*-- wptClipImportDlg.cpp --*/
void print_import_status( int *import_res, int is_revcert );

char* km_quote_uid( const char *uid );
int km_check_for_seckey (listview_ctrl_t lv, int pos, int * utrust);
int km_check_key_status( listview_ctrl_t lv, int pos );
int km_get_key_status( listview_ctrl_t lv, int pos );
int km_clip_export( HWND dlg, listview_ctrl_t lv);
int km_file_export( HWND dlg, listview_ctrl_t lv, const char *fname );
int km_privkey_export(HWND dlg, listview_ctrl_t lv, const char *fname );
void km_set_implicit_trust (HWND dlg, listview_ctrl_t lv, int pos);
int km_clip_import( HWND dlg );
int km_file_import( HWND dlg, const char *fname );
int km_http_import (HWND dlg, const char * url);
int km_delete_keys( listview_ctrl_t lv, HWND dlg );
int km_send_to_keyserver( listview_ctrl_t lv, HWND dlg, const char * host, unsigned short port);
int km_send_to_mail_recipient( listview_ctrl_t lv, HWND dlg );
void km_refresh_from_keyserver(listview_ctrl_t lv, HWND dlg);
void km_update_default_key_str( HWND dlg, int * ret_len );
void km_complete_status_bar( HWND sb, listview_ctrl_t lv, int startpos );
int km_check_if_protected( listview_ctrl_t lv, int pos );
int km_enable_disable_key( listview_ctrl_t lv, HWND dlg, int pos, int enable );
void km_set_clip_info( const char *uid );
int km_key_is_v3( listview_ctrl_t lv, int pos );

gpg_optfile_t km_groupdb_open( void );
int km_groupdb_expand_recipients( const char *name, gpgme_recipients_t rset );
int km_groups_new( km_group_t *r_gc, HWND ctrl );
void km_groups_release( km_group_t gc );
void km_groups_sync( km_group_t gc );
int km_groups_load( km_group_t gc );
int km_groups_add( km_group_t gc, listview_ctrl_t lv, int km_index );
int km_groups_del( km_group_t gc );

#endif /* WPT_KEYMANAGER_H */