/* rungpg.h -  gpg calling functions
 *	Copyright (C) 2000, 2001 Werner Koch (dd9jn), g10 Code GmbH
 *	Copyright (C) 2003, 2004 Timo Schulz
 *
 * This file is part of MyGPGME.
 *
 * MyGPGME is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MyGPGME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#ifndef GPGME_RUNGPG_H
#define GPGME_RUNGPG_H

#include "types.h"


typedef enum  {
    STATUS_EOF,
    /* mkstatus starts here */
    STATUS_ENTER	            , 
    STATUS_LEAVE	            ,
    STATUS_ABORT              ,

    STATUS_GOODSIG            ,
    STATUS_BADSIG	            ,
    STATUS_ERRSIG	            ,

    STATUS_BADARMOR           ,

    STATUS_RSA_OR_IDEA        ,
    STATUS_KEYEXPIRED         ,
    STATUS_KEYREVOKED         ,

    STATUS_TRUST_UNDEFINED    ,
    STATUS_TRUST_NEVER        ,
    STATUS_TRUST_MARGINAL     ,
    STATUS_TRUST_FULLY        ,
    STATUS_TRUST_ULTIMATE     ,

    STATUS_SHM_INFO           ,
    STATUS_SHM_GET	    ,
    STATUS_SHM_GET_BOOL       ,
    STATUS_SHM_GET_HIDDEN     ,

    STATUS_NEED_PASSPHRASE    ,    
    STATUS_VALIDSIG           ,
    STATUS_SIG_ID	            ,
    STATUS_ENC_TO	            ,
    STATUS_NODATA	            ,
    STATUS_BAD_PASSPHRASE     ,
    STATUS_NO_PUBKEY          ,
    STATUS_NO_SECKEY          ,
    STATUS_NEED_PASSPHRASE_PIN,
    STATUS_NEED_PASSPHRASE_SYM,
    STATUS_DECRYPTION_FAILED  ,
    STATUS_DECRYPTION_OKAY    ,
    STATUS_MISSING_PASSPHRASE ,
    STATUS_GOOD_PASSPHRASE    ,
    STATUS_GOODMDC            ,
    STATUS_BADMDC	            ,
    STATUS_ERRMDC	            ,
    STATUS_IMPORTED 	    ,
    STATUS_IMPORT_RES	    ,
    STATUS_IMPORT_CHECK	    ,
    STATUS_FILE_START	    ,
    STATUS_FILE_DONE	    ,
    STATUS_FILE_ERROR	    ,

    STATUS_BEGIN_DECRYPTION   ,
    STATUS_END_DECRYPTION     ,
    STATUS_BEGIN_ENCRYPTION   ,
    STATUS_END_ENCRYPTION     ,

    STATUS_DELETE_PROBLEM     ,
    STATUS_GET_BOOL 	    ,
    STATUS_GET_LINE 	    ,
    STATUS_GET_HIDDEN	    ,
    STATUS_GOT_IT	            ,
    STATUS_PROGRESS 	    ,
    STATUS_SIG_CREATED	    ,
    STATUS_SESSION_KEY        ,
    STATUS_NOTATION_NAME      ,
    STATUS_NOTATION_DATA      ,
    STATUS_POLICY_URL         ,
    STATUS_BEGIN_STREAM       ,
    STATUS_END_STREAM         ,
    STATUS_KEY_CREATED	    ,
    STATUS_USERID_HINT	    ,
    STATUS_UNEXPECTED         ,
    STATUS_INV_RECP           ,
    STATUS_NO_RECP            ,
    STATUS_ALREADY_SIGNED     ,
    STATUS_SIGEXPIRED         ,
    STATUS_EXPSIG             ,
    STATUS_EXPKEYSIG          ,
    STATUS_TRUNCATED          ,
    STATUS_REVKEYSIG	      ,
    STATUS_ERROR              ,
    STATUS_CARDCTRL,
    STATUS_SIG_SUBPACKET
} gpg_status_code_t;
typedef gpg_status_code_t gpg_statcode_t;

typedef void (*gpg_status_handler_t)( gpgme_ctx_t, gpg_status_code_t code, char *args ); 
typedef void (*gpg_logging_handler_t)( gpgme_ctx_t, char * line );
typedef void (*gpg_colon_line_handler_t)( gpgme_ctx_t, char * line ); 
typedef const char *(*gpg_command_handler_t)(void*, gpg_status_code_t code,
                                         const char * keyword);


gpgme_error_t _gpgme_gpg_new ( _gpg_object_t *r_gpg );
void       _gpgme_gpg_release( _gpg_object_t *r_gpg );
void       _gpgme_gpg_housecleaning (void);
gpgme_error_t _gpgme_gpg_add_arg ( _gpg_object_t gpg, const char *arg );
gpgme_error_t _gpgme_gpg_add_arg_concat (_gpg_object_t gpg, const char *arg1, const char *arg2);
gpgme_error_t _gpgme_gpg_add_data ( _gpg_object_t gpg, gpgme_data_t data, int dup_to );
void       _gpgme_gpg_set_status_handler ( _gpg_object_t gpg,
                                           gpg_status_handler_t fnc,
                                           void *fnc_value );
gpgme_error_t _gpgme_gpg_set_colon_line_handler ( _gpg_object_t gpg,
                                               gpg_colon_line_handler_t fnc,
                                               void *fnc_value );
gpgme_error_t _gpgme_gpg_set_simple_line_handler ( _gpg_object_t gpg,
                                                gpg_colon_line_handler_t fnc,
                                                void *fnc_value );
gpgme_error_t _gpgme_gpg_set_command_handler ( _gpg_object_t gpg,
                                            gpg_command_handler_t fnc,
                                            void *fnc_value );
void _gpgme_gpg_set_logging_handler( _gpg_object_t gpg, void * cb_val );
gpgme_error_t _gpgme_gpg_spawn ( _gpg_object_t gpg, void *opaque );
ulong _gpgme_gpg_getpid (_gpg_object_t gpg);
gpgme_error_t _gpgme_gpg_set_list_options (_gpg_object_t gpg, int opts);

#endif /* GPGME_RUNGPG_H */
