/* util.h 
 *	Copyright (C) 2000 Werner Koch (dd9jn)
 *	Copyright (C) 2000-2004 Timo Schulz 
 *
 * This file is part of MyGPGME.
 *
 * MyGPGME is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MyGPGME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#ifndef GPGME_UTIL_H
#define GPGME_UTIL_H

#include <windows.h>
#include <malloc.h>

#include "types.h"

#ifndef safe_free
#define safe_free(a) do { if (a) { free (a); a = NULL; } } while (0)
#endif

#define mk_error(a) (GPGME_##a)

#ifndef DIM
#define DIM(v) (sizeof (v)/sizeof ((v)[0]))
#endif
#define DIMof(type,member)   DIM(((type *)0)->member)
#ifndef STR
  #define STR(v) #v
#endif
#define STR2(v) STR(v)


void _gpgme_debug (int level, int line, const char *fname, 
				   const char *format, ... );
void _gpgme_debug_begin ( void **helper, int level, const char *text);
int  _gpgme_debug_enabled ( void **helper );
void _gpgme_debug_add (void **helper, const char *format, ...);
void _gpgme_debug_end (void **helper, const char *text);

#define _debug _gpgme_debug

#define DEBUG0(x) _debug (1,  __LINE__, __FILE__, x )
#define DEBUG1(x,a)	_debug (1,  __LINE__, __FILE__, x, (a) )
#define DEBUG2(x,a,b) _debug (1,  __LINE__, __FILE__, x, (a), (b) )
#define DEBUG3(x,a,b,c) _debug (1,  __LINE__, __FILE__, x, (a), (b), (c) )
#define DEBUG4(x,a,b,c,d) _debug (1,  __LINE__, __FILE__, x, (a), (b), (c),\
															 (d) )
#define DEBUG5(x,a,b,c,d,e) _debug (1,  __LINE__, __FILE__, x, (a), (b), \
																(c), (d), (e) )
#define DEBUG6(x,a,b,c,d,e,f) _debug (1,  __LINE__, __FILE__, x, (a), (b), \
									  (c), (d), (e), (f) )
#define DEBUG7(x,a,b,c,d,e,f,g) _debug (1,  __LINE__, __FILE__, x, (a), \
										(b), (c), (d), (e), (f), (g) )
#define DEBUG8(x,a,b,c,d,e,f,g,h) _debug (1, __LINE__, __FILE__ x, (a), (b), \
										  (c), (d), (e), (f), (g), (h) )
#define DEBUG9(x,a,b,c,d,e,f,g,h,i) _debug (1,  __LINE__, __FILE__ x, (a), (b), \
										   (c), (d), (e), (f), (g), (h), (i) )
#define DEBUG10(x,a,b,c,d,e,f,g,h,i,j) _debug (1,  __LINE__, __FILE__, x, (a), \
								(b), (c), (d), (e), (f), (g), (h), (i), (j) )

#define DEBUG_BEGIN(y,x)  _gpgme_debug_begin (&(y), 1,  __FILE__ ":" \
     STR2 (__LINE__) ": " x )
#define DEBUG_ENABLED(y)  _gpgme_debug_enabled(&(y))
#define DEBUG_ADD0(y,x)                 _gpgme_debug_add (&(y), (x), \
                       )
#define DEBUG_ADD1(y,x,a)               _gpgme_debug_add (&(y), (x), \
                      (a) )
#define DEBUG_ADD2(y,x,a,b)             _gpgme_debug_add (&(y), (x), \
                      (a), (b) )
#define DEBUG_ADD3(y,x,a,b,c)           _gpgme_debug_add (&(y), (x), \
                      (a), (b), (c) )
#define DEBUG_ADD4(y,x,a,b,c,d)         _gpgme_debug_add (&(y), (x), \
                      (a), (b), (c), (d) )
#define DEBUG_ADD5(y,x,a,b,c,d,e)       _gpgme_debug_add (&(y), (x), \
                      (a), (b), (c), (d), (e) )
#define DEBUG_END(y,x)  _gpgme_debug_end (&(y), (x) )

#ifndef HAVE_STPCPY
char *stpcpy (char *a, const char *b);
#endif

#ifndef HAVE_STRSEP
char * strsep (char **stringp, const char *delim);
#endif

#ifndef HAVE_MEMISTR
const char *memistr( const char *buf, size_t buflen, const char *sub );
#endif

#define return_if_fail(expr) do {                        \
    if (!(expr)) {                                       \
        fprintf (stderr, "%s:%d: assertion `%s' failed", \
                 __FILE__, __LINE__, #expr );            \
        return;	                                         \
    } } while (0)
#define return_null_if_fail(expr) do {                   \
    if (!(expr)) {                                       \
        fprintf (stderr, "%s:%d: assertion `%s' failed", \
                 __FILE__, __LINE__, #expr );            \
        return NULL;	                                 \
    } } while (0)
#define return_val_if_fail(expr,val) do {                \
    if (!(expr)) {                                       \
        fprintf (stderr, "%s:%d: assertion `%s' failed", \
                 __FILE__, __LINE__, #expr );            \
        return (val);	                                 \
    } } while (0)


FILE * my_fopen (const char * fname, const char * mode);
/*-- {posix,w32}-util.c --*/
const char *_gpgme_get_gpg_path (void);
char * _gpgme_get_gpg_optfile(void);
const char * _gpgme_get_gpg_keyring( const char *keyring );

#endif /* GPGME_UTIL_H */
