/* wptGPGOptDlg.cpp - WinPT GnuPG Options
 *	Copyright (C) 2001, 2002, 2003 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <windows.h>

#include "wptTypes.h"
#include "wptNLS.h"
#include "wptGPG.h"
#include "wptCommonCtl.h"
#include "wptContext.h" /* for passphrase_s */
#include "wptDlgs.h"
#include "wptW32API.h"
#include "wptErrors.h"
#include "../resource.h"


BOOL CALLBACK
gpgopt_dlg_proc( HWND dlg, UINT msg, WPARAM wparam, LPARAM lparam )
{	
    int id, nbytes = 8192;
    char t[4], *optbuf = NULL;
    
    switch( msg )  {
    case WM_INITDIALOG:	  
	optbuf = get_gnupg_config ();
	if( !optbuf )
	    dlg_fatal_error( dlg,  _("Could not load GnuPG config file!") );
	#ifndef LANG_DE
	SetWindowText( dlg, _("GnuPG Options" ) );
	SetDlgItemText( dlg, IDC_GPGOPT_FILE, optbuf );
	SetDlgItemText( dlg, IDC_GPGOPT_SAVE, _("&Save") );
	SetDlgItemText( dlg, IDC_GPGOPT_LOAD, _("&Load") );
	#endif
	free_if_alloc( optbuf );
	SetForegroundWindow( dlg );
	return TRUE;
        
    case WM_SYSCOMMAND:
	if( LOWORD (wparam) == SC_CLOSE )
	    EndDialog(dlg, TRUE);
	return FALSE;
        
    case WM_COMMAND:
        switch( LOWORD( wparam ) ) {
        case IDC_GPGOPT_SAVE:		    
            optbuf = new char[nbytes + 1];
            if( !optbuf )
		BUG( dlg);
            nbytes = GetDlgItemText( dlg, IDC_GPGOPT_FILE, optbuf, nbytes );
            if( !nbytes ) {
                msg_box( dlg, _("The 'gpg.conf' file is not loaded."), _("Options"), MB_ERR );
                free_if_alloc( optbuf );
                return FALSE;		
            }
            optbuf[nbytes] = '\0';
            if( check_gnupg_options( optbuf ) ) {
                msg_box( dlg, _("File contains invalid GnuPG keywords!"), _("Options"), MB_ERR );
                free_if_alloc( optbuf );
                return FALSE;
            }
            if( set_gnupg_options( optbuf, strlen( optbuf ) ) ) {
                msg_box( dlg, _("Could not save GnuPG options file."), _("Options"), MB_ERR );
                free_if_alloc( optbuf );
                return FALSE;
            }
            msg_box( dlg, _("Successfully saved."), _("Options"), MB_OK );
            free_if_alloc( optbuf );
            return TRUE;
            
        case IDC_GPGOPT_LOAD:			
            if( GetDlgItemText(dlg, IDC_GPGOPT_FILE, t, sizeof t - 1 ) ) {
                id = msg_box( dlg, _("Current data will be lost!\n"
                                     "Are you sure?"), _("Options"), MB_INFO|MB_YESNO );			
                if( id == IDNO )
                    return TRUE;
            }
            optbuf = get_gnupg_config ();
            if( !optbuf )
                msg_box( dlg, _("Could not load GnuPG options file!"), _("Options"), MB_ERR );
            SetDlgItemText( dlg, IDC_GPGOPT_FILE, optbuf );
            free_if_alloc( optbuf );
            return TRUE;
            
        case IDCANCEL:
            EndDialog( dlg, FALSE );
            return FALSE;
        }
        break;
    }
    
    return 0;
} /* gpgopt_dlg_proc */
