/* wptImagelist.cpp - Imagelist helper routines
 *	Copyright (C) 2003 Andreas Jobs
 *	Copyright (C) 2004 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * as published by the Free Software Foundation; either version 2 
 * of the License, or (at your option) any later version.
 *  
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 */

#include <windows.h>
#include <commctrl.h>

#include "wptTypes.h"
#include "wptErrors.h"
#include "wptNLS.h"
#include "wptW32API.h"
#include "../resource.h"
#include "wptCommonCtl.h"
#include "wptVersion.h"

int il_map[IMAGELIST_NUMIMAGES];


#define replace_icon(resid) \
    ImageList_ReplaceIcon (glob_imagelist, -1, \
			   LoadIcon (glob_hinst, MAKEINTRESOURCE (resid)))

int
imagelist_load (HWND hwnd)
{
    glob_imagelist = ImageList_Create (16, 16, ILC_COLOR|ILC_MASK, 
				       IMAGELIST_NUMIMAGES, 0);
    if (!glob_imagelist) {
        msg_box (hwnd, _("Could not create imagelist."), _("Key Manager"), MB_ERR);
	return -1;
    }

    il_map[IMI_KEY_DELETE]     = replace_icon (IDI_KEY_DELETE);
    il_map[IMI_KEY_PROPS]      = replace_icon (IDI_KEY_PROPS);
    il_map[IMI_KEY_SIGN]       = replace_icon (IDI_KEY_SIGN);
    il_map[IMI_KEY_IMPORT]     = replace_icon (IDI_KEY_IMPORT);
    il_map[IMI_KEY_EXPORT]     = replace_icon (IDI_KEY_EXPORT);
    il_map[IMI_SORT_UPARROW]   = replace_icon (IDI_SORT_UPARROW);
    il_map[IMI_SORT_DOWNARROW] = replace_icon (IDI_SORT_DOWNARROW);
    /*il_map[IMI_EXIT]         = replace_icon (IDI_EXIT);*/
    return 0;
} /* imagelist_load */


int
imagelist_destroy (void)
{
    ImageList_Destroy (glob_imagelist);
    glob_imagelist = NULL;
    return 0;
} /* imagelist_destroy */


int
imagelist_getindex (int icon)
{
    if ((icon < 0) || (icon >= IMAGELIST_NUMIMAGES))
        return -1;
    return il_map[icon];
} /* imagelist_getindex */