// ---------------------------------------------------------------------------
//	class SoundBuffer 
//	Copyright (C) cisc 1999.
// ---------------------------------------------------------------------------
//	$Id: soundbuf.h,v 1.2 1999/07/05 14:38:47 cisc Exp $

#ifndef common_soundbuf_h
#define common_soundbuf_h

#include "types.h"
#include "critsect.h"

// ---------------------------------------------------------------------------
//	SoundBuffer
//
class SoundBuffer
{
public:
	typedef int16 Sample;

public:
	SoundBuffer();
	~SoundBuffer();

	bool Init(int nch, int bufsize);	// bufsize ̓TvP
	void Cleanup();

	void Put(int sample);				// obt@ɍő sample f[^ǉ
	void Get(Sample* ptr, int sample);	// obt@ sample ̃f[^𓾂
	bool IsEmpty();
	void FillWhenEmpty(bool f);			// obt@ɂȂ[邩

	virtual void Mix(Sample* buffer, int sample) = 0;	// sample ̃f[^

private:
	void PutMain(int sample);
	
	Sample* buffer;
	CriticalSection cs;
	
	int buffersize;						// obt@̃TCY (in samples)
	int read;							// Ǎʒu (in samples)
	int write;							// ݈ʒu (in samples)
	int ch;								// `l(1sample = ch*Sample)
	bool fillwhenempty;
};

// ---------------------------------------------------------------------------

inline void SoundBuffer::FillWhenEmpty(bool f)
{
	fillwhenempty = f;
}

#endif // common_soundbuf_h
