// ---------------------------------------------------------------------------
//	OPN Sound Generator
//	Copyright (C) cisc 1998, 1999.
// ---------------------------------------------------------------------------
//	$Id: opna.h,v 1.4 1999/06/19 14:17:37 cisc Exp $

#ifndef FM_OPNA_H
#define FM_OPNA_H

#include "FMGen.h"

namespace FM
{
	//	OPN Base -------------------------------------------------------
	class OPNBase
	{
	public:
		OPNBase();
		bool	Init(uint c, uint r);
		virtual void Reset();
		bool	Count(int32 us);
		int32	GetNextEvent();
	
	protected:
		virtual void SetStatus(uint8 bit) = 0;
		virtual void ResetStatus(uint8 bit) = 0;
		void	SetParameter(Channel4* ch, uint addr, uint data);
		void	SetControl(uint addr, uint data);
		void	RebuildTimeTable();
		
		Channel4* csmch;
		
		uint	clock;
		uint	rate;
		uint8	status;
		uint8	reg27;
	
	private:
		void	SetPrescaler(uint p);
		uint8	prescale;
		uint8	reg24[2];
		
		int32	timera;
		int32	timera_count;
		int32	timerb;
		int32	timerb_count;
		int32	timer_count;
		int32	timer_step;
	};

	//	YM2203(OPN) ----------------------------------------------------
	class OPN : public OPNBase
	{
	public:
		OPN();
		virtual ~OPN() {}
		
		bool	Init(uint c, uint r, bool);
		bool	SetRate(uint c, uint r, bool);
		
		void	Reset();
		void 	Mix(Sample* buffer, int nsamples);
		void 	SetReg(uint addr, uint data);
		uint	GetReg(uint addr);
		uint	ReadStatus() { return status & 0x03; }
		uint	ReadStatusEx() { return 0xff; }
		
	private:
		virtual void Intr(bool) {}
		void	SetStatus(uint8 bit);
		void	ResetStatus(uint8 bit);
		
		uint	fnum[3];
		uint	fnum3[3];
		
		uint8	rega0[16];
		
		Channel4 ch[3];
	};

	//	YM2608(OPNA) ---------------------------------------------------
	class OPNA : public OPNBase
	{
	public:
		OPNA();
		virtual ~OPNA();
		
		bool	Init(uint c, uint r, bool ipflag = false);
		bool	SetRate(uint c, uint r, bool ipflag = false);

		void	Reset();
		void 	Mix(Sample* buffer, int nsamples);
		void 	SetReg(uint addr, uint data);
		uint	GetReg(uint addr);
		uint	ReadStatus() { return status & 0x03; }
		uint	ReadStatusEx();

		void	SetVolumeFM(int db);
		void	SetVolumeADPCM(int db);
		void	SetVolumeRhythmTotal(int db);
		void	SetVolumeRhythm(int index, int db);
		
	private:
		void 	Mix3(Sample* buffer, int nsamples);
		void 	Mix3I(Sample* buffer, int nsamples);
		void 	Mix6(Sample* buffer, int nsamples);
		void 	Mix6I(Sample* buffer, int nsamples);
		
		virtual void Intr(bool) {}
		void	SetStatus(uint8 bit);
		void	ResetStatus(uint8 bit);
		void	UpdateStatus();

		void	DecodeADPCM();
		void	ADPCMMix(Sample* dest, uint count);
		void	RhythmMix(Sample* buffer, uint count);
		void	LoadRhythmSample();
		
	// `ԗp[N
		int32	mixl, mixr;		
		int32	mixdelta;
		bool	interpolation;
		
	// FM ֌W
		uint8	reg29;
		uint8	reg22;
		uint8	stmask;
		uint8	statusnext;

		uint32	lfocount;
		uint32	lfodcount;
		
		uint	fnum[6];
		uint	fnum3[6];
		int		fmvolume;
		
		uint8	pan[6];
		uint8	rega0[16];
		uint8	reg1a0[16];

	// ADPCM ֌W
		uint8*	adpcmbuf;		// ADPCM RAM
		uint	startaddr;		// Start address
		uint	stopaddr;		// Stop address
		uint	memaddr;		// ĐAhX
		uint	limitaddr;		// Limit address
		int		adpcmlevel;		// ADPCM 
		int		adpcmvolume;
		int		adpcmvol;
		uint	deltan;			// N
		int		adplc;			// gϊpϐ
		int		adpld;			// gϊpϐl
		uint	adplbase;		// adpld ̌
		int		adpcmx;			// ADPCM p x
		int		adpcmd;			// ADPCM p 
		int		adpcmout;		// ADPCM ̏o
		int		adpcmprev;		// ADPCM Ȍo
		int		apout0;			// out(t-2)+out(t-1)
		int		apout1;			// out(t-1)+out(t)

		uint8	adpcmdata;		// ADPCM f[^z_
		bool	adpcmhalf;		// adpcmdata Ƀf[^
		bool	adpcmplay;		// ADPCM Đ

		uint8	granuality;		// ADPCM AhXw藱x
		uint8	control1;		// ADPCM Rg[WX^P
		uint8	control2;		// ADPCM Rg[WX^Q
		uint8	adpcmreg[8];	// ADPCM WX^̈ꕔ

	// Y֌W
		uint8	rhythmpan[6];	// Y PAN
		int8	rhythmil[6];	// Ỷ
		int8	rhythmtl;		// YŜ̉
		uint8	rhythmkey;		// ỸL[
		int		rhythmivol[6];	// Ỷω
		int		rhythmtvol;		// YŜ̉ω

		int16*	rhythmsample[6];// YTv
		int16*	rhythmlim[6];	// YTv̍Ō+1
		int16*	rhythmptr[6];	// Đ̃|C^
		uint	rhythmstep;		// rhythmptr ̑l
 
		Channel4 ch[6];
	};
}

// ---------------------------------------------------------------------------

inline void FM::OPNBase::RebuildTimeTable()
{
	int p = prescale;
	prescale = 0;
	SetPrescaler(p);
}

#endif // FM_OPNA_H
