// ---------------------------------------------------------------------------
//	PC-8801 emulator
//	Copyright (C) cisc 1999.
// ---------------------------------------------------------------------------
//	$Id: pc88.h,v 1.22 1999/06/29 13:24:34 cisc Exp $

#ifndef pc88_h
#define pc88_h

#include "schedule.h"
#include "device.h"
#include "Z80C.h"
#include "Z80_x86.h"
#include "Z80Test.h"
#include "Z80Debug.h"

#include "pc88/memory.h"
#include "pc88/pd8257.h"
#include "pc88/kanjirom.h"
#include "pc88/screen.h"
#include "pc88/intc.h"
#include "pc88/crtc.h"
#include "pc88/base.h"
#include "pc88/fdc.h"
#include "pc88/subsys.h"
#include "pc88/diskmgr.h"
#include "pc88/sio.h"
#include "pc88/cdif.h"
#include "pc88/opnif.h"

namespace PC8801
{
	class Config;
}
class Draw;

class PC88 : public Scheduler
{
public:
//	typedef Z80Debug Z80;
	typedef Z80C Z80;
//	typedef Z80_x86 Z80;
//	typedef Z80Test Z80;

	PC88();
	~PC88();
	bool Init(Draw* draw);
	int Proceed(uint us, uint clock);
	void UpdateScreen();
	void Reset();
	void ApplyConfig(PC8801::Config*);
	
	uint GetCPUTick() { return cpu1.GetCount(); }
	uint GetCPUSpeed() { return clock; }
	
	DiskManager* GetDiskManager() { return &diskmgr; }
	
	Bus* GetBus() { return &bus1; }
	PC8801::INTC* GetIntc() { return &intc; }
	PC8801::Base* GetBase() { return &base; }
	PC8801::PD8257* GetDMAC() { return &dmac; }
	PC8801::Memory* GetMem1() { return &mem1; }
	PC8801::OPNIF* GetOPN1() { return &opn1; }
	PC8801::OPNIF* GetOPN2() { return &opn2; }
	
public:
	enum SpecialPort
	{
		pint0 = 0x100, 
		pint1, pint2, pint3, pint4, pint5, pint6, pint7,
		pres,			// reset
		pirq,			// IRQ
		piack,			// interrupt acknowledgement
		vrtc,			// vertical retrace
		popnio,			// OPN ̓o̓|[g 1
		popnio2,		// OPN ̓o̓|[g 2 (A)
		portend
	};
	enum SpecialPort2
	{
		pres2 = 0x100,
		pirq2,
		piac2,
		portend2
	};

private:
	int Execute(int ticks);
	void Shorten(int ticks);
	bool ConnectDevices();
	bool ConnectDevices2();
	int GetTicks();
	
	void DumpMemory();
			
#ifndef __OS2__
private:
#else
public:
#endif
	enum CPUMode
	{
		ms11 = 0, ms21 = 1,		// bit 0
		stopwhenidle = 4,		// bit 2
	};
	
	Draw* draw;
	Draw::Region region;
	int clock;
	bool palchanged;
	uint refreshcount;
	uint refreshtiming;
	int cpumode;
	int dexc;
	uint cfgflags;
	uint cfgflag2;
	
	Z80 cpu1;
	Z80 cpu2;
	Bus bus1;
	Bus bus2;
	PC8801::Memory mem1;
	PC8801::PD8257 dmac;
	PC8801::KanjiROM knj1;
	PC8801::KanjiROM knj2;
	PC8801::Screen scrn;
	PC8801::INTC intc;
	PC8801::CRTC crtc;
	PC8801::Base base;
	PC8801::FDC fdc;
	PC8801::SubSystem subsys;
	PC8801::SIO sio;
	PC8801::CDIF cdif;
	PC8801::OPNIF opn1;
	PC8801::OPNIF opn2;
	DiskManager diskmgr;
#ifndef __OS2__
	friend class PC8801::Base;
#endif
};

#endif // pc88_h
