/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
#define INCL_PM
#define INCL_DOS
#define INCL_DOSERRORS
#define INCL_OS2MM
#include <OS2.H>
#include <OS2ME.H>
#include <mmioos2.h>
#include <memory.h>

#include <stdlib.h>

/* MMPM2.LIBNpɎw */
#pragma library("MMPM2.LIB");

#define USE_ASM                                 /* AZu */

#define STATIC static
#define MAX_BUFFER_NUMBER (4)



#define RING_BUFFER_SIZE  (8 * 1024 * 1024)     /* 8MoCgmۂ */


typedef struct {
    HMTX hmtxSound;             /* TEhobt@ANZXrpZ}tH */

    /* Oobt@֘A */
    LONG  lRingBufferSize;
    BYTE  *RingBuffer;
    LONG  lRingBufferWrite;
    LONG  lRingBufferRead;

    /* DART֘A */
    USHORT usDartDeviceID;

} DART_SOUND;




STATIC DART_SOUND dart;


MCI_MIX_BUFFER     MixBuffers[MAX_BUFFER_NUMBER];
MCI_MIXSETUP_PARMS MixSetupParms;             /* Mixer parameters        */
MCI_BUFFER_PARMS   BufferParms;               /* Device buffer parms     */

static LONG APIENTRY SoundEvent( ULONG ulStatus, PMCI_MIX_BUFFER  pBuffer, ULONG  ulFlags );

extern BOOL InitSound( void );
extern BOOL TermSound( void );
extern BOOL sndWrite( SHORT sLeft, SHORT sRight );
extern BOOL sndBlockWrite( PVOID *pvData, LONG lBytes );

BOOL InitSound( void )
{
    MCI_AMP_OPEN_PARMS AmpOpenParms;
    MCI_GENERIC_PARMS  GenericParms;
    register ULONG ulIndex;

    memset( &dart, 0, sizeof(DART_SOUND) );

    /* Oobt@̊m */
    dart.lRingBufferSize = RING_BUFFER_SIZE; /* Oobt@̃TCY */
    dart.RingBuffer      = (BYTE *)malloc( dart.lRingBufferSize );
    if(dart.RingBuffer == NULL) {
        /* Oobt@̊mۂɎs */
        return FALSE;
    }
    memset( dart.RingBuffer, 0, dart.lRingBufferSize );

    /* TEhpɃZ}tH */
    if(DosCreateMutexSem( NULL, &dart.hmtxSound, 0L, FALSE )) {
        free( dart.RingBuffer ); dart.RingBuffer = NULL; /* Oobt@̊m */
        return FALSE;
    }

    memset( &AmpOpenParms, 0, sizeof(MCI_AMP_OPEN_PARMS) );
    AmpOpenParms.usDeviceID    = 0; /* ftHg̃TEhfoCXI */
    AmpOpenParms.pszDeviceType = (PSZ)MCI_DEVTYPE_AUDIO_AMPMIX;
    if(mciSendCommand( 0, MCI_OPEN, MCI_WAIT | MCI_OPEN_TYPE_ID | MCI_OPEN_SHAREABLE, (PVOID)&AmpOpenParms, 0 )) {
        DosCloseMutexSem( dart.hmtxSound ); dart.hmtxSound = NULLHANDLE; /* Z}tH         */
        free( dart.RingBuffer ); dart.RingBuffer = NULL;                 /* Oobt@̊m */
        return FALSE;
    }
    dart.usDartDeviceID = AmpOpenParms.usDeviceID;

    memset( &MixSetupParms, 0, sizeof(MCI_MIXSETUP_PARMS) );
    MixSetupParms.ulSamplesPerSec = 44100/2;
    MixSetupParms.ulBitsPerSample = 16;
    MixSetupParms.ulChannels      = 2;
    MixSetupParms.ulFormatTag     = MCI_WAVE_FORMAT_PCM;
    MixSetupParms.ulFormatMode    = MCI_PLAY;
    MixSetupParms.ulDeviceType    = MCI_DEVTYPE_WAVEFORM_AUDIO;
//    MixSetupParms.pmixEvent       = SoundEvent;
    MixSetupParms.pmixEvent       = DriverDS::TimeProc;
    if(mciSendCommand( dart.usDartDeviceID, MCI_MIXSETUP, MCI_WAIT | MCI_MIXSETUP_INIT, (PVOID)&MixSetupParms, 0 )) {
        mciSendCommand( dart.usDartDeviceID, MCI_CLOSE, MCI_WAIT, (PVOID)&GenericParms, 0 );
        DosCloseMutexSem( dart.hmtxSound ); dart.hmtxSound = NULLHANDLE; /* Z}tH */
        free( dart.RingBuffer ); dart.RingBuffer = NULL;                 /* Oobt@̊m */
        return FALSE;
    }

    memset( &BufferParms, 0, sizeof(MCI_BUFFER_PARMS) );
    BufferParms.ulStructLength = sizeof(BufferParms);
    BufferParms.ulNumBuffers = MAX_BUFFER_NUMBER;
    BufferParms.ulBufferSize = MixSetupParms.ulBufferSize;
    BufferParms.pBufList     = MixBuffers;
    if(mciSendCommand( dart.usDartDeviceID, MCI_BUFFER, MCI_WAIT | MCI_ALLOCATE_MEMORY, (PVOID)&BufferParms, 0 ))
    {
        mciSendCommand( dart.usDartDeviceID, MCI_CLOSE, MCI_WAIT, (PVOID)&GenericParms, 0 );
        DosCloseMutexSem( dart.hmtxSound ); dart.hmtxSound = NULLHANDLE; /* Z}tH */
        free( dart.RingBuffer ); dart.RingBuffer = NULL;                 /* Oobt@̊m */
        return FALSE;
    }

    for(ulIndex = 0; ulIndex < BufferParms.ulNumBuffers; ulIndex++)
    {
        memset( MixBuffers[ulIndex].pBuffer, 0, MixBuffers[ulIndex].ulBufferLength );
        MixBuffers[ulIndex].ulFlags    = 0;
        MixBuffers[ulIndex].ulUserParm = 0;
    }

    dart.lRingBufferWrite = 0;
    dart.lRingBufferRead = 0;

    MixSetupParms.pmixWrite( MixSetupParms.ulMixHandle, MixBuffers, 2 );
    return TRUE;
}

BOOL TermSound( void )
{
    MCI_GENERIC_PARMS GenericParms;

    /* TEhobt@ւ̃ANZX擾 */
    if(dart.hmtxSound) {
        DosRequestMutexSem( dart.hmtxSound, 2000 /* 2b҂ */ );
    }

    mciSendCommand( dart.usDartDeviceID, MCI_CLOSE, MCI_WAIT, (PVOID)&GenericParms, 0 );
    if(dart.hmtxSound)  { DosCloseMutexSem( dart.hmtxSound ); dart.hmtxSound = NULLHANDLE; } /* Z}tH */
    if(dart.RingBuffer) { free( dart.RingBuffer ); dart.RingBuffer = NULL; }                 /* Oobt@̊m */
    return TRUE;
}

BOOL sndWrite( SHORT sLeft, SHORT sRight )
{
    register ULONG rc;
    register LONG  lFree;
    register LONG  lBytes = 4;

    /* TEhobt@ւ̃ANZX擾 */
    rc = DosRequestMutexSem( dart.hmtxSound, 1000 /* 1b҂ */ );
    if(rc != NO_ERROR) {
        /* ANZX擾Ɏs */
        return FALSE;
    }

    /* obt@̋󂫗eʂvZ */
    if(dart.lRingBufferRead <= dart.lRingBufferWrite) {
        lFree = dart.lRingBufferSize + dart.lRingBufferRead - dart.lRingBufferWrite;
    } else {
        lFree = dart.lRingBufferRead - dart.lRingBufferWrite;
    }

    if(lBytes > lFree) lBytes = (lFree - 4);
    if(lBytes < 0) {
        /* obt@ɋ󂫂Ȃ */
        DosReleaseMutexSem( dart.hmtxSound );
        return FALSE;
    }

    if(dart.lRingBufferSize - dart.lRingBufferWrite >= lBytes) {
        // xŏꍇ
        ULONG l = (((ULONG)sLeft) << 16) | ((ULONG)sRight);
        memcpy( &dart.RingBuffer[dart.lRingBufferWrite], &l, lBytes );
    } else {
        // Qxɕďꍇ
//        memcpy( &dart.RingBuffer[dart.lRingBufferWrite], , dart.lRingBufferSize - dart.lRingBufferWrite );
//        memcpy( &dart.RingBuffer[0],                     , lBytes - (dart.lRingBufferSize - dart.lRingBufferWrite) );
//        Mix( &dart.RingBuffer[dart.lRingBufferWrite], dart.lRingBufferSize - dart.lRingBufferWrite      );
//        Mix( &dart.RingBuffer[0],                     lBytes - (dart.lRingBufferSize - dart.lRingBufferWrite) );
    }

    /* ݈ʒui߂ */
    dart.lRingBufferWrite += lBytes;
    if(dart.lRingBufferWrite >= dart.lRingBufferSize) dart.lRingBufferWrite -= dart.lRingBufferSize;

    /* TEhobt@ւ̃ANZX̉ */
    DosReleaseMutexSem( dart.hmtxSound );
    return TRUE;
}

BOOL sndBlockWrite( PVOID *pvData, LONG lBytes )
{
    register ULONG rc;
    register LONG  lFree;

    /* TEhobt@ւ̃ANZX擾 */
    rc = DosRequestMutexSem( dart.hmtxSound, 1000 /* 1b҂ */ );
    if(rc != NO_ERROR) {
        /* ANZX擾Ɏs */
        return FALSE;
    }

    /* obt@̋󂫗eʂvZ */
    if(dart.lRingBufferRead <= dart.lRingBufferWrite) {
        lFree = dart.lRingBufferSize + dart.lRingBufferRead - dart.lRingBufferWrite;
    } else {
        lFree = dart.lRingBufferRead - dart.lRingBufferWrite;
    }

    if(lBytes > lFree) lBytes = (lFree - 4);
    if(lBytes < 0) {
        /* obt@ɋ󂫂Ȃ */
        DosReleaseMutexSem( dart.hmtxSound );
        return FALSE;
    }

    if(dart.lRingBufferSize - dart.lRingBufferWrite >= lBytes) {
        // xŏꍇ
//        Mix( &dart.RingBuffer[dart.lRingBufferWrite], lBytes );
        memcpy( &dart.RingBuffer[dart.lRingBufferWrite], pvData, lBytes );
    } else {
        // Qxɕďꍇ
//        Mix( &dart.RingBuffer[dart.lRingBufferWrite], dart.lRingBufferSize - dart.lRingBufferWrite            );
//        Mix( &dart.RingBuffer[0],                     lBytes - (dart.lRingBufferSize - dart.lRingBufferWrite) );
        memcpy( &dart.RingBuffer[dart.lRingBufferWrite], pvData, dart.lRingBufferSize - dart.lRingBufferWrite );
        (ULONG)pvData += dart.lRingBufferSize - dart.lRingBufferWrite;
        memcpy( &dart.RingBuffer[dart.lRingBufferWrite], pvData, lBytes - (dart.lRingBufferSize - dart.lRingBufferWrite) );
    }

    /* ݈ʒui߂ */
    dart.lRingBufferWrite += lBytes;
    if(dart.lRingBufferWrite >= dart.lRingBufferSize) dart.lRingBufferWrite -= dart.lRingBufferSize;

    /* TEhobt@ւ̃ANZX̉ */
    DosReleaseMutexSem( dart.hmtxSound );
    return TRUE;
}

static LONG APIENTRY SoundEvent( ULONG ulStatus, PMCI_MIX_BUFFER pBuffer, ULONG  ulFlags )
{
    BYTE *dest;
    LONG bytes;
    int rc;

    switch( ulFlags )
    {
        case MIX_WRITE_COMPLETE:           /* for playback  */
            rc = DosRequestMutexSem( dart.hmtxSound, 1000 /* 1b҂ */ );
            if(rc != NO_ERROR) {
                /* ANZX擾Ɏs */
                return FALSE;
            }
            DosEnterCritSec();
            dest  = pBuffer->pBuffer;
            bytes = pBuffer->ulBufferLength;
            while (bytes > 0)
            {
                int avail;
                int xsize;
                xsize = bytes;
                if(bytes > dart.lRingBufferSize - 4)                    { xsize = dart.lRingBufferSize - 4; }
                if(xsize > dart.lRingBufferSize - dart.lRingBufferRead) { xsize = dart.lRingBufferSize - dart.lRingBufferRead; }

                if(dart.lRingBufferWrite >= dart.lRingBufferRead) {
                    avail = dart.lRingBufferWrite - dart.lRingBufferRead;
                } else {
                    avail = dart.lRingBufferSize + dart.lRingBufferWrite - dart.lRingBufferRead;
                }

                if (xsize > avail) {
                    /* ԂɍȂ */
//                    Store( xsize - avail );
                    register LONG  lFree;
                    register LONG  lBytes;
                    lBytes = xsize - avail;

                    /* obt@̋󂫗eʂvZ */
                    if(dart.lRingBufferRead <= dart.lRingBufferWrite) {
                        lFree = dart.lRingBufferSize + dart.lRingBufferRead - dart.lRingBufferWrite;
                    } else {
                        lFree = dart.lRingBufferRead - dart.lRingBufferWrite;
                    }

                    if(lBytes > lFree) lBytes = (lFree - 4);
                    if(lBytes < 0) {
                        DosExitCritSec();
                        return FALSE;
                    }

                    if(dart.lRingBufferSize - dart.lRingBufferWrite >= lBytes) {
                        // xŏꍇ
                        memset( &dart.RingBuffer[dart.lRingBufferWrite], 0, lBytes );
                    } else {
                        memset( &dart.RingBuffer[dart.lRingBufferWrite], 0, dart.lRingBufferSize - dart.lRingBufferWrite );
                        memset( &dart.RingBuffer[dart.lRingBufferWrite], 0, lBytes - (dart.lRingBufferSize - dart.lRingBufferWrite) );
                    }

                    /* ݈ʒui߂ */
                    dart.lRingBufferWrite += lBytes;
                    if(dart.lRingBufferWrite >= dart.lRingBufferSize) dart.lRingBufferWrite -= dart.lRingBufferSize;
                }

                memcpy( dest, dart.RingBuffer + dart.lRingBufferRead, xsize);
                dart.lRingBufferRead += xsize;
                dest                 += xsize;
                bytes                -= xsize;
                if(dart.lRingBufferRead >= dart.lRingBufferSize) {
                    dart.lRingBufferRead -= dart.lRingBufferSize;
                }
            }
            /* TEhobt@ւ̃ANZX̉ */
            DosReleaseMutexSem( dart.hmtxSound );
            MixSetupParms.pmixWrite( MixSetupParms.ulMixHandle, pBuffer, 1 );
            DosExitCritSec();
            break;

        case MIX_STREAM_ERROR | MIX_READ_COMPLETE :  /* error occur in device */
//        case MIX_STREAM_ERROR | MIX_WRITE_COMPLETE:  /* error occur in device */
            break;

   }
   return TRUE;
}
