
/*
 * Transdisk V3
 * Copyright 1995,1996 Bernd Schmidt, Marcus Sundberg
 *
 * Use DICE and 2.0 includes or above to compile
 */

#include <stdio.h>

#include <exec/devices.h>
#include <exec/io.h>
#include <exec/memory.h>
#include <devices/trackdisk.h>

#include <clib/alib_protos.h>
#include <clib/exec_protos.h>

static void usage()
{
    fprintf(stderr, "Usage: transdisk options\n");
    fprintf(stderr, "Recognized options:\n");
    fprintf(stderr, "-d device unit: Use this device instead of DF0:\n");
    fprintf(stderr, "-s n: Begin transfer at track n\n");
    fprintf(stderr, "-e n: End transfer at track n\n");
    fprintf(stderr, "Example:\n");
    fprintf(stderr, "transdisk >RAM:df1.adf.1 -d trackdisk 1 -s 0 -e 39\n");
    fprintf(stderr, "transfers the first half of the floppy in DF1: into\n");
    fprintf(stderr, "a file in the RAM disk.\n");
}

int main(int argc, char **argv)
{
    struct IOStdReq *ioreq;
    int signal;
    struct MsgPort *port;

    UBYTE *buffer;
    char devicebuf[256];
    char *devicename = "trackdisk.device";
    char devicenum = 0;
    int i;
    int starttr = 0, endtr = 79;

    for (i = 1; i < argc;) {
	if (argv[i][0] != '-' || argv[i][2] != 0) {
	    usage();
	    exit(1);
	}
	switch (argv[i][1]) {
	case 'd':
	    if (i+2 >= argc) {
		usage();
		exit(1);
	    }
	    devicenum = atoi(argv[i+2]);
	    sprintf(devicebuf, "%s.device", argv[i+1]);
	    devicename = devicebuf;
	    i += 3;
	    break;
	case 's':
	    if (i+1 >= argc) {
		usage();
		exit(1);
	    }
	    starttr = atoi(argv[i+1]);
	    i += 2;
	    break;
	case 'e':
	    if (i+1 >= argc) {
		usage();
		exit(1);
	    }
	    endtr = atoi(argv[i+1]);
	    i += 2;
	    break;
	default:
	    usage();
	    exit(1);
	}
    }
    fprintf(stderr,"Using %s unit %d\n", devicename, devicenum);
    fprintf(stderr,"First track %d, last track %d\n", starttr, endtr);
    buffer = AllocMem(512, MEMF_CHIP);
    port = CreatePort(0, 0);
    if (port) {
	ioreq = CreateStdIO(port);
	if (ioreq) {
	    if (OpenDevice(devicename, devicenum, ioreq, 0) == 0) {
		int tr, sec;
		ioreq->io_Command = CMD_READ;
		ioreq->io_Length = 512;
		ioreq->io_Data = buffer;
		for (tr = starttr*2; tr < (endtr+1)*2; tr++) {
		    for (sec = 0; sec < 11; sec++) {
			ioreq->io_Offset = 512 * (tr * 11 + sec);
			DoIO(ioreq);
			fwrite(buffer, sizeof(UBYTE), 512, stdout);
		    }
		}
		CloseDevice(ioreq);
	    } else
		fprintf(stderr,"Unable to open %s unit %d\n", devicename, devicenum);
	    DeleteStdIO(ioreq);
	}
    }
    FreeMem(buffer, 512);
}
