#define INCL_DOS
#include "buddy.h"
#include "sessionmanager.h"
#include "compatibility.h"
#include <malloc.h>
#include <string.h>

Buddy :: Buddy( buddyListEntry *buddyInfo )
{
  debugf( "Buddy constructed @ 0x%08lx.\n", this );
  CHECKED_NEW;
  
  alias = NULL;
  record = NULL;
  buddyInfo->myRecord = NULL;
  imChatWin = 0;
  imChatClientWin = 0;
  isGroup = buddyInfo->numMembers > 0;
  handle = 0;
  
  flashState = BUDDY_STATE_OFFLINE;
  oldFlashState = BUDDY_STATE_OFFLINE;
  animStep = 0;
  userData.screenName = NULL;
  
  if ( !buddyInfo || !buddyInfo->entryName )
  {
    debugf( "Attempted to create a buddy with NULL buddy info!\n" );
    return;
  }
  
  if ( buddyInfo->gid || buddyInfo->id )
    onServer = 1;
  else onServer = 0;
  // Server group and user IDs are never 0, so a 0 means we added the
  //  buddy ourselves, not loaded it from the buddy list.
  
  buddyInfo->theBuddyPtr = this;
  
  if ( stricmp( buddyInfo->entryName, "PleaseUpgrade000" ) == 0 )
    return;
  // This is one of AOL's little gotcha's that is placed there by their
  //  current clients.  Nice of them, eh?

  CHECKED_STRDUP( buddyInfo->entryName, userData.screenName );
  // Ensure that this is initialized before any data arrives for the GUI
}

Buddy :: ~Buddy()
{
  debugf( "Destroying buddy @ 0x%08lx.\n", this );
  CHECKED_DELETE;
  
  handle = 0;
  if ( alias ) CHECKED_FREE( alias );
  if ( imChatWin )
  {
    WinPostMsg( imChatWin, WM_CLOSE, NULL, NULL );
  }
}

