#ifndef _KDOBENT_
#define _KDOBENT_

#ifndef _KDATA_
   #include <kdata.hpp>
#endif

#ifndef _IRESLOCK_
   #include <ireslock.hpp>
#endif

#ifndef _KDOBMGR_
   #include <kdobmgr.hpp>
#endif


struct KDobEntry 
{
   KDobEntry(KDataFactory const &fct) 
     : factory(&fct)
     , data(factory->makeDataObject()) 
   {
   }
  
   KDobEntry(KDobEntry const &copy) 
     : factory(copy.factory)
     , data(factory->cloneDataObject(copy.data)) 
   {
   }

   ~KDobEntry()
   {
      delete data;
   }

   KDobEntry &operator =(KDobEntry const &copy) 
   { 
      factory = copy.factory;
      delete data;
      data = factory->cloneDataObject(copy.data);
      return *this; 
   }

   Boolean operator <(KDobEntry const &other)
   { 
      return factory->name() < other.factory->name(); 
   }   

   Boolean operator ==(KDobEntry const &other) 
   { 
      return factory->name() == other.factory->name(); 
   }

   KDataFactory const *factory;
   KData              *data;
   IPrivateResource   lock;

};

typedef KDobEntry *KDobEntryPtr;

IString const &key(KDobEntryPtr const &entry);

#endif

