#ifndef _KSTDHDR_
#define _KSTDHDR_

#ifndef _IHDR_
   #include <ihandler.hpp>
#endif

#ifndef _IEVENT_
   #include <ievent.hpp>
#endif

#ifndef KWCONSTANTS
   #include <kwconst.hpp>
#endif

/*-------------------------------------------------
 * Align classes on four byte boundary.
 *-----------------------------------------------*/
#pragma pack(4)


class _Export KStandardEvent : public IEvent
{
   public:
      KStandardEvent(IEvent const &event) : IEvent(event) {}
      short controlId() { return parameter1().lowNumber(); }
};

/*-------------------------------------------------------------
 * Class: KStandardHandler
 *
 * Implementation File: kstdhdr.cpp
 *   
 * Description: 
 *   Event handler for all KASEWORKS standard events, which are
 *   used primarily for communicating between KASE:VIP objects.
 *
------------------------------------------------------------*/ 
class _Export KStandardHandler : public IHandler
{
   protected:
      virtual Boolean dispatchHandlerEvent(IEvent &evt);
      virtual Boolean setControls(IEvent &evt)      { return false; } 
      virtual Boolean setDefaults(IEvent &evt)      { return false; }
      virtual Boolean getData(IEvent &evt)          { return false; }
      virtual Boolean setData(IEvent &evt)          { return false; }
      virtual Boolean queryControls(IEvent &evt)    { return false; }
      virtual Boolean requiredControls(IEvent &evt) { return false; }
      virtual Boolean validateControls(IEvent &evt) { return false; }
      virtual Boolean actionComplete(IEvent &evt)   { return false; }
      virtual Boolean addDynamic(IEvent& event)     { return false; }
};

/*--------------------------------------------------
 * Resume compiler default packing.
 *--------------------------------------------------*/
#pragma pack()

#endif
