#define INCL_PM
#include <os2.h>
#include <kvalmask.hpp>
#include <kentryfd.hpp>
#include <ikeyevt.hpp>
#include <istrtest.hpp>
#include <ctype.h>

const int KMaskValidator::right = VK_RIGHT;
const int KMaskValidator::left  = VK_LEFT;

static const int alpha   = 1,
                 digit   = 2,
                 any     = 3,
                 space   = 4,
                 literal = 5;

Boolean KMaskFocusHandler::dispatchHandlerEvent(IEvent& event)
{
  Boolean filtered = false;
  if (event.eventId() == WM_SETFOCUS)
    filtered = setFocus(event);
  return filtered;
}

Boolean KMaskFocusHandler::setFocus(IEvent& event)
{
  KEntryField* field = (KEntryField*)event.window();
  field->disableInsertMode();
  field->postEvent(WM_CHAR, 
                   IEventParameter1(KC_VIRTUALKEY, 0),
                   IEventParameter2(0, VK_HOME));
  return false;
}

KMaskClickHandler::mouseClicked(IMouseClickEvent& event)
{
  return false;
}

KMaskValidator::KMaskValidator(const char *pattern)
  : originalMask(pattern)
  , emptyMask(0, strlen(pattern))
  , controlMask(0, strlen(pattern))
{
   fillMasks();
}

IHandler &KMaskValidator::handleEventsFor(IWindow* window)
{
  KValidator::handleEventsFor(window);
  focusHandler.handleEventsFor(window);
  clickHandler.handleEventsFor(window);
  return *this;
}


IString& KMaskValidator::fill(IString &strText)
{
  strText = emptyMask;
  return strText;
}

IString& KMaskValidator::strip(IString &strText)
{
  return strText;
}

Boolean KMaskValidator::isValid(const char *text, Boolean fill) const
{
   IString strText(text);
   if (controlMask.length() != strText.length())
      return false;

   for(unsigned i=0; i<controlMask.length(); i++)
   {
      IString character(strText.subString(i, 1));
      switch(controlMask[i])
      {
         case alpha:
            if (!character.isAlphabetic())
               return false;
            break;

         case digit:
            if (!character.isDigits())
               return false;
            break;

         case literal:
            if (character != originalMask[i])
               return false;
            break;

         case space:
            if (character != ' ')
               return false;
            break;

         default:
            break;
      }
   }
   return true;
}


Boolean KMaskValidator::characterKeyPress(IKeyboardEvent& event)
{
   Boolean filtered = false;
   KEntryField* field = (KEntryField*) event.window();
   selected = field->selectedRange();
   unsigned pos = selected.upperBound();
   IString character = event.mixedCharacter();

   if ((controlMask[pos] == alpha && character.isAlphabetic()) ||
       (controlMask[pos] == digit && character.isDigits()) ||
       (controlMask[pos] == any   && character.isPrintable()))
   {
     defaultProcedure(event);
     adjustPosition(field, right);
     filtered = true;
   }
   else
   {
      error();
      filtered = true;
   }
   return filtered;
}

Boolean KMaskValidator::virtualKeyPress(IKeyboardEvent& event)
{
   Boolean filtered = true;
   KEntryField* field = (KEntryField*) event.window();
   selected = field->selectedRange();
   unsigned pos = selected.upperBound();
   unsigned long ulKey = event.virtualKey();

   switch(ulKey)
   {
      case IKeyboardEvent::insert:
         error();
         break;

      case IKeyboardEvent::deleteKey:
      {
         I0String text(field->text());

         // 'delete' selected characters

         for(unsigned i=selected.lowerBound(); i<=selected.upperBound(); i++)
         {
           text[i] = emptyMask[i];
         }
         field->setText(text);

         // set cursor back to the original position
         field->selectRange(IRange(selected.lowerBound(), selected.lowerBound()));
         break;
      }

      case IKeyboardEvent::backSpace:
         field->postEvent(WM_CHAR, 
                          IEventParameter1(KC_VIRTUALKEY, 0),
                          IEventParameter2(0, VK_LEFT));
         field->postEvent(WM_CHAR, 
                          IEventParameter1(KC_VIRTUALKEY, 0),
                          IEventParameter2(0, VK_DELETE));
         break;
         
      case IKeyboardEvent::left:
         defaultProcedure(event);
         adjustPosition(field, left);
         break;

      case IKeyboardEvent::right:
         defaultProcedure(event);
         adjustPosition(field, right);
         break;

      case IKeyboardEvent::home:
         defaultProcedure(event);
         adjustPosition(field, right);
         break;

      case IKeyboardEvent::end:
         defaultProcedure(event);
         adjustPosition(field, left);
         break;

      default:
         filtered = false;
   }
   return filtered;
}

Boolean KMaskValidator::adjustPosition(KEntryField *field, 
                                    int direction)
{
   IRange current = field->selectedRange();
   unsigned pos = current.upperBound();

   // if the first character is a literal, force direction to right
   if (pos == 0 && (controlMask[pos] == literal || controlMask[pos] == space))
     direction = right;

   // make sure the current position isn't sitting on a literal character
   if (direction == right)
   {
     while(pos < controlMask.length() &&
           (controlMask[pos] == literal || controlMask[pos] == space))
     {
       IEvent event(field, WM_CHAR, 
                    IEventParameter1(KC_VIRTUALKEY, 0),
                    IEventParameter2(0, VK_RIGHT));
       defaultProcedure(event);
       pos++;
     }
   }
   else
   {
     while(pos && (controlMask[pos] == literal || controlMask[pos] == space))
     {
       IEvent event(field, WM_CHAR, 
                    IEventParameter1(KC_VIRTUALKEY, 0),
                    IEventParameter2(0, VK_LEFT));
       defaultProcedure(event);
       pos--;
     }
   }


   // return true if the current position was adjusted
   if (pos != current.upperBound())
     return true;
   else
     return false;
}

void KMaskValidator::fillMasks()
{
   unsigned length = originalMask.length();
   for(unsigned i=0; i<length; i++)
   {
      switch(toupper(originalMask[i]))
      {
         case 'X':
            emptyMask[i] = ' ';
            controlMask[i] = alpha;
            break;

         case '9':
            emptyMask[i] = ' ';
            controlMask[i] = digit;
            break;

         case '?':
            emptyMask[i] = ' ';
            controlMask[i] = any;
            break;

         case ' ':
            emptyMask[i] = ' ';
            controlMask[i] = space;
            break;

         default:
            emptyMask[i] = originalMask[i];
            controlMask[i] = literal;
            break;
      }
   }
}


