#ifndef _IMNITEM_INL_
#define _IMNITEM_INL_ 0
/*******************************************************************************
* FILE NAME: imnitem.inl                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the definition of the inline functions for the          *
*   classes declared in imnitem.hpp.                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1995       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

/*******************************************************************************
* There was an expectation from customers to have IBase:Boolean casts return   *                                                                          *
*    values of the BooleanConstatnts set rather then an int                    *
*                                                                              *
* The issue is properly documented, and the required change would break        *
*   existing code that checks for a specific bit pattern.                      *
*                                                                              *
* The goal can be achieved by comparing for example by comparing               *
*   false != x.isHighlighted();                                                *
*******************************************************************************/
#ifndef _IMNITEM_
  #undef  _IMNITEM_INL_
  #define _IMNITEM_INL_ 1
  #include <imnitem.hpp>
#endif

#include <ireslib.hpp>
#include <istring.hpp>
#if _IMNITEM_INL_
  #define inline
#endif


inline void  IMenuItem :: setDefaultStyle( const IMenuItem::Style& newDefault)
{
  currentDefaultStyle = newDefault;
}

inline void  IMenuItem :: setDefaultAttribute
                          ( const IMenuItem::Attribute& newDefault)
{
  currentDefaultAttribute = newDefault;
}

inline IMenuItem& IMenuItem :: setSelectable(Boolean state)
{
   if (!state)
     afStyle |= unavailable.asUnsignedLong();
   else
     afStyle &= ~unavailable.asUnsignedLong();
   return *this;
}

#ifndef IC_WIN
#ifndef IC_MOTIF
inline IMenuItem& IMenuItem :: setNoDismiss(Boolean state)
{
   if (state)
     afAttribute |= noDismiss.asUnsignedLong();
   else
     afAttribute &= ~noDismiss.asUnsignedLong();
   return *this;
}
#endif  // not Motif
#ifdef IC_MOTIF
#ifndef IC_MOTIF_FLAGNOP
inline IMenuItem& IMenuItem :: setNoDismiss(Boolean)
{
   return *this;
}
#endif  // IC_MOTIF_FLAGNOP
#endif  // Motif

#ifndef IC_MOTIF
inline IMenuItem& IMenuItem :: setFramed(Boolean state)
{
   if (state)
     afAttribute |= framed.asUnsignedLong();
   else
     afAttribute &= ~framed.asUnsignedLong();
   return *this;
}
#endif  // not Motif
#ifdef IC_MOTIF
#ifndef IC_MOTIF_FLAGNOP
inline IMenuItem& IMenuItem :: setFramed(Boolean)
{
   return *this;
}
#endif  // IC_MOTIF_FLAGNOP
#endif  // Motif
#endif  // !IC_WIN

inline IMenuItem& IMenuItem :: setChecked(Boolean state)
{
   if (state)
     afAttribute |= checked.asUnsignedLong();
   else
     afAttribute &= ~checked.asUnsignedLong();
   return *this;
}

inline IMenuItem& IMenuItem :: setDisabled(Boolean state)
{
   if (state)
     afAttribute |= disabled.asUnsignedLong();
   else
     afAttribute &= ~disabled.asUnsignedLong();
   return *this;
}

#ifndef IC_MOTIF
inline IMenuItem& IMenuItem :: setHighlighted(Boolean state)
{
   if (state)
     afAttribute |= highlighted.asUnsignedLong();
   else
     afAttribute &= ~highlighted.asUnsignedLong();
   return *this;
}
#endif  // not Motif
#ifdef IC_MOTIF
#ifndef IC_MOTIF_FLAGNOP
inline IMenuItem& IMenuItem :: setHighlighted(Boolean)
{
  // X/Motif does not support this behavior
   return *this;
}
#endif  // IC_MOTIF_FLAGNOP
#endif  // Motif

inline IBase::Boolean IMenuItem :: isSelectable() const
{
   return !(afStyle & unavailable.asUnsignedLong());
}

#ifndef IC_MOTIF_FLAGNOP
inline IBase::Boolean IMenuItem :: isDrawItem() const
{
   return ((IBase::Boolean)(afStyle & drawItem.asUnsignedLong()));
}
#endif  // IC_MOTIF_FLAGNOP

inline IBase::Boolean IMenuItem :: isSeparator() const
{
   return ((IBase::Boolean)(afStyle & separator.asUnsignedLong()));
}

inline IBase::Boolean IMenuItem :: isText() const
{
#ifdef IC_WIN
   return ((IBase::Boolean)(afExtendedStyle & textItem.asExtendedUnsignedLong()));
#else
   return ((IBase::Boolean)(afStyle & textItem.asUnsignedLong()));
#endif
}

inline IBase::Boolean IMenuItem :: isBitmap() const
{
   return ((IBase::Boolean)(afStyle & bitmapItem.asUnsignedLong()));
}

inline IBase::Boolean IMenuItem :: isSubmenu() const
{
   return ((IBase::Boolean)(afStyle & submenu.asUnsignedLong()));
}

#ifndef IC_WIN
#ifndef IC_MOTIF_FLAGNOP
inline IBase::Boolean IMenuItem :: isNoDismiss() const
{
   return ((IBase::Boolean)(afAttribute & noDismiss.asUnsignedLong()));
}
#endif  // IC_MOTIF_FLAGNOP

#ifndef IC_MOTIF_FLAGNOP
inline IBase::Boolean IMenuItem :: isFramed() const
{
   return ((IBase::Boolean)(afAttribute & framed.asUnsignedLong()));
}
#endif  // IC_MOTIF_FLAGNOP
#endif

inline IBase::Boolean IMenuItem :: isChecked() const
{
   return ((IBase::Boolean)(afAttribute & checked.asUnsignedLong()));
}

inline IBase::Boolean IMenuItem :: isDisabled() const
{
   return ((IBase::Boolean)(afAttribute & disabled.asUnsignedLong()));
}

#ifndef IC_MOTIF_FLAGNOP
inline IBase::Boolean IMenuItem :: isHighlighted() const
{
   return ((IBase::Boolean)(afAttribute & highlighted.asUnsignedLong()));
}
#endif  // IC_MOTIF_FLAGNOP

inline IMenuItem&  IMenuItem :: setBitmap(unsigned long bitmapResId)
{
  return(setBitmap(IResourceId(bitmapResId)));
}

inline IMenuItem& IMenuItem::setIndex ( unsigned long index)
{
  iPosition = index;
  return *this;
}

inline unsigned long  IMenuItem::id() const
{
    return itemId;
}

inline unsigned long IMenuItem::index  ( ) const
{
    return iPosition;
}

#ifdef IC_MOTIF
inline IWindowHandle IMenuItem::submenuHandle( ) const
{
    return hwndSubmenu;
}
#endif
#ifdef IC_PMWIN
inline IMenuHandle IMenuItem::submenuHandle( ) const
{
    return hwndSubmenu;
}
#endif

inline unsigned long IMenuItem:: style( ) const
{
  return afStyle;
}

inline unsigned long IMenuItem:: extendedStyle( ) const
{
  return afExtendedStyle;
}

inline unsigned long IMenuItem::attribute ( ) const
{
  return afAttribute;
}

inline IString IMenuItem::text( ) const
{
  return strClItemText;
}

inline IBitmapHandle IMenuItem::bitmap ( ) const
{
  return hBitmapHandle;
}

inline IMenuItem& IMenuItem::setStyle( unsigned long newStyle )
{
  afStyle = newStyle;
  return *this;
}

inline IMenuItem& IMenuItem::setExtendedStyle( unsigned long newExtStyle )
{
  afExtendedStyle = newExtStyle;
  return *this;
}

inline IMenuItem& IMenuItem::setAttribute( unsigned long newAttribute )
{
  afAttribute = newAttribute;
  return *this;
}

#endif // _IMNITEM_INL_
