/*******************************************************************************
* FILE NAME: isafeid.cpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains a static class that allows increment and decrement      *
*   operations that are safe even in multi-processing environments.            *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

/* Same priority as ibase.cpp.  This must be the first! */
#pragma priority ( -2147482624 )

#include <iplatfrm.hpp>
#include "isafeid.hpp"

// Initialize static variables.  These are function pointers - the function that
// they point to depends on the number of processors.
int (*_Optlink ISafeIncDec::incTestFnPtr) (int*) =
      (IPlatform::numProcessors() > 1) ? _increment_lock : _increment;
int (*_Optlink ISafeIncDec::decTestFnPtr) (int*) =
      (IPlatform::numProcessors() > 1) ? _decrement_testne_lock : _decrement_testne;

ISafeIncDec::ISafeIncDec ()
{
}

/*------------------------------------------------------------------------------
| ISafeIncDec::increment                                                       |
------------------------------------------------------------------------------*/
int ISafeIncDec::increment(unsigned int &count)
{
   return incTestFnPtr((int*) &count);
}

int ISafeIncDec::increment(long &count)
{
   return incTestFnPtr((int*) &count);
}

/*------------------------------------------------------------------------------
| ISafeIncDec::decrement                                                       |
------------------------------------------------------------------------------*/
int ISafeIncDec::decrement(unsigned int &count)
{
   return decTestFnPtr((int*) &count);
}

int ISafeIncDec::decrement(long &count)
{
   return decTestFnPtr((int*) &count);
}

