# EXAMPLE makefile for V Draw Demo application...
#
# creates .exe's under $(BINDIR)
# assumes that vibmcpp or vibmcppd (debug library) already built
# using v.mak or vopengl.mak 
#
# to create debug versions enter: nmake /f DEBUG=1 vdraw.mak
# to create release versions enter: nmake /f vdraw.mak
#

include cfgibm.mkh

# ---------------------------------------------------------------------------
SRCDIR=$(VDIR)\draw
INCDIR=$(VDIR)\draw
BINFILE=$(BINDIR)\vdraw.exe
RESFILE=$(OBJDIR)\vapp.res
DEFFILE=$(VSRCDIR)\vos2.def

OBJFILES= $(OBJDIR)\vstartup.obj \
 $(OBJDIR)\vdrwapp.obj \
 $(OBJDIR)\vdrwcnv.obj \
 $(OBJDIR)\vdrwcmdw.obj \
 $(OBJDIR)\vdrwdlg.obj 

# ---------------------------------------------------------------------------
.PRECIOUS: $(BINFILE)

.cpp.obj :
 $(CC) $(CFLAGS) /C /Fo$@ $<

{$(SRCDIR)}.cpp{$(OBJDIR)}.obj :
 $(CC) $(CFLAGS) /I$(INCDIR) /C /Fo$@ $<

all : $(BINFILE)

dirs:
	@-mkdir $(OBJDIR)
	@-mkdir $(BINDIR)

clean :
	-del $(OBJDIR)\*.*
	-del $(BINDIR)\*.*

$(BINFILE) : $(OBJFILES) $(RESFILE) $(VLIB)
	-$(CC) /Q /B"$(LFLAGS)" @<<
 /Fe$@
 $(OBJFILES)
 $(LIBS)
 $(DEFFILE)
<<NOKEEP
    $(RC) $(RFLAGS) $(RESFILE) $@

# ---------------------------------------------------------------------------

# Minimum RESOURCE
$(OBJDIR)\vapp.res :: $(VSRCDIR)\vos2.rc \
        $(VSRCDIR)\vapp.ico \
        $(VSRCDIR)\collate.bmp
	@copy $(VSRCDIR)\vapp.ico .
	@copy $(VSRCDIR)\collate.bmp .
    $(RC) -r $(RFLAGS) $(VSRCDIR)\vos2.rc $@ 
	@-attrib -r .\vapp.ico
	@-attrib -r .\collate.bmp
	-del .\vapp.ico
	-del .\collate.bmp

# APP
$(OBJDIR)\vstartup.obj : $(VSRCDIR)\$$(@B).cpp 

$(OBJDIR)\vdrwcnv.obj : $(SRCDIR)\$$(@B).cpp $(INCDIR)\$$(@B).h \
 $(VINCDIR)\v_defs.h $(INCDIR)\vdrwcmdw.h $(INCDIR)\vdrwdlg.h \
 $(VINCDIR)\vprinter.h $(VINCDIR)\vprintdc.h

$(OBJDIR)\vdrwdlg.obj : $(SRCDIR)\$$(@B).cpp $(INCDIR)\\$$(@B).h \
 $(VINCDIR)\v_defs.h $(INCDIR)\vdrwcmdw.h $(INCDIR)\vdrwcnv.h 

$(OBJDIR)\vdrwcmdw.obj : $(SRCDIR)\$$(@B).cpp $(INCDIR)\\$$(@B).h \
 $(VINCDIR)\v_defs.h $(INCDIR)\vdrwdlg.h $(INCDIR)\vdrwcnv.h 

$(OBJDIR)\vdrwapp.obj : $(SRCDIR)\$$(@B).cpp $(INCDIR)\\$$(@B).h \
 $(VINCDIR)\v_defs.h $(INCDIR)\vdrwcmdw.h $(INCDIR)\vdrwcnv.h \
 $(INCDIR)\vdrwdlg.h 
