/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db;

import com.ibm.db.DataException;
import com.ibm.db.IBMDBMessages;
import com.ibm.db.Utilities;
import com.ibm.db.base.DatabaseConnection;
import com.ibm.db.base.DatabaseConnectionSpec;
import com.ibm.db.base.JDBCConnectionManager;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.Serializable;

public class LogonDialog
extends Dialog
implements ActionListener,
KeyListener,
WindowListener {
    private TextField textFieldLogonID;
    private TextField textFieldPassword;
    private Button buttonOK;
    private Button buttonCancel;
    private Component parentRef;
    private String uid;
    private String pwd;
    private boolean cancelPrompt = false;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1998, 1999";

    public LogonDialog(Component component) {
        super(LogonDialog.getFrameForComponent(component), true);
        this.parentRef = component;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.buttonOK) {
            this.connButtonOK();
        }
        if (actionEvent.getSource() == this.buttonCancel) {
            this.setCancelPrompt(true);
            this.dispose();
        }
    }

    protected static void buildCons(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }

    protected static void centerWindowOnComponent(Window window, Component component) {
        Serializable serializable;
        Container container = null;
        if (component != null && (component instanceof Window || component instanceof Applet)) {
            container = (Container)component;
        } else {
            serializable = component.getParent();
            while (serializable != null) {
                if (serializable instanceof Window || serializable instanceof Applet) {
                    container = serializable;
                    break;
                }
                serializable = ((Component)serializable).getParent();
            }
        }
        if (component != null && !component.isShowing() || container == null || !container.isShowing()) {
            serializable = window.getSize();
            Dimension dimension = window.getToolkit().getScreenSize();
            ((Component)window).setLocation((dimension.width - ((Dimension)serializable).width) / 2, (dimension.height - ((Dimension)serializable).height) / 2);
        } else {
            LogonDialog.centerWindowOnRectangle(window, new Rectangle(component.getLocationOnScreen(), component.getSize()));
        }
    }

    protected static void centerWindowOnRectangle(Window window, Rectangle rectangle) {
        Dimension dimension = rectangle.getSize();
        Point point = rectangle.getLocation();
        Rectangle rectangle2 = window.getBounds();
        int n = point.x + (dimension.width - rectangle2.width >> 1);
        int n2 = point.y + (dimension.height - rectangle2.height >> 1);
        Dimension dimension2 = window.getToolkit().getScreenSize();
        if (n2 + rectangle2.height > dimension2.height) {
            n2 = dimension2.height - rectangle2.height;
            int n3 = n = point.x < dimension2.width >> 1 ? point.x + dimension.width : point.x - rectangle2.width;
        }
        if (n + rectangle2.width > dimension2.width) {
            n = dimension2.width - rectangle2.width;
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        ((Component)window).setLocation(n, n2);
    }

    private void connButtonOK() {
        this.setUid(this.textFieldLogonID.getText());
        this.setPwd(this.textFieldPassword.getText());
        this.setCancelPrompt(false);
        this.dispose();
    }

    protected boolean getCancelPrompt() {
        return this.cancelPrompt;
    }

    public static Frame getFrameForComponent(Component component) {
        if (component == null) {
            return null;
        }
        if (component instanceof Frame) {
            return (Frame)component;
        }
        return LogonDialog.getFrameForComponent(component.getParent());
    }

    public Insets getInsets() {
        return new Insets(40, 40, 10, 40);
    }

    protected String getPwd() {
        return this.pwd;
    }

    private TextField getTextFieldLogonID() {
        if (this.textFieldLogonID == null) {
            this.textFieldLogonID = new TextField();
        }
        return this.textFieldLogonID;
    }

    private TextField getTextFieldPassword() {
        if (this.textFieldPassword == null) {
            this.textFieldPassword = new TextField();
        }
        return this.textFieldPassword;
    }

    protected String getUid() {
        return this.uid;
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.connButtonOK();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public boolean promptAndSetUID(String[] stringArray, String[] stringArray2) {
        this.setUid(stringArray[0]);
        this.setPwd(stringArray2[0]);
        this.showDialog();
        if (this.getCancelPrompt()) {
            return false;
        }
        stringArray[0] = this.getTextFieldLogonID().getText();
        stringArray2[0] = this.getTextFieldPassword().getText();
        return true;
    }

    public boolean promptAndSetUID(DatabaseConnectionSpec databaseConnectionSpec) throws DataException {
        try {
            JDBCConnectionManager jDBCConnectionManager = JDBCConnectionManager.getJDBCConnectionManager(databaseConnectionSpec.getDriverName());
            DatabaseConnection databaseConnection = jDBCConnectionManager.getConnectionAtAlias(databaseConnectionSpec.getAlias());
            if (databaseConnection != null) {
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string = Utilities.logMessage(IBMDBMessages.driverNotFound);
            throw new DataException(string, 236);
        }
        this.setUid(databaseConnectionSpec.getLogonSpec().getId());
        this.setPwd(databaseConnectionSpec.getLogonSpec().getPassword());
        this.showDialog();
        if (this.getCancelPrompt()) {
            return false;
        }
        databaseConnectionSpec.getLogonSpec().setId(this.getTextFieldLogonID().getText());
        databaseConnectionSpec.getLogonSpec().setPassword(this.getTextFieldPassword().getText());
        return true;
    }

    private void setCancelPrompt(boolean bl) {
        this.cancelPrompt = bl;
    }

    protected void setPwd(String string) {
        this.pwd = string;
    }

    protected void setUid(String string) {
        this.uid = string;
    }

    protected void showDialog() {
        ((Component)this).setBackground(SystemColor.control);
        this.setForeground(Color.black);
        ((Component)this).setSize(400, 200);
        LogonDialog.centerWindowOnComponent(this, this.parentRef);
        this.setTitle(Utilities.getMessage(IBMDBMessages.logonIDPwd));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        LogonDialog.buildCons(gridBagConstraints, 0, 0, 1, 1, 20, 30);
        gridBagConstraints.anchor = 17;
        Label label = new Label(Utilities.getMessage(IBMDBMessages.EnterLogonID), 0);
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.add(label);
        ((TextComponent)this.getTextFieldLogonID()).setText(this.getUid());
        ((Component)this.getTextFieldLogonID()).setBackground(Color.white);
        LogonDialog.buildCons(gridBagConstraints, 1, 0, 1, 1, 80, 0);
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.textFieldLogonID, gridBagConstraints);
        this.add(this.textFieldLogonID);
        LogonDialog.buildCons(gridBagConstraints, 0, 1, 1, 1, 0, 30);
        gridBagConstraints.anchor = 17;
        Label label2 = new Label(Utilities.getMessage(IBMDBMessages.EnterPassword), 0);
        gridBagLayout.setConstraints(label2, gridBagConstraints);
        this.add(label2);
        ((TextComponent)this.getTextFieldPassword()).setText(this.getPwd());
        ((Component)this.getTextFieldPassword()).setBackground(Color.white);
        this.getTextFieldPassword().setEchoChar('*');
        LogonDialog.buildCons(gridBagConstraints, 1, 1, 1, 1, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.textFieldPassword, gridBagConstraints);
        this.add(this.textFieldPassword);
        this.buttonOK = new Button();
        this.buttonOK.setLabel(Utilities.getMessage(IBMDBMessages.OK));
        this.buttonCancel = new Button();
        this.buttonCancel.setLabel(Utilities.getMessage(IBMDBMessages.Cancel));
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 3, 10, 10));
        panel.add(new Label());
        panel.add(this.buttonOK);
        panel.add(this.buttonCancel);
        LogonDialog.buildCons(gridBagConstraints, 0, 2, 2, 1, 0, 40);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(panel, gridBagConstraints);
        this.add(panel);
        this.buttonCancel.addActionListener(this);
        this.buttonOK.addActionListener(this);
        this.addWindowListener(this);
        this.getTextFieldLogonID().addKeyListener(this);
        this.getTextFieldPassword().addKeyListener(this);
        this.show();
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (windowEvent.getSource() == this) {
            this.setCancelPrompt(true);
            this.dispose();
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

