/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db;

import com.ibm.db.DataEvent;
import com.ibm.db.DataRuntimeException;
import com.ibm.db.DatabaseConnectionAfterListener;
import com.ibm.db.DatabaseConnectionBeforeListener;
import com.ibm.db.IBMDBMessages;
import com.ibm.db.SelectResult;
import com.ibm.db.Statement;
import com.ibm.db.StatementMetaData;
import com.ibm.db.Utilities;
import com.ibm.db.base.DataException;
import com.ibm.db.base.DatabaseCompoundType;
import com.ibm.db.base.DatabaseConnection;
import com.ibm.db.base.DatabaseQuerySpec;
import com.ibm.db.base.DatabaseResultTable;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.sql.SQLException;

public class SelectStatement
extends Statement
implements DatabaseConnectionBeforeListener,
DatabaseConnectionAfterListener {
    protected boolean fieldLockRows = false;
    protected int fieldMaximumPacketsInCache = 0;
    private SelectResult fieldResult;
    protected int fieldMaximumRows = 0;
    protected int fieldPacketSize = 1;
    protected boolean fieldFillCacheOnExecute = true;
    protected boolean fieldForceSearchedUpdate = false;
    protected boolean forVAJavaSelect = false;
    protected transient boolean executing = false;
    static final long serialVersionUID = 4236151146126717768L;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1998, 1999.\nAll Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by\nGSA ADP Schedule Contract with IBM Corp.";

    public SelectStatement() {
        this.initialize();
    }

    public SelectStatement(boolean bl) {
        this.initialize();
        this.forVAJavaSelect = bl;
    }

    public void aboutToCommit(DataEvent dataEvent) {
        SelectResult selectResult = this.getResult();
        if (selectResult != null) {
            try {
                selectResult.updateRowBeforeLeaving();
            }
            catch (Exception exception) {
                throw new DataRuntimeException(exception);
            }
        }
    }

    public void aboutToConnect(DataEvent dataEvent) {
    }

    public void aboutToDisconnect(DataEvent dataEvent) {
    }

    public void aboutToRollback(DataEvent dataEvent) {
    }

    public boolean areDistinctTypesEnabled() {
        return this.fieldDistinctTypesEnabled;
    }

    public void cancelExecution() throws com.ibm.db.DataException {
        if (this.fieldConnection == null) {
            String string = Utilities.logMessage(IBMDBMessages.noConnection);
            throw new com.ibm.db.DataException(string, 206);
        }
        if (!this.executing || this.rt == null) {
            String string = Utilities.logMessage(IBMDBMessages.notExecuting);
            throw new com.ibm.db.DataException(string, 246);
        }
        if (this.executingSQL) {
            try {
                this.rt.cancel();
                this.executingSQL = false;
            }
            catch (SQLException sQLException) {
                Statement.handleSQLException(sQLException);
            }
        } else {
            this.fieldResult.cancelAction();
        }
    }

    protected void checkConnection() throws com.ibm.db.DataException {
        if (this.fieldConnection == null || !this.fieldConnection.isConnected()) {
            this.disconnect();
            String string = Utilities.logMessage(IBMDBMessages.noActiveConnection);
            throw new com.ibm.db.DataException(string, 226);
        }
    }

    public void close() throws com.ibm.db.DataException {
        this.fireAboutToClose(new DataEvent(this));
        this.closeInternal(false);
        this.fireClosed(new DataEvent(this));
    }

    protected void closeInternal(boolean bl) throws com.ibm.db.DataException {
        SelectResult selectResult = this.getResult();
        if (selectResult != null) {
            selectResult.closeInternal(bl);
        }
        try {
            if (this.rt != null) {
                DatabaseResultTable databaseResultTable = this.rt;
                this.rt = null;
                databaseResultTable.closeStatement();
            }
        }
        catch (SQLException sQLException) {
            if (bl) {
                Utilities.logSQLException(sQLException);
            }
            Statement.handleSQLException(sQLException);
        }
    }

    public void committed(DataEvent dataEvent) {
    }

    public void connected(DataEvent dataEvent) {
    }

    protected void createResultTable() throws com.ibm.db.DataException {
        DatabaseConnection databaseConnection = this.fieldConnection.getConnection();
        DatabaseQuerySpec databaseQuerySpec = null;
        try {
            databaseQuerySpec = new DatabaseQuerySpec(this.getMetaData().getDbQuerySpec());
            this.validateSQL();
            if (this.getParameters() == null) {
                this.rt = databaseConnection.resultTableFromQuerySpec(databaseQuerySpec);
                this.rt.setTimeout(this.fieldTimeout);
                this.executingSQL = true;
                this.rt.execute();
            } else {
                databaseQuerySpec.setStatement(Statement.replaceHostVars(databaseQuerySpec.getStatement()));
                this.rt = databaseConnection.resultTableFromQuerySpec(databaseQuerySpec, this.getParameters());
                this.rt.setTimeout(this.fieldTimeout);
                this.executingSQL = true;
                this.rt.execute(this.getParameters());
            }
            this.executingSQL = false;
            DatabaseCompoundType databaseCompoundType = new DatabaseCompoundType(this.rt.getRowStruct());
            this.getMetaData().setColumnShape(databaseCompoundType);
        }
        catch (SQLException sQLException) {
            Statement.handleSQLException(sQLException);
        }
        catch (DataException dataException) {
            String string = Utilities.logBaseException(dataException, this.forVAJavaSelect);
            throw new com.ibm.db.DataException(string, dataException.getErrorCode());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
    }

    protected void disconnect() {
        if (this.getResult() != null) {
            this.getResult().disconnect();
        }
        this.rt = null;
    }

    public void disconnected(DataEvent dataEvent) {
        this.disconnect();
    }

    public synchronized void execute() throws com.ibm.db.DataException {
        this.fireAboutToExecute(new DataEvent(this));
        this.executing = true;
        try {
            if (!this.connect()) {
                return;
            }
            if (this.isOpen()) {
                this.close();
            }
        }
        catch (com.ibm.db.DataException dataException) {
            this.executing = false;
            throw dataException;
        }
        try {
            this.createResultTable();
            this.fieldResult.setResultTable(this.rt);
            this.fieldResult.initialize();
            try {
                this.fieldResult.firstRow();
            }
            catch (com.ibm.db.DataException dataException) {
                if (dataException.getErrorCode() != 214) {
                    throw dataException;
                }
            }
        }
        catch (com.ibm.db.DataException dataException) {
            this.executing = false;
            this.closeInternal(true);
            throw dataException;
        }
        this.executing = false;
        this.fieldExecuted = true;
        this.fireExecuted(new DataEvent(this));
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    protected void fireAboutToClose(DataEvent dataEvent) {
        if (this.aStatementBeforeListener == null) {
            return;
        }
        this.aStatementBeforeListener.aboutToClose(dataEvent);
    }

    protected void fireClosed(DataEvent dataEvent) {
        if (this.aStatementAfterListener == null) {
            return;
        }
        this.aStatementAfterListener.closed(dataEvent);
    }

    public int getMaximumPacketsInCache() {
        return this.fieldMaximumPacketsInCache;
    }

    public int getMaximumRows() {
        return this.fieldMaximumRows;
    }

    public int getPacketSize() {
        return this.fieldPacketSize;
    }

    public SelectResult getResult() {
        return this.fieldResult;
    }

    protected void initialize() {
        this.fieldResult = new SelectResult(this);
    }

    public boolean isFillCacheOnExecute() {
        return this.fieldFillCacheOnExecute;
    }

    public boolean isForceSearchedUpdate() {
        return this.fieldForceSearchedUpdate;
    }

    protected boolean isForVAJavaSelect() {
        return this.forVAJavaSelect;
    }

    public boolean isLockRows() {
        return this.fieldLockRows;
    }

    public boolean isOpen() {
        return this.rt != null;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.propertyChange = new PropertyChangeSupport(this);
        this.executing = false;
        this.executingSQL = false;
    }

    public synchronized void refresh() throws com.ibm.db.DataException {
        this.checkConnection();
        if (!this.isOpen()) {
            String string = Utilities.logMessage(IBMDBMessages.notOpen);
            throw new com.ibm.db.DataException(string, 207);
        }
        this.fireAboutToExecute(new DataEvent(this));
        this.executing = true;
        try {
            if (this.fieldResult.isOpen()) {
                this.fieldResult.closeResult();
            }
            this.refreshResultTable();
            this.fieldResult.setResultTable(this.rt);
            this.fieldResult.initialize();
            try {
                this.fieldResult.firstRow();
            }
            catch (com.ibm.db.DataException dataException) {
                if (dataException.getErrorCode() != 214) {
                    throw dataException;
                }
            }
        }
        catch (com.ibm.db.DataException dataException) {
            this.executing = false;
            throw dataException;
        }
        this.executing = false;
        this.fireExecuted(new DataEvent(this));
    }

    protected void refreshResultTable() throws com.ibm.db.DataException {
        try {
            this.executingSQL = true;
            if (this.getParameters() == null) {
                this.rt.refresh();
            } else {
                this.rt.refresh(this.getParameters());
            }
            this.executingSQL = false;
            DatabaseCompoundType databaseCompoundType = new DatabaseCompoundType(this.rt.getRowStruct());
            this.getMetaData().setColumnShape(databaseCompoundType);
        }
        catch (SQLException sQLException) {
            Statement.handleSQLException(sQLException);
        }
        catch (DataException dataException) {
            String string = Utilities.logBaseException(dataException, this.forVAJavaSelect);
            throw new com.ibm.db.DataException(string, dataException.getErrorCode());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
    }

    public void rolledBack(DataEvent dataEvent) {
    }

    public void setConnection(com.ibm.db.DatabaseConnection databaseConnection) {
        if (this.fieldConnection != null) {
            this.fieldConnection.removeDatabaseConnectionBeforeListener(this);
            this.fieldConnection.removeDatabaseConnectionAfterListener(this);
        }
        this.fieldConnection = databaseConnection;
        if (this.fieldConnection != null) {
            this.fieldConnection.addDatabaseConnectionBeforeListener(this);
            this.fieldConnection.addDatabaseConnectionAfterListener(this);
        }
    }

    public void setDistinctTypesEnabled(boolean bl) {
        this.fieldDistinctTypesEnabled = bl;
    }

    public void setFillCacheOnExecute(boolean bl) {
        this.fieldFillCacheOnExecute = bl;
    }

    public void setForceSearchedUpdate(boolean bl) {
        this.fieldForceSearchedUpdate = bl;
    }

    public void setLockRows(boolean bl) {
        this.fieldLockRows = bl;
    }

    public void setMaximumPacketsInCache(int n) {
        this.fieldMaximumPacketsInCache = n;
    }

    public void setMaximumRows(int n) {
        this.fieldMaximumRows = n;
    }

    public synchronized void setMetaData(StatementMetaData statementMetaData) {
        super.setMetaData(statementMetaData);
        if (this.getResult() != null) {
            this.getResult().setStatement(this);
        }
    }

    public void setPacketSize(int n) {
        this.fieldPacketSize = n;
    }

    protected void validateSQL() throws com.ibm.db.DataException {
        String string = this.getMetaData().getSQL();
        boolean bl = false;
        try {
            bl = DatabaseResultTable.isSelectStatement(string);
        }
        catch (DataException dataException) {
            String string2 = Utilities.logMessage(IBMDBMessages.noSQL);
            throw new com.ibm.db.DataException(string2, 106);
        }
        if (!bl) {
            String string3 = Utilities.logMessage(IBMDBMessages.notSelect);
            throw new com.ibm.db.DataException(string3, 241);
        }
    }
}

