/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db;

import com.ibm.db.DataEvent;
import com.ibm.db.DataRuntimeException;
import com.ibm.db.DatabaseConnection;
import com.ibm.db.IBMDBMessages;
import com.ibm.db.StatementAfterEventMulticaster;
import com.ibm.db.StatementAfterListener;
import com.ibm.db.StatementBeforeEventMulticaster;
import com.ibm.db.StatementBeforeListener;
import com.ibm.db.StatementMetaData;
import com.ibm.db.Utilities;
import com.ibm.db.base.DataException;
import com.ibm.db.base.DatabaseCompoundType;
import com.ibm.db.base.DatabaseResultTable;
import com.ibm.db.base.DatabaseRow;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public abstract class Statement
implements Serializable {
    protected DatabaseConnection fieldConnection;
    protected boolean fieldExecuted = false;
    protected StatementMetaData fieldMetaData;
    protected boolean fieldReadOnly = false;
    protected boolean fieldDistinctTypesEnabled = false;
    protected int fieldTimeout = 0;
    protected DatabaseRow parameters;
    protected transient DatabaseResultTable rt;
    protected transient boolean executingSQL = false;
    protected transient PropertyChangeSupport propertyChange = new PropertyChangeSupport(this);
    protected transient StatementBeforeListener aStatementBeforeListener = null;
    protected transient StatementAfterListener aStatementAfterListener = null;
    static final long serialVersionUID = 5331334872843565022L;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1998, 1999.\nAll Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by\nGSA ADP Schedule Contract with IBM Corp.";
    static Class class$array1$$byte;
    static Class class$java$lang$Short;
    static Class class$java$sql$Time;
    static Class class$java$lang$String;
    static Class class$java$lang$Float;
    static Class class$java$sql$Timestamp;
    static Class class$java$lang$Double;
    static Class class$java$lang$Boolean;
    static Class class$java$sql$Date;
    static Class class$java$lang$Long;
    static Class class$java$lang$Integer;
    static Class class$java$math$BigDecimal;

    public void addStatementAfterListener(StatementAfterListener statementAfterListener) {
        this.aStatementAfterListener = StatementAfterEventMulticaster.add(this.aStatementAfterListener, statementAfterListener);
    }

    public void addStatementBeforeListener(StatementBeforeListener statementBeforeListener) {
        this.aStatementBeforeListener = StatementBeforeEventMulticaster.add(this.aStatementBeforeListener, statementBeforeListener);
    }

    protected void applyTimeout() throws com.ibm.db.DataException {
        try {
            this.rt.setTimeout(this.fieldTimeout);
        }
        catch (SQLException sQLException) {
            Statement.handleSQLException(sQLException);
        }
    }

    public abstract void cancelExecution() throws com.ibm.db.DataException;

    protected boolean connect() throws com.ibm.db.DataException {
        boolean bl = false;
        if (this.fieldConnection == null) {
            String string = Utilities.logMessage(IBMDBMessages.noConnection);
            throw new com.ibm.db.DataException(string, 206);
        }
        if (this.fieldConnection.isExternallyManaged()) {
            try {
                DatabaseMetaData databaseMetaData = this.getConnection().getConnection().getConnectionMetaData();
                if (!this.fieldConnection.getAutoCommit() && !databaseMetaData.supportsTransactions()) {
                    String string = Utilities.logMessage(IBMDBMessages.noTransactions);
                    throw new com.ibm.db.DataException(string, 239);
                }
                this.fieldConnection.setAutoCommit(this.fieldConnection.getAutoCommit());
                bl = true;
            }
            catch (SQLException sQLException) {
                String string = Utilities.logSQLException(sQLException);
                throw new com.ibm.db.DataException(string, 101);
            }
        } else {
            bl = this.fieldConnection.isConnected();
            if (!bl) {
                bl = this.fieldConnection.connect();
            }
        }
        return bl;
    }

    protected void copyParameters(DatabaseRow databaseRow) {
        if (this.parameters != null) {
            int n = 1;
            while (n < this.parameters.size()) {
                databaseRow.putAtIndex(n, this.parameters.getAtIndex(n));
                ++n;
            }
        }
        this.parameters = databaseRow;
    }

    public abstract void execute() throws com.ibm.db.DataException;

    protected void finalize() throws Throwable {
        super.finalize();
    }

    protected void fireAboutToExecute(DataEvent dataEvent) {
        if (this.aStatementBeforeListener == null) {
            return;
        }
        this.aStatementBeforeListener.aboutToExecute(dataEvent);
    }

    protected void fireExecuted(DataEvent dataEvent) {
        if (this.aStatementAfterListener == null) {
            return;
        }
        this.aStatementAfterListener.executed(dataEvent);
    }

    public DatabaseConnection getConnection() {
        return this.fieldConnection;
    }

    public StatementMetaData getMetaData() {
        if (this.fieldMetaData == null) {
            try {
                this.fieldMetaData = new StatementMetaData();
                this.fieldMetaData.setStatement(this);
            }
            catch (Throwable throwable) {
                String string = Utilities.logMessage(IBMDBMessages.noStatementMetaData);
                throw new DataRuntimeException(string);
            }
        }
        return this.fieldMetaData;
    }

    public Object getParameter(int n) throws com.ibm.db.DataException {
        if (this.parameters != null) {
            try {
                return this.parameters.getAtIndex(n);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                String string = Utilities.logMessage(IBMDBMessages.noSuchParm);
                throw new IndexOutOfBoundsException(string);
            }
        }
        String string = Utilities.logMessage(IBMDBMessages.noSuchParm);
        throw new IndexOutOfBoundsException(string);
    }

    public Object getParameter(String string) throws com.ibm.db.DataException {
        if (this.fieldMetaData == null) {
            String string2 = Utilities.logMessage(IBMDBMessages.noSuchParm);
            throw new IndexOutOfBoundsException(string2);
        }
        int n = this.fieldMetaData.getParameterIndex(string);
        return this.getParameter(n);
    }

    protected DatabaseRow getParameters() {
        return this.parameters;
    }

    public String getParameterToString(int n) throws com.ibm.db.DataException {
        String string = null;
        Object object = this.getParameter(n);
        if (object == null) {
            string = null;
            return string;
        }
        Class<?> clazz = object.getClass();
        Class<?> clazz2 = class$java$lang$String;
        if (clazz2 == null) {
            try {
                clazz2 = class$java$lang$String = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2) {
            string = (String)object;
        } else {
            Class<?> clazz3 = class$java$lang$Integer;
            if (clazz3 == null) {
                try {
                    clazz3 = class$java$lang$Integer = Class.forName("java.lang.Integer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz == clazz3) {
                string = ((Integer)object).toString();
            } else {
                Class<?> clazz4 = class$java$lang$Long;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$java$lang$Long = Class.forName("java.lang.Long");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz == clazz4) {
                    string = ((Long)object).toString();
                } else {
                    Class<?> clazz5 = class$java$lang$Short;
                    if (clazz5 == null) {
                        try {
                            clazz5 = class$java$lang$Short = Class.forName("java.lang.Short");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz == clazz5) {
                        string = ((Short)object).toString();
                    } else {
                        Class<?> clazz6 = class$java$math$BigDecimal;
                        if (clazz6 == null) {
                            try {
                                clazz6 = class$java$math$BigDecimal = Class.forName("java.math.BigDecimal");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (clazz == clazz6) {
                            string = ((BigDecimal)object).toString();
                        } else {
                            Class<?> clazz7 = class$java$lang$Float;
                            if (clazz7 == null) {
                                try {
                                    clazz7 = class$java$lang$Float = Class.forName("java.lang.Float");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (clazz == clazz7) {
                                string = ((Float)object).toString();
                            } else {
                                Class<?> clazz8 = class$java$lang$Double;
                                if (clazz8 == null) {
                                    try {
                                        clazz8 = class$java$lang$Double = Class.forName("java.lang.Double");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if (clazz == clazz8) {
                                    string = ((Double)object).toString();
                                } else {
                                    Class<?> clazz9 = class$java$lang$Boolean;
                                    if (clazz9 == null) {
                                        try {
                                            clazz9 = class$java$lang$Boolean = Class.forName("java.lang.Boolean");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    if (clazz == clazz9) {
                                        string = ((Boolean)object).toString();
                                    } else {
                                        Class<?> clazz10 = class$java$sql$Date;
                                        if (clazz10 == null) {
                                            try {
                                                clazz10 = class$java$sql$Date = Class.forName("java.sql.Date");
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                        }
                                        if (clazz == clazz10) {
                                            string = ((Date)object).toString();
                                        } else {
                                            Class<?> clazz11 = class$java$sql$Time;
                                            if (clazz11 == null) {
                                                try {
                                                    clazz11 = class$java$sql$Time = Class.forName("java.sql.Time");
                                                }
                                                catch (ClassNotFoundException classNotFoundException) {
                                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                }
                                            }
                                            if (clazz == clazz11) {
                                                string = ((Time)object).toString();
                                            } else {
                                                Class<?> clazz12 = class$java$sql$Timestamp;
                                                if (clazz12 == null) {
                                                    try {
                                                        clazz12 = class$java$sql$Timestamp = Class.forName("java.sql.Timestamp");
                                                    }
                                                    catch (ClassNotFoundException classNotFoundException) {
                                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                    }
                                                }
                                                if (clazz == clazz12) {
                                                    string = ((Timestamp)object).toString();
                                                } else {
                                                    Class<?> clazz13 = class$array1$$byte;
                                                    if (clazz13 == null) {
                                                        try {
                                                            clazz13 = class$array1$$byte = Class.forName("[B");
                                                        }
                                                        catch (ClassNotFoundException classNotFoundException) {
                                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                        }
                                                    }
                                                    if (clazz != clazz13) {
                                                        string = object.toString();
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return string;
    }

    public String getParameterToString(String string) throws com.ibm.db.DataException {
        if (this.fieldMetaData == null) {
            String string2 = Utilities.logMessage(IBMDBMessages.noSuchParm);
            throw new IndexOutOfBoundsException(string2);
        }
        int n = this.fieldMetaData.getParameterIndex(string);
        return this.getParameterToString(n);
    }

    public int getTimeout() {
        return this.fieldTimeout;
    }

    protected static void handleSQLException(SQLException sQLException) throws com.ibm.db.DataException {
        String string = Utilities.logSQLException(sQLException);
        throw new com.ibm.db.DataException(string, sQLException);
    }

    public boolean isExecuted() {
        return this.fieldExecuted;
    }

    public boolean isReadOnly() {
        return this.fieldReadOnly;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.propertyChange = new PropertyChangeSupport(this);
    }

    public void removeStatementAfterListener(StatementAfterListener statementAfterListener) {
        this.aStatementAfterListener = StatementAfterEventMulticaster.remove(this.aStatementAfterListener, statementAfterListener);
    }

    public void removeStatementBeforeListener(StatementBeforeListener statementBeforeListener) {
        this.aStatementBeforeListener = StatementBeforeEventMulticaster.remove(this.aStatementBeforeListener, statementBeforeListener);
    }

    protected static String replaceHostVars(String string) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (string == null) {
            return null;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            char c;
            char c2 = string.charAt(n2);
            if (bl) {
                if (c2 == '\'') {
                    if (n2 == n - 1) {
                        bl = false;
                    } else {
                        c = string.charAt(n2 + 1);
                        if (c == '\'') {
                            stringBuffer.append(c2);
                            ++n2;
                        } else {
                            bl = false;
                        }
                    }
                }
                stringBuffer.append(c2);
            } else if (bl2) {
                if (c2 == '\"') {
                    if (n2 == n - 1) {
                        bl2 = false;
                    } else {
                        c = string.charAt(n2 + 1);
                        if (c == '\"') {
                            stringBuffer.append(c2);
                            ++n2;
                        } else {
                            bl2 = false;
                        }
                    }
                }
                stringBuffer.append(c2);
            } else if (bl3) {
                if (c2 == ' ' || c2 == ',' || c2 == ')' || c2 == '|') {
                    bl3 = false;
                    stringBuffer.append(c2);
                }
            } else if (c2 == '\'') {
                bl = true;
                stringBuffer.append(c2);
            } else if (c2 == '\"') {
                bl2 = true;
                stringBuffer.append(c2);
            } else if (c2 == ':') {
                bl3 = true;
                stringBuffer.append('?');
            } else {
                stringBuffer.append(c2);
            }
            ++n2;
        }
        String string2 = new String(stringBuffer);
        return string2;
    }

    public void setConnection(DatabaseConnection databaseConnection) {
        this.fieldConnection = databaseConnection;
    }

    public synchronized void setMetaData(StatementMetaData statementMetaData) {
        this.fieldMetaData = statementMetaData;
        DatabaseCompoundType databaseCompoundType = statementMetaData.getParameterShape();
        this.parameters = databaseCompoundType != null ? new DatabaseRow(databaseCompoundType) : null;
        statementMetaData.setStatement(this);
    }

    public void setParameter(int n, Object object) throws com.ibm.db.DataException {
        Object object2;
        boolean bl = true;
        if (this.parameters == null && this.fieldMetaData != null && (object2 = this.fieldMetaData.getParameterShape()) != null) {
            this.parameters = new DatabaseRow((DatabaseCompoundType)object2);
        }
        if (this.parameters == null) {
            object2 = Utilities.logMessage(IBMDBMessages.noSuchParm);
            throw new IndexOutOfBoundsException((String)object2);
        }
        try {
            this.parameters.putAtIndexWithCheck(n, object);
            this.parameters.setColWasChanged(n, true);
            bl = false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            bl = true;
        }
        catch (DataException dataException) {
            Utilities.logBaseException(dataException);
            throw new com.ibm.db.DataException(dataException.getMessage(), dataException.getErrorCode());
        }
        if (bl) {
            object2 = Utilities.logMessage(IBMDBMessages.noSuchParm);
            throw new IndexOutOfBoundsException((String)object2);
        }
    }

    public void setParameter(String string, Object object) throws com.ibm.db.DataException {
        if (this.fieldMetaData == null) {
            String string2 = Utilities.logMessage(IBMDBMessages.noSuchParm);
            throw new IndexOutOfBoundsException(string2);
        }
        int n = this.fieldMetaData.getParameterIndex(string);
        this.setParameter(n, object);
    }

    public void setParameterFromString(int n, String string) throws com.ibm.db.DataException {
        Class clazz;
        block82: {
            block81: {
                if (this.fieldMetaData == null) {
                    String string2 = Utilities.logMessage(IBMDBMessages.noSuchParm);
                    throw new IndexOutOfBoundsException(string2);
                }
                clazz = this.fieldMetaData.getParameterClass(n);
                if (string == null) break block81;
                Class<?> clazz2 = class$java$lang$String;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$java$lang$String = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz == clazz2 || string.length() != 0) break block82;
            }
            this.setParameter(n, null);
            return;
        }
        Class<?> clazz3 = class$java$lang$String;
        if (clazz3 == null) {
            try {
                clazz3 = class$java$lang$String = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz3) {
            this.setParameter(n, (Object)string);
        } else {
            Class<?> clazz4 = class$java$lang$Integer;
            if (clazz4 == null) {
                try {
                    clazz4 = class$java$lang$Integer = Class.forName("java.lang.Integer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz == clazz4) {
                this.setParameter(n, (Object)new Integer(string));
            } else {
                Class<?> clazz5 = class$java$lang$Long;
                if (clazz5 == null) {
                    try {
                        clazz5 = class$java$lang$Long = Class.forName("java.lang.Long");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz == clazz5) {
                    this.setParameter(n, (Object)new Long(string));
                } else {
                    Class<?> clazz6 = class$java$lang$Short;
                    if (clazz6 == null) {
                        try {
                            clazz6 = class$java$lang$Short = Class.forName("java.lang.Short");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz == clazz6) {
                        this.setParameter(n, (Object)new Short(string));
                    } else {
                        Class<?> clazz7 = class$java$math$BigDecimal;
                        if (clazz7 == null) {
                            try {
                                clazz7 = class$java$math$BigDecimal = Class.forName("java.math.BigDecimal");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (clazz == clazz7) {
                            this.setParameter(n, (Object)new BigDecimal(string));
                        } else {
                            Class<?> clazz8 = class$java$lang$Float;
                            if (clazz8 == null) {
                                try {
                                    clazz8 = class$java$lang$Float = Class.forName("java.lang.Float");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (clazz == clazz8) {
                                this.setParameter(n, (Object)new Float(string));
                            } else {
                                Class<?> clazz9 = class$java$lang$Double;
                                if (clazz9 == null) {
                                    try {
                                        clazz9 = class$java$lang$Double = Class.forName("java.lang.Double");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if (clazz == clazz9) {
                                    this.setParameter(n, (Object)new Double(string));
                                } else {
                                    Class<?> clazz10 = class$java$lang$Boolean;
                                    if (clazz10 == null) {
                                        try {
                                            clazz10 = class$java$lang$Boolean = Class.forName("java.lang.Boolean");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    if (clazz == clazz10) {
                                        this.setParameter(n, (Object)Boolean.valueOf(string));
                                    } else {
                                        Class<?> clazz11 = class$java$sql$Date;
                                        if (clazz11 == null) {
                                            try {
                                                clazz11 = class$java$sql$Date = Class.forName("java.sql.Date");
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                        }
                                        if (clazz == clazz11) {
                                            this.setParameter(n, (Object)Date.valueOf(string));
                                        } else {
                                            Class<?> clazz12 = class$java$sql$Time;
                                            if (clazz12 == null) {
                                                try {
                                                    clazz12 = class$java$sql$Time = Class.forName("java.sql.Time");
                                                }
                                                catch (ClassNotFoundException classNotFoundException) {
                                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                }
                                            }
                                            if (clazz == clazz12) {
                                                this.setParameter(n, (Object)Time.valueOf(string));
                                            } else {
                                                Class<?> clazz13 = class$java$sql$Timestamp;
                                                if (clazz13 == null) {
                                                    try {
                                                        clazz13 = class$java$sql$Timestamp = Class.forName("java.sql.Timestamp");
                                                    }
                                                    catch (ClassNotFoundException classNotFoundException) {
                                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                    }
                                                }
                                                if (clazz == clazz13) {
                                                    this.setParameter(n, (Object)Timestamp.valueOf(string));
                                                } else {
                                                    Class<?> clazz14 = class$array1$$byte;
                                                    if (clazz14 == null) {
                                                        try {
                                                            clazz14 = class$array1$$byte = Class.forName("[B");
                                                        }
                                                        catch (ClassNotFoundException classNotFoundException) {
                                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                        }
                                                    }
                                                    if (clazz == clazz14) {
                                                        this.setParameter(n, (Object)string.getBytes());
                                                    } else {
                                                        String string3 = Utilities.logMessage(IBMDBMessages.cannotConvert);
                                                        throw new com.ibm.db.DataException(string3, 222);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public void setParameterFromString(String string, String string2) throws com.ibm.db.DataException {
        if (this.fieldMetaData == null) {
            String string3 = Utilities.logMessage(IBMDBMessages.noSuchParm);
            throw new IndexOutOfBoundsException(string3);
        }
        int n = this.fieldMetaData.getParameterIndex(string);
        this.setParameterFromString(n, string2);
    }

    public void setReadOnly(boolean bl) {
        this.fieldReadOnly = bl;
    }

    public void setTimeout(int n) {
        this.fieldTimeout = n;
    }
}

