/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db.base;

import com.ibm.db.base.DataException;
import com.ibm.db.base.IBMDBBaseMessages;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.sql.DriverManager;
import java.text.MessageFormat;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class UtilitiesBase {
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1998, 1999";

    protected static byte decodeByte(StringReader stringReader) throws IOException {
        char[] cArray = new char[2];
        while ((cArray[0] = (char)stringReader.read()) == '\n' || cArray[0] == '\r' || cArray[0] == '\f') {
        }
        if (cArray[0] == '\uffff') {
            throw new IOException();
        }
        if (cArray[0] == 'g') {
            return 0;
        }
        cArray[1] = (char)stringReader.read();
        if (cArray[0] == '\uffff') {
            throw new IOException();
        }
        return (byte)Integer.parseInt(new String(cArray), 16);
    }

    public static byte[] decodeData(String string) {
        StringReader stringReader = new StringReader(string);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string.length() / 2);
        boolean bl = false;
        while (!bl) {
            try {
                byteArrayOutputStream.write(UtilitiesBase.decodeByte(stringReader));
            }
            catch (IOException iOException) {
                bl = true;
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected static void encodeByte(byte by, StringWriter stringWriter) {
        if (by == 0) {
            stringWriter.write(103);
        } else {
            String string = Integer.toHexString(by);
            if (string.length() < 2) {
                stringWriter.write(48);
                stringWriter.write(string);
            } else {
                char[] cArray = new char[2];
                string.getChars(string.length() - 2, string.length(), cArray, 0);
                stringWriter.write(cArray, 0, 2);
            }
        }
    }

    public static String encodeData(byte[] byArray, int n) {
        StringWriter stringWriter = new StringWriter();
        int n2 = 0;
        while (n2 < byArray.length) {
            UtilitiesBase.encodeByte(byArray[n2], stringWriter);
            if ((n2 + 1) % n == 0) {
                stringWriter.write("\n");
            }
            ++n2;
        }
        return stringWriter.toString();
    }

    protected static String getMessage(String string) {
        String string2 = IBMDBBaseMessages.getText(string);
        return string2;
    }

    public static String getMessage(String string, Object[] objectArray) {
        String string2 = IBMDBBaseMessages.getText(string);
        String string3 = MessageFormat.format(string2, objectArray);
        return string3;
    }

    protected static String logMessage(String string) {
        String string2;
        PrintStream printStream = DriverManager.getLogStream();
        if (printStream == null) {
            printStream = System.out;
        }
        if ((string2 = UtilitiesBase.getMessage(string)) != null) {
            printStream.println(string2);
        } else {
            printStream.println(string);
        }
        return string2;
    }

    protected static String logMessage(String string, Object[] objectArray) {
        PrintStream printStream = DriverManager.getLogStream();
        if (printStream == null) {
            printStream = System.out;
        }
        String string2 = UtilitiesBase.getMessage(string, objectArray);
        printStream.println(string2);
        return string2;
    }

    protected static String password(String string) throws DataException {
        if (string == null || string.equals("")) {
            return string;
        }
        String string2 = null;
        byte[] byArray = null;
        try {
            byArray = UtilitiesBase.decodeData(string);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            string2 = (String)objectInputStream.readObject();
        }
        catch (Throwable throwable) {
            String string3 = throwable.getMessage();
            throw new DataException(string3, 111);
        }
        return string2;
    }

    public static byte[] unzipData(byte[] byArray) throws DataException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(byteArrayInputStream));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(10000);
        String string = null;
        try {
            try {
                int n;
                zipInputStream.getNextEntry();
                byte[] byArray2 = new byte[1024];
                while ((n = zipInputStream.read(byArray2, 0, byArray2.length)) != -1) {
                    byteArrayOutputStream.write(byArray2, 0, n);
                }
            }
            catch (IOException iOException) {
                string = String.valueOf(UtilitiesBase.getMessage(IBMDBBaseMessages.unzipError)) + iOException.toString();
            }
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            try {
                zipInputStream.closeEntry();
                zipInputStream.close();
                ((InputStream)byteArrayInputStream).close();
                ((OutputStream)byteArrayOutputStream).close();
            }
            catch (Throwable throwable2) {}
            throw throwable;
        }
        Object var5_10 = null;
        try {
            zipInputStream.closeEntry();
            zipInputStream.close();
            ((InputStream)byteArrayInputStream).close();
            ((OutputStream)byteArrayOutputStream).close();
        }
        catch (Throwable throwable) {}
        if (string != null) {
            throw new DataException(string, 110);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] zipData(byte[] byArray) throws DataException {
        String string = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
        ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);
        try {
            try {
                ZipEntry zipEntry = new ZipEntry("builder data");
                zipEntry.setSize(byArray.length);
                zipOutputStream.putNextEntry(zipEntry);
                zipOutputStream.write(byArray);
            }
            catch (IOException iOException) {
                string = String.valueOf(UtilitiesBase.getMessage(IBMDBBaseMessages.zipError)) + iOException.toString();
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            try {
                zipOutputStream.closeEntry();
                ((OutputStream)byteArrayOutputStream).close();
                zipOutputStream.close();
            }
            catch (Throwable throwable2) {}
            throw throwable;
        }
        Object var4_8 = null;
        try {
            zipOutputStream.closeEntry();
            ((OutputStream)byteArrayOutputStream).close();
            zipOutputStream.close();
        }
        catch (Throwable throwable) {}
        if (string != null) {
            throw new DataException(string, 109);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

