/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db.selector;

import com.ibm.db.selector.CellRangeSelector;
import com.ibm.db.selector.ColumnSelector;
import com.ibm.db.selector.IBMSelectorMessages;
import com.ibm.db.selector.RowSelector;
import com.ibm.db.selector.SelectionInfo;
import com.ibm.db.selector.SelectorEvent;
import com.ibm.db.selector.SelectorException;
import com.ibm.db.selector.SelectorListener;
import com.ibm.db.selector.Utilities;
import com.sun.java.swing.event.TableModelListener;
import com.sun.java.swing.table.TableModel;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Vector;

public abstract class Selector
implements Serializable {
    static final long serialVersionUID = -5274036883285906265L;
    static String sCoercion = "err.DataCoerce";
    static String sNull = "null";
    public static final int NONE = -2;
    public static final int NULL = -1;
    public static final int NATIVE = 0;
    public static final int BOOLEAN = 1;
    public static final int BYTE = 3;
    public static final int SHORT = 4;
    public static final int INT = 5;
    public static final int LONG = 6;
    public static final int FLOAT = 7;
    public static final int DOUBLE = 8;
    public static final int BIGINTEGER = 9;
    public static final int BIGDECIMAL = 10;
    public static final int DATE = 11;
    public static final int TIME = 12;
    public static final int TIMESTAMP = 13;
    public static final int BYTEARRAY = 14;
    public static final int STRING = 15;
    public static final int OBJECT = 16;
    public static final int VECTOR = 17;
    public static final int VECTOR_ARRAY = 18;
    public static final int VECTOR_OF_VECTORS = 19;
    public static final int NO_MAXIMUM = Integer.MIN_VALUE;
    static final String PROPERTY_NATIVE = "native";
    static final String PROPERTY_BOOLEAN = "boolean";
    static final String PROPERTY_BYTE = "byte";
    static final String PROPERTY_SHORT = "short";
    static final String PROPERTY_INT = "int";
    static final String PROPERTY_LONG = "long";
    static final String PROPERTY_FLOAT = "float";
    static final String PROPERTY_DOUBLE = "double";
    static final String PROPERTY_BIGINTEGER = "bigInteger";
    static final String PROPERTY_BIGDECIMAL = "bigDecimal";
    static final String PROPERTY_DATE = "date";
    static final String PROPERTY_TIME = "time";
    static final String PROPERTY_TIMESTAMP = "timestamp";
    static final String PROPERTY_BYTEARRAY = "byteArray";
    static final String PROPERTY_STRING = "string";
    static final String PROPERTY_OBJECT = "object";
    static final String PROPERTY_VECTOR = "vector";
    static final String PROPERTY_VECTOR_ARRAY = "vectorArray";
    static final String PROPERTY_VECTOR_OF_VECTORS = "vectorOfVectors";
    static final String PROPERTY_MODEL = "model";
    static final String PROPERTY_NOTIFICATION_TYPE = "notificationType";
    static final String PROPERTY_VECTOR_CONTENT_TYPE = "vectorContentType";
    static final String PROPERTY_INDEX_FROM_ONE = "indexFromOne";
    static final String PROPERTY_COLUMN_NAMES = "columnNames";
    private int fNotificationType = -2;
    private int fVectorContentType = 0;
    private boolean fIndexFromOne = false;
    private TableModel fTableModel = null;
    private transient PropertyChangeSupport fPropertyChangeSupport = null;
    private transient Vector fSelectorListeners = null;
    private transient TableModelListener fTableModelListener = null;
    transient boolean fCheckReadyDone = false;
    static Class class$array1$$byte;
    static Class class$java$lang$Short;
    static Class class$java$sql$Time;
    static Class class$java$lang$Boolean;
    static Class class$java$lang$Byte;
    static Class class$java$sql$Timestamp;
    static Class class$java$lang$Float;
    static Class class$java$lang$Double;
    static Class class$java$math$BigInteger;
    static Class class$java$lang$Long;
    static Class class$java$sql$Date;
    static Class class$java$lang$Integer;
    static Class class$java$lang$String;
    static Class class$java$lang$Object;
    static Class class$java$math$BigDecimal;

    Selector() {
        this.initialise();
    }

    Selector(TableModel tableModel) {
        this();
        this.setModel(tableModel);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void addSelectorListener(SelectorListener selectorListener) {
        if (!this.fSelectorListeners.contains(selectorListener)) {
            this.fSelectorListeners.addElement(selectorListener);
        }
    }

    void checkNotifyData(boolean bl) {
        if (this.fTableModel != null && bl) {
            this.notifyData();
        }
    }

    boolean checkReady() {
        boolean bl = true;
        TableModel tableModel = this.getModel();
        if (tableModel == null) {
            throw new SelectorException(Utilities.logMessage(IBMSelectorMessages.err_NoInputTab), 201);
        }
        if (tableModel.getColumnCount() == 0 || tableModel.getRowCount() == 0) {
            bl = false;
        }
        return bl;
    }

    static Object coerce(Object object, int n) {
        Object object2 = null;
        if (object != null) {
            switch (n) {
                case 1: {
                    object2 = new Boolean(Selector.getBoolean(object));
                    break;
                }
                case 3: {
                    object2 = new Byte(Selector.getByte(object));
                    break;
                }
                case 4: {
                    object2 = new Short(Selector.getShort(object));
                    break;
                }
                case 5: {
                    object2 = new Integer(Selector.getInt(object));
                    break;
                }
                case 6: {
                    object2 = new Long(Selector.getLong(object));
                    break;
                }
                case 7: {
                    object2 = new Float(Selector.getFloat(object));
                    break;
                }
                case 8: {
                    object2 = new Double(Selector.getDouble(object));
                    break;
                }
                case 9: {
                    object2 = Selector.getBigInteger(object);
                    break;
                }
                case 10: {
                    object2 = Selector.getBigDecimal(object);
                    break;
                }
                case 11: {
                    object2 = Selector.getDate(object);
                    break;
                }
                case 12: {
                    object2 = Selector.getTime(object);
                    break;
                }
                case 13: {
                    object2 = Selector.getTimestamp(object);
                    break;
                }
                case 14: {
                    object2 = Selector.getByteArray(object);
                    break;
                }
                case 15: {
                    object2 = Selector.getString(object);
                    break;
                }
                case 0: 
                case 16: {
                    object2 = object;
                    break;
                }
            }
        }
        return object2;
    }

    public static Object coerce(Object object, Class clazz) {
        return Selector.coerce(object, clazz, false);
    }

    public static Object coerce(Object object, Class clazz, boolean bl) {
        Object object2 = null;
        if (bl) {
            object2 = Selector.coerce(object, Selector.typeFromClass(clazz));
        } else {
            try {
                object2 = Selector.coerce(object, Selector.typeFromClass(clazz));
            }
            catch (SelectorException selectorException) {}
        }
        return object2;
    }

    private static String copyright() {
        return "\n\n(c) Copyright IBM Corporation 1999 (1998).\n\n";
    }

    public static Serializable deserializeFromByteArray(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = null;
        Serializable serializable = null;
        try {
            objectInputStream = new ObjectInputStream(byteArrayInputStream);
            serializable = (Serializable)objectInputStream.readObject();
        }
        catch (StreamCorruptedException streamCorruptedException) {
            streamCorruptedException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return serializable;
    }

    void fireDataChanged(int n) {
        Enumeration enumeration = ((Vector)this.fSelectorListeners.clone()).elements();
        SelectorEvent selectorEvent = new SelectorEvent(this);
        while (enumeration.hasMoreElements()) {
            ((SelectorListener)enumeration.nextElement()).dataChanged(selectorEvent);
        }
    }

    static BigDecimal[][] getBigDecimal(CellRangeSelector cellRangeSelector) {
        BigDecimal[][] bigDecimalArray = null;
        SelectionInfo selectionInfo = cellRangeSelector.getSelectionInfo();
        if (selectionInfo != null) {
            bigDecimalArray = selectionInfo.fInvertData ? new BigDecimal[selectionInfo.fColumns][selectionInfo.fRows] : new BigDecimal[selectionInfo.fRows][selectionInfo.fColumns];
            int n = 0;
            int n2 = selectionInfo.fStartColumnNumber;
            while (n2 <= selectionInfo.fEndColumnNumber) {
                int n3 = 0;
                int n4 = selectionInfo.fStartRowNumber;
                while (n4 <= selectionInfo.fEndRowNumber) {
                    BigDecimal bigDecimal = Selector.getBigDecimal(selectionInfo.fTableModel.getValueAt(n4, n2));
                    if (selectionInfo.fInvertData) {
                        bigDecimalArray[n][n3] = bigDecimal;
                    } else {
                        bigDecimalArray[n3][n] = bigDecimal;
                    }
                    ++n3;
                    ++n4;
                }
                ++n;
                ++n2;
            }
        }
        return bigDecimalArray;
    }

    static BigDecimal[] getBigDecimal(ColumnSelector columnSelector) {
        BigDecimal[] bigDecimalArray = null;
        SelectionInfo selectionInfo = columnSelector.getSelectionInfo();
        if (selectionInfo != null) {
            bigDecimalArray = Selector.getBigDecimal(selectionInfo.fTableModel, selectionInfo.fRows, selectionInfo.fStartRowNumber, selectionInfo.fEndRowNumber, selectionInfo.fColumnNumber, false);
        }
        return bigDecimalArray;
    }

    static BigDecimal[] getBigDecimal(RowSelector rowSelector) {
        BigDecimal[] bigDecimalArray = null;
        SelectionInfo selectionInfo = rowSelector.getSelectionInfo();
        if (selectionInfo != null) {
            bigDecimalArray = Selector.getBigDecimal(selectionInfo.fTableModel, selectionInfo.fColumns, selectionInfo.fStartColumnNumber, selectionInfo.fEndColumnNumber, selectionInfo.fRowNumber, true);
        }
        return bigDecimalArray;
    }

    static BigDecimal[] getBigDecimal(TableModel tableModel, int n, int n2, int n3, int n4, boolean bl) {
        BigDecimal[] bigDecimalArray = new BigDecimal[n];
        int n5 = 0;
        int n6 = n2;
        while (n6 <= n3) {
            bigDecimalArray[n5++] = Selector.getBigDecimal(Selector.getValueAt(tableModel, bl, n6, n4));
            ++n6;
        }
        return bigDecimalArray;
    }

    public static BigDecimal getBigDecimal(Object object) {
        boolean bl = true;
        BigDecimal bigDecimal = null;
        if (object instanceof Number) {
            try {
                bigDecimal = new BigDecimal(((Number)object).doubleValue());
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        } else if (object instanceof String) {
            try {
                bigDecimal = new BigDecimal((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        } else if (object instanceof Character) {
            int n = Character.getNumericValue(((Character)object).charValue());
            if (n > 0) {
                bigDecimal = BigDecimal.valueOf(new Integer(n).longValue());
            }
        } else if (object instanceof Boolean) {
            bigDecimal = (Boolean)object != false ? BigDecimal.valueOf(1L) : BigDecimal.valueOf(0L);
        } else if (object != null) {
            bl = false;
        }
        if (!bl) {
            throw new SelectorException(Utilities.logMessage(IBMSelectorMessages.err_DataCoerce, new Object[]{object, Selector.typeNameFromType(10)}), 209);
        }
        return bigDecimal;
    }

    static BigInteger[][] getBigInteger(CellRangeSelector cellRangeSelector) {
        BigInteger[][] bigIntegerArray = null;
        SelectionInfo selectionInfo = cellRangeSelector.getSelectionInfo();
        if (selectionInfo != null) {
            bigIntegerArray = selectionInfo.fInvertData ? new BigInteger[selectionInfo.fColumns][selectionInfo.fRows] : new BigInteger[selectionInfo.fRows][selectionInfo.fColumns];
            int n = 0;
            int n2 = selectionInfo.fStartColumnNumber;
            while (n2 <= selectionInfo.fEndColumnNumber) {
                int n3 = 0;
                int n4 = selectionInfo.fStartRowNumber;
                while (n4 <= selectionInfo.fEndRowNumber) {
                    BigInteger bigInteger = Selector.getBigInteger(selectionInfo.fTableModel.getValueAt(n4, n2));
                    if (selectionInfo.fInvertData) {
                        bigIntegerArray[n][n3] = bigInteger;
                    } else {
                        bigIntegerArray[n3][n] = bigInteger;
                    }
                    ++n3;
                    ++n4;
                }
                ++n;
                ++n2;
            }
        }
        return bigIntegerArray;
    }

    static BigInteger[] getBigInteger(ColumnSelector columnSelector) {
        BigInteger[] bigIntegerArray = null;
        SelectionInfo selectionInfo = columnSelector.getSelectionInfo();
        if (selectionInfo != null) {
            bigIntegerArray = Selector.getBigInteger(selectionInfo.fTableModel, selectionInfo.fRows, selectionInfo.fStartRowNumber, selectionInfo.fEndRowNumber, selectionInfo.fColumnNumber, false);
        }
        return bigIntegerArray;
    }

    static BigInteger[] getBigInteger(RowSelector rowSelector) {
        BigInteger[] bigIntegerArray = null;
        SelectionInfo selectionInfo = rowSelector.getSelectionInfo();
        if (selectionInfo != null) {
            bigIntegerArray = Selector.getBigInteger(selectionInfo.fTableModel, selectionInfo.fColumns, selectionInfo.fStartColumnNumber, selectionInfo.fEndColumnNumber, selectionInfo.fRowNumber, true);
        }
        return bigIntegerArray;
    }

    static BigInteger[] getBigInteger(TableModel tableModel, int n, int n2, int n3, int n4, boolean bl) {
        BigInteger[] bigIntegerArray = new BigInteger[n];
        int n5 = 0;
        int n6 = n2;
        while (n6 <= n3) {
            bigIntegerArray[n5++] = Selector.getBigInteger(Selector.getValueAt(tableModel, bl, n6, n4));
            ++n6;
        }
        return bigIntegerArray;
    }

    public static BigInteger getBigInteger(Object object) {
        boolean bl = true;
        BigInteger bigInteger = null;
        if (object instanceof Number) {
            bigInteger = BigInteger.valueOf(((Number)object).longValue());
        } else if (object instanceof String) {
            try {
                bigInteger = new BigInteger((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        } else if (object instanceof Character) {
            int n = Character.getNumericValue(((Character)object).charValue());
            if (n > 0) {
                bigInteger = BigInteger.valueOf(new Integer(n).longValue());
            }
        } else if (object instanceof Boolean) {
            bigInteger = (Boolean)object != false ? BigInteger.valueOf(1L) : BigInteger.valueOf(0L);
        } else if (object != null) {
            bl = false;
        }
        if (!bl) {
            throw new SelectorException(Utilities.logMessage(IBMSelectorMessages.err_DataCoerce, new Object[]{object, Selector.typeNameFromType(9)}), 209);
        }
        return bigInteger;
    }

    static boolean[][] getBoolean(CellRangeSelector cellRangeSelector) {
        boolean[][] blArray = null;
        SelectionInfo selectionInfo = cellRangeSelector.getSelectionInfo();
        if (selectionInfo != null) {
            blArray = selectionInfo.fInvertData ? new boolean[selectionInfo.fColumns][selectionInfo.fRows] : new boolean[selectionInfo.fRows][selectionInfo.fColumns];
            int n = 0;
            int n2 = selectionInfo.fStartColumnNumber;
            while (n2 <= selectionInfo.fEndColumnNumber) {
                int n3 = 0;
                int n4 = selectionInfo.fStartRowNumber;
                while (n4 <= selectionInfo.fEndRowNumber) {
                    boolean bl = Selector.getBoolean(selectionInfo.fTableModel.getValueAt(n4, n2));
                    if (selectionInfo.fInvertData) {
                        blArray[n][n3] = bl;
                    } else {
                        blArray[n3][n] = bl;
                    }
                    ++n3;
                    ++n4;
                }
                ++n;
                ++n2;
            }
        }
        return blArray;
    }

    static boolean[] getBoolean(ColumnSelector columnSelector) {
        boolean[] blArray = null;
        SelectionInfo selectionInfo = columnSelector.getSelectionInfo();
        if (selectionInfo != null) {
            blArray = Selector.getBoolean(selectionInfo.fTableModel, selectionInfo.fRows, selectionInfo.fStartRowNumber, selectionInfo.fEndRowNumber, selectionInfo.fColumnNumber, false);
        }
        return blArray;
    }

    static boolean[] getBoolean(RowSelector rowSelector) {
        boolean[] blArray = null;
        SelectionInfo selectionInfo = rowSelector.getSelectionInfo();
        if (selectionInfo != null) {
            blArray = Selector.getBoolean(selectionInfo.fTableModel, selectionInfo.fColumns, selectionInfo.fStartColumnNumber, selectionInfo.fEndColumnNumber, selectionInfo.fRowNumber, true);
        }
        return blArray;
    }

    static boolean[] getBoolean(TableModel tableModel, int n, int n2, int n3, int n4, boolean bl) {
        boolean[] blArray = new boolean[n];
        int n5 = 0;
        int n6 = n2;
        while (n6 <= n3) {
            blArray[n5++] = Selector.getBoolean(Selector.getValueAt(tableModel, bl, n6, n4));
            ++n6;
        }
        return blArray;
    }

    public static boolean getBoolean(Object object) {
        boolean bl = false;
        if (object instanceof Boolean) {
            bl = (Boolean)object;
        } else if (object instanceof String) {
            bl = Boolean.valueOf((String)object);
        } else if (object instanceof Number) {
            bl = ((Number)object).intValue() != 0;
        } else if (object instanceof Character) {
            bl = Character.getNumericValue(((Character)object).charValue()) > 0;
        } else {
            throw new SelectorException(Utilities.logMessage(IBMSelectorMessages.err_DataCoerce, new Object[]{object == null ? sNull : object, Selector.typeNameFromType(1)}), 209);
        }
        return bl;
    }

    static byte[][] getByte(CellRangeSelector cellRangeSelector) {
        byte[][] byArray = null;
        SelectionInfo selectionInfo = cellRangeSelector.getSelectionInfo();
        if (selectionInfo != null) {
            byArray = selectionInfo.fInvertData ? new byte[selectionInfo.fColumns][selectionInfo.fRows] : new byte[selectionInfo.fRows][selectionInfo.fColumns];
            int n = 0;
            int n2 = selectionInfo.fStartColumnNumber;
            while (n2 <= selectionInfo.fEndColumnNumber) {
                int n3 = 0;
                int n4 = selectionInfo.fStartRowNumber;
                while (n4 <= selectionInfo.fEndRowNumber) {
                    byte by = Selector.getByte(selectionInfo.fTableModel.getValueAt(n4, n2));
                    if (selectionInfo.fInvertData) {
                        byArray[n][n3] = by;
                    } else {
                        byArray[n3][n] = by;
                    }
                    ++n3;
                    ++n4;
                }
                ++n;
                ++n2;
            }
        }
        return byArray;
    }

    static byte[] getByte(ColumnSelector columnSelector) {
        byte[] byArray = null;
        SelectionInfo selectionInfo = columnSelector.getSelectionInfo();
        if (selectionInfo != null) {
            byArray = Selector.getByte(selectionInfo.fTableModel, selectionInfo.fRows, selectionInfo.fStartRowNumber, selectionInfo.fEndRowNumber, selectionInfo.fColumnNumber, false);
        }
        return byArray;
    }

    static byte[] getByte(RowSelector rowSelector) {
        byte[] byArray = null;
        SelectionInfo selectionInfo = rowSelector.getSelectionInfo();
        if (selectionInfo != null) {
            byArray = Selector.getByte(selectionInfo.fTableModel, selectionInfo.fColumns, selectionInfo.fStartColumnNumber, selectionInfo.fEndColumnNumber, selectionInfo.fRowNumber, true);
        }
        return byArray;
    }

    static byte[] getByte(TableModel tableModel, int n, int n2, int n3, int n4, boolean bl) {
        byte[] byArray = new byte[n];
        int n5 = 0;
        int n6 = n2;
        while (n6 <= n3) {
            byArray[n5++] = Selector.getByte(Selector.getValueAt(tableModel, bl, n6, n4));
            ++n6;
        }
        return byArray;
    }

    public static byte getByte(Object object) {
        boolean bl = true;
        byte by = 0;
        if (object instanceof Number) {
            by = ((Number)object).byteValue();
        } else if (object instanceof String) {
            try {
                by = Byte.parseByte((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        } else if (object instanceof Character) {
            int n = Character.getNumericValue(((Character)object).charValue());
            if (n > 0) {
                by = new Integer(n).byteValue();
            }
        } else if (object instanceof Boolean) {
            by = (Boolean)object != false ? (byte)1 : 0;
        } else {
            bl = false;
        }
        if (!bl) {
            throw new SelectorException(Utilities.logMessage(IBMSelectorMessages.err_DataCoerce, new Object[]{object == null ? sNull : object, Selector.typeNameFromType(3)}), 209);
        }
        return by;
    }

    static byte[][][] getByteArray(CellRangeSelector cellRangeSelector) {
        byte[][][] byArray = null;
        SelectionInfo selectionInfo = cellRangeSelector.getSelectionInfo();
        if (selectionInfo != null) {
            byArray = selectionInfo.fInvertData ? new byte[selectionInfo.fColumns][selectionInfo.fRows][] : new byte[selectionInfo.fRows][selectionInfo.fColumns][];
            int n = 0;
            int n2 = selectionInfo.fStartColumnNumber;
            while (n2 <= selectionInfo.fEndColumnNumber) {
                int n3 = 0;
                int n4 = selectionInfo.fStartRowNumber;
                while (n4 <= selectionInfo.fEndRowNumber) {
                    byte[] byArray2 = Selector.getByteArray(selectionInfo.fTableModel.getValueAt(n4, n2));
                    if (selectionInfo.fInvertData) {
                        byArray[n][n3] = byArray2;
                    } else {
                        byArray[n3][n] = byArray2;
                    }
                    ++n3;
                    ++n4;
                }
                ++n;
                ++n2;
            }
        }
        return byArray;
    }

    static byte[][] getByteArray(ColumnSelector columnSelector) {
        byte[][] byArray = null;
        SelectionInfo selectionInfo = columnSelector.getSelectionInfo();
        if (selectionInfo != null) {
            byArray = Selector.getByteArray(selectionInfo.fTableModel, selectionInfo.fRows, selectionInfo.fStartRowNumber, selectionInfo.fEndRowNumber, selectionInfo.fColumnNumber, false);
        }
        return byArray;
    }

    static byte[][] getByteArray(RowSelector rowSelector) {
        byte[][] byArray = null;
        SelectionInfo selectionInfo = rowSelector.getSelectionInfo();
        if (selectionInfo != null) {
            byArray = Selector.getByteArray(selectionInfo.fTableModel, selectionInfo.fColumns, selectionInfo.fStartColumnNumber, selectionInfo.fEndColumnNumber, selectionInfo.fRowNumber, true);
        }
        return byArray;
    }

    static byte[][] getByteArray(TableModel tableModel, int n, int n2, int n3, int n4, boolean bl) {
        byte[][] byArray = new byte[n][];
        int n5 = 0;
        int n6 = n2;
        while (n6 <= n3) {
            byArray[n5++] = Selector.getByteArray(Selector.getValueAt(tableModel, bl, n6, n4));
            ++n6;
        }
        return byArray;
    }

    public static byte[] getByteArray(Object object) {
        boolean bl = true;
        byte[] byArray = null;
        if (object instanceof byte[]) {
            byArray = (byte[])object;
        } else if (object instanceof String) {
            byArray = ((String)object).getBytes();
        } else if (object != null) {
            bl = false;
        }
        if (!bl) {
            throw new SelectorException(Utilities.logMessage(IBMSelectorMessages.err_DataCoerce, new Object[]{object, Selector.typeNameFromType(14)}), 209);
        }
        return byArray;
    }

    public int getColumns() {
        return this.fTableModel == null ? 0 : this.fTableModel.getColumnCount();
    }

    static Date[][] getDate(CellRangeSelector cellRangeSelector) {
        Date[][] dateArray = null;
        SelectionInfo selectionInfo = cellRangeSelector.getSelectionInfo();
        if (selectionInfo != null) {
            dateArray = selectionInfo.fInvertData ? new Date[selectionInfo.fColumns][selectionInfo.fRows] : new Date[selectionInfo.fRows][selectionInfo.fColumns];
            int n = 0;
            int n2 = selectionInfo.fStartColumnNumber;
            while (n2 <= selectionInfo.fEndColumnNumber) {
                int n3 = 0;
                int n4 = selectionInfo.fStartRowNumber;
                while (n4 <= selectionInfo.fEndRowNumber) {
                    Date date = Selector.getDate(selectionInfo.fTableModel.getValueAt(n4, n2));
                    if (selectionInfo.fInvertData) {
                        dateArray[n][n3] = date;
                    } else {
                        dateArray[n3][n] = date;
                    }
                    ++n3;
                    ++n4;
                }
                ++n;
                ++n2;
            }
        }
        return dateArray;
    }

    static Date[] getDate(ColumnSelector columnSelector) {
        Date[] dateArray = null;
        SelectionInfo selectionInfo = columnSelector.getSelectionInfo();
        if (selectionInfo != null) {
            dateArray = Selector.getDate(selectionInfo.fTableModel, selectionInfo.fRows, selectionInfo.fStartRowNumber, selectionInfo.fEndRowNumber, selectionInfo.fColumnNumber, false);
        }
        return dateArray;
    }

    static Date[] getDate(RowSelector rowSelector) {
        Date[] dateArray = null;
        SelectionInfo selectionInfo = rowSelector.getSelectionInfo();
        if (selectionInfo != null) {
            dateArray = Selector.getDate(selectionInfo.fTableModel, selectionInfo.fColumns, selectionInfo.fStartColumnNumber, selectionInfo.fEndColumnNumber, selectionInfo.fRowNumber, true);
        }
        return dateArray;
    }

    static Date[] getDate(TableModel tableModel, int n, int n2, int n3, int n4, boolean bl) {
        Date[] dateArray = new Date[n];
        int n5 = 0;
        int n6 = n2;
        while (n6 <= n3) {
            dateArray[n5++] = Selector.getDate(Selector.getValueAt(tableModel, bl, n6, n4));
            ++n6;
        }
        return dateArray;
    }

    public static Date getDate(Object object) {
        boolean bl = true;
        Date date = null;
        if (object instanceof java.util.Date) {
            date = new Date(((java.util.Date)object).getTime());
        } else if (object instanceof Number) {
            date = new Date(((Number)object).longValue());
        } else if (object instanceof String) {
            try {
                date = Date.valueOf((String)object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                bl = false;
            }
        } else if (object != null) {
            bl = false;
        }
        if (!bl) {
            throw new SelectorException(Utilities.logMessage(IBMSelectorMessages.err_DataCoerce, new Object[]{object, Selector.typeNameFromType(11)}), 209);
        }
        return date;
    }

    static double[][] getDouble(CellRangeSelector cellRangeSelector) {
        double[][] dArray = null;
        SelectionInfo selectionInfo = cellRangeSelector.getSelectionInfo();
        if (selectionInfo != null) {
            dArray = selectionInfo.fInvertData ? new double[selectionInfo.fColumns][selectionInfo.fRows] : new double[selectionInfo.fRows][selectionInfo.fColumns];
            int n = 0;
            int n2 = selectionInfo.fStartColumnNumber;
            while (n2 <= selectionInfo.fEndColumnNumber) {
                int n3 = 0;
                int n4 = selectionInfo.fStartRowNumber;
                while (n4 <= selectionInfo.fEndRowNumber) {
                    double d = Selector.getDouble(selectionInfo.fTableModel.getValueAt(n4, n2));
                    if (selectionInfo.fInvertData) {
                        dArray[n][n3] = d;
                    } else {
                        dArray[n3][n] = d;
                    }
                    ++n3;
                    ++n4;
                }
                ++n;
                ++n2;
            }
        }
        return dArray;
    }

    static double[] getDouble(ColumnSelector columnSelector) {
        double[] dArray = null;
        SelectionInfo selectionInfo = columnSelector.getSelectionInfo();
        if (selectionInfo != null) {
            dArray = Selector.getDouble(selectionInfo.fTableModel, selectionInfo.fRows, selectionInfo.fStartRowNumber, selectionInfo.fEndRowNumber, selectionInfo.fColumnNumber, false);
        }
        return dArray;
    }

    static double[] getDouble(RowSelector rowSelector) {
        double[] dArray = null;
        SelectionInfo selectionInfo = rowSelector.getSelectionInfo();
        if (selectionInfo != null) {
            dArray = Selector.getDouble(selectionInfo.fTableModel, selectionInfo.fColumns, selectionInfo.fStartColumnNumber, selectionInfo.fEndColumnNumber, selectionInfo.fRowNumber, true);
        }
        return dArray;
    }

    static double[] getDouble(TableModel tableModel, int n, int n2, int n3, int n4, boolean bl) {
        double[] dArray = new double[n];
        int n5 = 0;
        int n6 = n2;
        while (n6 <= n3) {
            dArray[n5++] = Selector.getDouble(Selector.getValueAt(tableModel, bl, n6, n4));
            ++n6;
        }
        return dArray;
    }

    public static double getDouble(Object object) {
        boolean bl = true;
        double d = 0.0;
        if (object instanceof Number) {
            d = ((Number)object).doubleValue();
        } else if (object instanceof String) {
            try {
                d = Double.valueOf((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        } else if (object instanceof Character) {
            int n = Character.getNumericValue(((Character)object).charValue());
            if (n > 0) {
                d = new Integer(n).doubleValue();
            }
        } else if (object instanceof Boolean) {
            d = (Boolean)object != false ? 1.0 : 0.0;
        } else {
            bl = false;
        }
        if (!bl) {
            throw new SelectorException(Utilities.logMessage(IBMSelectorMessages.err_DataCoerce, new Object[]{object == null ? sNull : object, Selector.typeNameFromType(8)}), 209);
        }
        return d;
    }

    static float[][] getFloat(CellRangeSelector cellRangeSelector) {
        float[][] fArray = null;
        SelectionInfo selectionInfo = cellRangeSelector.getSelectionInfo();
        if (selectionInfo != null) {
            fArray = selectionInfo.fInvertData ? new float[selectionInfo.fColumns][selectionInfo.fRows] : new float[selectionInfo.fRows][selectionInfo.fColumns];
            int n = 0;
            int n2 = selectionInfo.fStartColumnNumber;
            while (n2 <= selectionInfo.fEndColumnNumber) {
                int n3 = 0;
                int n4 = selectionInfo.fStartRowNumber;
                while (n4 <= selectionInfo.fEndRowNumber) {
                    float f = Selector.getFloat(selectionInfo.fTableModel.getValueAt(n4, n2));
                    if (selectionInfo.fInvertData) {
                        fArray[n][n3] = f;
                    } else {
                        fArray[n3][n] = f;
                    }
                    ++n3;
                    ++n4;
                }
                ++n;
                ++n2;
            }
        }
        return fArray;
    }

    static float[] getFloat(ColumnSelector columnSelector) {
        float[] fArray = null;
        SelectionInfo selectionInfo = columnSelector.getSelectionInfo();
        if (selectionInfo != null) {
            fArray = Selector.getFloat(selectionInfo.fTableModel, selectionInfo.fRows, selectionInfo.fStartRowNumber, selectionInfo.fEndRowNumber, selectionInfo.fColumnNumber, false);
        }
        return fArray;
    }

    static float[] getFloat(RowSelector rowSelector) {
        float[] fArray = null;
        SelectionInfo selectionInfo = rowSelector.getSelectionInfo();
        if (selectionInfo != null) {
            fArray = Selector.getFloat(selectionInfo.fTableModel, selectionInfo.fColumns, selectionInfo.fStartColumnNumber, selectionInfo.fEndColumnNumber, selectionInfo.fRowNumber, true);
        }
        return fArray;
    }

    static float[] getFloat(TableModel tableModel, int n, int n2, int n3, int n4, boolean bl) {
        float[] fArray = new float[n];
        int n5 = 0;
        int n6 = n2;
        while (n6 <= n3) {
            fArray[n5++] = Selector.getFloat(Selector.getValueAt(tableModel, bl, n6, n4));
            ++n6;
        }
        return fArray;
    }

    public static float getFloat(Object object) {
        boolean bl = true;
        float f = 0.0f;
        if (object instanceof Number) {
            f = ((Number)object).floatValue();
        } else if (object instanceof String) {
            try {
                f = Float.valueOf((String)object).floatValue();
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        } else if (object instanceof Character) {
            int n = Character.getNumericValue(((Character)object).charValue());
            if (n > 0) {
                f = new Integer(n).floatValue();
            }
        } else if (object instanceof Boolean) {
            f = (Boolean)object != false ? 1.0f : 0.0f;
        } else {
            bl = false;
        }
        if (!bl) {
            throw new SelectorException(Utilities.logMessage(IBMSelectorMessages.err_DataCoerce, new Object[]{object == null ? sNull : object, Selector.typeNameFromType(7)}), 209);
        }
        return f;
    }

    public boolean getIndexFromOne() {
        return this.fIndexFromOne;
    }

    static int[][] getInt(CellRangeSelector cellRangeSelector) {
        int[][] nArray = null;
        SelectionInfo selectionInfo = cellRangeSelector.getSelectionInfo();
        if (selectionInfo != null) {
            nArray = selectionInfo.fInvertData ? new int[selectionInfo.fColumns][selectionInfo.fRows] : new int[selectionInfo.fRows][selectionInfo.fColumns];
            int n = 0;
            int n2 = selectionInfo.fStartColumnNumber;
            while (n2 <= selectionInfo.fEndColumnNumber) {
                int n3 = 0;
                int n4 = selectionInfo.fStartRowNumber;
                while (n4 <= selectionInfo.fEndRowNumber) {
                    int n5 = Selector.getInt(selectionInfo.fTableModel.getValueAt(n4, n2));
                    if (selectionInfo.fInvertData) {
                        nArray[n][n3] = n5;
                    } else {
                        nArray[n3][n] = n5;
                    }
                    ++n3;
                    ++n4;
                }
                ++n;
                ++n2;
            }
        }
        return nArray;
    }

    static int[] getInt(ColumnSelector columnSelector) {
        int[] nArray = null;
        SelectionInfo selectionInfo = columnSelector.getSelectionInfo();
        if (selectionInfo != null) {
            nArray = Selector.getInt(selectionInfo.fTableModel, selectionInfo.fRows, selectionInfo.fStartRowNumber, selectionInfo.fEndRowNumber, selectionInfo.fColumnNumber, false);
        }
        return nArray;
    }

    static int[] getInt(RowSelector rowSelector) {
        int[] nArray = null;
        SelectionInfo selectionInfo = rowSelector.getSelectionInfo();
        if (selectionInfo != null) {
            nArray = Selector.getInt(selectionInfo.fTableModel, selectionInfo.fColumns, selectionInfo.fStartColumnNumber, selectionInfo.fEndColumnNumber, selectionInfo.fRowNumber, true);
        }
        return nArray;
    }

    static int[] getInt(TableModel tableModel, int n, int n2, int n3, int n4, boolean bl) {
        int[] nArray = new int[n];
        int n5 = 0;
        int n6 = n2;
        while (n6 <= n3) {
            nArray[n5++] = Selector.getInt(Selector.getValueAt(tableModel, bl, n6, n4));
            ++n6;
        }
        return nArray;
    }

    public static int getInt(Object object) {
        boolean bl = true;
        int n = 0;
        if (object instanceof Number) {
            n = ((Number)object).intValue();
        } else if (object instanceof String) {
            try {
                n = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        } else if (object instanceof Character) {
            int n2 = Character.getNumericValue(((Character)object).charValue());
            if (n2 > 0) {
                n = n2;
            }
        } else if (object instanceof Boolean) {
            n = (Boolean)object != false ? 1 : 0;
        } else {
            bl = false;
        }
        if (!bl) {
            throw new SelectorException(Utilities.logMessage(IBMSelectorMessages.err_DataCoerce, new Object[]{object == null ? sNull : object, Selector.typeNameFromType(5)}), 209);
        }
        return n;
    }

    static long[][] getLong(CellRangeSelector cellRangeSelector) {
        long[][] lArray = null;
        SelectionInfo selectionInfo = cellRangeSelector.getSelectionInfo();
        if (selectionInfo != null) {
            lArray = selectionInfo.fInvertData ? new long[selectionInfo.fColumns][selectionInfo.fRows] : new long[selectionInfo.fRows][selectionInfo.fColumns];
            int n = 0;
            int n2 = selectionInfo.fStartColumnNumber;
            while (n2 <= selectionInfo.fEndColumnNumber) {
                int n3 = 0;
                int n4 = selectionInfo.fStartRowNumber;
                while (n4 <= selectionInfo.fEndRowNumber) {
                    long l = Selector.getLong(selectionInfo.fTableModel.getValueAt(n4, n2));
                    if (selectionInfo.fInvertData) {
                        lArray[n][n3] = l;
                    } else {
                        lArray[n3][n] = l;
                    }
                    ++n3;
                    ++n4;
                }
                ++n;
                ++n2;
            }
        }
        return lArray;
    }

    static long[] getLong(ColumnSelector columnSelector) {
        long[] lArray = null;
        SelectionInfo selectionInfo = columnSelector.getSelectionInfo();
        if (selectionInfo != null) {
            lArray = Selector.getLong(selectionInfo.fTableModel, selectionInfo.fRows, selectionInfo.fStartRowNumber, selectionInfo.fEndRowNumber, selectionInfo.fColumnNumber, false);
        }
        return lArray;
    }

    static long[] getLong(RowSelector rowSelector) {
        long[] lArray = null;
        SelectionInfo selectionInfo = rowSelector.getSelectionInfo();
        if (selectionInfo != null) {
            lArray = Selector.getLong(selectionInfo.fTableModel, selectionInfo.fColumns, selectionInfo.fStartColumnNumber, selectionInfo.fEndColumnNumber, selectionInfo.fRowNumber, true);
        }
        return lArray;
    }

    static long[] getLong(TableModel tableModel, int n, int n2, int n3, int n4, boolean bl) {
        long[] lArray = new long[n];
        int n5 = 0;
        int n6 = n2;
        while (n6 <= n3) {
            lArray[n5++] = Selector.getLong(Selector.getValueAt(tableModel, bl, n6, n4));
            ++n6;
        }
        return lArray;
    }

    public static long getLong(Object object) {
        boolean bl = true;
        long l = 0L;
        if (object instanceof Number) {
            l = ((Number)object).longValue();
        } else if (object instanceof java.util.Date) {
            l = ((java.util.Date)object).getTime();
        } else if (object instanceof String) {
            try {
                l = Long.parseLong((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        } else if (object instanceof Character) {
            int n = Character.getNumericValue(((Character)object).charValue());
            if (n > 0) {
                l = new Integer(n).longValue();
            }
        } else if (object instanceof Boolean) {
            l = (Boolean)object != false ? 1L : 0L;
        } else {
            bl = false;
        }
        if (!bl) {
            throw new SelectorException(Utilities.logMessage(IBMSelectorMessages.err_DataCoerce, new Object[]{object == null ? sNull : object, Selector.typeNameFromType(6)}), 209);
        }
        return l;
    }

    public TableModel getModel() {
        return this.fTableModel;
    }

    public int getNotificationType() {
        return this.fNotificationType;
    }

    static Object[][] getObject(CellRangeSelector cellRangeSelector) {
        Object[][] objectArray = null;
        SelectionInfo selectionInfo = cellRangeSelector.getSelectionInfo();
        if (selectionInfo != null) {
            objectArray = selectionInfo.fInvertData ? new Object[selectionInfo.fColumns][selectionInfo.fRows] : new Object[selectionInfo.fRows][selectionInfo.fColumns];
            int n = 0;
            int n2 = selectionInfo.fStartColumnNumber;
            while (n2 <= selectionInfo.fEndColumnNumber) {
                int n3 = 0;
                int n4 = selectionInfo.fStartRowNumber;
                while (n4 <= selectionInfo.fEndRowNumber) {
                    Object object = selectionInfo.fTableModel.getValueAt(n4, n2);
                    if (selectionInfo.fInvertData) {
                        objectArray[n][n3] = object;
                    } else {
                        objectArray[n3][n] = object;
                    }
                    ++n3;
                    ++n4;
                }
                ++n;
                ++n2;
            }
        }
        return objectArray;
    }

    static Object[] getObject(ColumnSelector columnSelector) {
        Object[] objectArray = null;
        SelectionInfo selectionInfo = columnSelector.getSelectionInfo();
        if (selectionInfo != null) {
            objectArray = Selector.getObject(selectionInfo.fTableModel, selectionInfo.fRows, selectionInfo.fStartRowNumber, selectionInfo.fEndRowNumber, selectionInfo.fColumnNumber, false);
        }
        return objectArray;
    }

    static Object[] getObject(RowSelector rowSelector) {
        Object[] objectArray = null;
        SelectionInfo selectionInfo = rowSelector.getSelectionInfo();
        if (selectionInfo != null) {
            objectArray = Selector.getObject(selectionInfo.fTableModel, selectionInfo.fColumns, selectionInfo.fStartColumnNumber, selectionInfo.fEndColumnNumber, selectionInfo.fRowNumber, true);
        }
        return objectArray;
    }

    static Object[] getObject(TableModel tableModel, int n, int n2, int n3, int n4, boolean bl) {
        Object[] objectArray = new Object[n];
        int n5 = 0;
        int n6 = n2;
        while (n6 <= n3) {
            objectArray[n5++] = Selector.getValueAt(tableModel, bl, n6, n4);
            ++n6;
        }
        return objectArray;
    }

    PropertyChangeSupport getPropertyChangeSupport() {
        return this.fPropertyChangeSupport;
    }

    public int getRows() {
        return this.fTableModel == null ? 0 : this.fTableModel.getRowCount();
    }

    static short[][] getShort(CellRangeSelector cellRangeSelector) {
        short[][] sArray = null;
        SelectionInfo selectionInfo = cellRangeSelector.getSelectionInfo();
        if (selectionInfo != null) {
            sArray = selectionInfo.fInvertData ? new short[selectionInfo.fColumns][selectionInfo.fRows] : new short[selectionInfo.fRows][selectionInfo.fColumns];
            int n = 0;
            int n2 = selectionInfo.fStartColumnNumber;
            while (n2 <= selectionInfo.fEndColumnNumber) {
                int n3 = 0;
                int n4 = selectionInfo.fStartRowNumber;
                while (n4 <= selectionInfo.fEndRowNumber) {
                    short s = Selector.getShort(selectionInfo.fTableModel.getValueAt(n4, n2));
                    if (selectionInfo.fInvertData) {
                        sArray[n][n3] = s;
                    } else {
                        sArray[n3][n] = s;
                    }
                    ++n3;
                    ++n4;
                }
                ++n;
                ++n2;
            }
        }
        return sArray;
    }

    static short[] getShort(ColumnSelector columnSelector) {
        short[] sArray = null;
        SelectionInfo selectionInfo = columnSelector.getSelectionInfo();
        if (selectionInfo != null) {
            sArray = Selector.getShort(selectionInfo.fTableModel, selectionInfo.fRows, selectionInfo.fStartRowNumber, selectionInfo.fEndRowNumber, selectionInfo.fColumnNumber, false);
        }
        return sArray;
    }

    static short[] getShort(RowSelector rowSelector) {
        short[] sArray = null;
        SelectionInfo selectionInfo = rowSelector.getSelectionInfo();
        if (selectionInfo != null) {
            sArray = Selector.getShort(selectionInfo.fTableModel, selectionInfo.fColumns, selectionInfo.fStartColumnNumber, selectionInfo.fEndColumnNumber, selectionInfo.fRowNumber, true);
        }
        return sArray;
    }

    static short[] getShort(TableModel tableModel, int n, int n2, int n3, int n4, boolean bl) {
        short[] sArray = new short[n];
        int n5 = 0;
        int n6 = n2;
        while (n6 <= n3) {
            sArray[n5++] = Selector.getShort(Selector.getValueAt(tableModel, bl, n6, n4));
            ++n6;
        }
        return sArray;
    }

    public static short getShort(Object object) {
        boolean bl = true;
        short s = 0;
        if (object instanceof Number) {
            s = ((Number)object).shortValue();
        } else if (object instanceof String) {
            try {
                s = Short.parseShort((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        } else if (object instanceof Character) {
            int n = Character.getNumericValue(((Character)object).charValue());
            if (n > 0) {
                s = new Integer(n).shortValue();
            }
        } else if (object instanceof Boolean) {
            s = (Boolean)object != false ? (short)1 : 0;
        } else {
            bl = false;
        }
        if (!bl) {
            throw new SelectorException(Utilities.logMessage(IBMSelectorMessages.err_DataCoerce, new Object[]{object == null ? sNull : object, Selector.typeNameFromType(4)}), 209);
        }
        return s;
    }

    static String[][] getString(CellRangeSelector cellRangeSelector) {
        String[][] stringArray = null;
        SelectionInfo selectionInfo = cellRangeSelector.getSelectionInfo();
        if (selectionInfo != null) {
            String string;
            int n;
            int n2;
            int n3 = selectionInfo.fIncludeColumnNames ? 1 : 0;
            stringArray = selectionInfo.fInvertData ? new String[selectionInfo.fColumns][selectionInfo.fRows + n3] : new String[selectionInfo.fRows + n3][selectionInfo.fColumns];
            int n4 = 0;
            int n5 = 0;
            if (selectionInfo.fIncludeColumnNames) {
                n2 = 0;
                n = selectionInfo.fStartColumnNumber;
                while (n <= selectionInfo.fEndColumnNumber) {
                    string = selectionInfo.fColumnNames[n2++];
                    if (selectionInfo.fInvertData) {
                        stringArray[n5][n4] = string;
                    } else {
                        stringArray[n4][n5] = string;
                    }
                    ++n5;
                    ++n;
                }
            }
            n5 = 0;
            n2 = selectionInfo.fStartColumnNumber;
            while (n2 <= selectionInfo.fEndColumnNumber) {
                n4 = n3;
                n = selectionInfo.fStartRowNumber;
                while (n <= selectionInfo.fEndRowNumber) {
                    string = Selector.getString(selectionInfo.fTableModel.getValueAt(n, n2));
                    if (selectionInfo.fInvertData) {
                        stringArray[n5][n4++] = string;
                    } else {
                        stringArray[n4++][n5] = string;
                    }
                    ++n;
                }
                ++n5;
                ++n2;
            }
        }
        return stringArray;
    }

    static String[] getString(ColumnSelector columnSelector) {
        String[] stringArray = null;
        SelectionInfo selectionInfo = columnSelector.getSelectionInfo();
        if (selectionInfo != null) {
            int n = selectionInfo.fRows;
            int n2 = 0;
            if (selectionInfo.fIncludeColumnName) {
                ++n;
                n2 = 1;
            }
            stringArray = Selector.getString(selectionInfo.fTableModel, n, selectionInfo.fStartRowNumber, selectionInfo.fEndRowNumber, selectionInfo.fColumnNumber, false, n2);
            if (selectionInfo.fIncludeColumnName) {
                stringArray[0] = selectionInfo.fColumnName;
            }
        }
        return stringArray;
    }

    static String[] getString(RowSelector rowSelector) {
        String[] stringArray = null;
        SelectionInfo selectionInfo = rowSelector.getSelectionInfo();
        if (selectionInfo != null) {
            stringArray = Selector.getString(selectionInfo.fTableModel, selectionInfo.fColumns, selectionInfo.fStartColumnNumber, selectionInfo.fEndColumnNumber, selectionInfo.fRowNumber, true, 0);
        }
        return stringArray;
    }

    static String[] getString(TableModel tableModel, int n, int n2, int n3, int n4, boolean bl, int n5) {
        String[] stringArray = new String[n];
        int n6 = n2;
        while (n6 <= n3) {
            stringArray[n5++] = Selector.getString(Selector.getValueAt(tableModel, bl, n6, n4));
            ++n6;
        }
        return stringArray;
    }

    public static String getString(Object object) {
        String string = null;
        if (object instanceof String) {
            string = (String)object;
        } else if (object instanceof byte[]) {
            string = new String((byte[])object);
        } else if (object != null) {
            string = String.valueOf(object);
        }
        return string;
    }

    abstract TableModelListener getTableModelListener();

    static Time[][] getTime(CellRangeSelector cellRangeSelector) {
        Time[][] timeArray = null;
        SelectionInfo selectionInfo = cellRangeSelector.getSelectionInfo();
        if (selectionInfo != null) {
            timeArray = selectionInfo.fInvertData ? new Time[selectionInfo.fColumns][selectionInfo.fRows] : new Time[selectionInfo.fRows][selectionInfo.fColumns];
            int n = 0;
            int n2 = selectionInfo.fStartColumnNumber;
            while (n2 <= selectionInfo.fEndColumnNumber) {
                int n3 = 0;
                int n4 = selectionInfo.fStartRowNumber;
                while (n4 <= selectionInfo.fEndRowNumber) {
                    Time time = Selector.getTime(selectionInfo.fTableModel.getValueAt(n4, n2));
                    if (selectionInfo.fInvertData) {
                        timeArray[n][n3] = time;
                    } else {
                        timeArray[n3][n] = time;
                    }
                    ++n3;
                    ++n4;
                }
                ++n;
                ++n2;
            }
        }
        return timeArray;
    }

    static Time[] getTime(ColumnSelector columnSelector) {
        Time[] timeArray = null;
        SelectionInfo selectionInfo = columnSelector.getSelectionInfo();
        if (selectionInfo != null) {
            timeArray = Selector.getTime(selectionInfo.fTableModel, selectionInfo.fRows, selectionInfo.fStartRowNumber, selectionInfo.fEndRowNumber, selectionInfo.fColumnNumber, false);
        }
        return timeArray;
    }

    static Time[] getTime(RowSelector rowSelector) {
        Time[] timeArray = null;
        SelectionInfo selectionInfo = rowSelector.getSelectionInfo();
        if (selectionInfo != null) {
            timeArray = Selector.getTime(selectionInfo.fTableModel, selectionInfo.fColumns, selectionInfo.fStartColumnNumber, selectionInfo.fEndColumnNumber, selectionInfo.fRowNumber, true);
        }
        return timeArray;
    }

    static Time[] getTime(TableModel tableModel, int n, int n2, int n3, int n4, boolean bl) {
        Time[] timeArray = new Time[n];
        int n5 = 0;
        int n6 = n2;
        while (n6 <= n3) {
            timeArray[n5++] = Selector.getTime(Selector.getValueAt(tableModel, bl, n6, n4));
            ++n6;
        }
        return timeArray;
    }

    public static Time getTime(Object object) {
        boolean bl = true;
        Time time = null;
        if (object instanceof java.util.Date) {
            time = new Time(((java.util.Date)object).getTime());
        } else if (object instanceof Number) {
            time = new Time(((Number)object).longValue());
        } else if (object instanceof String) {
            try {
                time = Time.valueOf((String)object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                bl = false;
            }
        } else if (object != null) {
            bl = false;
        }
        if (!bl) {
            throw new SelectorException(Utilities.logMessage(IBMSelectorMessages.err_DataCoerce, new Object[]{object, Selector.typeNameFromType(12)}), 209);
        }
        return time;
    }

    static Timestamp[][] getTimestamp(CellRangeSelector cellRangeSelector) {
        Timestamp[][] timestampArray = null;
        SelectionInfo selectionInfo = cellRangeSelector.getSelectionInfo();
        if (selectionInfo != null) {
            timestampArray = selectionInfo.fInvertData ? new Timestamp[selectionInfo.fColumns][selectionInfo.fRows] : new Timestamp[selectionInfo.fRows][selectionInfo.fColumns];
            int n = 0;
            int n2 = selectionInfo.fStartColumnNumber;
            while (n2 <= selectionInfo.fEndColumnNumber) {
                int n3 = 0;
                int n4 = selectionInfo.fStartRowNumber;
                while (n4 <= selectionInfo.fEndRowNumber) {
                    Timestamp timestamp = Selector.getTimestamp(selectionInfo.fTableModel.getValueAt(n4, n2));
                    if (selectionInfo.fInvertData) {
                        timestampArray[n][n3] = timestamp;
                    } else {
                        timestampArray[n3][n] = timestamp;
                    }
                    ++n3;
                    ++n4;
                }
                ++n;
                ++n2;
            }
        }
        return timestampArray;
    }

    static Timestamp[] getTimestamp(ColumnSelector columnSelector) {
        Timestamp[] timestampArray = null;
        SelectionInfo selectionInfo = columnSelector.getSelectionInfo();
        if (selectionInfo != null) {
            timestampArray = Selector.getTimestamp(selectionInfo.fTableModel, selectionInfo.fRows, selectionInfo.fStartRowNumber, selectionInfo.fEndRowNumber, selectionInfo.fColumnNumber, false);
        }
        return timestampArray;
    }

    static Timestamp[] getTimestamp(RowSelector rowSelector) {
        Timestamp[] timestampArray = null;
        SelectionInfo selectionInfo = rowSelector.getSelectionInfo();
        if (selectionInfo != null) {
            timestampArray = Selector.getTimestamp(selectionInfo.fTableModel, selectionInfo.fColumns, selectionInfo.fStartColumnNumber, selectionInfo.fEndColumnNumber, selectionInfo.fRowNumber, true);
        }
        return timestampArray;
    }

    static Timestamp[] getTimestamp(TableModel tableModel, int n, int n2, int n3, int n4, boolean bl) {
        Timestamp[] timestampArray = new Timestamp[n];
        int n5 = 0;
        int n6 = n2;
        while (n6 <= n3) {
            timestampArray[n5++] = Selector.getTimestamp(Selector.getValueAt(tableModel, bl, n6, n4));
            ++n6;
        }
        return timestampArray;
    }

    public static Timestamp getTimestamp(Object object) {
        boolean bl = true;
        Timestamp timestamp = null;
        if (object instanceof java.util.Date) {
            timestamp = new Timestamp(((java.util.Date)object).getTime());
        } else if (object instanceof Number) {
            timestamp = new Timestamp(((Number)object).longValue());
        } else if (object instanceof String) {
            try {
                timestamp = Timestamp.valueOf((String)object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                bl = false;
            }
        } else if (object != null) {
            bl = false;
        }
        if (!bl) {
            throw new SelectorException(Utilities.logMessage(IBMSelectorMessages.err_DataCoerce, new Object[]{object, Selector.typeNameFromType(13)}), 209);
        }
        return timestamp;
    }

    private static Object getValueAt(TableModel tableModel, boolean bl, int n, int n2) {
        return bl ? tableModel.getValueAt(n2, n) : tableModel.getValueAt(n, n2);
    }

    static Vector getVector(ColumnSelector columnSelector) {
        Vector<Object> vector = null;
        SelectionInfo selectionInfo = columnSelector.getSelectionInfo();
        if (selectionInfo != null) {
            int n = selectionInfo.fRows;
            if (selectionInfo.fIncludeColumnName && (selectionInfo.fVectorContentType == 0 || selectionInfo.fVectorContentType == 15)) {
                vector = new Vector(++n);
                vector.addElement(selectionInfo.fColumnName);
            } else {
                vector = new Vector<Object>(n);
            }
            int n2 = selectionInfo.fStartRowNumber;
            while (n2 <= selectionInfo.fEndRowNumber) {
                vector.addElement(Selector.coerce(selectionInfo.fTableModel.getValueAt(n2, selectionInfo.fColumnNumber), selectionInfo.fVectorContentType));
                ++n2;
            }
        }
        return vector;
    }

    static Vector getVector(RowSelector rowSelector) {
        Vector<Object> vector = null;
        SelectionInfo selectionInfo = rowSelector.getSelectionInfo();
        if (selectionInfo != null) {
            vector = new Vector<Object>(selectionInfo.fColumns);
            int n = selectionInfo.fStartColumnNumber;
            while (n <= selectionInfo.fEndColumnNumber) {
                vector.addElement(Selector.coerce(selectionInfo.fTableModel.getValueAt(selectionInfo.fRowNumber, n), selectionInfo.fVectorContentType));
                ++n;
            }
        }
        return vector;
    }

    static Vector[] getVectorArray(CellRangeSelector cellRangeSelector) {
        Vector[] vectorArray;
        block9: {
            int n;
            vectorArray = null;
            SelectionInfo selectionInfo = cellRangeSelector.getSelectionInfo();
            if (selectionInfo == null) break block9;
            boolean bl = selectionInfo.fIncludeColumnNames && (selectionInfo.fVectorContentType == 0 || selectionInfo.fVectorContentType == 15);
            int n2 = n = bl ? selectionInfo.fRows + 1 : selectionInfo.fRows;
            if (selectionInfo.fInvertData) {
                vectorArray = new Vector[selectionInfo.fColumns];
                int n3 = 0;
                int n4 = selectionInfo.fStartColumnNumber;
                while (n4 <= selectionInfo.fEndColumnNumber) {
                    vectorArray[n4] = new Vector(n);
                    if (bl) {
                        vectorArray[n4].addElement(selectionInfo.fColumnNames[n3++]);
                    }
                    int n5 = selectionInfo.fStartRowNumber;
                    while (n5 <= selectionInfo.fEndRowNumber) {
                        vectorArray[n4].addElement(Selector.coerce(selectionInfo.fTableModel.getValueAt(n5, n4), selectionInfo.fVectorContentType));
                        ++n5;
                    }
                    ++n4;
                }
            } else {
                int n6;
                int n7;
                vectorArray = new Vector[n];
                boolean bl2 = bl;
                if (bl) {
                    vectorArray[0] = new Vector(selectionInfo.fColumns);
                    n7 = 0;
                    n6 = selectionInfo.fStartColumnNumber;
                    while (n6 <= selectionInfo.fEndColumnNumber) {
                        vectorArray[0].addElement(selectionInfo.fColumnNames[n7++]);
                        ++n6;
                    }
                }
                n7 = bl ? 1 : 0;
                n6 = selectionInfo.fStartRowNumber;
                while (n6 <= selectionInfo.fEndRowNumber) {
                    vectorArray[n7] = new Vector(selectionInfo.fColumns);
                    int n8 = selectionInfo.fStartColumnNumber;
                    while (n8 <= selectionInfo.fEndColumnNumber) {
                        vectorArray[n7].addElement(Selector.coerce(selectionInfo.fTableModel.getValueAt(n6, n8), selectionInfo.fVectorContentType));
                        ++n8;
                    }
                    ++n7;
                    ++n6;
                }
            }
        }
        return vectorArray;
    }

    public int getVectorContentType() {
        return this.fVectorContentType;
    }

    static Vector getVectorOfVectors(CellRangeSelector cellRangeSelector) {
        Vector<Vector> vector = null;
        Vector[] vectorArray = Selector.getVectorArray(cellRangeSelector);
        if (vectorArray != null) {
            vector = new Vector<Vector>(vectorArray.length);
            int n = 0;
            while (n < vectorArray.length) {
                vector.addElement(vectorArray[n]);
                ++n;
            }
        }
        return vector;
    }

    void initialise() {
        this.fPropertyChangeSupport = new PropertyChangeSupport(this);
        this.fSelectorListeners = new Vector(1, 1);
        this.fTableModelListener = this.getTableModelListener();
    }

    abstract void notifyBigDecimal();

    abstract void notifyBigInteger();

    abstract void notifyBoolean();

    abstract void notifyByte();

    abstract void notifyByteArray();

    void notifyData() {
        if (this.fTableModel != null) {
            switch (this.fNotificationType) {
                case -2: {
                    break;
                }
                case 1: {
                    this.notifyBoolean();
                    break;
                }
                case 3: {
                    this.notifyByte();
                    break;
                }
                case 4: {
                    this.notifyShort();
                    break;
                }
                case 5: {
                    this.notifyInt();
                    break;
                }
                case 6: {
                    this.notifyLong();
                    break;
                }
                case 7: {
                    this.notifyFloat();
                    break;
                }
                case 8: {
                    this.notifyDouble();
                    break;
                }
                case 9: {
                    this.notifyBigInteger();
                    break;
                }
                case 10: {
                    this.notifyBigDecimal();
                    break;
                }
                case 11: {
                    this.notifyDate();
                    break;
                }
                case 12: {
                    this.notifyTime();
                    break;
                }
                case 13: {
                    this.notifyTimestamp();
                    break;
                }
                case 14: {
                    this.notifyByteArray();
                    break;
                }
                case 15: {
                    this.notifyString();
                    break;
                }
                case 16: {
                    this.notifyObject();
                    break;
                }
                case 17: {
                    this.notifyVector();
                    break;
                }
                case 18: {
                    this.notifyVectorArray();
                    break;
                }
                case 19: {
                    this.notifyVectorOfVectors();
                    break;
                }
            }
            this.fireDataChanged(this.fNotificationType);
        }
    }

    abstract void notifyDate();

    abstract void notifyDouble();

    abstract void notifyFloat();

    abstract void notifyInt();

    abstract void notifyLong();

    abstract void notifyObject();

    abstract void notifyShort();

    abstract void notifyString();

    abstract void notifyTime();

    abstract void notifyTimestamp();

    abstract void notifyVector();

    abstract void notifyVectorArray();

    abstract void notifyVectorOfVectors();

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initialise();
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeSelectorListener(SelectorListener selectorListener) {
        this.fSelectorListeners.removeElement(selectorListener);
    }

    public static byte[] serializeToByteArray(Serializable serializable) {
        byte[] byArray = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(serializable);
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byArray;
    }

    public void setIndexFromOne(boolean bl) {
        if (this.fIndexFromOne != bl) {
            boolean bl2 = this.fIndexFromOne;
            this.fIndexFromOne = bl;
            this.fPropertyChangeSupport.firePropertyChange(PROPERTY_INDEX_FROM_ONE, new Boolean(bl2), new Boolean(this.fIndexFromOne));
        }
    }

    public void setModel(TableModel tableModel) {
        this.fCheckReadyDone = false;
        if (this.fTableModel != null) {
            this.fTableModel.removeTableModelListener(this.fTableModelListener);
        }
        this.fTableModel = tableModel;
        if (this.fTableModel != null) {
            this.fTableModel.addTableModelListener(this.fTableModelListener);
            this.notifyData();
        }
    }

    public void setNotificationType(int n) {
        this.setNotificationType(n, true);
    }

    void setNotificationType(int n, boolean bl) {
        if (this.fNotificationType != n) {
            int n2 = this.fNotificationType;
            this.fNotificationType = n;
            this.fPropertyChangeSupport.firePropertyChange(PROPERTY_NOTIFICATION_TYPE, new Integer(n2), new Integer(this.fNotificationType));
            if (bl) {
                this.notifyData();
            }
        }
    }

    public void setVectorContentType(int n) {
        this.setVectorContentType(n, true);
    }

    private void setVectorContentType(int n, boolean bl) {
        if (this.fVectorContentType != n) {
            int n2 = this.fVectorContentType;
            this.fVectorContentType = n;
            this.fPropertyChangeSupport.firePropertyChange(PROPERTY_VECTOR_CONTENT_TYPE, new Integer(n2), new Integer(this.fVectorContentType));
            if (bl) {
                this.notifyData();
            }
        }
    }

    static int typeFromClass(Class clazz) {
        int n = -1;
        Class<?> clazz2 = class$java$lang$Boolean;
        if (clazz2 == null) {
            try {
                clazz2 = class$java$lang$Boolean = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2) {
            n = 1;
        } else {
            Class<?> clazz3 = class$java$lang$Byte;
            if (clazz3 == null) {
                try {
                    clazz3 = class$java$lang$Byte = Class.forName("java.lang.Byte");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz == clazz3) {
                n = 3;
            } else {
                Class<?> clazz4 = class$java$lang$Short;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$java$lang$Short = Class.forName("java.lang.Short");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz == clazz4) {
                    n = 4;
                } else {
                    Class<?> clazz5 = class$java$lang$Integer;
                    if (clazz5 == null) {
                        try {
                            clazz5 = class$java$lang$Integer = Class.forName("java.lang.Integer");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz == clazz5) {
                        n = 5;
                    } else {
                        Class<?> clazz6 = class$java$lang$Long;
                        if (clazz6 == null) {
                            try {
                                clazz6 = class$java$lang$Long = Class.forName("java.lang.Long");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (clazz == clazz6) {
                            n = 6;
                        } else {
                            Class<?> clazz7 = class$java$lang$Float;
                            if (clazz7 == null) {
                                try {
                                    clazz7 = class$java$lang$Float = Class.forName("java.lang.Float");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (clazz == clazz7) {
                                n = 7;
                            } else {
                                Class<?> clazz8 = class$java$lang$Double;
                                if (clazz8 == null) {
                                    try {
                                        clazz8 = class$java$lang$Double = Class.forName("java.lang.Double");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if (clazz == clazz8) {
                                    n = 8;
                                } else {
                                    Class<?> clazz9 = class$java$math$BigInteger;
                                    if (clazz9 == null) {
                                        try {
                                            clazz9 = class$java$math$BigInteger = Class.forName("java.math.BigInteger");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    if (clazz == clazz9) {
                                        n = 9;
                                    } else {
                                        Class<?> clazz10 = class$java$math$BigDecimal;
                                        if (clazz10 == null) {
                                            try {
                                                clazz10 = class$java$math$BigDecimal = Class.forName("java.math.BigDecimal");
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                        }
                                        if (clazz == clazz10) {
                                            n = 10;
                                        } else {
                                            Class<?> clazz11 = class$java$sql$Date;
                                            if (clazz11 == null) {
                                                try {
                                                    clazz11 = class$java$sql$Date = Class.forName("java.sql.Date");
                                                }
                                                catch (ClassNotFoundException classNotFoundException) {
                                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                }
                                            }
                                            if (clazz == clazz11) {
                                                n = 11;
                                            } else {
                                                Class<?> clazz12 = class$java$sql$Time;
                                                if (clazz12 == null) {
                                                    try {
                                                        clazz12 = class$java$sql$Time = Class.forName("java.sql.Time");
                                                    }
                                                    catch (ClassNotFoundException classNotFoundException) {
                                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                    }
                                                }
                                                if (clazz == clazz12) {
                                                    n = 12;
                                                } else {
                                                    Class<?> clazz13 = class$java$sql$Timestamp;
                                                    if (clazz13 == null) {
                                                        try {
                                                            clazz13 = class$java$sql$Timestamp = Class.forName("java.sql.Timestamp");
                                                        }
                                                        catch (ClassNotFoundException classNotFoundException) {
                                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                        }
                                                    }
                                                    if (clazz == clazz13) {
                                                        n = 13;
                                                    } else {
                                                        Class<?> clazz14 = class$array1$$byte;
                                                        if (clazz14 == null) {
                                                            try {
                                                                clazz14 = class$array1$$byte = Class.forName("[B");
                                                            }
                                                            catch (ClassNotFoundException classNotFoundException) {
                                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                            }
                                                        }
                                                        if (clazz == clazz14) {
                                                            n = 14;
                                                        } else {
                                                            Class<?> clazz15 = class$java$lang$String;
                                                            if (clazz15 == null) {
                                                                try {
                                                                    clazz15 = class$java$lang$String = Class.forName("java.lang.String");
                                                                }
                                                                catch (ClassNotFoundException classNotFoundException) {
                                                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                                }
                                                            }
                                                            if (clazz == clazz15) {
                                                                n = 15;
                                                            } else {
                                                                Class<?> clazz16 = class$java$lang$Object;
                                                                if (clazz16 == null) {
                                                                    try {
                                                                        clazz16 = class$java$lang$Object = Class.forName("java.lang.Object");
                                                                    }
                                                                    catch (ClassNotFoundException classNotFoundException) {
                                                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                                    }
                                                                }
                                                                if (clazz == clazz16) {
                                                                    n = 16;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return n;
    }

    static String typeNameFromType(int n) {
        String string = "";
        if (n == 1) {
            string = Utilities.getMessage(IBMSelectorMessages.txt_typBoolean);
        } else if (n == 3) {
            string = Utilities.getMessage(IBMSelectorMessages.txt_typByte___);
        } else if (n == 4) {
            string = Utilities.getMessage(IBMSelectorMessages.txt_typShort__);
        } else if (n == 5) {
            string = Utilities.getMessage(IBMSelectorMessages.txt_typInt____);
        } else if (n == 6) {
            string = Utilities.getMessage(IBMSelectorMessages.txt_typLong___);
        } else if (n == 7) {
            string = Utilities.getMessage(IBMSelectorMessages.txt_typFloat__);
        } else if (n == 8) {
            string = Utilities.getMessage(IBMSelectorMessages.txt_typDouble_);
        } else if (n == 9) {
            string = Utilities.getMessage(IBMSelectorMessages.txt_typBigInt_);
        } else if (n == 10) {
            string = Utilities.getMessage(IBMSelectorMessages.txt_typBigDec_);
        } else if (n == 11) {
            string = Utilities.getMessage(IBMSelectorMessages.txt_typDate___);
        } else if (n == 12) {
            string = Utilities.getMessage(IBMSelectorMessages.txt_typTime___);
        } else if (n == 13) {
            string = Utilities.getMessage(IBMSelectorMessages.txt_typTimstmp);
        } else if (n == 14) {
            string = Utilities.getMessage(IBMSelectorMessages.txt_typByteArr);
        } else if (n == 15) {
            string = Utilities.getMessage(IBMSelectorMessages.txt_typString_);
        } else if (n == 16) {
            string = Utilities.getMessage(IBMSelectorMessages.txt_typObject_);
        }
        return string;
    }
}

