/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivj.db.uibeans;

import com.ibm.ivj.db.uibeans.DBActions;
import com.ibm.ivj.db.uibeans.ExceptionEvent;
import com.ibm.ivj.db.uibeans.ExceptionEventMulticaster;
import com.ibm.ivj.db.uibeans.ExceptionListener;
import com.ibm.ivj.db.uibeans.IBMIVJDBMessages;
import com.ibm.ivj.db.uibeans.Select;
import com.ibm.ivj.db.uibeans.Utilities;
import com.sun.java.swing.Icon;
import com.sun.java.swing.ImageIcon;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class DBNavigator
extends JPanel
implements ActionListener {
    private JButton execute = null;
    private JButton first = null;
    private JButton prev = null;
    private JButton next = null;
    private JButton last = null;
    private JButton insert = null;
    private JButton delete = null;
    private JButton refresh = null;
    private JButton commit = null;
    private JButton rollback = null;
    public static final int noSelect = 501;
    private static final int BUTTONWIDTH = 32;
    private static final int BUTTONHEIGHT = 32;
    private Select fieldModel = null;
    boolean fieldShowExecute = true;
    boolean fieldShowFirst = true;
    boolean fieldShowPrevious = true;
    boolean fieldShowNext = true;
    boolean fieldShowLast = true;
    boolean fieldShowInsert = true;
    boolean fieldShowDelete = true;
    boolean fieldShowRefresh = true;
    boolean fieldShowCommit = true;
    boolean fieldShowRollback = true;
    boolean fieldToolTipsEnabled = true;
    protected transient ExceptionListener aExceptionListener = null;
    private static final String copyright = "Licensed Material - Property of IBM\nIBM(R) VisualAge(TM) for Java(TM) Version 3.0\n(C) Copyright IBM Corp. 1998, 1999 - All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";

    public DBNavigator() {
        this.initialize();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n = 0;
        if (actionEvent.getSource() == this.getFirst()) {
            n = 1;
        } else if (actionEvent.getSource() == this.getPrevious()) {
            n = 2;
        } else if (actionEvent.getSource() == this.getNext()) {
            n = 3;
        } else if (actionEvent.getSource() == this.getLast()) {
            n = 4;
        } else if (actionEvent.getSource() == this.getInsert()) {
            n = 5;
        } else if (actionEvent.getSource() == this.getDelete()) {
            n = 6;
        } else if (actionEvent.getSource() == this.getRefresh()) {
            n = 7;
        } else if (actionEvent.getSource() == this.getCommit()) {
            n = 8;
        } else if (actionEvent.getSource() == this.getRollback()) {
            n = 9;
        } else if (actionEvent.getSource() == this.getExecute()) {
            n = 10;
        }
        this.disableButtons();
        DBActions dBActions = new DBActions(this, n);
        Thread thread = new Thread(dBActions);
        thread.start();
    }

    public void addExceptionListener(ExceptionListener exceptionListener) {
        this.aExceptionListener = ExceptionEventMulticaster.add(this.aExceptionListener, exceptionListener);
    }

    protected void disableButtons() {
        this.getExecute().setEnabled(false);
        this.getFirst().setEnabled(false);
        this.getPrevious().setEnabled(false);
        this.getNext().setEnabled(false);
        this.getLast().setEnabled(false);
        this.getInsert().setEnabled(false);
        this.getDelete().setEnabled(false);
        this.getRefresh().setEnabled(false);
        this.getCommit().setEnabled(false);
        this.getRollback().setEnabled(false);
    }

    protected void enableButtons() {
        this.getExecute().setEnabled(true);
        this.getFirst().setEnabled(true);
        this.getPrevious().setEnabled(true);
        this.getNext().setEnabled(true);
        this.getLast().setEnabled(true);
        this.getInsert().setEnabled(true);
        this.getDelete().setEnabled(true);
        this.getRefresh().setEnabled(true);
        this.getCommit().setEnabled(true);
        this.getRollback().setEnabled(true);
    }

    void fireExceptionOccurred(ExceptionEvent exceptionEvent) {
        if (this.aExceptionListener == null) {
            return;
        }
        this.aExceptionListener.exceptionOccurred(exceptionEvent);
    }

    private JButton getCommit() {
        if (this.commit == null) {
            ImageIcon imageIcon = new ImageIcon(ClassLoader.getSystemResource("com/ibm/ivj/db/uibeans/commit.gif"));
            this.commit = imageIcon != null ? new JButton((Icon)imageIcon) : new JButton();
            this.commit.setName("commit");
            this.commit.setBounds(256, 1, 32, 32);
            this.commit.setToolTipText(Utilities.getMessage(IBMIVJDBMessages.commit));
        }
        return this.commit;
    }

    private JButton getDelete() {
        if (this.delete == null) {
            ImageIcon imageIcon = new ImageIcon(ClassLoader.getSystemResource("com/ibm/ivj/db/uibeans/delete.gif"));
            this.delete = imageIcon != null ? new JButton((Icon)imageIcon) : new JButton();
            this.delete.setName("delete");
            this.delete.setBounds(192, 1, 32, 32);
            this.delete.setToolTipText(Utilities.getMessage(IBMIVJDBMessages.delete));
        }
        return this.delete;
    }

    private JButton getExecute() {
        if (this.execute == null) {
            ImageIcon imageIcon = new ImageIcon(ClassLoader.getSystemResource("com/ibm/ivj/db/uibeans/execute.gif"));
            this.execute = imageIcon != null ? new JButton((Icon)imageIcon) : new JButton();
            this.execute.setName("execute");
            this.execute.setBounds(-1, 1, 32, 32);
            this.execute.setToolTipText(Utilities.getMessage(IBMIVJDBMessages.execute));
        }
        return this.execute;
    }

    private JButton getFirst() {
        if (this.first == null) {
            ImageIcon imageIcon = new ImageIcon(ClassLoader.getSystemResource("com/ibm/ivj/db/uibeans/first.gif"));
            this.first = imageIcon != null ? new JButton((Icon)imageIcon) : new JButton();
            this.first.setName("first");
            this.first.setBounds(160, 1, 32, 32);
            this.first.setToolTipText(Utilities.getMessage(IBMIVJDBMessages.first));
        }
        return this.first;
    }

    private JButton getInsert() {
        if (this.insert == null) {
            ImageIcon imageIcon = new ImageIcon(ClassLoader.getSystemResource("com/ibm/ivj/db/uibeans/insert.gif"));
            this.insert = imageIcon != null ? new JButton((Icon)imageIcon) : new JButton();
            this.insert.setName("insert");
            this.insert.setBounds(160, 1, 32, 32);
            this.insert.setToolTipText(Utilities.getMessage(IBMIVJDBMessages.insert));
        }
        return this.insert;
    }

    private JButton getLast() {
        if (this.last == null) {
            ImageIcon imageIcon = new ImageIcon(ClassLoader.getSystemResource("com/ibm/ivj/db/uibeans/last.gif"));
            this.last = imageIcon != null ? new JButton((Icon)imageIcon) : new JButton();
            this.last.setName("last");
            this.last.setBounds(128, 1, 32, 32);
            this.last.setToolTipText(Utilities.getMessage(IBMIVJDBMessages.last));
        }
        return this.last;
    }

    public Select getModel() {
        return this.fieldModel;
    }

    private JButton getNext() {
        if (this.next == null) {
            ImageIcon imageIcon = new ImageIcon(ClassLoader.getSystemResource("com/ibm/ivj/db/uibeans/next.gif"));
            this.next = imageIcon != null ? new JButton((Icon)imageIcon) : new JButton();
            this.next.setName("next");
            this.next.setBounds(96, 1, 32, 32);
            this.next.setToolTipText(Utilities.getMessage(IBMIVJDBMessages.next));
        }
        return this.next;
    }

    private JButton getPrevious() {
        if (this.prev == null) {
            ImageIcon imageIcon = new ImageIcon(ClassLoader.getSystemResource("com/ibm/ivj/db/uibeans/previous.gif"));
            this.prev = imageIcon != null ? new JButton((Icon)imageIcon) : new JButton();
            this.prev.setName("prev");
            this.prev.setBounds(64, 1, 32, 32);
            this.prev.setToolTipText(Utilities.getMessage(IBMIVJDBMessages.prev));
        }
        return this.prev;
    }

    private JButton getRefresh() {
        if (this.refresh == null) {
            ImageIcon imageIcon = new ImageIcon(ClassLoader.getSystemResource("com/ibm/ivj/db/uibeans/refresh.gif"));
            this.refresh = imageIcon != null ? new JButton((Icon)imageIcon) : new JButton();
            this.refresh.setName("refresh");
            this.refresh.setBounds(224, 1, 32, 32);
            this.refresh.setToolTipText(Utilities.getMessage(IBMIVJDBMessages.refresh));
        }
        return this.refresh;
    }

    private JButton getRollback() {
        if (this.rollback == null) {
            ImageIcon imageIcon = new ImageIcon(ClassLoader.getSystemResource("com/ibm/ivj/db/uibeans/rollback.gif"));
            this.rollback = imageIcon != null ? new JButton((Icon)imageIcon) : new JButton();
            this.rollback.setName("rollback");
            this.rollback.setBounds(288, 1, 32, 32);
            this.rollback.setToolTipText(Utilities.getMessage(IBMIVJDBMessages.rollback));
        }
        return this.rollback;
    }

    private void initConnections() {
        this.getExecute().addActionListener((ActionListener)this);
        this.getFirst().addActionListener((ActionListener)this);
        this.getPrevious().addActionListener((ActionListener)this);
        this.getNext().addActionListener((ActionListener)this);
        this.getLast().addActionListener((ActionListener)this);
        this.getInsert().addActionListener((ActionListener)this);
        this.getDelete().addActionListener((ActionListener)this);
        this.getRefresh().addActionListener((ActionListener)this);
        this.getCommit().addActionListener((ActionListener)this);
        this.getRollback().addActionListener((ActionListener)this);
    }

    private void initialize() {
        ((Component)((Object)this)).setName("DBNavigator");
        ((Component)((Object)this)).setName("DBNavigator");
        ((Container)((Object)this)).setLayout(new GridLayout());
        this.setPreferredSize(new Dimension(320, 32));
        this.setOpaque(false);
        this.refreshPanel();
        this.initConnections();
    }

    public boolean isShowCommit() {
        return this.fieldShowCommit;
    }

    public boolean isShowDelete() {
        return this.fieldShowDelete;
    }

    public boolean isShowExecute() {
        return this.fieldShowExecute;
    }

    public boolean isShowFirst() {
        return this.fieldShowFirst;
    }

    public boolean isShowInsert() {
        return this.fieldShowInsert;
    }

    public boolean isShowLast() {
        return this.fieldShowLast;
    }

    public boolean isShowNext() {
        return this.fieldShowNext;
    }

    public boolean isShowPrevious() {
        return this.fieldShowPrevious;
    }

    public boolean isShowRefresh() {
        return this.fieldShowRefresh;
    }

    public boolean isShowRollback() {
        return this.fieldShowRollback;
    }

    public boolean isToolTipsEnabled() {
        return this.fieldToolTipsEnabled;
    }

    protected void recalculatePanelSize(boolean bl, boolean bl2) {
        if (bl != bl2) {
            Dimension dimension = this.getPreferredSize();
            if (bl2) {
                this.setPreferredSize(new Dimension(dimension.width + 32, dimension.height));
            } else {
                this.setPreferredSize(new Dimension(dimension.width - 32, dimension.height));
            }
            Container container = ((Component)((Object)this)).getParent();
            if (container != null) {
                container.doLayout();
            }
        }
    }

    protected void refreshPanel() {
        ((Container)((Object)this)).removeAll();
        if (this.isShowExecute()) {
            ((Container)((Object)this)).add((Component)this.getExecute(), this.getExecute().getName());
        }
        if (this.isShowFirst()) {
            ((Container)((Object)this)).add((Component)this.getFirst(), this.getFirst().getName());
        }
        if (this.isShowPrevious()) {
            ((Container)((Object)this)).add((Component)this.getPrevious(), this.getPrevious().getName());
        }
        if (this.isShowNext()) {
            ((Container)((Object)this)).add((Component)this.getNext(), this.getNext().getName());
        }
        if (this.isShowLast()) {
            ((Container)((Object)this)).add((Component)this.getLast(), this.getLast().getName());
        }
        if (this.isShowInsert()) {
            ((Container)((Object)this)).add((Component)this.getInsert(), this.getInsert().getName());
        }
        if (this.isShowDelete()) {
            ((Container)((Object)this)).add((Component)this.getDelete(), this.getDelete().getName());
        }
        if (this.isShowRefresh()) {
            ((Container)((Object)this)).add((Component)this.getRefresh(), this.getRefresh().getName());
        }
        if (this.isShowCommit()) {
            ((Container)((Object)this)).add((Component)this.getCommit(), this.getCommit().getName());
        }
        if (this.isShowRollback()) {
            ((Container)((Object)this)).add((Component)this.getRollback(), this.getRollback().getName());
        }
        ((Container)((Object)this)).doLayout();
        this.setVisible(true);
    }

    public void removeExceptionListener(ExceptionListener exceptionListener) {
        this.aExceptionListener = ExceptionEventMulticaster.remove(this.aExceptionListener, exceptionListener);
    }

    public void setModel(Select select) {
        this.fieldModel = select;
    }

    public void setShowCommit(boolean bl) {
        this.recalculatePanelSize(this.fieldShowCommit, bl);
        this.fieldShowCommit = bl;
        this.refreshPanel();
    }

    public void setShowDelete(boolean bl) {
        this.recalculatePanelSize(this.fieldShowDelete, bl);
        this.fieldShowDelete = bl;
        this.refreshPanel();
    }

    public void setShowExecute(boolean bl) {
        this.recalculatePanelSize(this.fieldShowExecute, bl);
        this.fieldShowExecute = bl;
        this.refreshPanel();
    }

    public void setShowFirst(boolean bl) {
        this.recalculatePanelSize(this.fieldShowFirst, bl);
        this.fieldShowFirst = bl;
        this.refreshPanel();
    }

    public void setShowInsert(boolean bl) {
        this.recalculatePanelSize(this.fieldShowInsert, bl);
        this.fieldShowInsert = bl;
        this.refreshPanel();
    }

    public void setShowLast(boolean bl) {
        this.recalculatePanelSize(this.fieldShowLast, bl);
        this.fieldShowLast = bl;
        this.refreshPanel();
    }

    public void setShowNext(boolean bl) {
        this.recalculatePanelSize(this.fieldShowNext, bl);
        this.fieldShowNext = bl;
        this.refreshPanel();
    }

    public void setShowPrevious(boolean bl) {
        this.recalculatePanelSize(this.fieldShowPrevious, bl);
        this.fieldShowPrevious = bl;
        this.refreshPanel();
    }

    public void setShowRefresh(boolean bl) {
        this.recalculatePanelSize(this.fieldShowRefresh, bl);
        this.fieldShowRefresh = bl;
        this.refreshPanel();
    }

    public void setShowRollback(boolean bl) {
        this.recalculatePanelSize(this.fieldShowRollback, bl);
        this.fieldShowRollback = bl;
        this.refreshPanel();
    }

    public void setToolTipsEnabled(boolean bl) {
        this.fieldToolTipsEnabled = bl;
        if (this.isToolTipsEnabled()) {
            this.getExecute().setToolTipText(Utilities.getMessage(IBMIVJDBMessages.execute));
            this.getFirst().setToolTipText(Utilities.getMessage(IBMIVJDBMessages.first));
            this.getPrevious().setToolTipText(Utilities.getMessage(IBMIVJDBMessages.prev));
            this.getNext().setToolTipText(Utilities.getMessage(IBMIVJDBMessages.next));
            this.getLast().setToolTipText(Utilities.getMessage(IBMIVJDBMessages.last));
            this.getInsert().setToolTipText(Utilities.getMessage(IBMIVJDBMessages.insert));
            this.getDelete().setToolTipText(Utilities.getMessage(IBMIVJDBMessages.delete));
            this.getRefresh().setToolTipText(Utilities.getMessage(IBMIVJDBMessages.refresh));
            this.getCommit().setToolTipText(Utilities.getMessage(IBMIVJDBMessages.commit));
            this.getRollback().setToolTipText(Utilities.getMessage(IBMIVJDBMessages.rollback));
        } else {
            this.getExecute().setToolTipText(null);
            this.getFirst().setToolTipText(null);
            this.getPrevious().setToolTipText(null);
            this.getNext().setToolTipText(null);
            this.getLast().setToolTipText(null);
            this.getInsert().setToolTipText(null);
            this.getDelete().setToolTipText(null);
            this.getRefresh().setToolTipText(null);
            this.getCommit().setToolTipText(null);
            this.getRollback().setToolTipText(null);
        }
    }
}

