/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivj.db.uibeans;

import com.ibm.db.DataEvent;
import com.ibm.db.DataException;
import com.ibm.db.DataRuntimeException;
import com.ibm.db.DatabaseConnection;
import com.ibm.db.DatabaseConnectionAfterListener;
import com.ibm.db.DatabaseConnectionBeforeListener;
import com.ibm.db.SelectResult;
import com.ibm.db.SelectStatement;
import com.ibm.db.StatementAfterListener;
import com.ibm.db.StatementBeforeListener;
import com.ibm.db.StatementMetaData;
import com.ibm.db.StatementResultAfterListener;
import com.ibm.db.StatementResultBeforeListener;
import com.ibm.db.StatementResultValueChangeListener;
import com.ibm.ivj.db.uibeans.IBMIVJDBMessages;
import com.ibm.ivj.db.uibeans.Query;
import com.ibm.ivj.db.uibeans.Statement;
import com.ibm.ivj.db.uibeans.TableModelEventMulticaster;
import com.ibm.ivj.db.uibeans.Utilities;
import com.sun.java.swing.event.TableModelEvent;
import com.sun.java.swing.event.TableModelListener;
import com.sun.java.swing.table.TableModel;
import java.beans.BeanInfo;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Enumeration;

public class Select
extends Statement
implements Serializable,
DatabaseConnectionAfterListener,
DatabaseConnectionBeforeListener,
StatementAfterListener,
StatementBeforeListener,
PropertyChangeListener,
StatementResultAfterListener,
StatementResultBeforeListener,
StatementResultValueChangeListener,
TableModel {
    protected SelectResult fieldResult = null;
    protected SelectStatement fieldSelectStatement = null;
    protected transient boolean executing = false;
    protected transient TableModelListener aTableModelListener = null;
    static final long serialVersionUID = -5745125611264755939L;
    private static final String copyright = "Licensed Material - Property of IBM\nIBM(R) VisualAge(TM) for Java(TM) Version 3.0\n(C) Copyright IBM Corp. 1998, 1999 - All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    static Class class$com$ibm$ivj$db$uibeans$Select;
    static Class class$java$lang$String;

    public Select() {
        this.setSelectStatement(this.newSelectStatement());
        this.setResult(this.fieldSelectStatement.getResult());
    }

    public void aboutToAddNewRow(DataEvent dataEvent) {
        this.fireAboutToAddNewRow(new DataEvent(this));
    }

    public void aboutToDeleteRow(DataEvent dataEvent) {
        this.fireAboutToDeleteRow(new DataEvent(this));
    }

    public void aboutToSetColumnValue(PropertyChangeEvent propertyChangeEvent) {
    }

    public void aboutToUpdateRow(DataEvent dataEvent) {
        this.fireAboutToUpdateRow(new DataEvent(this));
    }

    public void addedNewRow(DataEvent dataEvent) {
        this.fireAddedNewRow(new DataEvent(this));
    }

    public void addTableModelListener(TableModelListener tableModelListener) {
        this.aTableModelListener = TableModelEventMulticaster.add(this.aTableModelListener, tableModelListener);
    }

    public boolean areDistinctTypesEnabled() {
        return this.fieldSelectStatement.areDistinctTypesEnabled();
    }

    public void cacheRowsChanged(DataEvent dataEvent) {
        this.fireCacheRowsChanged(new DataEvent(this));
    }

    public void cancelAction() throws DataException {
        if (this.executing) {
            this.fieldSelectStatement.cancelExecution();
            this.executing = false;
        } else {
            this.fieldResult.cancelAction();
        }
    }

    public void close() throws DataException {
        this.fieldSelectStatement.close();
    }

    public Enumeration columnNames() throws DataException {
        return this.fieldResult.columnNames();
    }

    public void columnValueSet(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        this.firePropertyChange(string, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        this.firePropertyChange(String.valueOf(string) + "_String", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        if (this.aTableModelListener != null) {
            int n = this.fieldSelectStatement.getMetaData().getColumnIndex(propertyChangeEvent.getPropertyName());
            this.fireTableChanged(new TableModelEvent((TableModel)this, this.getCurrentRow(), this.getCurrentRow(), n - 1));
        }
    }

    public void commit() throws DataException {
        this.fieldDatabaseConnection.commit();
    }

    public void committed(DataEvent dataEvent) {
        this.fireCommitted(new DataEvent(this));
    }

    public void connect() throws DataException {
        this.fieldDatabaseConnection.connect();
    }

    public void connected(DataEvent dataEvent) {
        this.fireConnected(new DataEvent(this));
    }

    protected void currentRowChange(PropertyChangeEvent propertyChangeEvent) {
        int n = (Integer)propertyChangeEvent.getNewValue() - 1;
        if (propertyChangeEvent.getOldValue() != null) {
            int n2 = (Integer)propertyChangeEvent.getOldValue() - 1;
            this.firePropertyChange("currentRow", new Integer(n2), new Integer(n));
        } else {
            this.firePropertyChange("currentRow", null, new Integer(n));
        }
        this.fireAllColumnsChange(propertyChangeEvent);
    }

    protected void currentRowInCacheChange(PropertyChangeEvent propertyChangeEvent) {
        int n = (Integer)propertyChangeEvent.getNewValue() - 1;
        if (propertyChangeEvent.getOldValue() != null) {
            int n2 = (Integer)propertyChangeEvent.getOldValue() - 1;
            this.firePropertyChange("currentRowInCache", new Integer(n2), new Integer(n));
        } else {
            this.firePropertyChange("currentRowInCache", null, new Integer(n));
        }
    }

    public void deletedRow(DataEvent dataEvent) {
        this.fireDeletedRow(new DataEvent(this));
    }

    public void deleteRow() throws DataException {
        this.fieldResult.deleteRow();
    }

    public void disconnect() throws DataException {
        this.fieldDatabaseConnection.disconnect();
    }

    public void disconnected(DataEvent dataEvent) {
        this.fireDisconnected(new DataEvent(this));
    }

    public void execute() throws DataException {
        this.executing = true;
        try {
            this.fieldSelectStatement.execute();
        }
        catch (DataException dataException) {
            this.executing = false;
            throw dataException;
        }
        this.executing = false;
    }

    protected void fireAboutToAddNewRow(DataEvent dataEvent) {
        if (this.aDataBeforeListener == null) {
            return;
        }
        this.aDataBeforeListener.aboutToAddNewRow(dataEvent);
    }

    protected void fireAboutToClose(DataEvent dataEvent) {
        if (this.aDataBeforeListener == null) {
            return;
        }
        this.aDataBeforeListener.aboutToClose(dataEvent);
    }

    protected void fireAboutToDeleteRow(DataEvent dataEvent) {
        if (this.aDataBeforeListener == null) {
            return;
        }
        this.aDataBeforeListener.aboutToDeleteRow(dataEvent);
    }

    protected void fireAboutToUpdateRow(DataEvent dataEvent) {
        if (this.aDataBeforeListener == null) {
            return;
        }
        this.aDataBeforeListener.aboutToUpdateRow(dataEvent);
    }

    protected void fireAddedNewRow(DataEvent dataEvent) {
        if (this.aDataAfterListener != null) {
            this.aDataAfterListener.addedNewRow(dataEvent);
        }
        if (this.aTableModelListener != null) {
            int n = this.getCurrentRowInCache();
            this.fireTableChanged(new TableModelEvent((TableModel)this, n, n, -1, 1));
        }
    }

    protected void fireAllColumnsChange(PropertyChangeEvent propertyChangeEvent) {
        StatementMetaData statementMetaData = this.fieldSelectStatement.getMetaData();
        Object object = null;
        int n = 1;
        while (n <= statementMetaData.getColumnCount()) {
            String string = statementMetaData.getColumnName(n);
            object = this.getCurrentRow() < 0 || this.getCurrentRowInCache() < 0 ? null : this.getColumnValue(n - 1);
            this.firePropertyChange(string, null, object);
            this.firePropertyChange(String.valueOf(string) + "_String", null, object);
            ++n;
        }
    }

    protected void fireCacheRowsChanged(DataEvent dataEvent) {
        if (this.aDataAfterListener != null) {
            this.aDataAfterListener.cacheRowsChanged(dataEvent);
        }
        if (this.aTableModelListener != null && dataEvent.getTriggeringAction() != 3 && dataEvent.getTriggeringAction() != 1) {
            if (this.executing) {
                this.fireTableChanged(new TableModelEvent((TableModel)this, -1));
            } else {
                this.fireTableChanged(new TableModelEvent((TableModel)this));
            }
        }
    }

    protected void fireClosed(DataEvent dataEvent) {
        if (this.aDataAfterListener == null) {
            return;
        }
        this.aDataAfterListener.closed(dataEvent);
    }

    protected void fireDeletedRow(DataEvent dataEvent) {
        if (this.aDataAfterListener != null) {
            this.aDataAfterListener.deletedRow(dataEvent);
        }
        if (this.aTableModelListener != null) {
            int n = this.getCurrentRowInCache();
            this.fireTableChanged(new TableModelEvent((TableModel)this, n, n, -1, -1));
        }
    }

    protected void fireTableChanged(TableModelEvent tableModelEvent) {
        if (this.aTableModelListener == null) {
            return;
        }
        this.aTableModelListener.tableChanged(tableModelEvent);
    }

    protected void fireUpdatedRow(DataEvent dataEvent) {
        if (this.aDataAfterListener == null) {
            return;
        }
        this.aDataAfterListener.updatedRow(dataEvent);
    }

    public void firstRow() throws DataException {
        this.fieldResult.firstRow();
    }

    public Class getColumnClass(int n) {
        return this.fieldSelectStatement.getMetaData().getColumnClass(n + 1);
    }

    public Class getColumnClass(String string) {
        return this.fieldSelectStatement.getMetaData().getColumnClass(string);
    }

    public int getColumnCount() {
        return this.fieldSelectStatement.getMetaData().getColumnCount();
    }

    public int getColumnIndex(String string) {
        return this.fieldSelectStatement.getMetaData().getColumnIndex(string) - 1;
    }

    public String getColumnName(int n) {
        return this.fieldSelectStatement.getMetaData().getColumnName(n + 1);
    }

    public Object getColumnValue(int n) {
        if (!this.isExecuted() && !this.executing) {
            return null;
        }
        try {
            return this.fieldResult.getColumnValue(n + 1);
        }
        catch (DataException dataException) {
            return null;
        }
    }

    public Object getColumnValue(String string) {
        if (!this.isExecuted() && !this.executing) {
            return null;
        }
        try {
            return this.fieldResult.getColumnValue(string);
        }
        catch (DataException dataException) {
            return null;
        }
    }

    public String getColumnValueToString(int n) {
        if (!this.isExecuted() && !this.executing) {
            return null;
        }
        try {
            return this.fieldResult.getColumnValueToString(n + 1);
        }
        catch (DataException dataException) {
            return null;
        }
    }

    public String getColumnValueToString(String string) {
        if (!this.isExecuted() && !this.executing) {
            return null;
        }
        try {
            return this.fieldResult.getColumnValueToString(string);
        }
        catch (DataException dataException) {
            return null;
        }
    }

    public int getCurrentRow() {
        return this.fieldResult.getCurrentRow() - 1;
    }

    public int getCurrentRowInCache() {
        return this.fieldResult.getCurrentRowInCache() - 1;
    }

    public BeanInfo getInstanceBeanInfo() {
        BeanInfo beanInfo = null;
        try {
            Class<?> clazz = Class.forName("com.ibm.ivj.db.uibeans.SelectBeanInfo");
            Object[] objectArray = new Object[]{this};
            Class[] classArray = new Class[1];
            Class<?> clazz2 = class$com$ibm$ivj$db$uibeans$Select;
            if (clazz2 == null) {
                try {
                    clazz2 = class$com$ibm$ivj$db$uibeans$Select = Class.forName("com.ibm.ivj.db.uibeans.Select");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            Class[] classArray2 = classArray;
            Method method = clazz.getDeclaredMethod("getInstanceBeanInfo", classArray2);
            beanInfo = (BeanInfo)method.invoke(clazz, objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return beanInfo;
    }

    public int getMaximumPacketsInCache() {
        return this.fieldSelectStatement.getMaximumPacketsInCache();
    }

    public int getMaximumRows() {
        return this.fieldSelectStatement.getMaximumRows();
    }

    public int getNumPacketsInCache() {
        return this.fieldResult.getNumPacketsInCache();
    }

    public int getNumRows() {
        return this.fieldResult.getNumRows();
    }

    public int getNumRowsInCache() {
        return this.fieldResult.getNumRowsInCache();
    }

    public int getPacketSize() {
        return this.fieldSelectStatement.getPacketSize();
    }

    public Object getParameter(int n) throws DataException {
        return this.fieldSelectStatement.getParameter(n);
    }

    public Object getParameter(String string) throws DataException {
        return this.fieldSelectStatement.getParameter(string);
    }

    public String getParameterToString(int n) throws DataException {
        return this.fieldSelectStatement.getParameterToString(n);
    }

    public String getParameterToString(String string) throws DataException {
        return this.fieldSelectStatement.getParameterToString(string);
    }

    public Query getQuery() {
        return new Query(this.getDatabaseConnection(), this.getStatementMetaData());
    }

    public SelectResult getResult() {
        return this.fieldResult;
    }

    public int getRowCount() {
        return this.fieldResult.getNumRowsInCache();
    }

    public SelectStatement getSelectStatement() {
        return this.fieldSelectStatement;
    }

    public StatementMetaData getStatementMetaData() {
        return this.fieldSelectStatement.getMetaData();
    }

    public int getTimeout() {
        return this.fieldSelectStatement.getTimeout();
    }

    public Object getValueAt(int n, int n2) {
        try {
            if (!this.isExecuted() && !this.executing) {
                return null;
            }
            return this.fieldResult.getCacheValueAt(n + 1, n2 + 1);
        }
        catch (DataException dataException) {
            return null;
        }
    }

    public boolean isCellEditable(int n, int n2) {
        return !this.isReadOnly();
    }

    public boolean isEnd() {
        return this.fieldResult.isEnd();
    }

    public boolean isExecuted() {
        return this.fieldSelectStatement.isExecuted();
    }

    public boolean isFillCacheOnExecute() {
        return this.fieldSelectStatement.isFillCacheOnExecute();
    }

    public boolean isForceSearchedUpdate() {
        return this.fieldSelectStatement.isForceSearchedUpdate();
    }

    public boolean isLockRows() {
        return this.fieldSelectStatement.isLockRows();
    }

    public boolean isMaxRowsReached() {
        try {
            return this.fieldResult.isMaxRowsReached();
        }
        catch (DataException dataException) {
            return false;
        }
    }

    public boolean isOpen() {
        return this.fieldSelectStatement.isOpen();
    }

    public boolean isReadOnly() {
        return this.fieldSelectStatement.isReadOnly();
    }

    public void lastRow() throws DataException {
        this.fieldResult.lastRow();
    }

    public void lockRow() throws DataException {
        this.fieldResult.lockRow();
    }

    public void newRow(boolean bl) throws DataException {
        this.fieldResult.newRow(bl);
    }

    protected SelectStatement newSelectStatement() {
        SelectStatement selectStatement = null;
        try {
            selectStatement = new SelectStatement(true);
        }
        catch (Throwable throwable) {
            Object[] objectArray = new Object[]{"Select", "SelectStatement"};
            String string = Utilities.logMessage(IBMIVJDBMessages.noStatement, objectArray);
            throw new DataRuntimeException(string);
        }
        return selectStatement;
    }

    public void nextPacket() throws DataException {
        this.fieldResult.nextPacket();
    }

    public void nextRow() throws DataException {
        this.fieldResult.nextRow();
    }

    public void previousRow() throws DataException {
        this.fieldResult.previousRow();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.getResult()) {
            if (propertyChangeEvent.getPropertyName().equals("currentRow")) {
                this.currentRowChange(propertyChangeEvent);
            } else if (propertyChangeEvent.getPropertyName().equals("currentRowInCache")) {
                this.currentRowInCacheChange(propertyChangeEvent);
            }
        }
    }

    public void refresh() throws DataException {
        this.executing = true;
        try {
            this.fieldSelectStatement.refresh();
        }
        catch (DataException dataException) {
            this.executing = false;
            throw dataException;
        }
        this.executing = false;
    }

    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.aTableModelListener = TableModelEventMulticaster.remove(this.aTableModelListener, tableModelListener);
    }

    public void restoreRow() throws DataException {
        this.fieldResult.restoreRow();
    }

    public void rollback() throws DataException {
        this.fieldDatabaseConnection.rollback();
    }

    public void rolledBack(DataEvent dataEvent) {
        this.fireRolledBack(new DataEvent(this));
    }

    public void setColumnValue(int n, Object object) throws DataException {
        this.fieldResult.setColumnValue(n + 1, object);
    }

    public void setColumnValue(String string, Object object) throws DataException {
        this.fieldResult.setColumnValue(string, object);
    }

    public void setColumnValueFromString(int n, String string) throws DataException {
        if (!(this.isExecuted() || string != null && string.length() != 0)) {
            return;
        }
        this.fieldResult.setColumnValueFromString(n + 1, string);
    }

    public void setColumnValueFromString(String string, String string2) throws DataException {
        if (!(this.isExecuted() || string2 != null && string2.length() != 0)) {
            return;
        }
        this.fieldResult.setColumnValueFromString(string, string2);
    }

    public void setCurrentRow(int n) throws DataException {
        if (n == -1 && this.getCurrentRow() == -1) {
            return;
        }
        this.fieldResult.setCurrentRow(n + 1);
    }

    public void setCurrentRowInCache(int n) throws DataException {
        this.setCurrentRow(n + this.getCurrentRow() - this.getCurrentRowInCache());
    }

    public void setDatabaseConnection(DatabaseConnection databaseConnection) {
        super.setDatabaseConnection(databaseConnection);
        if (this.fieldSelectStatement != null) {
            this.fieldSelectStatement.setConnection(databaseConnection);
        }
    }

    public void setDistinctTypesEnabled(boolean bl) {
        this.fieldSelectStatement.setDistinctTypesEnabled(bl);
    }

    public void setFillCacheOnExecute(boolean bl) {
        this.fieldSelectStatement.setFillCacheOnExecute(bl);
    }

    public void setForceSearchedUpdate(boolean bl) {
        this.fieldSelectStatement.setForceSearchedUpdate(bl);
    }

    public void setLockRows(boolean bl) {
        this.fieldSelectStatement.setLockRows(bl);
    }

    public void setMaximumPacketsInCache(int n) {
        this.fieldSelectStatement.setMaximumPacketsInCache(n);
    }

    public void setMaximumRows(int n) {
        this.fieldSelectStatement.setMaximumRows(n);
    }

    public void setPacketSize(int n) {
        this.fieldSelectStatement.setPacketSize(n);
    }

    public void setParameter(int n, Object object) throws DataException {
        this.fieldSelectStatement.setParameter(n, object);
    }

    public void setParameter(String string, Object object) throws DataException {
        this.fieldSelectStatement.setParameter(string, object);
    }

    public void setParameterFromString(int n, String string) throws DataException {
        this.fieldSelectStatement.setParameterFromString(n, string);
    }

    public void setParameterFromString(String string, String string2) throws DataException {
        this.fieldSelectStatement.setParameterFromString(string, string2);
    }

    public void setQuery(Query query) {
        this.setStatementMetaData(query.getSQLSpec());
        this.setDatabaseConnection(query.getConnectionAlias());
    }

    public void setReadOnly(boolean bl) {
        this.fieldSelectStatement.setReadOnly(bl);
    }

    protected void setResult(SelectResult selectResult) {
        if (this.fieldResult != null) {
            this.fieldResult.removePropertyChangeListener(this);
            this.fieldResult.removeStatementResultAfterListener(this);
            this.fieldResult.removeStatementResultBeforeListener(this);
            this.fieldResult.removeStatementResultValueChangeListener(this);
        }
        this.fieldResult = selectResult;
        if (this.fieldResult != null) {
            this.fieldResult.addPropertyChangeListener(this);
            this.fieldResult.addStatementResultAfterListener(this);
            this.fieldResult.addStatementResultBeforeListener(this);
            this.fieldResult.addStatementResultValueChangeListener(this);
        }
    }

    protected void setSelectStatement(SelectStatement selectStatement) {
        if (this.fieldSelectStatement != null) {
            this.fieldSelectStatement.removeStatementAfterListener(this);
            this.fieldSelectStatement.removeStatementBeforeListener(this);
        }
        this.fieldSelectStatement = selectStatement;
        this.fieldSelectStatement.setConnection(this.fieldDatabaseConnection);
        if (this.fieldSelectStatement != null) {
            this.fieldSelectStatement.addStatementAfterListener(this);
            this.fieldSelectStatement.addStatementBeforeListener(this);
        }
    }

    public void setStatementMetaData(StatementMetaData statementMetaData) {
        this.fieldSelectStatement.setMetaData(statementMetaData);
    }

    public void setTimeout(int n) {
        this.fieldSelectStatement.setTimeout(n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setValueAt(Object object, int n, int n2) {
        if (!this.isExecuted()) {
            if (object == null) return;
            Class<?> clazz = object.getClass();
            Class<?> clazz2 = class$java$lang$String;
            if (clazz2 == null) {
                Class<?> clazz3;
                try {
                    clazz3 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz2 = class$java$lang$String = clazz3;
            }
            if (clazz == clazz2 && ((String)object).length() == 0) {
                return;
            }
        }
        try {
            if (n != this.getCurrentRowInCache()) {
                this.setCurrentRowInCache(n);
            }
            if (object != null) {
                Class<?> clazz = object.getClass();
                Class<?> clazz4 = class$java$lang$String;
                if (clazz4 == null) {
                    Class<?> clazz5;
                    try {
                        clazz5 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz4 = class$java$lang$String = clazz5;
                }
                if (clazz == clazz4) {
                    this.setColumnValueFromString(n2, (String)object);
                    return;
                }
            }
            this.setColumnValue(n2, object);
            return;
        }
        catch (DataException dataException) {
            throw new DataRuntimeException(dataException.getMessage());
        }
    }

    public void unlockRow() throws DataException {
        this.fieldResult.unlockRow();
    }

    public void updatedRow(DataEvent dataEvent) {
        this.fireUpdatedRow(new DataEvent(this));
    }

    public void updateRow() throws DataException {
        this.fieldResult.updateRow();
    }
}

