/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eou.toolkit.filter;

import com.ibm.eou.toolkit.filter.TextComponentEditable;
import com.ibm.eou.toolkit.filter.TextEditable;
import com.ibm.eou.toolkit.filter.TextEditableEvent;
import com.ibm.eou.toolkit.filter.TextEditableListener;
import com.ibm.eou.toolkit.filter.TextFilter;
import com.ibm.eou.toolkit.filter.TextFilterEvent;
import com.ibm.eou.toolkit.filter.TextFilterInputEvent;
import com.ibm.eou.toolkit.filter.TextFilterInputListener;
import com.ibm.eou.toolkit.filter.TextFilterListener;
import com.ibm.eou.toolkit.info.InfoTrigger;
import com.ibm.eou.toolkit.util.ArrayUtils;
import java.awt.Component;
import java.awt.TextComponent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;

public abstract class BaseTextFilter
implements TextFilter,
TextEditableListener,
TextFilterListener,
TextFilterInputListener,
Serializable {
    private TextEditable fTextEditable = null;
    private Locale fLocale = null;
    private char[] fExitCharacters = TextFilter.DEFAULT_EXIT_CHARS;
    private boolean fRemoveSelectionOnFocusLost = false;
    private boolean fSelectAllOnFocusGained = false;
    private transient Vector fTextFilterListeners = new Vector(1, 1);
    private transient Vector fTextFilterInputListeners = new Vector(1, 1);
    private int fNumberOfValidateFailures = 0;
    private int fNumberOfInputFailures = 0;
    private PropertyChangeSupport fPropertyChangeSupport = new PropertyChangeSupport(this);
    private InfoTrigger fInfoTrigger;
    private String fInfoText = "{0}";
    private long fInfoTimeout = 500L;
    private int fInfoErrorThreshold = 4;
    private boolean fInfoEnabled = true;

    protected BaseTextFilter() {
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void addTextFilterInputListener(TextFilterInputListener textFilterInputListener) {
        if (!this.fTextFilterInputListeners.contains(textFilterInputListener)) {
            this.fTextFilterInputListeners.addElement(textFilterInputListener);
        }
    }

    public void addTextFilterListener(TextFilterListener textFilterListener) {
        if (!this.fTextFilterListeners.contains(textFilterListener)) {
            this.fTextFilterListeners.addElement(textFilterListener);
        }
    }

    protected boolean allowKeyPressed(TextEditableEvent textEditableEvent) {
        return true;
    }

    protected boolean allowKeyReleased(TextEditableEvent textEditableEvent) {
        return true;
    }

    protected boolean allowKeyTyped(TextEditableEvent textEditableEvent) {
        return true;
    }

    public final void caretPositionChanged(TextEditableEvent textEditableEvent) {
        this.processCaretPositionChanged(textEditableEvent);
    }

    private void checkInfoTrigger() {
        String string;
        String string2 = string = this.fInfoText == null ? null : MessageFormat.format(this.fInfoText, this.getSample());
        if ((this.fTextEditable instanceof TextComponentEditable || this.fTextEditable instanceof Component) && this.fInfoEnabled && this.fInfoText != null && string.length() > 0) {
            Component component;
            Component component2 = component = this.fTextEditable instanceof Component ? (Component)((Object)this.fTextEditable) : ((TextComponentEditable)this.fTextEditable).getTextComponent();
            if (this.fInfoTrigger == null) {
                this.fInfoTrigger = new InfoTrigger(component, string);
                this.fInfoTrigger.enableDefaultDisplay();
                this.addTextFilterListener(this);
                this.addTextFilterInputListener(this);
            } else {
                if (component != this.fInfoTrigger.getTriggerComponent()) {
                    this.fInfoTrigger.setTrigger(component, null);
                }
                if (!string.equals(this.fInfoTrigger.getText())) {
                    this.fInfoTrigger.setText(string);
                }
            }
            if (this.getInfoDelay() != this.fInfoTrigger.getDelay()) {
                this.fInfoTrigger.setDelay(this.getInfoDelay());
            }
            if (!this.fInfoTrigger.isEnabled()) {
                this.fInfoTrigger.setEnabled(true);
            }
        } else if (this.fInfoTrigger != null) {
            this.fInfoTrigger.setEnabled(this.fInfoEnabled);
            this.removeTextFilterListener(this);
            this.removeTextFilterInputListener(this);
        }
    }

    private static String copyright() {
        return "\n\nLicensed Materials - Property of IBM\nIBM(R) VisualAge(TM) for Java(TM) Version 3.0\n(c) Copyright IBM Corp. 1999, All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    }

    public void dispose() {
        this.setTextEditable(null);
    }

    protected void fireInputAccepted(String string, String string2) {
        Enumeration enumeration = ((Vector)this.fTextFilterInputListeners.clone()).elements();
        TextFilterInputEvent textFilterInputEvent = new TextFilterInputEvent(this, 2000, string, string2, this.fNumberOfInputFailures);
        while (enumeration.hasMoreElements()) {
            ((TextFilterInputListener)enumeration.nextElement()).inputAccepted(textFilterInputEvent);
        }
        this.fNumberOfInputFailures = 0;
    }

    protected void fireInputExtended(String string, String string2) {
        Enumeration enumeration = ((Vector)this.fTextFilterInputListeners.clone()).elements();
        TextFilterInputEvent textFilterInputEvent = new TextFilterInputEvent(this, 2003, string, string2, this.fNumberOfInputFailures);
        while (enumeration.hasMoreElements()) {
            ((TextFilterInputListener)enumeration.nextElement()).inputExtended(textFilterInputEvent);
        }
    }

    protected void fireInputFormatted(String string, String string2) {
        Enumeration enumeration = ((Vector)this.fTextFilterInputListeners.clone()).elements();
        TextFilterInputEvent textFilterInputEvent = new TextFilterInputEvent(this, 2002, string, string2, this.fNumberOfInputFailures);
        while (enumeration.hasMoreElements()) {
            ((TextFilterInputListener)enumeration.nextElement()).inputFormatted(textFilterInputEvent);
        }
    }

    protected void fireInputRejected(String string, String string2) {
        Enumeration enumeration = ((Vector)this.fTextFilterInputListeners.clone()).elements();
        TextFilterInputEvent textFilterInputEvent = new TextFilterInputEvent(this, 2001, string, string2, this.fNumberOfInputFailures);
        while (enumeration.hasMoreElements()) {
            ((TextFilterInputListener)enumeration.nextElement()).inputRejected(textFilterInputEvent);
        }
        ++this.fNumberOfInputFailures;
    }

    protected void fireTextValueValidated(String string, boolean bl) {
        Enumeration enumeration = ((Vector)this.fTextFilterListeners.clone()).elements();
        TextFilterEvent textFilterEvent = new TextFilterEvent(this, 1000, string, bl, this.fNumberOfValidateFailures);
        while (enumeration.hasMoreElements()) {
            ((TextFilterListener)enumeration.nextElement()).textValueValidated(textFilterEvent);
        }
        this.fNumberOfValidateFailures = bl ? 0 : ++this.fNumberOfValidateFailures;
    }

    public final void focusGained(TextEditableEvent textEditableEvent) {
        if (this.fSelectAllOnFocusGained) {
            this.fTextEditable.selectAll();
        }
        this.processFocusGained(textEditableEvent);
    }

    public final void focusLost(TextEditableEvent textEditableEvent) {
        if (this.fRemoveSelectionOnFocusLost) {
            int n = this.fTextEditable.getSelectionStart();
            int n2 = this.fTextEditable.getSelectionEnd();
            if (n != -1 && n2 != -1 && n != n2) {
                int n3 = this.fTextEditable.getCaretPosition();
                this.fTextEditable.select(0, 0);
                this.fTextEditable.setCaretPosition(n3);
            }
        }
        this.processFocusLost(textEditableEvent);
    }

    public char[] getExitCharacters() {
        return this.fExitCharacters;
    }

    public long getInfoDelay() {
        return this.fInfoTimeout;
    }

    public boolean getInfoEnabled() {
        return this.fInfoEnabled;
    }

    public int getInfoErrorThreshold() {
        return this.fInfoErrorThreshold;
    }

    public String getInfoText() {
        return this.fInfoText;
    }

    public Locale getLocale() {
        return this.fLocale != null ? this.fLocale : Locale.getDefault();
    }

    public int getNumberOfInputFailures() {
        return this.fNumberOfInputFailures;
    }

    public int getNumberOfValidateFailures() {
        return this.fNumberOfValidateFailures;
    }

    public boolean getRemoveSelectionOnFocusLost() {
        return this.fRemoveSelectionOnFocusLost;
    }

    public String getSample() {
        return "";
    }

    public boolean getSelectAllOnFocusGained() {
        return this.fSelectAllOnFocusGained;
    }

    protected PropertyChangeSupport getSupport() {
        return this.fPropertyChangeSupport;
    }

    public TextEditable getTextEditable() {
        return this.fTextEditable;
    }

    public Object getValue() {
        String string = null;
        if (this.fTextEditable != null) {
            string = this.fTextEditable.getText();
        }
        return string;
    }

    public void inputAccepted(TextFilterInputEvent textFilterInputEvent) {
        if (this.fInfoTrigger != null && this.fInfoTrigger.isShowing()) {
            this.fInfoTrigger.kill();
        }
    }

    public void inputExtended(TextFilterInputEvent textFilterInputEvent) {
    }

    public void inputFormatted(TextFilterInputEvent textFilterInputEvent) {
    }

    public void inputRejected(TextFilterInputEvent textFilterInputEvent) {
        if (this.fInfoTrigger != null && textFilterInputEvent.getNumberOfFailures() >= this.getInfoErrorThreshold()) {
            this.fInfoTrigger.trigger();
        }
    }

    public void keyPressed(TextEditableEvent textEditableEvent) {
        boolean bl = true;
        String string = null;
        String string2 = null;
        if (ArrayUtils.indexOf(this.fExitCharacters, textEditableEvent.getKeyChar()) != -1) {
            textEditableEvent.consume();
            this.fTextEditable.transferFocus();
        } else {
            string = this.fTextEditable.getText();
            bl = this.allowKeyPressed(textEditableEvent);
            string2 = this.fTextEditable.getText();
        }
        if (bl) {
            this.fireInputAccepted(string2, string);
        } else {
            this.fireInputRejected(string2, string);
        }
    }

    public final void keyReleased(TextEditableEvent textEditableEvent) {
        this.allowKeyReleased(textEditableEvent);
    }

    public final void keyTyped(TextEditableEvent textEditableEvent) {
        boolean bl = true;
        String string = null;
        String string2 = null;
        string = this.fTextEditable.getText();
        bl = this.allowKeyTyped(textEditableEvent);
        string2 = this.fTextEditable.getText();
        if (bl) {
            this.fireInputAccepted(string2, string);
        } else {
            this.fireInputRejected(string2, string);
        }
    }

    protected void processCaretPositionChanged(TextEditableEvent textEditableEvent) {
    }

    protected void processFocusGained(TextEditableEvent textEditableEvent) {
    }

    protected void processFocusLost(TextEditableEvent textEditableEvent) {
    }

    protected void processTextValueChanged(TextEditableEvent textEditableEvent) {
    }

    protected boolean processTextValueCompleted(TextEditableEvent textEditableEvent) {
        return true;
    }

    private void readObject(ObjectInputStream objectInputStream) {
        try {
            objectInputStream.defaultReadObject();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        this.fTextFilterListeners = new Vector(1, 1);
        this.fTextFilterInputListeners = new Vector(1, 1);
        if (this.fTextEditable != null) {
            this.fTextEditable.addTextEditableListener(this);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeTextFilterInputListener(TextFilterInputListener textFilterInputListener) {
        this.fTextFilterInputListeners.removeElement(textFilterInputListener);
    }

    public void removeTextFilterListener(TextFilterListener textFilterListener) {
        this.fTextFilterListeners.removeElement(textFilterListener);
    }

    public void setExitCharacters(char[] cArray) {
        char[] cArray2 = this.fExitCharacters;
        this.fExitCharacters = cArray;
        this.getSupport().firePropertyChange("exitCharacters", cArray2, this.fExitCharacters);
    }

    public void setInfoDelay(long l) {
        long l2 = this.fInfoTimeout;
        this.fInfoTimeout = l;
        this.checkInfoTrigger();
        this.getSupport().firePropertyChange("infoDelay", new Long(l2), new Long(this.fInfoTimeout));
    }

    public void setInfoEnabled(boolean bl) {
        boolean bl2 = this.fInfoEnabled;
        this.fInfoEnabled = bl;
        this.checkInfoTrigger();
        this.getSupport().firePropertyChange("infoEnabled", new Boolean(bl2), new Boolean(this.fInfoEnabled));
    }

    public void setInfoErrorThreshold(int n) {
        int n2 = this.fInfoErrorThreshold;
        this.fInfoErrorThreshold = n;
        this.getSupport().firePropertyChange("infoErrorThreshold", new Integer(n2), new Integer(this.fInfoErrorThreshold));
    }

    public void setInfoText(String string) {
        String string2 = this.fInfoText;
        this.fInfoText = string;
        this.checkInfoTrigger();
        this.getSupport().firePropertyChange("infoText", string2, this.fInfoText);
    }

    public void setLocale(Locale locale) {
        Locale locale2 = this.fLocale;
        this.fLocale = locale;
        this.getSupport().firePropertyChange("locale", locale2, this.fLocale);
    }

    public void setRemoveSelectionOnFocusLost(boolean bl) {
        this.fRemoveSelectionOnFocusLost = bl;
        this.getSupport().firePropertyChange("removeSelectionOnFocusLost", new Boolean(!bl), new Boolean(bl));
    }

    public void setSelectAllOnFocusGained(boolean bl) {
        this.fSelectAllOnFocusGained = bl;
        this.getSupport().firePropertyChange("selectAllOnFocusGained", new Boolean(!bl), new Boolean(bl));
    }

    public void setTextComponent(TextComponent textComponent) {
        this.setTextEditable(new TextComponentEditable(textComponent));
    }

    public void setTextEditable(TextEditable textEditable) {
        TextEditable textEditable2 = this.fTextEditable;
        if (this.fTextEditable != null) {
            this.fTextEditable.removeTextEditableListener(this);
            this.fTextEditable = null;
        }
        if (textEditable != null) {
            this.fTextEditable = textEditable;
            this.fTextEditable.addTextEditableListener(this);
        }
        if (this.fTextEditable != null) {
            this.processTextValueChanged(new TextEditableEvent(this.fTextEditable, 3004));
            this.processTextValueCompleted(new TextEditableEvent(this.fTextEditable, 3005));
        }
        this.checkInfoTrigger();
        this.getSupport().firePropertyChange("textEditable", textEditable2, this.fTextEditable);
    }

    public void setValue(Object object) {
        if (this.fTextEditable != null) {
            if (object instanceof String) {
                this.fTextEditable.setText((String)object);
            } else {
                this.fTextEditable.setText(object != null ? "" + object : "");
            }
        }
    }

    public final void textValueChanged(TextEditableEvent textEditableEvent) {
        this.processTextValueChanged(textEditableEvent);
    }

    public final void textValueCompleted(TextEditableEvent textEditableEvent) {
        boolean bl = this.processTextValueCompleted(textEditableEvent);
        String string = this.fTextEditable.getText();
        this.fireTextValueValidated(string, bl);
        this.fTextEditable.setValid(bl);
    }

    public void textValueValidated(TextFilterEvent textFilterEvent) {
        if (this.fInfoTrigger != null && !textFilterEvent.isValid() && textFilterEvent.getNumberOfFailures() >= this.getInfoErrorThreshold()) {
            this.fInfoTrigger.trigger();
        }
    }

    protected void updateSample() {
        this.checkInfoTrigger();
    }
}

