/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eou.toolkit.filter;

import com.ibm.eou.toolkit.filter.BaseTextEditable;
import com.ibm.eou.toolkit.filter.TextEditable;
import com.ibm.eou.toolkit.filter.TextEditableEvent;
import java.awt.IllegalComponentStateException;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public class TextComponentEditable
extends BaseTextEditable
implements KeyListener,
FocusListener,
TextListener,
MouseListener,
Runnable {
    private TextComponent fTextComponent;
    private int fCaretPosition = -1;
    private Thread fCaretThread;
    private long fCaretPollInterval = 0L;
    private int fCaretThreadState = 0;
    private static final int CARET_THREAD_READY = 0;
    private static final int CARET_THREAD_TIMER_RUNNING = 1;
    private static final int CARET_THREAD_TIMER_RESET = 2;
    private static final int CARET_THREAD_EXITING = 3;

    public TextComponentEditable(TextComponent textComponent) {
        TextComponent textComponent2 = this.fTextComponent = textComponent;
        synchronized (textComponent2) {
            this.fTextComponent.removeKeyListener(this);
            this.fTextComponent.removeFocusListener(this);
            this.fTextComponent.removeTextListener(this);
            this.fTextComponent.addKeyListener(this);
            this.fTextComponent.addFocusListener(this);
            this.fTextComponent.addTextListener(this);
        }
        this.fCaretThread = new Thread(this);
        this.fCaretThread.start();
    }

    public void append(String string) {
        this.append(string, true);
    }

    public void append(String string, boolean bl) {
        TextComponent textComponent = this.fTextComponent;
        synchronized (textComponent) {
            if (this.fTextComponent instanceof TextArea) {
                ((TextArea)this.fTextComponent).append(string);
                if (bl) {
                    this.fireTextValueCompleted(new TextEditableEvent(this, 3005));
                }
            } else {
                this.setText(String.valueOf(this.fTextComponent.getText()) + string, bl);
            }
        }
    }

    private void checkCaretAndRestartTimer() {
        Thread thread = this.fCaretThread;
        synchronized (thread) {
            if (this.fCaretThreadState == 1) {
                this.getCaretPosition();
            }
            this.fCaretThreadState = 2;
            this.fCaretThread.notifyAll();
        }
    }

    private static String copyright() {
        return "\n\n(c) Copyright IBM Corporation 1999, \n\n";
    }

    public void dispose() {
        super.dispose();
        Object object = this.fCaretThread;
        synchronized (object) {
            this.fCaretThreadState = 3;
            this.fCaretThread.notifyAll();
        }
        object = this.fTextComponent;
        synchronized (object) {
            this.fTextComponent.removeKeyListener(this);
            this.fTextComponent.removeFocusListener(this);
            this.fTextComponent.removeTextListener(this);
        }
    }

    public final void focusGained(FocusEvent focusEvent) {
        this.fireFocusGained(new TextEditableEvent((TextEditable)this, 3006, focusEvent.isTemporary()));
    }

    public final void focusLost(FocusEvent focusEvent) {
        this.fireFocusLost(new TextEditableEvent((TextEditable)this, 3007, focusEvent.isTemporary()));
    }

    public int getCaretPosition() {
        TextComponent textComponent = this.fTextComponent;
        synchronized (textComponent) {
            int n = this.fTextComponent.getCaretPosition();
            if (n != this.fCaretPosition) {
                this.fCaretPosition = n;
                this.fireCaretPositionChanged(new TextEditableEvent(this, 3003));
            }
            return this.fCaretPosition;
        }
    }

    public int getSelectionEnd() {
        TextComponent textComponent = this.fTextComponent;
        synchronized (textComponent) {
            return this.fTextComponent.getSelectionEnd();
        }
    }

    public int getSelectionStart() {
        TextComponent textComponent = this.fTextComponent;
        synchronized (textComponent) {
            return this.fTextComponent.getSelectionStart();
        }
    }

    public String getText() {
        TextComponent textComponent = this.fTextComponent;
        synchronized (textComponent) {
            return this.fTextComponent.getText();
        }
    }

    public TextComponent getTextComponent() {
        TextComponent textComponent = this.fTextComponent;
        synchronized (textComponent) {
            return this.fTextComponent;
        }
    }

    private boolean hasCaretPositionChanged() {
        int n = this.fCaretPosition;
        int n2 = this.getCaretPosition();
        return n != n2;
    }

    public void insert(String string, int n) {
        this.insert(string, n, true);
    }

    public void insert(String string, int n, boolean bl) {
        TextComponent textComponent = this.fTextComponent;
        synchronized (textComponent) {
            if (this.fTextComponent instanceof TextArea) {
                ((TextArea)this.fTextComponent).insert(string, n);
                if (bl) {
                    this.fireTextValueCompleted(new TextEditableEvent(this, 3005));
                }
            } else {
                this.replaceRange(string, n, n, bl);
            }
        }
    }

    public final void keyPressed(KeyEvent keyEvent) {
        this.fireKeyPressed(new TextEditableEvent((TextEditable)this, 3000, keyEvent));
        if (!keyEvent.isConsumed() && Character.isISOControl(keyEvent.getKeyChar()) && keyEvent.getKeyCode() != 127 && keyEvent.getKeyCode() != 8) {
            this.checkCaretAndRestartTimer();
        }
    }

    public final void keyReleased(KeyEvent keyEvent) {
        this.fireKeyReleased(new TextEditableEvent((TextEditable)this, 3001, keyEvent));
    }

    public final void keyTyped(KeyEvent keyEvent) {
        this.fireKeyTyped(new TextEditableEvent((TextEditable)this, 3002, keyEvent));
        if (!keyEvent.isConsumed() && Character.isISOControl(keyEvent.getKeyChar()) && keyEvent.getKeyCode() != 127 && keyEvent.getKeyCode() != 8) {
            this.checkCaretAndRestartTimer();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.checkCaretAndRestartTimer();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void replaceRange(String string, int n, int n2) {
        this.replaceRange(string, n, n2, true);
    }

    public void replaceRange(String string, int n, int n2, boolean bl) {
        TextComponent textComponent = this.fTextComponent;
        synchronized (textComponent) {
            if (this.fTextComponent instanceof TextArea) {
                ((TextArea)this.fTextComponent).replaceRange(string, n, n2);
                if (bl) {
                    this.fireTextValueCompleted(new TextEditableEvent(this, 3005));
                }
            } else {
                String string2 = this.fTextComponent.getText();
                this.setText(String.valueOf(string2.substring(0, n)) + string + string2.substring(n2), bl);
            }
        }
    }

    public void run() {
        boolean bl = false;
        Thread thread = this.fCaretThread;
        synchronized (thread) {
            while (!bl) {
                try {
                    this.fCaretThread.wait(this.fCaretPollInterval);
                }
                catch (InterruptedException interruptedException) {}
                switch (this.fCaretThreadState) {
                    case 0: {
                        this.fCaretPollInterval = 0L;
                        break;
                    }
                    case 1: {
                        if (this.hasCaretPositionChanged()) {
                            this.fCaretThreadState = 0;
                            this.fCaretPollInterval = 0L;
                            break;
                        }
                        this.fCaretPollInterval *= 2L;
                        break;
                    }
                    case 2: {
                        this.fCaretThreadState = 1;
                        this.fCaretPollInterval = 10L;
                        break;
                    }
                    case 3: {
                        bl = true;
                    }
                }
            }
        }
    }

    public void select(int n, int n2) {
        TextComponent textComponent = this.fTextComponent;
        synchronized (textComponent) {
            this.fTextComponent.select(n, n2);
        }
    }

    public void selectAll() {
        TextComponent textComponent = this.fTextComponent;
        synchronized (textComponent) {
            this.fTextComponent.selectAll();
        }
    }

    public void setCaretPosition(int n) {
        try {
            TextComponent textComponent = this.fTextComponent;
            synchronized (textComponent) {
                this.fTextComponent.setCaretPosition(n);
                this.getCaretPosition();
            }
        }
        catch (IllegalComponentStateException illegalComponentStateException) {}
    }

    public void setSelectionEnd(int n) {
        TextComponent textComponent = this.fTextComponent;
        synchronized (textComponent) {
            this.fTextComponent.setSelectionEnd(n);
        }
    }

    public void setSelectionStart(int n) {
        TextComponent textComponent = this.fTextComponent;
        synchronized (textComponent) {
            this.fTextComponent.setSelectionStart(n);
        }
    }

    public void setText(String string) {
        this.setText(string, true);
    }

    public void setText(String string, boolean bl) {
        TextComponent textComponent = this.fTextComponent;
        synchronized (textComponent) {
            int n = this.fTextComponent.getCaretPosition();
            this.fTextComponent.setText(string);
            this.setCaretPosition(n);
            if (bl) {
                this.fireTextValueCompleted(new TextEditableEvent(this, 3005));
            }
        }
    }

    public final void textValueChanged(TextEvent textEvent) {
        this.fireTextValueChanged(new TextEditableEvent(this, 3004));
    }

    public void transferFocus() {
        TextComponent textComponent = this.fTextComponent;
        synchronized (textComponent) {
            this.fTextComponent.transferFocus();
        }
    }
}

