/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eou.toolkit.util;

import com.ibm.eou.toolkit.util.TimerListener;
import java.util.Date;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Vector;

public class Timer
implements Runnable {
    private long fMark;
    private Vector fListeners = new Vector(1, 1);
    private boolean fQuitThreads;
    private static final int DEAD = 0;
    private static final int WAITING = 1;
    private static final int EXPIRED = 2;
    private int fTimerState;
    private Object fTimerLock = new Object();
    private Thread fTimerThread;
    private long fTimerMark;
    private long fTimerInterval;
    private boolean fTimerRecurring;
    private static Hashtable stamps = null;
    private static Object stampsync = new Object();

    public Timer() {
        this.mark();
    }

    public void addTimerListener(TimerListener timerListener) {
        if (!this.fListeners.contains(timerListener)) {
            this.fListeners.addElement(timerListener);
        }
    }

    public static void closeTimerSession(Object object) {
        Object object2 = stampsync;
        synchronized (object2) {
            stamps.remove(object);
            if (stamps.isEmpty()) {
                stamps = null;
            }
        }
    }

    private static String copyright() {
        return "\n\nLicensed Materials - Property of IBM\nIBM(R) VisualAge(TM) for Java(TM) Version 3.0\n(c) Copyright IBM Corp. 1999. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    }

    public void dispose() {
        this.fListeners.removeAllElements();
        this.fQuitThreads = true;
        Object object = this.fTimerLock;
        synchronized (object) {
            this.fTimerLock.notifyAll();
        }
    }

    protected void fireTimerExpired() {
        EventObject eventObject = new EventObject(this);
        Enumeration enumeration = ((Vector)this.fListeners.clone()).elements();
        while (enumeration.hasMoreElements()) {
            ((TimerListener)enumeration.nextElement()).timerExpired(eventObject);
        }
    }

    public static long getElapsedTime(Object object) {
        Object object2 = stampsync;
        synchronized (object2) {
            return Timer.hasTimerSession(object) ? new Date().getTime() - (Long)stamps.get(object) : -1L;
        }
    }

    public long getMark() {
        return this.fMark;
    }

    public static boolean hasTimerSession(Object object) {
        return stamps.containsKey(object);
    }

    public void mark() {
        this.setMark(System.currentTimeMillis());
    }

    public static void openTimerSession(Object object) {
        Object object2 = stampsync;
        synchronized (object2) {
            if (stamps == null) {
                stamps = new Hashtable();
            }
            if (!stamps.containsKey(object)) {
                stamps.put(object, new Long(0L));
                Timer.resetTimer(object);
            }
        }
    }

    public void removeTimerListener(TimerListener timerListener) {
        this.fListeners.removeElement(timerListener);
    }

    public static void resetTimer(Object object) {
        if (Timer.hasTimerSession(object)) {
            Object object2 = stampsync;
            synchronized (object2) {
                stamps.put(object, new Long(new Date().getTime()));
            }
        }
    }

    public void run() {
        Object object = this.fTimerLock;
        synchronized (object) {
            boolean bl = true;
            while (bl) {
                long l = System.currentTimeMillis();
                switch (this.fTimerState) {
                    case 1: {
                        int n = this.fTimerState = l < this.fTimerMark + this.fTimerInterval ? 1 : 2;
                        if (this.fTimerState != 1) break;
                        try {
                            this.fTimerLock.wait(this.fTimerMark + this.fTimerInterval - l);
                        }
                        catch (InterruptedException interruptedException) {}
                        break;
                    }
                    case 2: {
                        this.fTimerMark += this.fTimerInterval;
                        this.setMark(this.fTimerMark);
                        this.fTimerState = this.fTimerRecurring ? 1 : 0;
                        this.fireTimerExpired();
                        break;
                    }
                    case 0: {
                        try {
                            this.fTimerLock.wait(10000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        if (this.fTimerState != 0) break;
                        bl = false;
                        break;
                    }
                }
                bl &= !this.fQuitThreads;
            }
            this.fTimerThread = null;
        }
    }

    public void setMark(long l) {
        this.fMark = l;
    }

    public void startTimer(long l, boolean bl) {
        this.startTimer(l, bl, false);
    }

    public void startTimer(long l, boolean bl, boolean bl2) {
        Object object = this.fTimerLock;
        synchronized (object) {
            this.fTimerState = 1;
            this.fTimerMark = bl2 ? System.currentTimeMillis() : this.getMark();
            this.fTimerInterval = l;
            this.fTimerRecurring = bl;
            if (this.fTimerThread == null) {
                this.fTimerThread = new Thread(this);
                this.fTimerThread.setDaemon(true);
                this.fTimerThread.setPriority(1);
                this.fTimerThread.start();
            } else {
                this.fTimerLock.notifyAll();
            }
        }
    }

    public void stopTimer() {
        Object object = this.fTimerLock;
        synchronized (object) {
            if (this.fTimerThread != null) {
                this.fTimerState = 0;
                this.fTimerLock.notifyAll();
            }
        }
    }

    public void waitUntil(long l) throws InterruptedException {
        this.waitUntil(l, new Object(), true);
    }

    public boolean waitUntil(long l, Object object, boolean bl) throws InterruptedException {
        long l2 = this.getMark() + l;
        boolean bl2 = false;
        Object object2 = object;
        synchronized (object2) {
            long l3 = System.currentTimeMillis();
            boolean bl3 = l3 < l2;
            while (bl3) {
                object.wait(l2 - l3);
                l3 = System.currentTimeMillis();
                bl2 = l3 >= l2;
                boolean bl4 = bl3 = !bl2 && !bl;
            }
        }
        return bl2;
    }

    public static boolean waitUntil(Object object, long l) throws InterruptedException {
        return Timer.waitUntil(object, l, new Object());
    }

    public static boolean waitUntil(Object object, long l, Object object2) throws InterruptedException {
        boolean bl = false;
        if (Timer.hasTimerSession(object)) {
            long l2;
            long l3;
            Object object3 = stampsync;
            synchronized (object3) {
                l3 = (Long)stamps.get(object);
                l2 = l3 + l - new Date().getTime();
            }
            if (l2 > 0L) {
                object3 = object2;
                synchronized (object3) {
                    object2.wait(l2);
                }
            }
            object3 = stampsync;
            synchronized (object3) {
                long l4 = l3 + l;
                long l5 = new Date().getTime();
                boolean bl2 = bl = l5 >= l4;
                if (bl) {
                    stamps.put(object, new Long(l5));
                }
            }
        }
        return bl;
    }
}

