/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivj.db.ibeans;

import com.ibm.db.DatabaseConnection;
import com.ibm.db.LogonDialog;
import com.ibm.db.base.UtilitiesBase;
import com.ibm.ivj.db.ibeans.CommonUtil;
import com.ibm.ivj.db.ibeans.ErrorMessageDialog;
import com.ibm.ivj.db.ibeans.IBMIVJDBDialog;
import com.ibm.ivj.db.ibeans.QuerySpecification;
import com.ibm.uvm.abt.edit.DialogHelper;
import com.sun.java.swing.JDialog;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JTabbedPane;
import com.sun.java.swing.event.ChangeEvent;
import com.sun.java.swing.event.ChangeListener;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class ConnectionAttrDialog
extends JDialog
implements WindowListener,
ItemListener,
ActionListener,
KeyListener,
TextListener,
ChangeListener {
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1998, 1999";
    QuerySpecification parentRef = null;
    private Panel ivjConnNamePanel = null;
    private Choice ivjChoiceDriver = null;
    private Button ivjButtonCancel = null;
    private Button ivjButtonOK = null;
    private Button ivjButtonTest = null;
    private Button ivjButtonBack = null;
    private Button ivjButtonNext = null;
    private CheckboxGroup ivjCheckboxGroup1 = null;
    private Checkbox ivjCheckboxPromptUID = null;
    private Checkbox ivjCheckboxAuto = null;
    private Checkbox ivjCheckboxPool = null;
    private Checkbox ivjCheckboxPromptYes = null;
    private Checkbox ivjCheckboxPromptNo = null;
    private TextField ivjTextFieldConnectionName = null;
    private TextField ivjTextFieldDataSourceName = null;
    private TextField ivjTextFieldLogonID = null;
    private TextField ivjTextFieldPassword = null;
    private TextField ivjTextFieldURL = null;
    private TextField ivjTextFieldDriver = null;
    private TextField ivjTextFieldProp = null;
    private Label ivjMsgLabel = null;
    private JTabbedPane tabPane = null;
    private boolean createFlag = false;
    private String oldSpecName = null;
    private boolean validName = true;

    public ConnectionAttrDialog(QuerySpecification querySpecification) {
        super(querySpecification.getParentFrame(), true);
        this.parentRef = querySpecification;
        try {
            this.initialize();
            DialogHelper.centerWindowOnComponent((Window)((Object)this), (Component)((Object)querySpecification));
            this.initConnections(querySpecification);
        }
        catch (Throwable throwable) {
            CommonUtil.handleException(throwable, (Component)((Object)this));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.getButtonOK()) {
            this.connButtonOK();
        } else if (actionEvent.getSource() == this.getButtonCancel()) {
            ((Window)((Object)this)).dispose();
        } else if (actionEvent.getSource() == this.getButtonTest()) {
            this.connTestConnection();
        }
        if (actionEvent.getSource() == this.getButtonNext()) {
            this.getTabbedPane().setSelectedIndex(1);
            this.getButtonNext().setEnabled(false);
            this.getButtonBack().setEnabled(true);
        }
        if (actionEvent.getSource() == this.getButtonBack()) {
            this.getTabbedPane().setSelectedIndex(0);
            this.getButtonBack().setEnabled(false);
            this.getButtonNext().setEnabled(true);
        }
    }

    private boolean checkOK() {
        if (this.getTextFieldConnectionName().getText().equals("") || this.getTextFieldURL().getText().equals("")) {
            return false;
        }
        return !this.getTextFieldDriver().getText().equals("") || !this.getChoiceDriver().getSelectedItem().equals(CommonUtil.getMessage(IBMIVJDBDialog.otherDriver));
    }

    private void connButtonOK() {
        try {
            String string = this.getTextFieldConnectionName().getText();
            if (this.generateConnectSpec() < 0) {
                return;
            }
            if (this.createFlag || !this.createFlag && !string.equals(this.oldSpecName)) {
                this.parentRef.getPanelConnect().getChoice().add(string);
                this.parentRef.getPanelConnect().sortListItems();
                this.parentRef.getPanelConnect().selectListItem(string);
                this.parentRef.getPanelConnect().getButtonEdit().setEnabled(true);
                this.parentRef.getPanelConnect().getButtonDelete().setEnabled(true);
                this.parentRef.getQueryEditor().getQLocator().setConnectName(string);
                this.parentRef.getQueryEditor().getQLocator().setConnectBundleName(this.parentRef.getConnectSpecPath());
            }
            this.parentRef.getPanelConnect().getTextArea().setText(this.getTextFieldURL().getText());
            this.parentRef.getQueryEditor().getSupport().firePropertyChange(null, null, null);
            ((Window)((Object)this)).dispose();
        }
        catch (Throwable throwable) {
            CommonUtil.handleException(throwable, (Component)((Object)this));
        }
    }

    public void connCreateEdit(boolean bl, String string) {
        try {
            if (bl) {
                this.getButtonOK().setEnabled(false);
                this.createFlag = true;
            } else {
                this.getButtonOK().setEnabled(true);
                this.createFlag = false;
            }
            this.oldSpecName = string;
            this.getTabbedPane().setSelectedIndex(0);
            this.getButtonBack().setEnabled(false);
            this.getTextFieldConnectionName().requestFocus();
            if (this.mnlGetConnectSpecValue(string) == 0) {
                ((Dialog)((Object)this)).show();
            }
        }
        catch (Throwable throwable) {
            CommonUtil.handleException(throwable, (Component)((Object)this));
        }
    }

    private void connTestConnection() {
        String[] stringArray = new String[1];
        String[] stringArray2 = new String[1];
        LogonDialog logonDialog = null;
        try {
            Object object;
            String string = this.getTextFieldDriver().getText();
            if (string == null || string.equals("")) {
                string = this.getChoiceDriver().getSelectedItem();
            }
            Class.forName(string);
            Properties properties = new Properties();
            stringArray[0] = this.getTextFieldLogonID().getText();
            stringArray2[0] = this.getTextFieldPassword().getText();
            if (this.getCheckboxPromptUID().getState() && !(logonDialog = new LogonDialog((Component)((Object)this))).promptAndSetUID(stringArray, stringArray2)) {
                return;
            }
            ((Hashtable)properties).put("user", stringArray[0]);
            ((Hashtable)properties).put("password", stringArray2[0]);
            String string2 = this.getTextFieldProp().getText();
            if (!string2.equals("")) {
                object = new String[2];
                int n = 0;
                while (n >= 0) {
                    n = string2.indexOf(";", n + 1);
                    object = this.parseProp(string2);
                    if (object == null) {
                        new ErrorMessageDialog(CommonUtil.getMessage(IBMIVJDBDialog.propSyntaxErr), (Component)((Object)this));
                        return;
                    }
                    ((Hashtable)properties).put(object[0], object[1]);
                    string2 = string2.substring(n + 1, string2.length());
                }
            }
            ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(3));
            object = DriverManager.getConnection(this.getTextFieldURL().getText(), properties);
            object.close();
            ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(0));
            new ErrorMessageDialog(CommonUtil.getMessage(IBMIVJDBDialog.connectOK), (Component)((Object)this));
        }
        catch (ClassNotFoundException classNotFoundException) {
            ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(0));
            CommonUtil.handleException(CommonUtil.getMessage(IBMIVJDBDialog.driverNotFound), classNotFoundException, (Component)((Object)this));
        }
        catch (SQLException sQLException) {
            ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(0));
            CommonUtil.handleException(sQLException, (Component)((Object)this));
        }
        catch (Throwable throwable) {
            ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(0));
            CommonUtil.handleException(throwable, (Component)((Object)this));
        }
    }

    public int generateConnectSpec() {
        Object object;
        Object object2;
        String string = this.parentRef.getPanelConnect().getChoiceClass().getSelectedItem();
        String string2 = this.getTextFieldConnectionName().getText();
        String string3 = "  com.ibm.db.DatabaseConnection connection = null;\n";
        string3 = String.valueOf(string3) + "  try{ \n";
        string3 = String.valueOf(string3) + "    connection = new com.ibm.db.DatabaseConnection();\n";
        string3 = String.valueOf(string3) + "    connection.setConnectionAlias(\"" + string + "." + string2 + "\");\n";
        string3 = String.valueOf(string3) + "    connection.setDriverName(\"";
        String string4 = this.getChoiceDriver().getSelectedItem();
        boolean bl = false;
        int n = 0;
        while (n < CommonUtil.driverName.length) {
            if (string4 != null && string4.equals(CommonUtil.driverName[n])) {
                bl = true;
                break;
            }
            ++n;
        }
        string3 = !bl ? String.valueOf(string3) + this.getTextFieldDriver().getText() + "\");\n" : String.valueOf(string3) + this.getChoiceDriver().getSelectedItem() + "\");\n";
        string3 = String.valueOf(string3) + "    connection.setDataSourceName(\"" + this.getTextFieldURL().getText() + "\");\n";
        string3 = String.valueOf(string3) + "    connection.setUserID(\"" + this.getTextFieldLogonID().getText() + "\");\n";
        String string5 = this.getTextFieldPassword().getText();
        if (!string5.equals("")) {
            object2 = null;
            try {
                object = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)object);
                objectOutputStream.writeObject(string5);
                object2 = object.toByteArray();
            }
            catch (IOException iOException) {
                CommonUtil.handleException(iOException, (Component)((Object)this));
                return -1;
            }
            string5 = UtilitiesBase.encodeData((byte[])object2, (int)5000);
        }
        string3 = String.valueOf(string3) + "    connection.setPromptUID(" + this.getCheckboxPromptUID().getState() + ");\n";
        object2 = this.getTextFieldProp().getText();
        if (!((String)object2).equals("")) {
            string3 = String.valueOf(string3) + "    java.util.Properties props = new java.util.Properties();\n";
            object = new String[2];
            int n2 = 0;
            while (n2 >= 0) {
                n2 = ((String)object2).indexOf(";", n2 + 1);
                object = this.parseProp((String)object2);
                if (object == null) {
                    new ErrorMessageDialog(CommonUtil.getMessage(IBMIVJDBDialog.propSyntaxErr));
                    return -2;
                }
                string3 = String.valueOf(string3) + "    props.put(\"" + object[0] + "\", \"" + object[1] + "\");\n";
                object2 = ((String)object2).substring(n2 + 1, ((String)object2).length());
            }
            string3 = String.valueOf(string3) + "    connection.setProperties(props);\n";
        }
        string3 = String.valueOf(string3) + "    connection.setAutoCommit(" + this.getCheckboxAuto().getState() + ");\n";
        string3 = String.valueOf(string3) + "    connection.setPassword(\"" + string5 + "\", true);\n";
        if (this.getCheckboxPool().getState()) {
            string3 = String.valueOf(string3) + "    connection.setConnectionPoolType(com.ibm.db.DatabaseConnection.POOL_TYPE_WEBSPHERE);\n";
        }
        string3 = String.valueOf(string3) + "  }\n  catch(com.ibm.db.DataException e){throw e;}\n";
        string3 = String.valueOf(string3) + "  catch(java.lang.Throwable e){throw e;}\n";
        string3 = String.valueOf(string3) + "  return connection;\n";
        object = this.parentRef.getPanelConnect().getChoiceClass().getSelectedItem();
        CommonUtil.methodCodeGen("com.ibm.db.DatabaseConnection", (String)object, string2, string3, (Component)((Object)this));
        return 0;
    }

    public Button getButtonBack() {
        if (this.ivjButtonBack == null) {
            try {
                this.ivjButtonBack = new Button();
                this.ivjButtonBack.setLabel(CommonUtil.getMessage(IBMIVJDBDialog.buttonBack));
            }
            catch (Throwable throwable) {
                CommonUtil.handleException(throwable, (Component)((Object)this));
            }
        }
        return this.ivjButtonBack;
    }

    public Button getButtonCancel() {
        if (this.ivjButtonCancel == null) {
            try {
                this.ivjButtonCancel = new Button();
                this.ivjButtonCancel.setLabel(CommonUtil.getMessage(IBMIVJDBDialog.Cancel));
            }
            catch (Throwable throwable) {
                CommonUtil.handleException(throwable, (Component)((Object)this));
            }
        }
        return this.ivjButtonCancel;
    }

    public Button getButtonNext() {
        if (this.ivjButtonNext == null) {
            try {
                this.ivjButtonNext = new Button();
                this.ivjButtonNext.setLabel(CommonUtil.getMessage(IBMIVJDBDialog.buttonNext));
            }
            catch (Throwable throwable) {
                CommonUtil.handleException(throwable, (Component)((Object)this));
            }
        }
        return this.ivjButtonNext;
    }

    public Button getButtonOK() {
        if (this.ivjButtonOK == null) {
            try {
                this.ivjButtonOK = new Button();
                this.ivjButtonOK.setLabel(CommonUtil.getMessage(IBMIVJDBDialog.finishButton));
            }
            catch (Throwable throwable) {
                CommonUtil.handleException(throwable, (Component)((Object)this));
            }
        }
        return this.ivjButtonOK;
    }

    private Button getButtonTest() {
        if (this.ivjButtonTest == null) {
            try {
                this.ivjButtonTest = new Button();
                this.ivjButtonTest.setLabel(CommonUtil.getMessage(IBMIVJDBDialog.testConnect));
            }
            catch (Throwable throwable) {
                CommonUtil.handleException(throwable, (Component)((Object)this));
            }
        }
        return this.ivjButtonTest;
    }

    public Checkbox getCheckboxAuto() {
        if (this.ivjCheckboxAuto == null) {
            try {
                this.ivjCheckboxAuto = new Checkbox(CommonUtil.getMessage(IBMIVJDBDialog.autoCommit), true);
            }
            catch (Throwable throwable) {
                CommonUtil.handleException(throwable, (Component)((Object)this));
            }
        }
        return this.ivjCheckboxAuto;
    }

    public Checkbox getCheckboxPool() {
        if (this.ivjCheckboxPool == null) {
            try {
                this.ivjCheckboxPool = new Checkbox(CommonUtil.getMessage(IBMIVJDBDialog.checkBoxPool), false);
            }
            catch (Throwable throwable) {
                CommonUtil.handleException(throwable, (Component)((Object)this));
            }
        }
        return this.ivjCheckboxPool;
    }

    public Checkbox getCheckboxPromptUID() {
        if (this.ivjCheckboxPromptUID == null) {
            try {
                this.ivjCheckboxPromptUID = new Checkbox(CommonUtil.getMessage(IBMIVJDBDialog.propmtID), false);
            }
            catch (Throwable throwable) {
                CommonUtil.handleException(throwable, (Component)((Object)this));
            }
        }
        return this.ivjCheckboxPromptUID;
    }

    public Choice getChoiceDriver() {
        if (this.ivjChoiceDriver == null) {
            try {
                this.ivjChoiceDriver = new Choice();
                this.ivjChoiceDriver.setBackground(Color.white);
                this.ivjChoiceDriver.setForeground(Color.black);
                int n = 0;
                while (n < CommonUtil.driverName.length) {
                    this.ivjChoiceDriver.addItem(CommonUtil.driverName[n]);
                    ++n;
                }
                this.ivjChoiceDriver.addItem(CommonUtil.getMessage(IBMIVJDBDialog.otherDriver));
            }
            catch (Throwable throwable) {
                CommonUtil.handleException(throwable, (Component)((Object)this));
            }
        }
        return this.ivjChoiceDriver;
    }

    Label getMsgLabel() {
        if (this.ivjMsgLabel == null) {
            this.ivjMsgLabel = new Label();
        }
        return this.ivjMsgLabel;
    }

    public JTabbedPane getTabbedPane() {
        if (this.tabPane == null) {
            this.tabPane = new JTabbedPane();
        }
        return this.tabPane;
    }

    public TextField getTextFieldConnectionName() {
        if (this.ivjTextFieldConnectionName == null) {
            try {
                this.ivjTextFieldConnectionName = new TextField();
                ((TextComponent)this.ivjTextFieldConnectionName).setText("");
                ((Component)this.ivjTextFieldConnectionName).setBackground(Color.white);
                this.ivjTextFieldConnectionName.setForeground(Color.black);
            }
            catch (Throwable throwable) {
                CommonUtil.handleException(throwable, (Component)((Object)this));
            }
        }
        return this.ivjTextFieldConnectionName;
    }

    private TextField getTextFieldDriver() {
        if (this.ivjTextFieldDriver == null) {
            try {
                this.ivjTextFieldDriver = new TextField();
                this.ivjTextFieldDriver.setForeground(Color.black);
                this.setDriverField();
            }
            catch (Throwable throwable) {
                CommonUtil.handleException(throwable, (Component)((Object)this));
            }
        }
        return this.ivjTextFieldDriver;
    }

    public TextField getTextFieldLogonID() {
        if (this.ivjTextFieldLogonID == null) {
            try {
                this.ivjTextFieldLogonID = new TextField();
                ((TextComponent)this.ivjTextFieldLogonID).setText("");
                ((Component)this.ivjTextFieldLogonID).setBackground(Color.white);
                this.ivjTextFieldLogonID.setForeground(Color.black);
            }
            catch (Throwable throwable) {
                CommonUtil.handleException(throwable, (Component)((Object)this));
            }
        }
        return this.ivjTextFieldLogonID;
    }

    public TextField getTextFieldPassword() {
        if (this.ivjTextFieldPassword == null) {
            try {
                this.ivjTextFieldPassword = new TextField();
                ((Component)this.ivjTextFieldPassword).setBackground(Color.white);
                this.ivjTextFieldPassword.setForeground(Color.black);
                this.ivjTextFieldPassword.setEchoChar('*');
            }
            catch (Throwable throwable) {
                CommonUtil.handleException(throwable, (Component)((Object)this));
            }
        }
        return this.ivjTextFieldPassword;
    }

    private TextField getTextFieldProp() {
        if (this.ivjTextFieldProp == null) {
            try {
                this.ivjTextFieldProp = new TextField();
                ((TextComponent)this.ivjTextFieldProp).setText("");
                ((Component)this.ivjTextFieldProp).setBackground(Color.white);
                this.ivjTextFieldProp.setForeground(Color.black);
            }
            catch (Throwable throwable) {
                CommonUtil.handleException(throwable, (Component)((Object)this));
            }
        }
        return this.ivjTextFieldProp;
    }

    private TextField getTextFieldURL() {
        if (this.ivjTextFieldURL == null) {
            try {
                this.ivjTextFieldURL = new TextField();
                ((TextComponent)this.ivjTextFieldURL).setText("");
                ((Component)this.ivjTextFieldURL).setBackground(Color.white);
                this.ivjTextFieldURL.setForeground(Color.black);
            }
            catch (Throwable throwable) {
                CommonUtil.handleException(throwable, (Component)((Object)this));
            }
        }
        return this.ivjTextFieldURL;
    }

    private void handlePromptNoField() {
        ((Component)this.getTextFieldLogonID()).setBackground(Color.white);
        this.getTextFieldLogonID().setEnabled(true);
        ((Component)this.getTextFieldPassword()).setBackground(Color.white);
        this.getTextFieldPassword().setEnabled(true);
    }

    private void handlePromptYesField() {
        ((Component)this.getTextFieldLogonID()).setBackground(SystemColor.control);
        ((TextComponent)this.getTextFieldLogonID()).setText("");
        this.getTextFieldLogonID().setEnabled(false);
        ((Component)this.getTextFieldPassword()).setBackground(SystemColor.control);
        ((TextComponent)this.getTextFieldPassword()).setText("");
        this.getTextFieldPassword().setEnabled(false);
    }

    private void initConnections(Object object) {
        ((Window)((Object)this)).addWindowListener(this);
        this.getCheckboxPromptUID().addItemListener(this);
        this.getButtonOK().addActionListener(this);
        this.getButtonTest().addActionListener(this);
        this.getButtonCancel().addActionListener(this);
        this.getButtonBack().addActionListener(this);
        this.getButtonNext().addActionListener(this);
        this.getChoiceDriver().addItemListener(this);
        this.getTextFieldConnectionName().addTextListener(this);
        this.getTextFieldURL().addTextListener(this);
        this.getTextFieldDriver().addTextListener(this);
        this.getTextFieldConnectionName().addKeyListener(this);
        this.getTextFieldURL().addKeyListener(this);
        this.getTextFieldDriver().addKeyListener(this);
        this.getTextFieldLogonID().addKeyListener(this);
        this.getTextFieldPassword().addKeyListener(this);
        this.getChoiceDriver().addKeyListener(this);
        this.getCheckboxPromptUID().addKeyListener(this);
        this.getCheckboxAuto().addKeyListener(this);
        this.getTextFieldProp().addKeyListener(this);
        this.getTabbedPane().addChangeListener((ChangeListener)this);
    }

    private void initialize() {
        Container container = this.getContentPane();
        container.setBackground(SystemColor.control);
        container.setForeground(Color.black);
        ((Component)((Object)this)).setBackground(SystemColor.control);
        ((Component)((Object)this)).setForeground(Color.black);
        ((Dialog)((Object)this)).setTitle(CommonUtil.getMessage(IBMIVJDBDialog.ConnectAlias));
        GridBagLayout gridBagLayout = new GridBagLayout();
        container.setLayout(gridBagLayout);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel.setBackground(SystemColor.control);
        jPanel2.setBackground(SystemColor.control);
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        jPanel.setLayout(gridBagLayout2);
        GridBagLayout gridBagLayout3 = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout3);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        CommonUtil.buildCons(gridBagConstraints, 0, 0, 1, 1, 100, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(50, 35, 0, 35);
        gridBagLayout3.setConstraints(this.getCheckboxPool(), gridBagConstraints);
        jPanel2.add(this.getCheckboxPool());
        gridBagConstraints = new GridBagConstraints();
        CommonUtil.buildCons(gridBagConstraints, 0, 1, 1, 1, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 60, 300, 35);
        Label label = new Label(CommonUtil.getMessage(IBMIVJDBDialog.checkBoxPool1), 0);
        gridBagLayout3.setConstraints(label, gridBagConstraints);
        jPanel2.add(label);
        gridBagConstraints = new GridBagConstraints();
        CommonUtil.buildCons(gridBagConstraints, 0, 0, 1, 1, 0, 10);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 35, 5, 0);
        Label label2 = new Label(CommonUtil.getMessage(IBMIVJDBDialog.ConnectionName), 0);
        gridBagLayout2.setConstraints(label2, gridBagConstraints);
        jPanel.add(label2);
        gridBagConstraints = new GridBagConstraints();
        CommonUtil.buildCons(gridBagConstraints, 1, 0, 1, 1, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(15, 0, 5, 35);
        gridBagLayout2.setConstraints(this.getTextFieldConnectionName(), gridBagConstraints);
        jPanel.add(this.getTextFieldConnectionName());
        gridBagConstraints = new GridBagConstraints();
        CommonUtil.buildCons(gridBagConstraints, 0, 1, 1, 1, 0, 10);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 35, 0, 0);
        Label label3 = new Label(CommonUtil.getMessage(IBMIVJDBDialog.URL), 0);
        gridBagLayout2.setConstraints(label3, gridBagConstraints);
        jPanel.add(label3);
        gridBagConstraints = new GridBagConstraints();
        CommonUtil.buildCons(gridBagConstraints, 1, 1, 1, 1, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 5, 35);
        gridBagLayout2.setConstraints(this.getTextFieldURL(), gridBagConstraints);
        jPanel.add(this.getTextFieldURL());
        gridBagConstraints = new GridBagConstraints();
        CommonUtil.buildCons(gridBagConstraints, 0, 2, 1, 1, 20, 10);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 35, 0, 0);
        Label label4 = new Label(CommonUtil.getMessage(IBMIVJDBDialog.JDBCDriverChoices), 0);
        gridBagLayout2.setConstraints(label4, gridBagConstraints);
        jPanel.add(label4);
        gridBagConstraints = new GridBagConstraints();
        CommonUtil.buildCons(gridBagConstraints, 1, 2, 1, 1, 100, 10);
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 5, 35);
        gridBagLayout2.setConstraints(this.getChoiceDriver(), gridBagConstraints);
        jPanel.add(this.getChoiceDriver());
        gridBagConstraints = new GridBagConstraints();
        CommonUtil.buildCons(gridBagConstraints, 0, 3, 1, 1, 0, 10);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 35, 0, 0);
        Label label5 = new Label(CommonUtil.getMessage(IBMIVJDBDialog.JDBCDriverInput), 0);
        gridBagLayout2.setConstraints(label5, gridBagConstraints);
        jPanel.add(label5);
        gridBagConstraints = new GridBagConstraints();
        CommonUtil.buildCons(gridBagConstraints, 1, 3, 1, 1, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 5, 35);
        gridBagLayout2.setConstraints(this.getTextFieldDriver(), gridBagConstraints);
        jPanel.add(this.getTextFieldDriver());
        gridBagConstraints = new GridBagConstraints();
        CommonUtil.buildCons(gridBagConstraints, 0, 4, 1, 1, 0, 10);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 35, 0, 0);
        Label label6 = new Label(CommonUtil.getMessage(IBMIVJDBDialog.connectProp), 0);
        gridBagLayout2.setConstraints(label6, gridBagConstraints);
        jPanel.add(label6);
        gridBagConstraints = new GridBagConstraints();
        CommonUtil.buildCons(gridBagConstraints, 1, 4, 1, 1, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 5, 35);
        gridBagLayout2.setConstraints(this.getTextFieldProp(), gridBagConstraints);
        jPanel.add(this.getTextFieldProp());
        gridBagConstraints = new GridBagConstraints();
        CommonUtil.buildCons(gridBagConstraints, 0, 5, 2, 1, 0, 10);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 35, 5, 0);
        gridBagLayout2.setConstraints(this.getCheckboxAuto(), gridBagConstraints);
        jPanel.add(this.getCheckboxAuto());
        gridBagConstraints = new GridBagConstraints();
        CommonUtil.buildCons(gridBagConstraints, 0, 6, 2, 1, 0, 5);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 35, 5, 0);
        gridBagLayout2.setConstraints(this.getCheckboxPromptUID(), gridBagConstraints);
        jPanel.add(this.getCheckboxPromptUID());
        gridBagConstraints = new GridBagConstraints();
        CommonUtil.buildCons(gridBagConstraints, 0, 7, 1, 1, 0, 10);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 53, 0, 0);
        Label label7 = new Label(CommonUtil.getMessage(IBMIVJDBDialog.UserID), 0);
        gridBagLayout2.setConstraints(label7, gridBagConstraints);
        jPanel.add(label7);
        gridBagConstraints = new GridBagConstraints();
        CommonUtil.buildCons(gridBagConstraints, 1, 7, 1, 1, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 5, 35);
        gridBagLayout2.setConstraints(this.getTextFieldLogonID(), gridBagConstraints);
        jPanel.add(this.getTextFieldLogonID());
        gridBagConstraints = new GridBagConstraints();
        CommonUtil.buildCons(gridBagConstraints, 0, 8, 1, 1, 0, 10);
        gridBagConstraints.insets = new Insets(0, 53, 0, 0);
        gridBagConstraints.anchor = 17;
        Label label8 = new Label(CommonUtil.getMessage(IBMIVJDBDialog.Password), 0);
        gridBagLayout2.setConstraints(label8, gridBagConstraints);
        jPanel.add(label8);
        gridBagConstraints = new GridBagConstraints();
        CommonUtil.buildCons(gridBagConstraints, 1, 8, 1, 1, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 5, 35);
        gridBagLayout2.setConstraints(this.getTextFieldPassword(), gridBagConstraints);
        jPanel.add(this.getTextFieldPassword());
        gridBagConstraints = new GridBagConstraints();
        CommonUtil.buildCons(gridBagConstraints, 0, 9, 2, 1, 0, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 35, 5, 35);
        gridBagLayout2.setConstraints(this.getMsgLabel(), gridBagConstraints);
        jPanel.add(this.getMsgLabel());
        JTabbedPane jTabbedPane = this.getTabbedPane();
        jTabbedPane.addTab(CommonUtil.getMessage(IBMIVJDBDialog.tabConnectAlias), null, (Component)jPanel, CommonUtil.getMessage(IBMIVJDBDialog.tabConnectAlias));
        jTabbedPane.addTab(CommonUtil.getMessage(IBMIVJDBDialog.tabAdvanced), null, (Component)jPanel2, CommonUtil.getMessage(IBMIVJDBDialog.tabAdvanced));
        jTabbedPane.setBackground(SystemColor.control);
        jTabbedPane.setForeground(Color.black);
        jTabbedPane.setSelectedIndex(0);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.setBackground(new Color(160, 160, 164));
        jPanel3.setForeground(Color.black);
        jPanel3.add("North", CommonUtil.spacer(5, 5));
        jPanel3.add("Center", (Component)jTabbedPane);
        gridBagConstraints = new GridBagConstraints();
        CommonUtil.buildCons(gridBagConstraints, 0, 0, 1, 1, 0, 100);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints((Component)jPanel3, gridBagConstraints);
        container.add((Component)jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setBackground(SystemColor.control);
        jPanel4.setLayout(new GridLayout(1, 0, 5, 0));
        jPanel4.add(this.getButtonBack());
        jPanel4.add(this.getButtonNext());
        jPanel4.add(this.getButtonOK());
        jPanel4.add(this.getButtonCancel());
        jPanel4.add(this.getButtonTest());
        gridBagConstraints = new GridBagConstraints();
        CommonUtil.buildCons(gridBagConstraints, 0, 1, 1, 1, 100, 0);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        gridBagLayout.setConstraints((Component)jPanel4, gridBagConstraints);
        container.add((Component)jPanel4);
        ((Window)((Object)this)).pack();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.getChoiceDriver()) {
            this.setDriverField();
            if (this.getChoiceDriver().getSelectedItem().equals(CommonUtil.getMessage(IBMIVJDBDialog.otherDriver))) {
                this.getTextFieldDriver().requestFocus();
            }
        } else if (itemEvent.getSource() == this.getCheckboxPromptUID()) {
            if (this.getCheckboxPromptUID().getState()) {
                this.handlePromptYesField();
            } else {
                this.handlePromptNoField();
                this.getTextFieldLogonID().requestFocus();
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10 && this.checkOK()) {
            this.connButtonOK();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public int mnlGetConnectSpecValue(String string) {
        String string2 = null;
        ((TextComponent)this.getTextFieldProp()).setText("");
        this.getMsgLabel().setText("                                                                      ");
        if (string.equals("")) {
            string2 = "";
            ((TextComponent)this.getTextFieldLogonID()).setText("");
            ((TextComponent)this.getTextFieldPassword()).setText("");
            ((TextComponent)this.getTextFieldURL()).setText("jdbc:db2:sample");
            ((TextComponent)this.getTextFieldConnectionName()).setText(string2);
            this.getCheckboxPromptUID().setState(false);
            this.getCheckboxAuto().setState(true);
            this.handlePromptNoField();
            this.parentRef.getTabPane().setEnabledAt(1, true);
            return 0;
        }
        try {
            DatabaseConnection databaseConnection = CommonUtil.invokeConnectionMethod(this.parentRef.getQueryEditor().getQLocator(), null, (Component)((Object)this));
            if (databaseConnection == null) {
                return -1;
            }
            ((TextComponent)this.getTextFieldLogonID()).setText(databaseConnection.getConnectionSpec().getLogonSpec().getId());
            ((TextComponent)this.getTextFieldPassword()).setText(databaseConnection.getConnectionSpec().getLogonSpec().getPassword());
            ((TextComponent)this.getTextFieldURL()).setText(databaseConnection.getConnectionSpec().getDataSourceName());
            ((TextComponent)this.getTextFieldConnectionName()).setText(CommonUtil.getMethodName(databaseConnection.getConnectionSpec().getAlias()));
            boolean bl = false;
            int n = 0;
            while (n < CommonUtil.driverName.length) {
                if (databaseConnection.getConnectionSpec().getDriverName().equals(CommonUtil.driverName[n])) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                ((Component)this.getTextFieldDriver()).setBackground(Color.white);
                this.getTextFieldDriver().setEnabled(true);
                this.getChoiceDriver().select(CommonUtil.getMessage(IBMIVJDBDialog.otherDriver));
                ((TextComponent)this.getTextFieldDriver()).setText(databaseConnection.getConnectionSpec().getDriverName());
            } else {
                ((Component)this.getTextFieldDriver()).setBackground(SystemColor.control);
                this.getTextFieldDriver().setEnabled(false);
                this.getChoiceDriver().select(databaseConnection.getConnectionSpec().getDriverName());
                ((TextComponent)this.getTextFieldDriver()).setText("");
            }
            if (databaseConnection.getConnectionSpec().getPromptUID()) {
                this.getCheckboxPromptUID().setState(true);
                this.handlePromptYesField();
            } else {
                this.getCheckboxPromptUID().setState(false);
                this.handlePromptNoField();
            }
            this.getCheckboxAuto().setState(databaseConnection.getAutoCommit());
            Properties properties = databaseConnection.getConnectionSpec().getProps();
            if (properties != null) {
                String string3 = null;
                Enumeration<?> enumeration = properties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    String string4 = (String)enumeration.nextElement();
                    String string5 = (String)((Hashtable)properties).get(string4);
                    string3 = string3 == null ? String.valueOf(string4) + "=" + string5 : String.valueOf(string4) + "=" + string5 + ";" + string3;
                }
                ((TextComponent)this.getTextFieldProp()).setText(string3);
            }
            if (databaseConnection.getConnectionPoolType() == 1) {
                this.getCheckboxPool().setState(true);
            } else {
                this.getCheckboxPool().setState(false);
            }
        }
        catch (Throwable throwable) {
            CommonUtil.handleException(throwable, (Component)((Object)this));
        }
        return 0;
    }

    private String[] parseProp(String string) {
        int n;
        String[] stringArray = new String[2];
        int n2 = string.indexOf(";");
        if (n2 >= 0) {
            string = string.substring(0, n2);
        }
        if ((n = string.indexOf("=")) < 0) {
            return null;
        }
        stringArray[0] = string.substring(0, n);
        stringArray[1] = string.substring(n + 1, string.length());
        stringArray[0] = stringArray[0].trim();
        stringArray[1] = stringArray[1].trim();
        if (stringArray[0].equals("") || stringArray[1].equals("")) {
            return null;
        }
        return stringArray;
    }

    private void setDriverField() {
        String string = this.getChoiceDriver().getSelectedItem();
        if (string.equals(CommonUtil.getMessage(IBMIVJDBDialog.otherDriver))) {
            ((Component)this.getTextFieldDriver()).setBackground(Color.white);
            this.getTextFieldDriver().setEnabled(true);
            ((TextComponent)this.getTextFieldDriver()).setText("");
        } else {
            ((Component)this.getTextFieldDriver()).setBackground(SystemColor.control);
            this.getTextFieldDriver().setEnabled(false);
            ((TextComponent)this.getTextFieldDriver()).setText("");
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.getTabbedPane().getSelectedIndex() >= 1) {
            this.getButtonBack().setEnabled(true);
            this.getButtonNext().setEnabled(false);
        } else {
            this.getButtonNext().setEnabled(true);
            this.getButtonBack().setEnabled(false);
        }
    }

    public void textValueChanged(TextEvent textEvent) {
        if (textEvent.getSource() == this.getTextFieldURL() || textEvent.getSource() == this.getTextFieldDriver()) {
            if (this.checkOK() && this.validName) {
                this.getButtonOK().setEnabled(true);
            } else {
                this.getButtonOK().setEnabled(false);
            }
        } else if (textEvent.getSource() == this.getTextFieldConnectionName()) {
            this.validateName();
            if (this.checkOK() && this.validName) {
                this.getButtonOK().setEnabled(true);
            } else {
                this.getButtonOK().setEnabled(false);
            }
        }
    }

    private boolean validateName() {
        boolean bl = false;
        try {
            String string = this.getTextFieldConnectionName().getText();
            if (string.length() > 0) {
                if (Character.isJavaIdentifierStart(string.charAt(0))) {
                    if (string.length() > 1) {
                        int n = 1;
                        while (n < string.length()) {
                            if (!Character.isJavaIdentifierPart(string.charAt(n))) {
                                bl = true;
                                break;
                            }
                            ++n;
                        }
                    }
                } else {
                    bl = true;
                }
            }
            if (bl) {
                this.getMsgLabel().setText(CommonUtil.getMessage(IBMIVJDBDialog.errorConnectionName));
            } else {
                this.getMsgLabel().setText("");
                if (this.createFlag || !this.createFlag && !string.equals(this.oldSpecName)) {
                    String string2 = this.parentRef.getConnectSpecPath();
                    bl = this.parentRef.methodExisting(this.getMsgLabel(), string2, string);
                }
            }
        }
        catch (Throwable throwable) {
            CommonUtil.handleException(throwable, (Component)((Object)this));
        }
        this.validName = !bl;
        return !bl;
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (windowEvent.getSource() == this) {
            ((Window)((Object)this)).dispose();
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
        this.getTextFieldConnectionName().requestFocus();
    }
}

