/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivj.db.ibeans;

import com.ibm.sqlassist.common.SQLAssistUtils;
import java.sql.ResultSet;
import java.sql.SQLException;

public class SPColumnObject {
    private String name;
    private int column_Type = 0;
    private int data_Type = -1;
    private String type_Name;
    private int precision;
    private int length;
    private int scale;
    private int radix;
    private int nullable;
    private int genericData_Type = 1111;
    public static final int GENERIC_CHAR = 1;
    public static final int GENERIC_INTEGER = 4;
    public static final int GENERIC_DECIMAL = 2;
    public static final int GENERIC_BINARY = -2;
    public static final int GENERIC_DATE = 91;
    public static final int GENERIC_TIME = 92;
    public static final int GENERIC_TIMESTAMP = 93;
    public static final int GENERIC_OTHER = 1111;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1999.\nAll Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by\nGSA ADP Schedule Contract with IBM Corp.";

    public SPColumnObject(ResultSet resultSet) throws SQLException {
        this.name = resultSet.getString(4);
        if (this.name != null) {
            this.name = this.name.trim();
        }
        this.column_Type = resultSet.getInt(5);
        this.data_Type = resultSet.getInt(6);
        this.type_Name = resultSet.getString(7);
        this.precision = resultSet.getInt(8);
        this.length = resultSet.getInt(9);
        this.scale = resultSet.getInt(10);
        this.radix = resultSet.getInt(11);
        this.nullable = resultSet.getInt(12);
        this.determineGenericData_Type();
    }

    private void determineGenericData_Type() {
        switch (this.data_Type) {
            case -1: 
            case 1: 
            case 12: {
                this.setGenericData_Type(1);
                break;
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                this.setGenericData_Type(4);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                this.setGenericData_Type(2);
                break;
            }
            case -7: 
            case -4: 
            case -3: 
            case -2: {
                this.setGenericData_Type(-2);
                break;
            }
            case 9: 
            case 91: {
                this.setGenericData_Type(91);
                break;
            }
            case 92: {
                this.setGenericData_Type(92);
                break;
            }
            case 93: {
                this.setGenericData_Type(93);
                break;
            }
            default: {
                this.setGenericData_Type(1111);
                break;
            }
        }
    }

    public int getColumn_Type() {
        return this.column_Type;
    }

    public int getData_Type() {
        return this.data_Type;
    }

    public String getFormatType_Name() {
        String string = this.type_Name.toLowerCase();
        if (this.getData_Type() == 1 || this.getData_Type() == 12 || this.getData_Type() == -2 || this.getData_Type() == -3) {
            string = String.valueOf(string) + "(" + this.getLength() + ")";
        } else if (this.getData_Type() == 3 || this.getData_Type() == 2) {
            string = String.valueOf(string) + "(" + this.getPrecision() + "," + this.getScale() + ")";
        }
        return string;
    }

    public int getGenericData_Type() {
        return this.genericData_Type;
    }

    public int getLength() {
        return this.length;
    }

    public String getName() {
        return this.name;
    }

    public String getNameQuoted() {
        return SQLAssistUtils.quoteString(this.getName());
    }

    public String getNameTypeSize() {
        return String.valueOf(this.getName()) + ", " + this.getTypeSize();
    }

    public int getNullable() {
        return this.nullable;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getRadix() {
        return this.radix;
    }

    public int getScale() {
        return this.scale;
    }

    public String getType_Name() {
        return this.type_Name;
    }

    public String getTypeSize() {
        if (this.getType_Name() == null) {
            return "";
        }
        String string = "" + this.getType_Name();
        if (this.getLength() > 0) {
            string = String.valueOf(string) + "(" + this.getLength();
            if (this.getScale() > 0) {
                string = String.valueOf(string) + "," + this.getScale();
            }
            string = String.valueOf(string) + ")";
        }
        return string;
    }

    public void setColumn_Type(int n) {
        this.column_Type = n;
    }

    public void setData_Type(int n) {
        this.data_Type = n;
    }

    public void setGenericData_Type(int n) {
        this.genericData_Type = n;
    }

    public void setLength(int n) {
        this.length = n;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setNullable(int n) {
        this.nullable = n;
    }

    public void setPrecision(int n) {
        this.precision = n;
    }

    public void setRadix(int n) {
        this.radix = n;
    }

    public void setScale(int n) {
        this.scale = n;
    }

    public void setType_Name(String string) {
        this.type_Name = string;
    }
}

