/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivj.db.ibeans;

import com.ibm.ivj.db.ibeans.CommonUtil;
import com.ibm.ivj.db.ibeans.IBMIVJDBDialog;
import com.ibm.uvm.abt.edit.codeGeneration.CgPackageDescription;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;

public class SpecBundleCreatePanel
extends Panel
implements ActionListener,
TextListener {
    String fieldClassName = "";
    String fieldErrorStatusString = "";
    String fieldGetClassName = "";
    String fieldPackageName = "";
    private Button ivjButton1 = null;
    private TextField ivjClassTextField = null;
    private Label ivjLabel = null;
    private Label ivjLabel1 = null;
    private TextField ivjPackageTextField = null;
    protected transient PropertyChangeSupport propertyChange = new PropertyChangeSupport(this);
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1998, 1999";

    public SpecBundleCreatePanel() {
        this.initialize();
    }

    public SpecBundleCreatePanel(LayoutManager layoutManager) {
        super(layoutManager);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.getButton1()) {
            this.conn2(actionEvent);
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChange.addPropertyChangeListener(propertyChangeListener);
    }

    protected void browseButtonPressed() {
        String string = CgPackageDescription.promptForPackageName((String)this.getPackageName());
        if (string != null) {
            ((TextComponent)this.getPackageTextField()).setText(string);
        }
        this.getClassTextField().requestFocus();
    }

    private void conn0SetSource() {
        try {
            this.setPackageName(this.getPackageTextField().getText());
        }
        catch (Throwable throwable) {
            CommonUtil.handleException(throwable, this);
        }
    }

    private void conn0SetTarget() {
        try {
            ((TextComponent)this.getPackageTextField()).setText(this.getPackageName());
        }
        catch (Throwable throwable) {
            CommonUtil.handleException(throwable, this);
        }
    }

    private void conn1SetSource() {
        try {
            this.setClassName(this.getClassTextField().getText());
        }
        catch (Throwable throwable) {
            CommonUtil.handleException(throwable, this);
        }
    }

    private void conn1SetTarget() {
        try {
            ((TextComponent)this.getClassTextField()).setText(this.getClassName());
        }
        catch (Throwable throwable) {
            CommonUtil.handleException(throwable, this);
        }
    }

    private void conn2(ActionEvent actionEvent) {
        try {
            this.browseButtonPressed();
        }
        catch (Throwable throwable) {
            CommonUtil.handleException(throwable, this);
        }
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        this.propertyChange.firePropertyChange(string, object, object2);
    }

    private static void getBuilderData() {
    }

    private Button getButton1() {
        if (this.ivjButton1 == null) {
            try {
                this.ivjButton1 = new Button();
                this.ivjButton1.setLabel(CommonUtil.getMessage(IBMIVJDBDialog.browse));
            }
            catch (Throwable throwable) {
                CommonUtil.handleException(throwable, this);
            }
        }
        return this.ivjButton1;
    }

    public String getClassName() {
        if (this.fieldClassName == null) {
            this.fieldClassName = new String();
        }
        return this.fieldClassName;
    }

    private TextField getClassTextField() {
        if (this.ivjClassTextField == null) {
            try {
                this.ivjClassTextField = new TextField();
                this.ivjClassTextField.setName("ClassTextField");
                this.ivjClassTextField.setColumns(50);
                ((Component)this.ivjClassTextField).setBackground(Color.white);
                this.ivjClassTextField.setForeground(Color.black);
            }
            catch (Throwable throwable) {
                CommonUtil.handleException(throwable, this);
            }
        }
        return this.ivjClassTextField;
    }

    public String getErrorStatusString() {
        return this.fieldErrorStatusString;
    }

    private Label getLabel() {
        if (this.ivjLabel == null) {
            try {
                this.ivjLabel = new Label();
                this.ivjLabel.setText(CommonUtil.getMessage(IBMIVJDBDialog.className));
            }
            catch (Throwable throwable) {
                CommonUtil.handleException(throwable, this);
            }
        }
        return this.ivjLabel;
    }

    private Label getLabel1() {
        if (this.ivjLabel1 == null) {
            try {
                this.ivjLabel1 = new Label();
                this.ivjLabel1.setName("Label1");
                this.ivjLabel1.setText(CommonUtil.getMessage(IBMIVJDBDialog.Package));
            }
            catch (Throwable throwable) {
                CommonUtil.handleException(throwable, this);
            }
        }
        return this.ivjLabel1;
    }

    public String getPackageName() {
        return this.fieldPackageName;
    }

    private TextField getPackageTextField() {
        if (this.ivjPackageTextField == null) {
            try {
                this.ivjPackageTextField = new TextField();
                this.ivjPackageTextField.setName("PackageTextField");
                this.ivjPackageTextField.setColumns(10);
                ((Component)this.ivjPackageTextField).setBackground(Color.white);
                this.ivjPackageTextField.setForeground(Color.black);
            }
            catch (Throwable throwable) {
                CommonUtil.handleException(throwable, this);
            }
        }
        return this.ivjPackageTextField;
    }

    public String getQualifiedClassName() {
        return String.valueOf(this.getPackageName()) + "." + this.getClassName();
    }

    private void initConnections() {
        this.getPackageTextField().addTextListener(this);
        this.getClassTextField().addTextListener(this);
        this.getButton1().addActionListener(this);
        this.conn0SetTarget();
        this.conn1SetTarget();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.setBackground(SystemColor.control);
        this.setForeground(Color.black);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        ((GridBagLayout)this.getLayout()).setConstraints(this.getLabel1(), gridBagConstraints);
        this.add(this.getLabel1());
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.anchor = 10;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.insets = new Insets(0, 0, 5, 5);
        ((GridBagLayout)this.getLayout()).setConstraints(this.getPackageTextField(), gridBagConstraints2);
        this.add(this.getPackageTextField());
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.gridwidth = 1;
        gridBagConstraints3.gridheight = 1;
        gridBagConstraints3.anchor = 11;
        gridBagConstraints3.weightx = 0.0;
        gridBagConstraints3.weighty = 0.0;
        gridBagConstraints3.insets = new Insets(0, 0, 5, 0);
        ((GridBagLayout)this.getLayout()).setConstraints(this.getButton1(), gridBagConstraints3);
        this.add(this.getButton1());
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 2;
        gridBagConstraints4.gridwidth = 1;
        gridBagConstraints4.gridheight = 1;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.weightx = 0.0;
        gridBagConstraints4.weighty = 0.0;
        gridBagConstraints4.insets = new Insets(0, 0, 5, 0);
        ((GridBagLayout)this.getLayout()).setConstraints(this.getLabel(), gridBagConstraints4);
        this.add(this.getLabel());
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.gridy = 3;
        gridBagConstraints5.gridwidth = 2;
        gridBagConstraints5.gridheight = 1;
        gridBagConstraints5.fill = 2;
        gridBagConstraints5.anchor = 10;
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.weighty = 0.0;
        ((GridBagLayout)this.getLayout()).setConstraints(this.getClassTextField(), gridBagConstraints5);
        this.add(this.getClassTextField());
        this.initConnections();
    }

    private boolean isClassNameValid() {
        String string = this.getClassName();
        if (string.length() > 0 && Character.isJavaIdentifierStart(string.charAt(0))) {
            if (string.length() > 1) {
                int n = 1;
                while (n < string.length()) {
                    if (!Character.isJavaIdentifierPart(string.charAt(n))) {
                        return false;
                    }
                    ++n;
                }
            }
            return true;
        }
        return false;
    }

    public boolean isValidState() {
        return this.getErrorStatusString().equals("");
    }

    public static void main(String[] stringArray) {
        try {
            Frame frame;
            Serializable serializable;
            try {
                serializable = Class.forName("com.ibm.uvm.abt.edit.TestFrame");
                frame = (Frame)((Class)serializable).newInstance();
            }
            catch (Throwable throwable) {
                frame = new Frame();
            }
            serializable = new SpecBundleCreatePanel();
            frame.add("Center", (Component)serializable);
            ((Component)frame).setSize(((Component)serializable).getSize());
            ((Component)frame).setVisible(true);
        }
        catch (Throwable throwable) {
            CommonUtil.handleException(throwable, null);
        }
    }

    private boolean packageExists() {
        return CgPackageDescription.packageExists((String)this.getPackageName());
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChange.removePropertyChangeListener(propertyChangeListener);
    }

    public void setClassName(String string) {
        this.fieldClassName = string;
        this.updateValidity();
    }

    protected void setErrorStatusString(String string) {
        if (!string.equals(this.fieldErrorStatusString)) {
            String string2 = this.fieldErrorStatusString;
            this.fieldErrorStatusString = string;
            this.firePropertyChange("errorStatusString", string2, string);
            this.firePropertyChange("validState", null, null);
        }
    }

    public void setPackageName(String string) {
        this.fieldPackageName = string;
        this.updateValidity();
    }

    public void setQualifiedClassName(String string) {
        int n = string.lastIndexOf(46);
        if (n != -1) {
            this.setClassName(string.substring(0, n));
            this.setPackageName(string.substring(n));
        } else {
            this.setClassName(string);
            this.setPackageName("");
        }
    }

    public void textValueChanged(TextEvent textEvent) {
        if (textEvent.getSource() == this.getPackageTextField()) {
            this.conn0SetSource();
        }
        if (textEvent.getSource() == this.getClassTextField()) {
            this.conn1SetSource();
        }
    }

    private void updateValidity() {
        if (!this.packageExists()) {
            this.setErrorStatusString(CommonUtil.getMessage(IBMIVJDBDialog.errorPkgExist));
        } else if (!this.isClassNameValid()) {
            this.setErrorStatusString(CommonUtil.getMessage(IBMIVJDBDialog.errorClassName));
        } else {
            try {
                Class.forName(this.getQualifiedClassName());
                this.setErrorStatusString(CommonUtil.getMessage(IBMIVJDBDialog.errorClassExist));
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.setErrorStatusString("");
            }
        }
    }
}

