/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sqlassist;

import com.ibm.sqlassist.SQLAssistPanel;
import com.ibm.sqlassist.common.ExitEvent;
import com.ibm.sqlassist.common.ExitListener;
import com.ibm.sqlassist.common.SQLAssistUtils;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.Serializable;
import java.util.Vector;

public class SQLAssistFrame
extends Frame
implements ActionListener,
WindowListener {
    private boolean debug = false;
    private SQLAssistPanel resource;
    private Applet applet;
    private transient Vector eventList = new Vector();
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1999.\nAll Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by\nGSA ADP Schedule Contract with IBM Corp.";

    public SQLAssistFrame(SQLAssistPanel sQLAssistPanel) {
        this(sQLAssistPanel, null);
    }

    public SQLAssistFrame(SQLAssistPanel sQLAssistPanel, Applet applet) {
        this.resource = sQLAssistPanel;
        this.applet = applet;
        if (this.applet == null) {
            this.resource.getProperties().load("sqlassist.ini");
        }
        if (this.debug) {
            System.out.println("sa DEBUG MODE = TRUE");
            this.resource.getOptions().setDisplayVariableButton(true);
            this.resource.getOptions().setReferToAsVariable(false);
            this.resource.getOptions().setDisplaySchemaTextField(true);
            this.resource.getOptions().setDisplayEditWarning(true);
            this.resource.getOptions().setForceLogon(true);
            this.resource.getOptions().setDisplayWelcomeTab(false);
            this.resource.getOptions().setDisplayLogonTab(false);
            this.resource.getOptions().setDisplayFinishTab(false);
            this.resource.getOptions().setSupportEditSQL(true);
            this.resource.getOptions().setPromptSchemasAtLogon(true);
            Button button = new Button("my button");
            this.resource.getGui().setCustom1Button(button);
            button.addActionListener(this);
            this.resource.getOptions().setSchemaQualifiedNames(true);
            this.resource.getOptions().setEnableDistinctTypeSupport(true);
            this.resource.getQuery().setType(2);
            this.resource.getOptions().setVAJavaVM(true);
            this.resource.getOptions().setPageComponentBackgroundColor(Color.yellow);
            this.resource.getProperties().list(System.out);
        }
        if (this.resource.getGui().getParentApplet() == null) {
            this.resource.getGui().setParentApplet(this.applet);
        } else {
            this.applet = this.resource.getGui().getParentApplet();
        }
        ((Component)this).setSize(640, 480);
        ((Component)this).setBackground(SystemColor.control);
        this.setForeground(SystemColor.controlText);
        this.setTitle(this.resource.getOptions().getTitleText());
        this.setLayout(new BorderLayout());
        this.add("Center", this.resource);
        this.resource.build();
        if (!this.resource.getOptions().getDisplayLogonTab() && this.resource.getOptions().getForceLogon() && this.resource.getQuery().getDatabase() == null) {
            this.dispose();
        }
        if (this.resource.getGui().getCancelButton() != null) {
            this.resource.getGui().getCancelButton().addActionListener(this);
        }
        if (this.resource.getGui().getFinishButton() != null) {
            this.resource.getGui().getFinishButton().addActionListener(this);
        }
        this.addWindowListener(this);
        this.show();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.resource.getGui().getCancelButton())) {
            this.dispose();
        } else if (actionEvent.getSource().equals(this.resource.getGui().getFinishButton())) {
            if (this.applet == null) {
                this.resource.getQuery().buildSQL();
                this.resource.getProperties().getState();
                this.resource.getProperties().save("sqlassist.ini");
            }
            if (this.debug) {
                this.resource.getProperties().list(System.out);
                SQLAssistUtils.print("AvailableVariableNames", this.resource.getQuery().getAvailableVariableNames());
                SQLAssistUtils.print("AvailableVariables", this.resource.getQuery().getAvailableVariables());
                SQLAssistUtils.print("UniqueAvailableVariableNames", this.resource.getQuery().getUniqueAvailableVariableNames());
                SQLAssistUtils.print("Selected Tables", this.resource.getQuery().getSelectedDatabaseTables());
                SQLAssistUtils.print("Available Fields", this.resource.getQuery().getAvailableFields());
                SQLAssistUtils.print("Selected Fields", this.resource.getQuery().getSelectedFields());
                SQLAssistUtils.print("Available Fields Matching Data Type CHAR", this.resource.getQuery().getAvailableFieldsMatchingData_Type(1));
                SQLAssistUtils.print("Mappings", this.resource.getQuery().getDataTypeMappings());
                System.out.println("sql=" + this.resource.getQuery().getSql());
            }
            this.dispose();
        }
    }

    public synchronized void addExitListener(ExitListener exitListener) {
        this.eventList.addElement(exitListener);
    }

    public void dispose() {
        ExitListener exitListener;
        Vector vector;
        Serializable serializable = this.eventList;
        synchronized (serializable) {
            vector = (Vector)this.eventList.clone();
        }
        serializable = new ExitEvent(this);
        int n = 0;
        while (n < vector.size()) {
            exitListener = (ExitListener)vector.elementAt(n);
            exitListener.exiting((ExitEvent)serializable);
            ++n;
        }
        if (!((ExitEvent)serializable).isCancel()) {
            this.resource.getQuery().closeDatabaseConnection();
            if (this.resource.getOptions().getSystemExit()) {
                System.exit(0);
            }
            super.dispose();
            serializable = new ExitEvent(this);
            n = 0;
            while (n < vector.size()) {
                exitListener = (ExitListener)vector.elementAt(n);
                exitListener.exited((ExitEvent)serializable);
                ++n;
            }
        }
    }

    public SQLAssistPanel getResource() {
        return this.resource;
    }

    private void refreshJoins() {
        if (this.resource.getGui().getSqlAssistJoinPanel() != null) {
            this.resource.getGui().getSqlAssistJoinPanel().refresh();
        }
    }

    public synchronized void removeExitListener(ExitListener exitListener) {
        this.eventList.removeElement(exitListener);
    }

    public void setResource(SQLAssistPanel sQLAssistPanel) {
        this.resource = sQLAssistPanel;
    }

    public void windowActivated(WindowEvent windowEvent) {
        this.refreshJoins();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.dispose();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
        this.refreshJoins();
    }
}

