/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sqlassist;

import com.ibm.sqlassist.SQLAssistJoinOptionsDialog;
import com.ibm.sqlassist.SQLAssistPanel;
import com.ibm.sqlassist.common.ColumnObject;
import com.ibm.sqlassist.common.DatabaseObject;
import com.ibm.sqlassist.common.JoinContainer;
import com.ibm.sqlassist.common.JoinListPanelObject;
import com.ibm.sqlassist.common.JoinObject;
import com.ibm.sqlassist.common.PaintEvent;
import com.ibm.sqlassist.common.PaintListener;
import com.ibm.sqlassist.common.PanelObject;
import com.ibm.sqlassist.common.SQLAssistStrings;
import com.ibm.sqlassist.common.SQLAssistUtils;
import com.ibm.sqlassist.common.TableObject;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;

public class SQLAssistJoinPanel
extends Panel
implements ActionListener,
ItemListener,
PaintListener {
    private SQLAssistPanel resource;
    private Vector joins = new Vector();
    private Button aliasButton;
    private Button joinButton;
    private Button unjoinButton;
    private Button optionsButton;
    private Button prevJoinButton;
    private Button nextJoinButton;
    private Vector joinPanels = new Vector();
    private JoinContainer main;
    private ScrollPane sp = new ScrollPane(1);
    private JoinListPanelObject selectedJlpo;
    private JoinListPanelObject lastSelectedJlpo;
    private int selectedIndex = -1;
    private int lastSelectedIndex = -1;
    private int sourceX = 0;
    private int sourceY = 0;
    private int targetX = 0;
    private int targetY = 0;
    private int oldSourceX = 0;
    private int oldSourceY = 0;
    private int oldTargetX = 0;
    private int oldTargetY = 0;
    private Vector oldLines = new Vector();
    private int joinType = 0;
    private int lastJoinIndex = -1;
    private JoinObject currentJoinObject;
    private SQLAssistJoinOptionsDialog joinOptionsDialog;
    private boolean massJoinSw = false;
    private TextArea descriptionTextArea = new TextArea("", 2, 40, 1);
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1999.\nAll Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by\nGSA ADP Schedule Contract with IBM Corp.";

    public SQLAssistJoinPanel(SQLAssistPanel sQLAssistPanel) {
        this.resource = sQLAssistPanel;
        this.build();
        this.getProperties();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.aliasButton)) {
            this.processAlias();
            this.resource.getQuery().eventBuildSQL();
        } else if (actionEvent.getSource().equals(this.joinButton)) {
            this.processJoin();
            this.resource.getQuery().eventBuildSQL();
        } else if (actionEvent.getSource().equals(this.unjoinButton)) {
            this.processUnjoin(this.selectedJlpo, this.lastSelectedJlpo);
            this.resource.getQuery().eventBuildSQL();
        } else if (actionEvent.getSource().equals(this.nextJoinButton)) {
            this.selectJoin(1);
        } else if (actionEvent.getSource().equals(this.prevJoinButton)) {
            this.selectJoin(-1);
        } else if (actionEvent.getSource().equals(this.optionsButton)) {
            this.joinOptionsDialog = new SQLAssistJoinOptionsDialog(this.resource, this.getJoinObject(this.selectedJlpo, this.lastSelectedJlpo));
            ((Component)this.joinOptionsDialog).setVisible(true);
            this.refresh();
        }
    }

    private void build() {
        this.main = new JoinContainer();
        this.main.setLayout(new FlowLayout(0, 15, 15));
        PanelObject panelObject = new PanelObject(this.resource.getString(SQLAssistStrings.JoinPanel_Title), 5);
        this.aliasButton = new Button(this.resource.getString(SQLAssistStrings.Alias_Button));
        this.aliasButton.setEnabled(false);
        this.aliasButton.setVisible(false);
        this.joinButton = new Button(this.resource.getString(SQLAssistStrings.Join_Button));
        this.joinButton.setEnabled(false);
        this.unjoinButton = new Button(this.resource.getString(SQLAssistStrings.Unjoin_Button));
        this.unjoinButton.setEnabled(false);
        this.optionsButton = new Button(this.resource.getString(SQLAssistStrings.Options_Button));
        this.optionsButton.setEnabled(false);
        this.prevJoinButton = new Button("<");
        this.prevJoinButton.setEnabled(false);
        this.nextJoinButton = new Button(">");
        this.nextJoinButton.setEnabled(false);
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 2, 10, 10));
        panel.add(this.prevJoinButton);
        panel.add(this.nextJoinButton);
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout(5, 5));
        Panel panel3 = new Panel();
        panel3.setLayout(new BorderLayout(5, 5));
        panel3.add("North", this.aliasButton);
        panel3.add("Center", this.joinButton);
        panel3.add("South", panel);
        Panel panel4 = new Panel();
        panel4.setLayout(new BorderLayout(5, 5));
        panel4.add("North", panel3);
        panel4.add("Center", this.unjoinButton);
        if (!this.resource.getOptions().getSupportRightOuterJoin() && !this.resource.getOptions().getSupportLeftOuterJoin() || this.resource.getQuery().getDatabase() != null && !this.resource.getQuery().getDatabase().getSupportsOuterJoins()) {
            this.joinType = 0;
            panel4.add("South", new Label());
        } else {
            panel4.add("South", this.optionsButton);
        }
        panel2.add("North", panel4);
        Panel panel5 = new Panel();
        panel5.setLayout(new BorderLayout());
        panel5.add("North", SQLAssistUtils.spacer(5));
        panel5.add("Center", this.descriptionTextArea);
        this.descriptionTextArea.setEditable(false);
        panelObject.add("Center", this.sp);
        panelObject.add("East", panel2);
        Panel panel6 = new Panel();
        panel6.setLayout(new BorderLayout(5, 5));
        panel6.add("Center", panelObject);
        panel6.add("South", this.descriptionTextArea);
        this.setLayout(new BorderLayout(10, 10));
        this.add("Center", panel6);
        this.add("North", new Label());
        this.add("South", this.resource.getGui().buildStatusbarPanel());
        this.add("East", new Label());
        this.add("West", new Label());
        this.rebuild();
        this.main.addPaintListener(this);
        this.aliasButton.addActionListener(this);
        this.joinButton.addActionListener(this);
        this.unjoinButton.addActionListener(this);
        this.optionsButton.addActionListener(this);
        this.prevJoinButton.addActionListener(this);
        this.nextJoinButton.addActionListener(this);
    }

    public String buildDescription(JoinListPanelObject joinListPanelObject, JoinListPanelObject joinListPanelObject2, int n, boolean bl) {
        String string = "";
        if (joinListPanelObject != null && joinListPanelObject2 != null) {
            string = n == 1 ? this.resource.getString(SQLAssistStrings.OuterJoinDesc_Text, new Object[]{this.resource.getString(SQLAssistStrings.LeftOuterJoin_Text), joinListPanelObject.getName(), joinListPanelObject2.getName()}) : (n == 2 ? this.resource.getString(SQLAssistStrings.OuterJoinDesc_Text, new Object[]{this.resource.getString(SQLAssistStrings.RightOuterJoin_Text), joinListPanelObject2.getName(), joinListPanelObject.getName()}) : this.resource.getString(SQLAssistStrings.InnerJoinDesc_Text));
        }
        return string;
    }

    public String buildDescription(JoinObject joinObject, int n, boolean bl) {
        return this.buildDescription(joinObject.getJlpo1(), joinObject.getJlpo2(), n, bl);
    }

    public String buildJoinFieldName(JoinListPanelObject joinListPanelObject, boolean bl) {
        String string = "";
        if (joinListPanelObject != null) {
            string = String.valueOf(joinListPanelObject.getTable().getName(true)) + ".";
        }
        ColumnObject columnObject = null;
        if (joinListPanelObject != null && (columnObject = joinListPanelObject.getTable().getColumn(joinListPanelObject.getList().getSelectedItem())) != null) {
            string = String.valueOf(string) + columnObject.getName();
            if (bl) {
                string = String.valueOf(string) + ", " + columnObject.getTypeSize();
            }
        }
        if (string.equals("")) {
            string = this.resource.getString(SQLAssistStrings.none_Text);
        }
        return string;
    }

    private void cleanupJoins() {
        int n = this.joins.size() - 1;
        while (n >= 0) {
            JoinObject joinObject = (JoinObject)this.joins.elementAt(n);
            joinObject.setJlpo1(this.getJoinListPanelObject(joinObject.getJlpo1().getTable()));
            joinObject.setJlpo2(this.getJoinListPanelObject(joinObject.getJlpo2().getTable()));
            if (joinObject.getJlpo1() == null || joinObject.getJlpo2() == null) {
                this.drawLine(this.main, joinObject, this.main.getBackground());
                this.joins.removeElement(joinObject);
            }
            --n;
        }
    }

    private void drawLine(Panel panel, int n, int n2, int n3, int n4, Color color) {
        Graphics graphics = panel.getGraphics();
        graphics.setColor(color);
        graphics.drawLine(n, n2, n3, n4);
    }

    public void drawLine(Panel panel, JoinListPanelObject joinListPanelObject, int n, JoinListPanelObject joinListPanelObject2, int n2, Color color) {
        JoinListPanelObject joinListPanelObject3;
        JoinListPanelObject joinListPanelObject4;
        if (joinListPanelObject == null || joinListPanelObject2 == null) {
            return;
        }
        int n3 = 0;
        int n4 = 0;
        if (joinListPanelObject.getBounds().x <= joinListPanelObject2.getBounds().x) {
            joinListPanelObject4 = joinListPanelObject;
            joinListPanelObject3 = joinListPanelObject2;
            n3 = n;
            n4 = n2;
        } else {
            joinListPanelObject4 = joinListPanelObject2;
            joinListPanelObject3 = joinListPanelObject;
            n3 = n2;
            n4 = n;
        }
        Rectangle rectangle = joinListPanelObject4.getBounds();
        Rectangle rectangle2 = joinListPanelObject3.getBounds();
        this.sourceX = rectangle.x + rectangle.width;
        this.targetX = rectangle2.x;
        int n5 = joinListPanelObject4.getLabel().getBounds().height;
        int n6 = joinListPanelObject3.getLabel().getBounds().height;
        int n7 = (rectangle.height - n5) / joinListPanelObject4.getList().getItemCount();
        int n8 = (rectangle2.height - n6) / joinListPanelObject3.getList().getItemCount();
        this.sourceY = rectangle.y + n5 + n7 * n3 + n7 / 2;
        this.targetY = rectangle2.y + n6 + n8 * n4 + n8 / 2;
        this.drawLine(panel, this.sourceX, this.sourceY, this.targetX, this.targetY, color);
    }

    private void drawLine(Panel panel, JoinListPanelObject joinListPanelObject, JoinListPanelObject joinListPanelObject2, Color color) {
        if (joinListPanelObject != null && joinListPanelObject2 != null) {
            this.drawLine(panel, joinListPanelObject, joinListPanelObject.getList().getSelectedIndex(), joinListPanelObject2, joinListPanelObject2.getList().getSelectedIndex(), color);
        }
    }

    private void drawLine(Panel panel, JoinObject joinObject) {
        if (joinObject.getJlpo1() == this.selectedJlpo && joinObject.getCobj1().getName() == this.selectedJlpo.getList().getSelectedItem() && joinObject.getJlpo2() == this.lastSelectedJlpo && joinObject.getCobj2().getName() == this.lastSelectedJlpo.getList().getSelectedItem() || joinObject.getJlpo2() == this.selectedJlpo && joinObject.getCobj2().getName() == this.selectedJlpo.getList().getSelectedItem() && joinObject.getJlpo1() == this.lastSelectedJlpo && joinObject.getCobj1().getName() == this.lastSelectedJlpo.getList().getSelectedItem()) {
            this.drawLine(panel, joinObject, Color.red);
        } else {
            this.drawLine(panel, joinObject, Color.blue.darker());
        }
    }

    private void drawLine(Panel panel, JoinObject joinObject, Color color) {
        if (joinObject.getJlpo1() != null && joinObject.getJlpo2() != null) {
            this.drawLine(panel, joinObject.getJlpo1(), joinObject.getJlpo1().getListIndex(joinObject.getCobj1().getName()), joinObject.getJlpo2(), joinObject.getJlpo2().getListIndex(joinObject.getCobj2().getName()), color);
        }
    }

    private void drawTempJoin() {
        if (this.selectedJlpo == null || this.lastSelectedJlpo == null) {
            return;
        }
        this.drawLine((Panel)this.main, this.oldSourceX, this.oldSourceY, this.oldTargetX, this.oldTargetY, this.main.getBackground());
        this.drawLine(this.main, this.selectedJlpo, this.lastSelectedJlpo, this.main.getBackground().darker());
        this.oldSourceX = this.sourceX;
        this.oldSourceY = this.sourceY;
        this.oldTargetX = this.targetX;
        this.oldTargetY = this.targetY;
        this.resource.getGui().setStatus(this.resource.getString(SQLAssistStrings.ClickJoin_Msg));
    }

    private void enableButtons() {
        if (this.selectedJlpo != null && !this.selectedJlpo.getTable().getIsAlias()) {
            this.aliasButton.setEnabled(true);
        } else {
            this.aliasButton.setEnabled(false);
        }
        if (this.selectedJlpo != null && this.lastSelectedJlpo != null) {
            if (this.isValidToJoin(this.selectedJlpo, this.lastSelectedJlpo)) {
                this.joinButton.setEnabled(true);
                this.unjoinButton.setEnabled(false);
                this.optionsButton.setEnabled(false);
            } else if (this.getJoinObject(this.selectedJlpo, this.lastSelectedJlpo) != null) {
                this.joinButton.setEnabled(false);
                this.unjoinButton.setEnabled(true);
                this.optionsButton.setEnabled(true);
            } else {
                this.joinButton.setEnabled(false);
                this.unjoinButton.setEnabled(false);
                this.optionsButton.setEnabled(false);
            }
        } else {
            this.joinButton.setEnabled(false);
            this.unjoinButton.setEnabled(false);
            this.optionsButton.setEnabled(false);
        }
        if (this.joins.size() > 0) {
            this.nextJoinButton.setEnabled(true);
            this.prevJoinButton.setEnabled(true);
        } else {
            this.nextJoinButton.setEnabled(false);
            this.prevJoinButton.setEnabled(false);
        }
    }

    private JoinListPanelObject find(String string) {
        int n = 0;
        while (n < this.joinPanels.size()) {
            JoinListPanelObject joinListPanelObject = (JoinListPanelObject)this.joinPanels.elementAt(n);
            if (SQLAssistUtils.parseSchemaTableColumn(joinListPanelObject.getQualifiedName(), true).equals(string)) {
                return joinListPanelObject;
            }
            ++n;
        }
        return null;
    }

    public Button getAliasButton() {
        return this.aliasButton;
    }

    public Button getJoinButton() {
        return this.joinButton;
    }

    private JoinListPanelObject getJoinListPanelObject(TableObject tableObject) {
        if (tableObject == null) {
            return null;
        }
        int n = 0;
        while (n < this.joinPanels.size()) {
            JoinListPanelObject joinListPanelObject = (JoinListPanelObject)this.joinPanels.elementAt(n);
            if (joinListPanelObject.getTable() == tableObject) {
                return joinListPanelObject;
            }
            ++n;
        }
        return null;
    }

    private JoinObject getJoinObject(JoinListPanelObject joinListPanelObject, JoinListPanelObject joinListPanelObject2) {
        if (joinListPanelObject == null || joinListPanelObject2 == null) {
            return null;
        }
        int n = 0;
        while (n < this.joins.size()) {
            JoinObject joinObject = (JoinObject)this.joins.elementAt(n);
            if ((joinObject.getJlpo1() == joinListPanelObject && joinObject.getJlpo2() == joinListPanelObject2 || joinObject.getJlpo1() == joinListPanelObject2 && joinObject.getJlpo2() == joinListPanelObject) && (joinObject.getCobj1().getName() == joinListPanelObject.getTable().getColumn(joinListPanelObject.getList().getSelectedItem()).getName() && joinObject.getCobj2().getName() == joinListPanelObject2.getTable().getColumn(joinListPanelObject2.getList().getSelectedItem()).getName() || joinObject.getCobj1().getName() == joinListPanelObject2.getTable().getColumn(joinListPanelObject2.getList().getSelectedItem()).getName() && joinObject.getCobj2().getName() == joinListPanelObject.getTable().getColumn(joinListPanelObject.getList().getSelectedItem()).getName())) {
                return joinObject;
            }
            ++n;
        }
        return null;
    }

    public Vector getJoins() {
        return this.joins;
    }

    public Button getNextJoinButton() {
        return this.nextJoinButton;
    }

    public Button getOptionsButton() {
        return this.optionsButton;
    }

    public Button getPrevJoinButton() {
        return this.prevJoinButton;
    }

    public synchronized void getProperties() {
        int n = Integer.parseInt(this.resource.getProperties().getProperty("701", "0"));
        int n2 = 0;
        while (n2 < n) {
            String string = this.resource.getProperties().getProperty("702_{0}", "", new String[]{"" + n2});
            String string2 = this.resource.getProperties().getProperty("703_{0}", "", new String[]{"" + n2});
            if (string != null && string2 != null) {
                JoinListPanelObject joinListPanelObject = this.find(SQLAssistUtils.parseSchemaTableColumn(string, true));
                JoinListPanelObject joinListPanelObject2 = this.find(SQLAssistUtils.parseSchemaTableColumn(string2, true));
                if (joinListPanelObject != null && joinListPanelObject2 != null) {
                    SQLAssistUtils.select(joinListPanelObject.getList(), SQLAssistUtils.parseSchemaTableColumn(string, false));
                    SQLAssistUtils.select(joinListPanelObject2.getList(), SQLAssistUtils.parseSchemaTableColumn(string2, false));
                    int n3 = Integer.parseInt(this.resource.getProperties().getProperty("704_{0}", "0", new String[]{"" + n2}));
                    this.massJoinSw = true;
                    this.processJoin(joinListPanelObject, joinListPanelObject2, n3);
                }
            }
            ++n2;
        }
    }

    public Button getUnjoinButton() {
        return this.unjoinButton;
    }

    private boolean isValidToJoin(JoinListPanelObject joinListPanelObject, JoinListPanelObject joinListPanelObject2) {
        boolean bl = true;
        ColumnObject columnObject = joinListPanelObject.getTable().getColumn(joinListPanelObject.getList().getSelectedItem());
        ColumnObject columnObject2 = joinListPanelObject2.getTable().getColumn(joinListPanelObject2.getList().getSelectedItem());
        int n = 0;
        while (n < this.joins.size()) {
            JoinObject joinObject = (JoinObject)this.joins.elementAt(n);
            JoinListPanelObject joinListPanelObject3 = joinObject.getJlpo1();
            JoinListPanelObject joinListPanelObject4 = joinObject.getJlpo2();
            if ((joinListPanelObject3 == joinListPanelObject && joinListPanelObject4 == joinListPanelObject2 || joinListPanelObject3 == joinListPanelObject2 && joinListPanelObject4 == joinListPanelObject) && (columnObject == joinObject.getCobj1() || columnObject == joinObject.getCobj2() || columnObject2 == joinObject.getCobj1() || columnObject2 == joinObject.getCobj2())) {
                bl = false;
                break;
            }
            ++n;
        }
        if (!bl) {
            this.resource.getGui().setStatus(this.resource.getString(SQLAssistStrings.CannotJoinTwoFields_Msg));
            return bl;
        }
        if (columnObject.getGenericData_Type() == 1111 && columnObject2.getGenericData_Type() == 1111 && columnObject.getData_Type() != columnObject2.getData_Type()) {
            bl = false;
        }
        if (columnObject.getGenericData_Type() != columnObject2.getGenericData_Type()) {
            bl = false;
        }
        if (!bl) {
            this.resource.getGui().setStatus(this.resource.getString(SQLAssistStrings.CannotJoinDifferentFieldTypes_Msg, new Object[]{columnObject.getTypeSize(), columnObject2.getTypeSize()}));
            return bl;
        }
        return bl;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            if (this.selectedJlpo == null || (JoinListPanelObject)((List)itemEvent.getSource()).getParent() != this.selectedJlpo) {
                if (this.lastSelectedJlpo != null && (JoinListPanelObject)((List)itemEvent.getSource()).getParent() != this.lastSelectedJlpo) {
                    this.lastSelectedJlpo.getList().deselect(this.lastSelectedJlpo.getList().getSelectedIndex());
                }
                this.lastSelectedJlpo = this.selectedJlpo;
            }
            this.selectedJlpo = (JoinListPanelObject)((List)itemEvent.getSource()).getParent();
            this.refresh();
        }
    }

    public void performPaint(PaintEvent paintEvent) {
        this.redrawJoins();
    }

    private void populateDescriptionTextArea() {
        this.descriptionTextArea.setText(this.buildDescription(this.selectedJlpo, this.lastSelectedJlpo, this.joinType, true));
    }

    private void processAlias() {
        if (this.selectedJlpo == null) {
            return;
        }
        TableObject tableObject = this.selectedJlpo.getTable();
        DatabaseObject databaseObject = tableObject.getDatabaseObject();
        databaseObject.addTable(tableObject.createAlias());
        this.resource.getGui().getSqlAssistTablesPanel().populateSelectedDatabaseTablesList();
        this.rebuild();
    }

    private void processJoin() {
        this.massJoinSw = false;
        this.processJoin(this.selectedJlpo, this.lastSelectedJlpo, this.joinType);
    }

    private void processJoin(JoinListPanelObject joinListPanelObject, JoinListPanelObject joinListPanelObject2, int n) {
        if (joinListPanelObject == null || joinListPanelObject2 == null || !this.isValidToJoin(joinListPanelObject, joinListPanelObject2)) {
            return;
        }
        this.joins.addElement(new JoinObject(this.resource, joinListPanelObject, joinListPanelObject2, n));
        if (!this.massJoinSw) {
            this.resource.getGui().setStatus(this.resource.getString(SQLAssistStrings.Joined_Msg, new Object[]{joinListPanelObject.getQualifiedName(), joinListPanelObject2.getQualifiedName()}));
            this.resource.getGui().setStatusLocked(true, this);
            this.refresh();
            this.resource.getGui().setStatusLocked(false, this);
        }
    }

    private void processUnjoin(JoinListPanelObject joinListPanelObject, JoinListPanelObject joinListPanelObject2) {
        JoinObject joinObject = this.getJoinObject(joinListPanelObject, joinListPanelObject2);
        if (joinObject != null) {
            this.drawLine(this.main, joinObject, this.main.getBackground());
            this.joins.removeElement(joinObject);
        }
        String string = this.resource.getString(SQLAssistStrings.Unjoined_Msg, new Object[]{joinListPanelObject.getQualifiedName(), joinListPanelObject2.getQualifiedName()});
        this.refresh();
        this.resource.getGui().setStatus(string);
    }

    public synchronized void putProperties() {
        if (this.joins == null || this.joins.size() == 0) {
            return;
        }
        this.resource.getProperties().put("701", "" + this.joins.size());
        int n = 0;
        while (n < this.joins.size()) {
            JoinObject joinObject = (JoinObject)this.joins.elementAt(n);
            this.resource.getProperties().put("702_{0}", joinObject.getJoin1Name(), new String[]{"" + n});
            this.resource.getProperties().put("703_{0}", joinObject.getJoin2Name(), new String[]{"" + n});
            this.resource.getProperties().put("704_{0}", "" + joinObject.getType(), new String[]{"" + n});
            ++n;
        }
    }

    public void rebuild() {
        this.rebuild(false);
    }

    public void rebuild(boolean bl) {
        this.selectedJlpo = null;
        this.lastSelectedJlpo = null;
        this.joinPanels = new Vector();
        this.main.removeAll();
        List list = this.resource.getGui().getSqlAssistTablesPanel().getSelectedDatabaseTablesList();
        JoinListPanelObject joinListPanelObject = null;
        int n = 0;
        while (n < list.getItemCount()) {
            String string;
            String string2 = string = list.getItem(n);
            TableObject tableObject = this.resource.getQuery().getDatabase().getTable(string2);
            if (tableObject != null) {
                joinListPanelObject = new JoinListPanelObject(this.resource, tableObject);
                this.joinPanels.addElement(joinListPanelObject);
                this.main.add(joinListPanelObject);
                if (tableObject.getAliasIndex() > 1 && !tableObject.getIsAlias()) {
                    int n2 = 2;
                    while (n2 <= tableObject.getAliasIndex()) {
                        TableObject tableObject2 = this.resource.getQuery().getDatabase().getTable(String.valueOf(string2) + "_" + n2);
                        if (tableObject2 != null) {
                            joinListPanelObject = new JoinListPanelObject(this.resource, tableObject2);
                            this.joinPanels.addElement(joinListPanelObject);
                            this.main.add(joinListPanelObject);
                        }
                        ++n2;
                    }
                }
            }
            ++n;
        }
        this.sp.add(this.main);
        this.repaintJoinListPanelObjects();
        this.refresh(bl);
    }

    private void redrawJoins() {
        this.cleanupJoins();
        int n = 0;
        while (n < this.joins.size()) {
            this.drawLine(this.main, (JoinObject)this.joins.elementAt(n));
            ++n;
        }
    }

    public void refresh() {
        this.refresh(false);
    }

    public void refresh(boolean bl) {
        ColumnObject columnObject;
        String string;
        if (!bl && !this.resource.getGui().getNotebook().getTab().equals(this.resource.getString(SQLAssistStrings.Join_Text))) {
            return;
        }
        if (this.selectedJlpo != null) {
            string = this.selectedJlpo.getList().getSelectedItem();
            columnObject = this.selectedJlpo.getTable().getColumn(string);
            this.resource.getString(SQLAssistStrings.Field_nn_Label, new Object[]{"1", this.selectedJlpo.getQualifiedName(), columnObject.getType_Name(), "" + columnObject.getSize()});
        }
        if (this.lastSelectedJlpo != null) {
            string = this.lastSelectedJlpo.getList().getSelectedItem();
            columnObject = this.lastSelectedJlpo.getTable().getColumn(string);
            this.resource.getString(SQLAssistStrings.Field_nn_Label, new Object[]{"2", this.lastSelectedJlpo.getQualifiedName(), columnObject.getType_Name(), "" + columnObject.getSize()});
        }
        this.currentJoinObject = this.getJoinObject(this.selectedJlpo, this.lastSelectedJlpo);
        this.populateDescriptionTextArea();
        this.drawTempJoin();
        this.redrawJoins();
        this.enableButtons();
    }

    private void repaintJoinListPanelObjects() {
        this.main.validate();
        this.main.doLayout();
        int n = 0;
        while (n < this.joinPanels.size()) {
            JoinListPanelObject joinListPanelObject = (JoinListPanelObject)this.joinPanels.elementAt(n);
            joinListPanelObject.doLayout();
            ++n;
        }
        this.sp.validate();
        this.sp.doLayout();
    }

    public void resetJoinType(JoinObject joinObject) {
        this.joinType = joinObject.getType();
        TableObject tableObject = joinObject.getJlpo1().getTable();
        TableObject tableObject2 = joinObject.getJlpo2().getTable();
        boolean bl = false;
        int n = 0;
        while (n < this.joins.size()) {
            JoinObject joinObject2 = (JoinObject)this.joins.elementAt(n);
            if (joinObject2.getType() != 0 && tableObject == joinObject2.getJlpo1().getTable() && tableObject2 == joinObject2.getJlpo2().getTable() || tableObject == joinObject2.getJlpo2().getTable() && tableObject2 == joinObject2.getJlpo1().getTable()) {
                bl = true;
                joinObject2.setType(joinObject.getType());
            }
            ++n;
        }
        this.joinOptionsDialog.dispose();
        this.joinOptionsDialog = null;
        if (bl) {
            this.resource.getGui().setStatus(this.resource.getString(SQLAssistStrings.ChangedOuterJoins_Msg, new Object[]{joinObject.getJlpo1().getName(), joinObject.getJlpo2().getName(), joinObject.getTypeName()}));
        } else {
            this.resource.getGui().setStatus();
        }
        this.resource.getGui().setStatusLocked(true, this);
        this.refresh();
        this.resource.getGui().setStatusLocked(false, this);
        this.resource.getQuery().eventBuildSQL();
    }

    private void selectJoin(int n) {
        this.lastJoinIndex += n;
        if (this.lastJoinIndex < 0) {
            this.lastJoinIndex = this.joins.size() - 1;
        }
        if (this.lastJoinIndex >= this.joins.size() || this.lastJoinIndex < 0) {
            this.lastJoinIndex = 0;
        }
        if (this.selectedJlpo != null) {
            this.selectedJlpo.getList().deselect(this.selectedJlpo.getList().getSelectedIndex());
        }
        if (this.lastSelectedJlpo != null) {
            this.lastSelectedJlpo.getList().deselect(this.lastSelectedJlpo.getList().getSelectedIndex());
        }
        JoinObject joinObject = (JoinObject)this.joins.elementAt(this.lastJoinIndex);
        this.selectedJlpo = joinObject.getJlpo1();
        this.lastSelectedJlpo = joinObject.getJlpo2();
        this.joinType = joinObject.getType();
        if (this.selectedJlpo != null) {
            this.selectedJlpo.getList().select(this.selectedJlpo.getListIndex(joinObject.getCobj1().getName()));
        }
        if (this.lastSelectedJlpo != null) {
            this.lastSelectedJlpo.getList().select(this.lastSelectedJlpo.getListIndex(joinObject.getCobj2().getName()));
        }
        this.resource.getGui().setStatus(this.resource.getString(SQLAssistStrings.SelectedJoin_Msg, new Object[]{"" + (this.lastJoinIndex + 1), "" + this.joins.size()}));
        this.resource.getGui().setStatusLocked(true, this);
        this.refresh();
        this.resource.getGui().setStatusLocked(false, this);
    }

    public void setAliasButton(Button button) {
        this.aliasButton = button;
    }

    public void setJoinButton(Button button) {
        this.joinButton = button;
    }

    public void setJoins(Vector vector) {
        this.joins = vector;
    }

    public void setNextJoinButton(Button button) {
        this.nextJoinButton = button;
    }

    public void setOptionsButton(Button button) {
        this.optionsButton = button;
    }

    public void setPrevJoinButton(Button button) {
        this.prevJoinButton = button;
    }

    public void setUnjoinButton(Button button) {
        this.unjoinButton = button;
    }

    public boolean usedInJoins(TableObject tableObject) {
        if (tableObject == null) {
            return false;
        }
        return this.usedInJoins(tableObject.getName(true));
    }

    public boolean usedInJoins(String string) {
        int n = 0;
        while (n < this.resource.getGui().getSqlAssistJoinPanel().getJoins().size()) {
            JoinObject joinObject = (JoinObject)this.resource.getGui().getSqlAssistJoinPanel().getJoins().elementAt(n);
            if (!(joinObject.getType() == 0 || !joinObject.getJlpo1().getTable().getName().equals(string) && !joinObject.getJlpo2().getTable().getName().equals(string) || this.resource.getQuery().getDatabase().isOracle() && joinObject.isOuterJoin())) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

