/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sqlassist;

import com.ibm.sqlassist.SQLAssistFinishPanel;
import com.ibm.sqlassist.SQLAssistLogonPanel;
import com.ibm.sqlassist.SQLAssistWelcomePanel;
import com.ibm.sqlassist.common.DatabaseObject;
import com.ibm.sqlassist.common.SQLAssistGUIObject;
import com.ibm.sqlassist.common.SQLAssistOptionsObject;
import com.ibm.sqlassist.common.SQLAssistPropertiesObject;
import com.ibm.sqlassist.common.SQLAssistQueryObject;
import com.ibm.sqlassist.common.SQLAssistStrings;
import com.ibm.sqlassist.common.SQLAssistUtils;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.text.MessageFormat;
import java.util.Vector;

public class SQLAssistPanel
extends Panel {
    public static final String version = "19990330";
    private SQLAssistStrings strings = new SQLAssistStrings();
    private SQLAssistOptionsObject options = new SQLAssistOptionsObject();
    private SQLAssistGUIObject gui = new SQLAssistGUIObject(this);
    private SQLAssistPropertiesObject properties = new SQLAssistPropertiesObject(this);
    private SQLAssistQueryObject query = new SQLAssistQueryObject(this);
    private boolean firstTimeLogonSw = true;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1999.\nAll Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by\nGSA ADP Schedule Contract with IBM Corp.";

    public SQLAssistPanel() {
        this(null, 0, true);
    }

    public SQLAssistPanel(Frame frame) {
        this(frame, 0, true);
    }

    public SQLAssistPanel(Frame frame, int n, boolean bl) {
        this.getGui().setSqlAssistPanel(this);
        this.getGui().setParentFrame(frame);
        this.getQuery().setType(n);
        this.getOptions().setDisplayStatementType(bl);
    }

    public void build() {
        this.getOptions().setSupportBuildSQL(false);
        if (this.getGui().getParentFrame() != null) {
            if (this.getGui().getParentFrame().getTitle().equals("")) {
                this.getGui().setOrigTitle(this.getString(SQLAssistStrings.Product_Title));
            } else {
                this.getGui().setOrigTitle(this.getGui().getParentFrame().getTitle());
            }
        } else {
            this.getGui().setParentFrame(new Frame());
            this.getGui().setOrigTitle(this.getString(SQLAssistStrings.Product_Title));
        }
        this.setLayout(new BorderLayout(0, 0));
        this.add("North", SQLAssistUtils.spacer(1));
        if (this.getOptions().getDisplayWelcomeTab() && this.getGui().getSqlAssistWelcomePanel() == null) {
            if (this.getOptions().getWelcomeText() == null) {
                this.getOptions().setWelcomeText(this.getString(SQLAssistStrings.Welcome_Msg, new Object[]{this.getOptions().getTitleText()}));
            }
            this.getGui().setSqlAssistWelcomePanel(new SQLAssistWelcomePanel(this.getOptions().getWelcomeText(), this.getOptions().getWelcomeImage()));
            this.getGui().getNotebook().addPage(this.getString(SQLAssistStrings.Welcome_Text), this.getGui().getSqlAssistWelcomePanel(), null);
        }
        if (this.getGui().getSqlAssistLogonPanel() == null) {
            this.getGui().setSqlAssistLogonPanel(new SQLAssistLogonPanel(this));
            if (this.getOptions().getDisplayLogonTab()) {
                this.getGui().getNotebook().addPage(this.getString(SQLAssistStrings.Logon_Text), this.getGui().getSqlAssistLogonPanel(), null);
            }
        }
        this.getGui().buildNotebook();
        if (this.getOptions().getDisplayFinishTab() && this.getGui().getSqlAssistFinishPanel() == null) {
            if (this.getOptions().getFinishText() == null) {
                this.getOptions().setFinishText(this.getString(SQLAssistStrings.Finish_Msg));
            }
            this.getGui().setSqlAssistFinishPanel(new SQLAssistFinishPanel(this.getOptions().getFinishText(), this.getOptions().getFinishImage()));
            this.getGui().getNotebook().addPage(this.getString(SQLAssistStrings.Finish_Text), this.getGui().getSqlAssistFinishPanel(), null);
        }
        this.add("Center", this.getGui().getNotebook());
        Vector<Button> vector = new Vector<Button>();
        if (this.getGui().getCustom1Button() != null) {
            vector.addElement(this.getGui().getCustom1Button());
        }
        if (this.getGui().getCustom2Button() != null) {
            vector.addElement(this.getGui().getCustom2Button());
        }
        if (this.getGui().getCustom3Button() != null) {
            vector.addElement(this.getGui().getCustom3Button());
        }
        Panel panel = new Panel();
        if (vector.size() > 0) {
            panel.setLayout(new GridLayout(1, vector.size(), 5, 5));
            int n = 0;
            while (n < vector.size()) {
                panel.add((Button)vector.elementAt(n));
                ++n;
            }
        }
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout());
        Panel panel3 = new Panel();
        panel3.setLayout(new GridLayout(1, 3, 0, 0));
        panel2.add("East", panel3);
        if (this.getGui().getBackButton() != null) {
            panel3.add(this.getGui().getBackButton());
        } else {
            panel3.add(new Label());
        }
        if (this.getGui().getNextButton() != null) {
            panel3.add(this.getGui().getNextButton());
        } else {
            panel3.add(new Label());
        }
        Panel panel4 = new Panel();
        panel4.setLayout(new BorderLayout());
        Panel panel5 = new Panel();
        panel5.setLayout(new GridLayout(1, 2, 10, 10));
        panel4.add("East", panel5);
        if (this.getGui().getFinishButton() != null) {
            panel5.add(this.getGui().getFinishButton());
            SQLAssistUtils.enableButton(this.getGui().getFinishButton(), false);
        }
        if (this.getGui().getCancelButton() != null) {
            panel5.add(this.getGui().getCancelButton());
        }
        Panel panel6 = new Panel();
        panel6.setLayout(new BorderLayout(10, 10));
        panel6.add("East", panel2);
        Panel panel7 = new Panel();
        panel7.setLayout(new BorderLayout(10, 10));
        panel7.add("Center", panel6);
        panel7.add("East", panel4);
        Panel panel8 = new Panel();
        panel8.setLayout(new BorderLayout(10, 10));
        if (vector.size() > 0 && !this.getGui().getCustomButtonAlignWest()) {
            Panel panel9 = new Panel();
            panel9.setLayout(new FlowLayout(1, 10, 0));
            panel9.add(panel7);
            panel9.add(panel);
            panel8.add("East", panel9);
        } else {
            panel8.add("West", panel);
            panel8.add("East", panel7);
        }
        panel8.add("Center", new Label());
        this.getGui().setButtonPanel(new Panel());
        this.getGui().getButtonPanel().setLayout(new BorderLayout(3, 3));
        this.getGui().getButtonPanel().add("Center", panel8);
        this.getGui().getButtonPanel().add("West", SQLAssistUtils.spacer(1));
        this.getGui().getButtonPanel().add("East", SQLAssistUtils.spacer(1));
        this.getGui().getButtonPanel().add("North", SQLAssistUtils.spacer(6));
        this.getGui().getButtonPanel().add("South", SQLAssistUtils.spacer(5));
        this.add("South", this.getGui().getButtonPanel());
        if (this.getOptions().getForceLogon()) {
            this.getGui().getSqlAssistLogonPanel().processConnect();
            if (this.getQuery().getDatabase() == null && !this.getOptions().getDisplayLogonTab()) {
                return;
            }
        }
        this.getGui().setFirstTime(false);
        this.getOptions().setSupportBuildSQL(true);
        this.getQuery().buildSQL();
        this.getGui().refreshButtons(true);
    }

    public SQLAssistGUIObject getGui() {
        return this.gui;
    }

    public SQLAssistOptionsObject getOptions() {
        return this.options;
    }

    public Dimension getPreferredSize() {
        return new Dimension(630, 470);
    }

    public SQLAssistPropertiesObject getProperties() {
        return this.properties;
    }

    public SQLAssistQueryObject getQuery() {
        return this.query;
    }

    public String getString(String string) {
        return SQLAssistStrings.getText(string);
    }

    public String getString(String string, Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] == null) {
                objectArray[n] = "";
            }
            ++n;
        }
        return MessageFormat.format(SQLAssistStrings.getText(string), objectArray);
    }

    public SQLAssistStrings getStrings() {
        return this.strings;
    }

    public synchronized void processLogon(DatabaseObject databaseObject) {
        this.getQuery().setDatabase(databaseObject);
        if (!databaseObject.getHasRemarks() && this.getOptions().getDisplayTableRemarks()) {
            this.getOptions().setDisplayTableRemarks(false);
        }
        if (!databaseObject.getSupportsMixedCaseQuotedIdentifiers()) {
            this.getOptions().setSupportQuoteMixedCaseNames(false);
        }
        this.getGui().buildNotebook();
        this.getGui().getNotebook().turnToPage(this.getString(SQLAssistStrings.Tables_Text), 1);
        this.getGui().refreshButtons();
    }

    public void reset() {
        this.getGui().reset();
        this.getQuery().reset();
    }

    public void setGui(SQLAssistGUIObject sQLAssistGUIObject) {
        this.gui = sQLAssistGUIObject;
    }

    public void setOptions(SQLAssistOptionsObject sQLAssistOptionsObject) {
        this.options = sQLAssistOptionsObject;
    }

    public void setProperties(SQLAssistPropertiesObject sQLAssistPropertiesObject) {
        this.properties = sQLAssistPropertiesObject;
    }

    public void setQuery(SQLAssistQueryObject sQLAssistQueryObject) {
        this.query = sQLAssistQueryObject;
    }

    public void setStrings(SQLAssistStrings sQLAssistStrings) {
        this.strings = sQLAssistStrings;
    }
}

