/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sqlassist;

import com.ibm.sqlassist.SQLAssistPanel;
import com.ibm.sqlassist.common.MCLB;
import com.ibm.sqlassist.common.SQLAssistStrings;
import com.ibm.sqlassist.common.SQLAssistUtils;
import com.ibm.webrunner.util.SelectionSorter;
import com.ibm.webrunner.widget.ListboxColumn;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class SQLAssistResultSetDialog
extends Dialog
implements ActionListener,
WindowListener {
    private SQLAssistPanel resource;
    private MCLB multiColumnListbox;
    private TextArea textarea;
    private Button okButton;
    private Button saveResultsButton;
    private Button copyToClipboardButton;
    private int[] colLen = new int[]{-1};
    private ResultSet resultSet;
    private int type;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1999.\nAll Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by\nGSA ADP Schedule Contract with IBM Corp.";

    public SQLAssistResultSetDialog(SQLAssistPanel sQLAssistPanel, int n, ResultSet resultSet, ActionListener actionListener) {
        super(sQLAssistPanel.getGui().getParentFrame(), sQLAssistPanel.getString(SQLAssistStrings.ResultSetDialog_Title), true);
        this.resource = sQLAssistPanel;
        this.resultSet = resultSet;
        this.type = n;
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout(10, 10));
        if (this.type == 0 || this.type == 1) {
            this.textarea = null;
            this.multiColumnListbox = new MCLB(this.resource, true);
            panel.add("Center", this.multiColumnListbox);
        } else {
            this.multiColumnListbox = null;
            this.textarea = new TextArea("", 5, 10, 1);
            panel.add("Center", this.textarea);
        }
        String string = this.resource.getOptions().getReferToAsOK() ? this.resource.getString(SQLAssistStrings.OK_Button) : this.resource.getString(SQLAssistStrings.Close_Button);
        this.okButton = new Button(string);
        this.saveResultsButton = new Button(this.resource.getString(SQLAssistStrings.SaveResults_Button));
        this.copyToClipboardButton = new Button(this.resource.getString(SQLAssistStrings.CopyToClipboard_Button));
        this.okButton.setEnabled(false);
        this.saveResultsButton.setEnabled(false);
        this.copyToClipboardButton.setEnabled(false);
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(1, 3, 10, 10));
        if (!this.resource.getOptions().getSupportResultsCopyToClipboard()) {
            panel2.add(new Label());
        } else {
            panel2.add(this.copyToClipboardButton);
        }
        if (!this.resource.getOptions().getSupportSaveResults() || this.resource.getGui().getParentApplet() != null || this.type != 0 && this.type != 1) {
            panel2.add(new Label());
        } else {
            panel2.add(this.saveResultsButton);
        }
        panel2.add(this.okButton);
        Panel panel3 = new Panel();
        panel3.setLayout(new BorderLayout());
        panel3.add("East", panel2);
        panel.add("South", panel3);
        this.setLayout(new BorderLayout(10, 10));
        this.add("North", SQLAssistUtils.spacer(1));
        this.add("South", SQLAssistUtils.spacer(1));
        this.add("East", SQLAssistUtils.spacer(1));
        this.add("West", SQLAssistUtils.spacer(1));
        this.add("Center", panel);
        if (this.resource.getOptions().getDialogBackgroundColor() != null) {
            ((Component)this).setBackground(this.resource.getOptions().getDialogBackgroundColor());
            panel.setBackground(this.resource.getOptions().getDialogBackgroundColor());
        }
        this.okButton.addActionListener(this);
        this.copyToClipboardButton.addActionListener(this);
        this.addWindowListener(this);
        if (actionListener == null) {
            this.saveResultsButton.addActionListener(this);
        } else {
            this.saveResultsButton.addActionListener(actionListener);
        }
        this.pack();
        Dimension dimension = this.getSize();
        if (dimension.height < 350 || dimension.width < 525) {
            if (dimension.height < 350) {
                dimension.height = 350;
            }
            if (dimension.width < 525) {
                dimension.width = 525;
            }
            ((Component)this).setSize(dimension);
        }
        this.resource.getGui().setStatus(this.resource.getString(SQLAssistStrings.QuerySuccessful_Text));
        this.processResultSet();
        this.resource.getGui().setStatus();
        this.show();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            this.dispose();
        } else if (actionEvent.getSource() == this.saveResultsButton) {
            this.processSaveResultsButton();
        } else if (actionEvent.getSource() == this.copyToClipboardButton) {
            this.processCopyToClipboardButton();
        }
    }

    private String buildResults() {
        Object[][] objectArray;
        if (this.multiColumnListbox == null) {
            return null;
        }
        if (this.multiColumnListbox.getSelectedRows().length == 0) {
            this.multiColumnListbox.selectAllRows();
        }
        if ((objectArray = this.multiColumnListbox.getSelectedRows()) == null || objectArray.length == 0) {
            return null;
        }
        this.colLen[0] = ("" + this.multiColumnListbox.getRowCount()).length();
        String string = "";
        int n = 0;
        while (n < this.multiColumnListbox.getColumnCount()) {
            string = String.valueOf(string) + this.buildString((String)this.multiColumnListbox.getColumnInfo(n).getLabel(), this.colLen[n]) + " ";
            ++n;
        }
        string = String.valueOf(string) + "\n";
        n = 0;
        while (n < objectArray.length) {
            Object[] objectArray2 = objectArray[n];
            int n2 = 0;
            while (n2 < objectArray2.length) {
                String string2 = (String)objectArray2[n2];
                string = String.valueOf(string) + this.buildString(string2, this.colLen[n2]) + " ";
                ++n2;
            }
            string = String.valueOf(string) + "\n";
            ++n;
        }
        return string;
    }

    private String buildString(String string, int n) {
        if (string == null) {
            string = "";
        }
        if (n > 512) {
            n = 512;
        }
        if (string.length() < n) {
            n -= string.length();
            int n2 = 0;
            while (n2 < n) {
                string = String.valueOf(string) + " ";
                ++n2;
            }
        }
        return string;
    }

    public Button getCopyToClipboardButton() {
        return this.copyToClipboardButton;
    }

    public Button getOkButton() {
        return this.okButton;
    }

    public Button getSaveResultsButton() {
        return this.saveResultsButton;
    }

    private void processCopyToClipboardButton() {
        this.resource.getGui().copyToClipboard(this.buildResults());
    }

    private synchronized void processResultSet() {
        if (this.textarea != null) {
            try {
                int n = this.resource.getQuery().getDatabase().getStatement().getUpdateCount();
                if (n < 0) {
                    n = 0;
                }
                String string = this.type == 2 ? SQLAssistStrings.nnRowsInserted_Msg : (this.type == 3 ? SQLAssistStrings.nnRowsUpdated_Msg : SQLAssistStrings.nnRowsDeleted_Msg);
                this.textarea.setText(this.resource.getString(string, new Object[]{"" + n}));
            }
            catch (Exception exception) {
                this.resource.getGui().handleException(exception);
            }
            this.okButton.setEnabled(true);
            return;
        }
        try {
            ResultSetMetaData resultSetMetaData = this.resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount() + 1;
            String[] stringArray = new String[n];
            this.colLen = new int[n];
            int n2 = 0;
            while (n2 < n) {
                if (n2 == 0) {
                    stringArray[n2] = " ";
                    this.colLen[n2] = -1;
                } else {
                    try {
                        stringArray[n2] = resultSetMetaData.getColumnLabel(n2);
                    }
                    catch (SQLException sQLException) {
                        stringArray[n2] = resultSetMetaData.getColumnName(n2);
                    }
                    this.colLen[n2] = resultSetMetaData.getColumnDisplaySize(n2);
                    if (this.colLen[n2] < stringArray[n2].length()) {
                        this.colLen[n2] = stringArray[n2].length();
                    }
                }
                this.multiColumnListbox.addColumn(stringArray[n2]);
                ++n2;
            }
            int n3 = 0;
            while (n3 < stringArray.length) {
                ListboxColumn listboxColumn = this.multiColumnListbox.getColumnInfo(n3);
                if (n3 == 0) {
                    listboxColumn.setWidth(25);
                } else {
                    listboxColumn.setWidth(75);
                    listboxColumn.setSorter(new SelectionSorter());
                }
                ++n3;
            }
            n3 = 0;
            while (this.resultSet.next()) {
                Object[] objectArray = new Object[n];
                objectArray[0] = "" + ++n3;
                int n4 = 1;
                while (n4 < n) {
                    objectArray[n4] = this.resultSet.getString(n4);
                    ++n4;
                }
                this.multiColumnListbox.addRow(objectArray);
            }
            this.resultSet.close();
            int n5 = 0;
            while (n5 < n) {
                ++n5;
            }
        }
        catch (Exception exception) {
            this.resource.getGui().handleException(exception);
        }
        this.okButton.setEnabled(true);
        if (this.multiColumnListbox.getRowCount() > 0) {
            this.saveResultsButton.setEnabled(true);
            this.copyToClipboardButton.setEnabled(true);
        }
    }

    private void processSaveResultsButton() {
        String string = this.buildResults();
        if (string == null) {
            return;
        }
        try {
            SQLAssistUtils.saveToFile(this.resource.getGui().getParentFrame(), this.resource.getString(SQLAssistStrings.SaveResults_Title), string, "*.txt");
        }
        catch (Exception exception) {
            this.resource.getGui().handleException(exception);
        }
    }

    public void setCopyToClipboardButton(Button button) {
        this.copyToClipboardButton = button;
    }

    public void setOkButton(Button button) {
        this.okButton = button;
    }

    public void setSaveResultsButton(Button button) {
        this.saveResultsButton = button;
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.dispose();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

