/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sqlassist.common;

import com.ibm.sqlassist.SQLAssistPanel;
import com.ibm.sqlassist.common.ColumnObject;
import com.ibm.sqlassist.common.SQLAssistStrings;
import java.awt.Font;
import java.awt.TextField;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyVetoException;

public class ColumnTextField
extends TextField
implements KeyListener {
    private ColumnObject columnObject;
    private boolean isLocked = false;
    private boolean isVariable = false;
    private SQLAssistPanel resource;
    private Font defaultFont;
    private String oldValue = "";
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1999.\nAll Rights Reserved.\nUS Government Users Restrictfd Rights -\nUse, duplication or disclosure restrictfd by\nGSA ADP Schedule Contract with IBM Corp.";

    public ColumnTextField(SQLAssistPanel sQLAssistPanel) {
        this(sQLAssistPanel, null, null);
    }

    public ColumnTextField(SQLAssistPanel sQLAssistPanel, ColumnObject columnObject, String string) {
        this(sQLAssistPanel, columnObject, false);
        if (string != null) {
            this.setText(string);
        } else {
            this.setText("");
        }
    }

    public ColumnTextField(SQLAssistPanel sQLAssistPanel, ColumnObject columnObject, boolean bl) {
        this.resource = sQLAssistPanel;
        this.columnObject = columnObject;
        if (bl && this.columnObject != null && this.columnObject.getDefaultValue() != null) {
            this.setText(this.columnObject.getDefaultValue());
        }
        this.addKeyListener(this);
    }

    private void displayInvalidKeyMessage() {
        String string = this.columnObject != null ? this.columnObject.getType_Name() : "?";
        this.resource.getGui().setStatus(this.resource.getString(SQLAssistStrings.InvalidKeyInField_Msg, new Object[]{string}));
    }

    private void displayInvalidSizeMessage() {
        if (this.columnObject != null) {
            this.resource.getGui().setStatus(this.resource.getString(SQLAssistStrings.InvalidLengthForField_Msg, new Object[]{this.columnObject.getName(), "" + this.columnObject.getSize()}));
        }
    }

    public ColumnObject getColumnObject() {
        return this.columnObject;
    }

    public boolean getIsLocked() {
        return this.isLocked;
    }

    public boolean getIsVariable() {
        return this.isVariable;
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.oldValue = this.getText();
        this.resource.getGui().setStatus();
        if (this.getText().length() == 0 && !this.isLocked) {
            this.isVariable = false;
        }
        if (keyEvent.isActionKey() || keyEvent.getKeyCode() == 127 || keyEvent.getKeyCode() == 12 || keyEvent.getKeyCode() == 8 || keyEvent.getKeyCode() == 16 || keyEvent.getKeyCode() == 9 || keyEvent.getKeyCode() == 37 || keyEvent.getKeyCode() == 39) {
            return;
        }
        String string = String.valueOf(keyEvent.getKeyChar());
        if (!(this.getText().length() != 0 || this.resource.getOptions().getDisplayVariableButton() || this.isVariable || this.isLocked)) {
            this.isVariable = this.resource.getQuery().isVariableStart(string);
        }
        this.setVariableFont();
        if (this.isVariable) {
            return;
        }
        int n = 1111;
        if (this.columnObject != null) {
            n = this.columnObject.getGenericData_Type();
        }
        if (n == 4 && "0123456789+-".indexOf(string) == -1 || n == 2 && "0123456789+-.".indexOf(string) == -1 || n == 93 && "0123456789-/.: ".indexOf(string) == -1 || n == -2 && "01234567890ABCDEFabcdef".indexOf(string) == -1) {
            keyEvent.consume();
            this.displayInvalidKeyMessage();
            return;
        }
        if (n == 2 || n == 93) {
            return;
        }
        if (this.columnObject != null && this.getText().length() >= this.columnObject.getSize() && this.columnObject.getSize() > 0) {
            keyEvent.consume();
            this.displayInvalidSizeMessage();
            return;
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this.isVariable && this.resource.getOptions().getUpperVariables() && !this.resource.getOptions().getDisplayVariableButton() && !this.getText().equals(this.getText().toUpperCase())) {
            this.setText(this.getText().toUpperCase());
            this.setSelectionStart(this.getText().length());
            this.setSelectionEnd(this.getText().length());
        }
        if (this.resource.getOptions().getSupportVetoVariableOnly() && !this.isVariable) {
            return;
        }
        try {
            this.resource.getOptions().getVetoableChangeSupport().fireVetoableChange("value", this.oldValue, this.getText());
        }
        catch (PropertyVetoException propertyVetoException) {
            this.setText(this.oldValue);
            this.setSelectionStart(this.getText().length());
            this.setSelectionEnd(this.getText().length());
            if (propertyVetoException.getMessage() != null && !propertyVetoException.getMessage().equals("")) {
                this.resource.getGui().setStatus(propertyVetoException.getMessage());
            }
            return;
        }
        catch (Exception exception) {}
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void setColumnObject(ColumnObject columnObject) {
        this.columnObject = columnObject;
    }

    public void setFont(Font font) {
        if (font == null) {
            return;
        }
        super.setFont(font);
    }

    public void setIsLocked(boolean bl) {
        this.isLocked = bl;
    }

    public void setIsVariable(boolean bl) {
        this.isVariable = bl;
        if (this.isVariable && this.resource.getOptions().getUpperVariables() && !this.resource.getOptions().getDisplayVariableButton()) {
            this.setText(this.getText().toUpperCase());
        }
        this.setVariableFont();
    }

    public void setText(String string) {
        super.setText(string);
        this.setVariableFont();
    }

    public void setVariableFont() {
        if (this.isVariable) {
            this.setFont(this.resource.getOptions().getDefaultVariableFont());
        } else {
            this.setFont(this.resource.getOptions().getDefaultValueFont());
        }
    }
}

