/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sqlassist.common;

import com.ibm.sqlassist.common.ColumnObject;
import com.ibm.sqlassist.common.SQLAssistUtils;
import com.ibm.sqlassist.common.SchemaObject;
import com.ibm.sqlassist.common.TableObject;
import com.ibm.sqlassist.common.TypeInfoObject;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class DatabaseObject {
    private String name;
    private String login;
    private String password;
    private String jdbcDriver;
    private String jdbcServer;
    private Vector tables = new Vector();
    private Connection connection;
    private Statement statement;
    private ResultSet resultSet;
    private boolean supportsOuterJoins = true;
    private boolean supportsFullOuterJoins = true;
    private boolean supportsOrderByUnrelated = true;
    private boolean supportsNonNullableColumns = true;
    private boolean supportsMixedCaseQuotedIdentifiers = true;
    private boolean supportsSchemas = false;
    private boolean hasRemarks = false;
    private String[] table_Type;
    private Vector allTable_Type = new Vector();
    private TypeInfoObject typeInfo = new TypeInfoObject();
    private Vector schemas = new Vector();
    private boolean promptSchemasAtLogon = false;
    private String databaseProductName;
    private String extraNameCharacters = "";
    public static final String NONQUOTABLECHARACTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_";
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1999.\nAll Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by\nGSA ADP Schedule Contract with IBM Corp.";

    public DatabaseObject(String string) {
        this.setName(string);
    }

    public DatabaseObject(String string, String string2, String string3, String string4) {
        this.login = string;
        this.password = string2;
        this.jdbcDriver = string3;
        this.jdbcServer = string4;
        string4 = string4.replace(':', ' ');
        string4 = string4.replace('/', ' ');
        string4 = string4.trim();
        this.name = string4.lastIndexOf(" ") >= 0 ? string4.substring(string4.lastIndexOf(" ")).toUpperCase().trim() : null;
    }

    public void addTable(TableObject tableObject) {
        if (this.exists(tableObject)) {
            return;
        }
        String string = tableObject.getName();
        int n = 0;
        while (n < this.tables.size()) {
            TableObject tableObject2 = (TableObject)this.tables.elementAt(n);
            if (string.compareTo(tableObject2.getName()) < 0) {
                this.tables.insertElementAt(tableObject, n);
                SQLAssistUtils.selectSchemaObject(this.getSchemas(), tableObject.getSchema(), true);
                return;
            }
            if (string.compareTo(tableObject2.getName()) == 0) {
                return;
            }
            ++n;
        }
        this.tables.addElement(tableObject);
        SQLAssistUtils.selectSchemaObject(this.getSchemas(), tableObject.getSchema(), true);
    }

    public void close() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception exception) {}
        }
    }

    public void closeStatement() throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.close();
            this.resultSet = null;
        }
        if (this.statement != null) {
            this.statement.close();
            this.statement = null;
        }
    }

    public ResultSet execute(String string, int n, int n2) throws SQLException {
        this.resultSet = null;
        this.statement = this.connection.createStatement();
        try {
            this.statement.setQueryTimeout(n);
        }
        catch (Exception exception) {}
        try {
            this.statement.setMaxRows(n2);
        }
        catch (Exception exception) {}
        this.statement.execute(string);
        this.resultSet = this.statement.getResultSet();
        return this.resultSet;
    }

    private boolean exists(TableObject tableObject) {
        String string = tableObject.getName();
        int n = 0;
        while (n < this.tables.size()) {
            if (((TableObject)this.tables.elementAt(n)).getName().equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public Vector getAllTable_Type() {
        return this.allTable_Type;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String getDatabaseProductName() {
        return this.databaseProductName;
    }

    public String getExtraNameCharacters() {
        return this.extraNameCharacters;
    }

    public boolean getHasRemarks() {
        return this.hasRemarks;
    }

    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public String getJdbcServer() {
        return this.jdbcServer;
    }

    public String getLogin() {
        return this.login;
    }

    public String getName() {
        return this.name;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean getPromptSchemasAtLogon() {
        return this.promptSchemasAtLogon;
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public Vector getSchemas() {
        return this.schemas;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public boolean getSupportsFullOuterJoins() {
        return this.supportsFullOuterJoins;
    }

    public boolean getSupportsMixedCaseQuotedIdentifiers() {
        return this.supportsMixedCaseQuotedIdentifiers;
    }

    public boolean getSupportsNonNullableColumns() {
        return this.supportsNonNullableColumns;
    }

    public boolean getSupportsOrderByUnrelated() {
        return this.supportsOrderByUnrelated;
    }

    public boolean getSupportsOuterJoins() {
        return this.supportsOuterJoins;
    }

    public boolean getSupportsSchemas() {
        return this.supportsSchemas;
    }

    public TableObject getTable(String string) {
        int n = 0;
        while (n < this.getTables().size()) {
            TableObject tableObject = (TableObject)this.getTables().elementAt(n);
            if (tableObject.getName(false).equals(string) || tableObject.getName(true).equals(string)) {
                return tableObject;
            }
            ++n;
        }
        return null;
    }

    public String[] getTable_Type() {
        return this.table_Type;
    }

    public Vector getTables() {
        return this.tables;
    }

    public TypeInfoObject getTypeInfo() {
        return this.typeInfo;
    }

    public boolean isAS400() {
        return this.isDatabaseName("AS400");
    }

    private boolean isDatabaseName(String string) {
        string = string.toUpperCase();
        String string2 = (String.valueOf(this.getJdbcDriver()) + " " + this.getDatabaseProductName()).toUpperCase();
        return string2.indexOf(string) >= 0;
    }

    public boolean isDB2() {
        return this.isDatabaseName("DB2");
    }

    public boolean isOracle() {
        return this.isDatabaseName("ORACLE");
    }

    public boolean isSybase() {
        return this.isDatabaseName("SYBASE");
    }

    public boolean isValidToPromptForSchemasAtLogon() {
        return this.getTables().size() == 0 && this.getSchemas().size() > 0 && this.getPromptSchemasAtLogon();
    }

    public static String nonQuote(String string) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    private void processResultSet(ResultSet resultSet, String string) throws Exception {
        while (resultSet.next()) {
            this.addTable(new TableObject(this, resultSet, string));
        }
        resultSet.close();
    }

    public String quote(String string) {
        if (string == null) {
            return null;
        }
        if (!this.getSupportsMixedCaseQuotedIdentifiers() || string.startsWith("\"") && string.endsWith("\"")) {
            return string;
        }
        boolean bl = false;
        String string2 = NONQUOTABLECHARACTERS + this.getExtraNameCharacters();
        int n = 0;
        while (n < string.length()) {
            if (string2.indexOf("" + string.charAt(n)) == -1) {
                bl = true;
                break;
            }
            ++n;
        }
        if (bl) {
            string = "\"" + string + "\"";
        }
        return string;
    }

    public void removeAlias(TableObject tableObject) {
        int n = this.getTables().size() - 1;
        while (n >= 0) {
            TableObject tableObject2 = (TableObject)this.getTables().elementAt(n);
            if (tableObject2.getAliasIndex() > 1 && tableObject.getName(false).equals(tableObject2.getName(false))) {
                if (tableObject2.getIsAlias()) {
                    this.getTables().removeElement(tableObject2);
                } else {
                    tableObject2.reset();
                }
            }
            --n;
        }
    }

    public void retrieveAllSchemas() {
        this.setSchemas(new Vector());
        try {
            DatabaseMetaData databaseMetaData = this.connection.getMetaData();
            ResultSet resultSet = databaseMetaData.getSchemas();
            while (resultSet.next()) {
                SchemaObject schemaObject = new SchemaObject(resultSet);
                this.getSchemas().addElement(schemaObject);
            }
            resultSet.close();
        }
        catch (Exception exception) {}
    }

    public String retrieveSchemas(String string, String string2) throws UnsatisfiedLinkError, Exception {
        String string3 = "";
        if (string != null) {
            String string4;
            if (!string.endsWith(";")) {
                string = String.valueOf(string) + ";";
            }
            if (!(string4 = SQLAssistUtils.replaceText(string, ";", " ")).endsWith(" ")) {
                string4 = String.valueOf(string4) + " ";
            }
            String string5 = null;
            boolean bl = false;
            while (!bl) {
                string5 = SQLAssistUtils.parseString(string4, true, " ");
                if (string5 != null) {
                    try {
                        this.retrieveTables(string5, string2);
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        throw unsatisfiedLinkError;
                    }
                    catch (Exception exception) {
                        throw exception;
                    }
                    string3 = String.valueOf(string3) + string5 + ";";
                    string4 = SQLAssistUtils.parseString(string4, false, " ");
                    if (string4 != null) continue;
                    bl = true;
                    continue;
                }
                bl = true;
            }
        }
        if (!string3.endsWith(";")) {
            string3 = String.valueOf(string3) + ";";
        }
        return string3;
    }

    public void retrieveTables(String string, String string2) throws UnsatisfiedLinkError, Exception {
        Object object;
        String string3;
        boolean bl = false;
        if (string == null) {
            string3 = this.login.toUpperCase();
            bl = true;
        } else if (string.equals("")) {
            string3 = null;
        } else {
            string3 = string;
            if (!string3.startsWith("\"")) {
                int n = 0;
                while (n < this.schemas.size()) {
                    object = (SchemaObject)this.schemas.elementAt(n);
                    if (string3.equalsIgnoreCase(((SchemaObject)object).getName())) {
                        string3 = ((SchemaObject)object).getName();
                        break;
                    }
                    ++n;
                }
            }
        }
        if (this.connection == null) {
            try {
                Class<?> clazz = Class.forName(this.jdbcDriver);
                DriverManager.registerDriver((Driver)clazz.newInstance());
                this.connection = DriverManager.getConnection(this.jdbcServer, this.login, this.password);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw unsatisfiedLinkError;
            }
            catch (Exception exception) {
                throw exception;
            }
            this.retrieveAllSchemas();
        }
        DatabaseMetaData databaseMetaData = this.connection.getMetaData();
        try {
            this.supportsOuterJoins = databaseMetaData.supportsOuterJoins();
            this.supportsFullOuterJoins = databaseMetaData.supportsFullOuterJoins();
            this.supportsOrderByUnrelated = databaseMetaData.supportsOrderByUnrelated();
            this.supportsNonNullableColumns = databaseMetaData.supportsNonNullableColumns();
            this.supportsSchemas = databaseMetaData.supportsSchemasInTableDefinitions();
            this.supportsMixedCaseQuotedIdentifiers = databaseMetaData.supportsMixedCaseQuotedIdentifiers();
            this.setTypeInfo(new TypeInfoObject());
            this.getTypeInfo().process(databaseMetaData.getTypeInfo());
            this.setDatabaseProductName(String.valueOf(databaseMetaData.getDatabaseProductName()) + " " + databaseMetaData.getDatabaseProductVersion());
            this.setExtraNameCharacters(databaseMetaData.getExtraNameCharacters());
        }
        catch (Exception exception) {}
        try {
            this.allTable_Type = new Vector();
            object = databaseMetaData.getTableTypes();
            while (object.next()) {
                String string4 = object.getString(1);
                this.allTable_Type.addElement(string4);
            }
            object.close();
        }
        catch (Exception exception) {}
        try {
            this.processResultSet(databaseMetaData.getTables(null, string3, string2, this.table_Type), string);
        }
        catch (Exception exception) {
            if (this.tables.size() == 0 && string3 != null) {
                bl = true;
            }
            throw exception;
        }
        if (this.isValidToPromptForSchemasAtLogon()) {
            return;
        }
        if (this.tables.size() == 0 && bl && string3 != null) {
            this.processResultSet(databaseMetaData.getTables(null, null, string2, this.table_Type), null);
        }
    }

    public void setAllTable_Type(Vector vector) {
        this.allTable_Type = vector;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void setDatabaseProductName(String string) {
        this.databaseProductName = string;
    }

    public void setExtraNameCharacters(String string) {
        this.extraNameCharacters = string;
    }

    public void setHasRemarks(boolean bl) {
        this.hasRemarks = bl;
    }

    public void setJdbcDriver(String string) {
        this.jdbcDriver = string;
    }

    public void setJdbcServer(String string) {
        this.jdbcServer = string;
    }

    public void setLogin(String string) {
        this.login = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setPromptSchemasAtLogon(boolean bl) {
        this.promptSchemasAtLogon = bl;
    }

    public void setResultSet(ResultSet resultSet) {
        this.resultSet = resultSet;
    }

    public void setSchemas(Vector vector) {
        this.schemas = vector;
    }

    public void setStatement(Statement statement) {
        this.statement = statement;
    }

    public void setSupportsFullOuterJoins(boolean bl) {
        this.supportsFullOuterJoins = bl;
    }

    public void setSupportsMixedCaseQuotedIdentifiers(boolean bl) {
        this.supportsMixedCaseQuotedIdentifiers = bl;
    }

    public void setSupportsNonNullableColumns(boolean bl) {
        this.supportsNonNullableColumns = bl;
    }

    public void setSupportsOrderByUnrelated(boolean bl) {
        this.supportsOrderByUnrelated = bl;
    }

    public void setSupportsOuterJoins(boolean bl) {
        this.supportsOuterJoins = bl;
    }

    public void setSupportsSchemas(boolean bl) {
        this.supportsSchemas = bl;
    }

    public void setTable_Type(String[] stringArray) {
        this.table_Type = stringArray;
    }

    public void setTables(Vector vector) {
        this.tables = vector;
    }

    public void setTypeInfo(TypeInfoObject typeInfoObject) {
        this.typeInfo = typeInfoObject;
    }

    public String toString(ColumnObject columnObject) {
        if (columnObject == null) {
            return "";
        }
        String string = String.valueOf(columnObject.getName()) + ", " + columnObject.getTypeSize();
        return string;
    }

    public boolean validateColumnExists(String string) {
        String string2 = SQLAssistUtils.parseSchemaTableColumn(string, true);
        String string3 = SQLAssistUtils.parseSchemaTableColumn(string, false);
        if (string2 == null || string2.equals("") || string3 == null || string3.equals("")) {
            return false;
        }
        TableObject tableObject = this.getTable(string2);
        if (tableObject == null) {
            return false;
        }
        ColumnObject columnObject = tableObject.getColumn(string3);
        return columnObject != null;
    }
}

