/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sqlassist.common;

import com.ibm.sqlassist.SQLAssistPanel;
import com.ibm.sqlassist.common.ColumnObject;
import com.ibm.sqlassist.common.JoinListPanelObject;
import com.ibm.sqlassist.common.SQLAssistStrings;

public class JoinObject {
    private SQLAssistPanel resource;
    public static final int INNER_JOIN = 0;
    public static final int LEFT_OUTER_JOIN = 1;
    public static final int RIGHT_OUTER_JOIN = 2;
    public static final int FULL_OUTER_JOIN = 3;
    private JoinListPanelObject jlpo1;
    private JoinListPanelObject jlpo2;
    private ColumnObject cobj1;
    private ColumnObject cobj2;
    private int type = 0;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1999.\nAll Rights Reserved.\nUS Government Users Restrictfd Rights -\nUse, duplication or disclosure restrictfd by\nGSA ADP Schedule Contract with IBM Corp.";

    public JoinObject(SQLAssistPanel sQLAssistPanel, JoinListPanelObject joinListPanelObject, JoinListPanelObject joinListPanelObject2) {
        this.resource = sQLAssistPanel;
        this.jlpo1 = joinListPanelObject;
        this.jlpo2 = joinListPanelObject2;
        this.cobj1 = this.jlpo1.getTable().getColumn(this.jlpo1.getList().getSelectedItem());
        this.cobj2 = this.jlpo2.getTable().getColumn(this.jlpo2.getList().getSelectedItem());
    }

    public JoinObject(SQLAssistPanel sQLAssistPanel, JoinListPanelObject joinListPanelObject, JoinListPanelObject joinListPanelObject2, int n) {
        this(sQLAssistPanel, joinListPanelObject, joinListPanelObject2);
        this.type = n;
    }

    public ColumnObject getCobj1() {
        return this.cobj1;
    }

    public ColumnObject getCobj2() {
        return this.cobj2;
    }

    public JoinListPanelObject getJlpo1() {
        return this.jlpo1;
    }

    public JoinListPanelObject getJlpo2() {
        return this.jlpo2;
    }

    public String getJoin1Name() {
        if (this.jlpo1 == null || this.cobj1 == null || this.jlpo1.getTable() == null) {
            return null;
        }
        return String.valueOf(this.jlpo1.getTable().getName()) + "." + this.cobj1.getName();
    }

    public String getJoin2Name() {
        if (this.jlpo2 == null || this.cobj2 == null || this.jlpo2.getTable() == null) {
            return null;
        }
        return String.valueOf(this.jlpo2.getTable().getName()) + "." + this.cobj2.getName();
    }

    public int getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.getTypeName(this.type);
    }

    public String getTypeName(int n) {
        if (n == 1) {
            return this.resource.getString(SQLAssistStrings.LeftOuterJoin_Text);
        }
        if (n == 2) {
            return this.resource.getString(SQLAssistStrings.RightOuterJoin_Text);
        }
        if (n == 3) {
            return this.resource.getString(SQLAssistStrings.FullOuterJoin_Text);
        }
        return this.resource.getString(SQLAssistStrings.InnerJoin_Text);
    }

    public boolean isOuterJoin() {
        return this.getType() != 0;
    }

    public void setCobj1(ColumnObject columnObject) {
        this.cobj1 = columnObject;
    }

    public void setCobj2(ColumnObject columnObject) {
        this.cobj2 = columnObject;
    }

    public void setJlpo1(JoinListPanelObject joinListPanelObject) {
        this.jlpo1 = joinListPanelObject;
    }

    public void setJlpo2(JoinListPanelObject joinListPanelObject) {
        this.jlpo2 = joinListPanelObject;
    }

    public void setType(int n) {
        this.type = n;
    }
}

