/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sqlassist.common;

import com.ibm.extend.awt.Notebook;
import com.ibm.sqlassist.common.SchemaObject;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Choice;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.List;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.StringTokenizer;
import java.util.Vector;

public class SQLAssistUtils {
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1999.\nAll Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by\nGSA ADP Schedule Contract with IBM Corp.";

    public static String arrayToString(String[] stringArray) {
        String string = "";
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                string = String.valueOf(string) + ";" + stringArray[n] + ";";
                ++n;
            }
        }
        return string;
    }

    public static boolean contains(int[] nArray, int n) {
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean contains(String[] stringArray, String string) {
        if (string == null || string.equals("")) {
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean contains(Choice choice, String string) {
        if (string == null || string.equals("")) {
            return false;
        }
        int n = 0;
        while (n < choice.getItemCount()) {
            if (choice.getItem(n).equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean contains(List list, String string) {
        if (string == null || string.equals("")) {
            return false;
        }
        String[] stringArray = list.getItems();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static void enableButton(Button button, boolean bl) {
        if (button == null) {
            return;
        }
        button.setEnabled(bl);
    }

    public static String getWords(String string, String string2, int n) {
        int n2 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            ++n2;
            String string3 = stringTokenizer.nextToken();
            if (string3.indexOf(string2) > -1) break;
        }
        int n3 = n2;
        int n4 = n2;
        if (n < 0) {
            n3 += n;
        } else if (n > 0) {
            n4 += n;
        }
        return SQLAssistUtils.getWordsLoop(string, n3, n4);
    }

    private static String getWordsLoop(String string, int n, int n2) {
        if (n < 1) {
            n = 1;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        int n3 = 0;
        String string2 = "";
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (++n3 < n || n3 > n2) continue;
            string2 = String.valueOf(string2) + string3 + " ";
        }
        return string2;
    }

    public static String parseSchemaTableColumn(String string, boolean bl) {
        String string2;
        String string3;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            if (vector.size() > 0) {
                string2 = (String)vector.elementAt(vector.size() - 1);
                if (string2.startsWith("\"") && !string2.endsWith("\"")) {
                    vector.setElementAt(String.valueOf(string2) + "." + string3, vector.size() - 1);
                    continue;
                }
                vector.addElement(string3);
                continue;
            }
            vector.addElement(string3);
        }
        string3 = "";
        string2 = "";
        int n = 0;
        while (n < vector.size() - 1) {
            if (!string3.equals("")) {
                string3 = String.valueOf(string3) + ".";
            }
            string3 = String.valueOf(string3) + (String)vector.elementAt(n);
            ++n;
        }
        if (vector.size() > 0) {
            string2 = (String)vector.elementAt(vector.size() - 1);
        }
        if (bl) {
            return string3;
        }
        return string2;
    }

    public static String parseString(String string, boolean bl) {
        return SQLAssistUtils.parseString(string, bl, ".");
    }

    public static String parseString(String string, boolean bl, String string2) {
        if (string.indexOf(string2) < 0) {
            return null;
        }
        if (bl) {
            return string.substring(0, string.indexOf(string2));
        }
        return string.substring(string.indexOf(string2) + string2.length());
    }

    public static void print(String[][] stringArray) {
        SQLAssistUtils.print("", stringArray);
    }

    public static void print(String[] stringArray) {
        SQLAssistUtils.print("", stringArray);
    }

    public static void print(String string, String[][] stringArray) {
        System.out.println(string);
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                int n2 = 0;
                while (n2 < stringArray[n].length) {
                    System.out.println("--> " + n + "." + n2 + " = " + stringArray[n][n2]);
                    ++n2;
                }
                ++n;
            }
        } else {
            System.out.println("--> array is null");
        }
    }

    public static void print(String string, String[] stringArray) {
        System.out.println(string);
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                System.out.println("--> " + n + " = " + stringArray[n]);
                ++n;
            }
        } else {
            System.out.println("--> array is null");
        }
    }

    public static String quoteString(String string) {
        if (string == null) {
            return string;
        }
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreElements()) {
            String string3 = stringTokenizer.nextToken();
            if (!string3.equals(string3.toUpperCase()) && string3.indexOf("\"") < 0) {
                string3 = "\"" + string3 + "\"";
            }
            string2 = String.valueOf(string2) + string3;
            if (!stringTokenizer.hasMoreElements()) continue;
            string2 = String.valueOf(string2) + ".";
        }
        return string2;
    }

    public static String replaceFirstText(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        if (n >= 0) {
            string = String.valueOf(string.substring(0, n)) + string3 + string.substring(n + string2.length());
        }
        return string;
    }

    public static String replaceFirstTextVariable(String string, String string2, String string3) {
        boolean bl = false;
        int n = -1;
        int n2 = -1;
        while (!bl) {
            String string4 = "";
            String string5 = "";
            try {
                int n3;
                n = string.indexOf(string2, n2);
                int n4 = n - 1;
                n2 = n3 = n + string2.length();
                if (n > -1) {
                    if (n4 > -1) {
                        string4 = string.substring(n4, n4 + 1);
                    }
                    if (n3 > -1 && n3 + 1 <= string.length()) {
                        string5 = string.substring(n3, n3 + 1);
                    }
                }
                if ((string4.equals(" ") || string4.equals("'") || string4.equals("%") || string4.equals("\n") || string4.equals(",") || string4.equals("|")) && (string5.equals(" ") || string5.equals("'") || string5.equals("%") || string5.equals("\n") || string5.equals(",") || string4.equals("|") || string5.equals(""))) {
                    bl = true;
                }
            }
            catch (Exception exception) {}
            if (n != -1) continue;
            bl = true;
        }
        if (n > -1) {
            string = String.valueOf(string.substring(0, n)) + string3 + string.substring(n + string2.length());
        }
        return string;
    }

    public static String replaceText(String string, String string2, String string3) {
        int n = 0;
        while (n >= 0) {
            n = string.indexOf(string2);
            if (n < 0) continue;
            string = String.valueOf(string.substring(0, n)) + string3 + string.substring(n + string2.length());
        }
        return string;
    }

    public static void saveToFile(Frame frame, String string, String string2, String string3) throws Exception {
        FileDialog fileDialog = new FileDialog(frame, string, 1);
        fileDialog.setFile(string3);
        fileDialog.setDirectory(".");
        fileDialog.show();
        String string4 = fileDialog.getFile();
        String string5 = fileDialog.getDirectory();
        if (string4 == null) {
            return;
        }
        if (string4.endsWith(".*.*")) {
            string4 = string4.substring(0, string4.length() - 4);
        }
        if (string5 != null) {
            string4 = String.valueOf(string5) + string4;
        }
        SQLAssistUtils.saveToFile(string4, string2);
    }

    public static void saveToFile(String string, String string2) throws Exception {
        File file = new File(string);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
        dataOutputStream.writeBytes(string2);
        dataOutputStream.close();
        fileOutputStream.close();
    }

    public static void select(List list, String string) {
        if (string != null && !string.equals("")) {
            String[] stringArray = list.getItems();
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equals(string)) {
                    list.select(n);
                    return;
                }
                ++n;
            }
        }
        if (list.getItemCount() > 0) {
            list.select(0);
        }
    }

    public static void selectSchemaObject(Vector vector, String string, boolean bl) {
        if (string == null || vector == null) {
            return;
        }
        int n = 0;
        while (n < vector.size()) {
            SchemaObject schemaObject = (SchemaObject)vector.elementAt(n);
            if (schemaObject != null && schemaObject.getName() != null && schemaObject.getName().equals(string)) {
                schemaObject.setSelected(bl);
                return;
            }
            ++n;
        }
    }

    public static void showButton(Button button, boolean bl) {
        if (button == null) {
            return;
        }
        button.setVisible(bl);
    }

    public static Canvas spacer(int n) {
        Canvas canvas = new Canvas();
        canvas.setSize(n, n);
        return canvas;
    }

    public static void turnToPage(Notebook notebook, int n) {
        int n2 = notebook.getCurrentTab() + n;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= notebook.getTabList().length) {
            n2 = notebook.getTabList().length - 1;
        }
        notebook.turnToPage(notebook.getTabList()[n2], 1);
    }
}

