/*
 * Decompiled with CFR 0.152.
 */
package sunw.demo.buttons;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Vector;

public class OurButton
extends Component
implements Serializable,
MouseListener,
MouseMotionListener {
    private boolean debug;
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);
    private Vector pushListeners = new Vector();
    private String label;
    private boolean down;
    private boolean sized;
    static final int TEXT_XPAD = 12;
    static final int TEXT_YPAD = 8;

    public OurButton() {
        this("press");
    }

    public OurButton(String string) {
        this.label = string;
        this.setFont(new Font("Dialog", 0, 12));
        this.setBackground(Color.lightGray);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public synchronized void paint(Graphics graphics) {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        graphics.setColor(this.getBackground());
        graphics.fill3DRect(0, 0, n - 1, n2 - 1, !this.down);
        graphics.setColor(this.getForeground());
        graphics.setFont(this.getFont());
        graphics.drawRect(2, 2, n - 4, n2 - 4);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.drawString(this.label, (n - fontMetrics.stringWidth(this.label)) / 2, (n2 + fontMetrics.getMaxAscent() - fontMetrics.getMaxDescent()) / 2);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        this.down = true;
        this.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.down) {
            this.fireAction();
            this.down = false;
            this.repaint();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = this.getSize().width;
        int n4 = this.getSize().height;
        if (n < 0 || n > n3 || n2 < 0 || n2 > n4) {
            if (this.down) {
                this.down = false;
                this.repaint();
                return;
            }
        } else if (!this.down) {
            this.down = true;
            this.repaint();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.pushListeners.addElement(actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.pushListeners.removeElement(actionListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public void fireAction() {
        Vector vector;
        if (this.debug) {
            System.err.println("Button " + this.getLabel() + " pressed.");
        }
        Serializable serializable = this;
        synchronized (serializable) {
            vector = (Vector)this.pushListeners.clone();
        }
        serializable = new ActionEvent(this, 0, null);
        int n = 0;
        while (n < vector.size()) {
            ActionListener actionListener = (ActionListener)vector.elementAt(n);
            actionListener.actionPerformed((ActionEvent)serializable);
            ++n;
        }
    }

    public void setDebug(boolean bl) {
        boolean bl2 = this.debug;
        this.debug = bl;
        this.changes.firePropertyChange("debug", new Boolean(bl2), new Boolean(bl));
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setLargeFont(boolean bl) {
        if (this.isLargeFont() == bl) {
            return;
        }
        int n = 12;
        if (bl) {
            n = 18;
        }
        Font font = this.getFont();
        this.setFont(new Font(font.getName(), font.getStyle(), n));
        this.changes.firePropertyChange("largeFont", new Boolean(!bl), new Boolean(bl));
    }

    public boolean isLargeFont() {
        return this.getFont().getSize() >= 18;
    }

    public void setFontSize(int n) {
        Font font = this.getFont();
        this.setFont(new Font(font.getName(), font.getStyle(), n));
        this.changes.firePropertyChange("fontSize", new Integer(font.getSize()), new Integer(n));
    }

    public int getFontSize() {
        return this.getFont().getSize();
    }

    public void setFont(Font font) {
        Font font2 = this.getFont();
        super.setFont(font);
        this.sizeToFit();
        this.changes.firePropertyChange("font", font2, font);
    }

    public void setLabel(String string) {
        String string2 = this.label;
        this.label = string;
        this.sizeToFit();
        this.changes.firePropertyChange("label", string2, string);
    }

    public String getLabel() {
        return this.label;
    }

    public Dimension getPreferredSize() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        return new Dimension(fontMetrics.stringWidth(this.label) + 12, fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + 8);
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    private void sizeToFit() {
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getPreferredSize();
        if (dimension2.width > dimension.width || dimension2.height > dimension.height) {
            int n;
            int n2 = dimension.width;
            if (dimension2.width > n2) {
                n2 = dimension2.width;
            }
            if (dimension2.height > (n = dimension.height)) {
                n = dimension2.height;
            }
            this.setSize(n2, n);
            Container container = this.getParent();
            if (container != null) {
                ((Component)container).invalidate();
                ((Component)container).validate();
            }
        }
    }

    public void setForeground(Color color) {
        Color color2 = this.getForeground();
        super.setForeground(color);
        this.changes.firePropertyChange("foreground", color2, color);
        this.repaint();
    }

    public void setBackground(Color color) {
        Color color2 = this.getBackground();
        super.setBackground(color);
        this.changes.firePropertyChange("background", color2, color);
        this.repaint();
    }
}

