/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jos.lap;

import com.ibm.jos.lap.LAPConstants;
import com.ibm.jos.lap.LicenseAcceptanceProcess;
import com.ibm.jos.lap.LocaleManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;

public class License {
    private String laPath;
    private URL laURLBase;
    private Hashtable LAs = new Hashtable(3, 1.0f);
    private static final String copyright_notice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. YEAR     All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public License(String laPath) {
        this.laPath = laPath;
    }

    public License(URL laURLBase) {
        this.laURLBase = laURLBase;
    }

    public static void copyLicense(String laFileName, String liFileName, String licenseFileName, String licenseEncoding) throws FileNotFoundException, IOException {
        char[] buffer = new char[2048];
        BufferedReader br = null;
        BufferedWriter bw = null;
        int len = 0;
        br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(laFileName), "Unicode"));
        bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(licenseFileName), licenseEncoding));
        while ((len = br.read(buffer)) != -1) {
            bw.write(buffer, 0, len);
        }
        br.close();
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(liFileName), "Unicode"));
            while ((len = br.read(buffer)) != -1) {
                bw.write(buffer, 0, len);
            }
        }
        catch (Exception exception) {}
        br.close();
        bw.close();
    }

    public String[] getLicense(Locale locale) throws MalformedURLException, FileNotFoundException, IOException {
        try {
            return this.getLicenseAgreement(locale);
        }
        catch (FileNotFoundException e) {
            if (locale.equals(LAPConstants.DEFAULT_LOCALE)) {
                throw e;
            }
            return this.getLicense(LAPConstants.DEFAULT_LOCALE);
        }
        catch (IOException e) {
            if (locale.equals(LAPConstants.DEFAULT_LOCALE)) {
                throw e;
            }
            return this.getLicense(LAPConstants.DEFAULT_LOCALE);
        }
    }

    String[] getLicenseAgreement(Locale locale) throws FileNotFoundException, MalformedURLException, IOException {
        if (this.LAs.containsKey(locale)) {
            return (String[])this.LAs.get(locale);
        }
        return this.retrieveLicenseAgreement(locale);
    }

    private static String getShortName(String name, String extension) {
        String shortName = name;
        if (!extension.equals("")) {
            shortName = String.valueOf(name) + "_" + extension;
        }
        if (shortName.length() > 8) {
            shortName = shortName.substring(0, 8);
        }
        return shortName;
    }

    public boolean isLicenseAvailable(Locale locale) {
        boolean isAvailable = false;
        String fileName = null;
        File licenseFile = null;
        String locCode = locale.toString();
        try {
            if (this.laURLBase != null) {
                URL u = new URL(this.laURLBase, "LA_" + locCode);
                u.openStream();
                isAvailable = true;
            } else {
                fileName = String.valueOf(this.laPath) + File.separator + "LA" + "_" + locCode;
                licenseFile = new File(fileName);
                if (licenseFile.exists()) {
                    isAvailable = true;
                }
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return isAvailable;
    }

    public boolean licenseExists(Locale[] languageLocales) {
        boolean exist = true;
        int i = 0;
        while (i < languageLocales.length) {
            if (!this.isLicenseAvailable(languageLocales[i])) {
                System.out.println("Error: License agreement file missing. Aborted.");
                exist = false;
                break;
            }
            ++i;
        }
        return exist;
    }

    private String[] retrieveLicenseAgreement(Locale locale) throws FileNotFoundException, MalformedURLException, IOException {
        String fileName;
        String locCode = locale.toString();
        InputStream is = null;
        if (this.laURLBase != null) {
            URL u = new URL(this.laURLBase, "LA_" + locCode);
            is = u.openStream();
        } else {
            fileName = String.valueOf(this.laPath) + File.separator + "LA" + "_" + locCode;
            is = new FileInputStream(new File(fileName));
        }
        InputStream isLI = null;
        try {
            if (this.laURLBase != null) {
                URL u = new URL(this.laURLBase, "LI_" + locCode);
                isLI = u.openStream();
            } else {
                fileName = String.valueOf(this.laPath) + File.separator + "LI" + "_" + locCode;
                isLI = new FileInputStream(new File(fileName));
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            System.out.println("Warning: MalformedURL detected. ");
        }
        catch (FileNotFoundException fileNotFoundException) {}
        Vector<String> buffer = new Vector<String>(100);
        BufferedReader br = new BufferedReader(new InputStreamReader(is, "Unicode"));
        while (br.ready()) {
            buffer.addElement(br.readLine());
        }
        br.close();
        if (isLI != null) {
            br = new BufferedReader(new InputStreamReader(isLI, "Unicode"));
            while (br.ready()) {
                buffer.addElement(br.readLine());
            }
            br.close();
        }
        buffer.trimToSize();
        Object[] textLines = new String[buffer.size()];
        buffer.copyInto(textLines);
        this.LAs.put(locale, textLines);
        return textLines;
    }

    public static void writeLicense(String sourcePath, String targetPath, String encodingBundleName) {
        Locale encodingLoc = new Locale("", "");
        String key = null;
        String value = null;
        String inLA = null;
        String inLI = null;
        String outLA = null;
        Locale langLocale = null;
        String laFileName = null;
        ResourceBundle bundle = null;
        encodingLoc = LicenseAcceptanceProcess.getOSLocale();
        try {
            bundle = ResourceBundle.getBundle(encodingBundleName, encodingLoc);
        }
        catch (MissingResourceException e) {
            e.printStackTrace();
            System.out.println("Error: Missing encoding bundle. Aborted.");
            System.exit(0);
        }
        Enumeration<String> entry = bundle.getKeys();
        while (entry.hasMoreElements()) {
            key = entry.nextElement();
            value = bundle.getString(key);
            langLocale = LocaleManager.getLocale(key);
            laFileName = langLocale.getDisplayLanguage(Locale.ENGLISH);
            inLA = String.valueOf(sourcePath) + File.separator + "LA" + "_" + key;
            inLI = String.valueOf(sourcePath) + File.separator + "LI" + "_" + key;
            outLA = langLocale.getCountry().equals("") ? String.valueOf(targetPath) + File.separator + laFileName + ".txt" : String.valueOf(targetPath) + File.separator + laFileName + "_" + langLocale.getCountry() + ".txt";
            try {
                License.copyLicense(inLA, inLI, outLA, value);
            }
            catch (Exception exception) {
                outLA = String.valueOf(targetPath) + File.separator + License.getShortName(laFileName, langLocale.getCountry()) + ".txt";
                try {
                    License.copyLicense(inLA, inLI, outLA, value);
                }
                catch (IOException iOException) {
                    System.out.println("Warning: One of the license agreement file is not properly created.");
                }
            }
        }
    }
}

