/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jos.lap;

import com.ibm.jos.lap.TextBreaker;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.util.Locale;

public class TextPrinter
implements Runnable {
    private double tMargin = 0.5;
    private double lMargin = 0.5;
    private double bMargin = 0.5;
    private double rMargin = 0.5;
    private double hMargin = 0.5;
    private double spacing = 1.0;
    private String[] paragraphs;
    private Thread printThread;
    private Font font;
    private static final String copyright_notice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. YEAR     All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public TextPrinter(String[] paragraphs) {
        this.paragraphs = paragraphs;
    }

    public TextPrinter(String paragraph) {
        this.paragraphs = new String[1];
        this.paragraphs[0] = paragraph;
    }

    public void print() {
        if (this.printThread == null || !this.printThread.isAlive()) {
            this.printThread = new Thread(this);
            try {
                this.printThread.start();
            }
            catch (IllegalThreadStateException e) {
                e.printStackTrace();
            }
        }
    }

    public void run() {
        int yStart;
        Frame f = new Frame();
        f.addNotify();
        if (this.font == null) {
            this.font = f.getFont();
        }
        Locale locale = f.getLocale();
        PrintJob pj = f.getToolkit().getPrintJob(f, "Software License Agreement", null);
        if (pj == null) {
            return;
        }
        Graphics g = pj.getGraphics();
        if (g == null) {
            return;
        }
        g.setFont(this.font);
        FontMetrics fm = g.getFontMetrics(this.font);
        int fh = fm.getHeight();
        f.getToolkit().getScreenResolution();
        Dimension d = pj.getPageDimension();
        double dpi = (double)d.width / 8.5;
        int effWidth = d.width - (int)((this.lMargin + this.rMargin + this.hMargin) * dpi);
        int effHeight = d.height - (int)((this.tMargin + this.bMargin + this.hMargin) * dpi);
        int linesPerPage = (int)((double)effHeight / ((double)fh * this.spacing));
        String[] textLines = new TextBreaker(fm, locale, effWidth).getTextLines(this.paragraphs);
        int lines = textLines.length;
        int xStart = (int)(this.lMargin * dpi);
        int y = yStart = (int)(this.tMargin * dpi);
        int i = 0;
        while (i < lines) {
            g.drawString(textLines[i], xStart, y += fh);
            if ((i + 1) % linesPerPage == 0 || i == lines - 1) {
                g.dispose();
                g = pj.getGraphics();
                if (g == null) {
                    return;
                }
                g.setFont(this.font);
                y = yStart;
            }
            y += (int)((double)fh * (this.spacing - 1.0));
            ++i;
        }
        g.dispose();
        pj.end();
    }

    public void setFont(Font aFont) {
        this.font = aFont;
    }

    public void setHiddenMargin(double ahMargin) {
        this.hMargin = ahMargin;
    }

    public void setMargin(double top, double left, double bottom, double right) {
        this.tMargin = top;
        this.lMargin = left;
        this.bMargin = bottom;
        this.rMargin = right;
    }

    public void setSpacing(double aSpacing) {
        this.spacing = aSpacing;
    }
}

