implementation module cmdargs

import StdEnv
import osargs

CmdArgs :: [String]
CmdArgs = cmdargs n
		  where
		  n = OSGetArgCount 1
		  
		  cmdargs 0
		  		= []
		  cmdargs m
		  		= let!
		  			arg  = OSGetArg (n - m)
		  			args = cmdargs (m - 1)
		  		  in [arg : args]
		  		  
