(********************************************************************************************
** PROGRAM     : ListDir
** VERSION     : 1.0.0
** DESCRIPTION : Displays a list of the directories in the current directory.
** AUTHOR      : Stuart King
** COPYRIGHT   : Copyright (c) Irie Tools, 2002. All Rights Reserved.
** NOTES       :
**    This sample program is distributed with Irie Pascal, and was written to provide
** an example of how to manipulates files and directories. I find this program useful
** under UNIX-like operating systems because I don't know of a convenient way to do
** this. To make best use of this sample you should have a basic understanding of Pascal.
**********************************************************************************************)
program listdir(output);
var
   d : dir;
   filename : string;

   function IsDir(name : string) : boolean;
   var
      mode : integer;
   begin
      getfilemode(name, mode);
      IsDir := (mode and dir_bit) <> 0;
   end;

begin
   opendir(d, '.');  { Open current directory }
   repeat
      readdir(d, filename);  { Get next file in directory }
      { if the next file exists and it is a directory then list it }
      if (filename <> '') and (IsDir(filename)) then
          writeln(filename);
   until filename = '';
   closedir(d) { Close directory }
end.
