/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end; else do
        call VROptions 'ImplicitNames'
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary:
    __vrlsWait = abbrev( 'WAIT', translate(arg(2)), 1 )
    if __vrlsWait then do
        call VRFlush
    end
    __vrlsHWnd = VRLoad( VRWindow(), VRWindowPath(), arg(1) )
    if __vrlsHWnd = '' then signal __vrlsDone
    if __vrlsWait \= 1 then signal __vrlsDone
    call VRSet __vrlsHWnd, 'WindowMode', 'Modal' 
    __vrlsTmp = __vrlsWindows.0
    if( DataType(__vrlsTmp) \= 'NUM' ) then do
        __vrlsTmp = 1
    end
    else do
        __vrlsTmp = __vrlsTmp + 1
    end
    __vrlsWindows.__vrlsTmp = VRWindow( __vrlsHWnd )
    __vrlsWindows.0 = __vrlsTmp
    do while( VRIsValidObject( VRWindow() ) = 1 )
        __vrlsEvent = VREvent()
        interpret __vrlsEvent
    end
    __vrlsTmp = __vrlsWindows.0
    __vrlsWindows.0 = __vrlsTmp - 1
    call VRWindow __vrlsWindows.__vrlsTmp 
    __vrlsHWnd = ''
__vrlsDone:
return __vrlsHWnd

/*:VRX         __VXREXX____APPENDS__
*/
__VXREXX____APPENDS__:
/*
#append ddetools.vrs
*/
return
/*:VRX         CloseFile
*/
CloseFile: procedure expose Globals.
    call status "Closing File"

    WPCtrl = VRGet( "DDEC_WPCtrl", "Self" )
    WPData = VRGet( "DDEC_WPData", "Self" )

    if \WPRunning() then do
        error = "Word Processor is not running"
        signal CloseFile_error
    end

    if VRGet( WPData, "Status" ) <> "ACTIVE" then do
        error = "No file connection."
        signal CloseFile_error
    end

/*  Closing the file terminates the connection so don't wait for an
    ack after the DDE execute, instead wait for the conversation to
    terminate.
*/

    call DDEExecB WPData, 'Close("' || Globals.!WPOpenFile || '")', "N"
    call DDEWaitT WPData, 5

    success = VRMethod( WPData, "Terminate", "Wait", 5 )
    if \success then do
        error = "Could not Terminate data topic"
        signal CloseFile_error
    end

return 1

  Closefile_error:
    call status error
return 0
/*:VRX         CloseWP
*/
CloseWP:procedure expose Globals.

    call Status "Closing WordProcessor"

    if \WPRunning() then do
        error = "No WPRunning"
        signal CloseWP_ok
    end
/*
    - There is no direct way to shutdown describe via DDE, so we activate the 
    Describe window and use {Alt}{F4} instead.
*/
    ok = 0

    WPCtrl = "DDEC_WPCtrl"
    call VRMethod WPCtrl, "Terminate", "Wait", 5

    HWnd = FindWPWin()

    call VRMethod HWnd, "Restore"
    call VRMethod HWnd, "Activate"
    call SendKeys "DeScribe", "{Alt}{F4}", 10

    ok = 1

  CloseWP_ok:
return 1

  CloseWP_Error:
    call status error
return 0
/*:VRX         Describe_Close
*/
Describe_Close:
    call Quit
return

/*:VRX         FindWPWin
*/
FindWPWin: 
return VRMethod( "Screen", "FindWindow", Globals.!WPCaption, "Desktop", "Exact","Abbreviation" )
/*:VRX         Fini
*/
Fini:
    Globals.!WPThreadStarted = 0
    call VRMethod "Application", "PostQueue", 0, 0, 'call VRSet "PB_Open_WP", "Enabled", 1'
    call VRMethod "Application", "PutVar", "Globals.!WPThreadStarted"
    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window
return 1
/*:VRX         Globals.
*/
Globals.: 
    /* Dummy Section for documenting Global Variables */
    
/* File Global */
    /* Globals.!WPCaption = Caption of WordProcessor Window*/
                         /* Modified in: InitDescribe  */
    /* Globals.!WPName = Name of WordProcessor */
                         /* Modified in: InitDescribe  */
    /* Globals.!WPOpenFile = The currently open file */
                         /* Modified in: OpenFile */
    /* Globals.!WPSampleDocument = ProgramDir() || "\Sample.DSC" */
                         /* Modified in: InitDescribe */
    /* Globals.!WPDDEName = What is the DDE Server's name */
                         /* Modified in InitWinWord */


/* Application Global */
    /* Globals.!WpThreadStarted= Is WP thread running?  */
                         /* Modified in: Init, Fini     */

return
/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
Init:
    Globals.!WPThreadStarted = 1
    call VRMethod "Application", "PutVar", "Globals.!WPThreadStarted"
    call InitDescribe

    window = VRWindow()
    call VRMethod window, "CenterWindow", "Desktop"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
    drop window
return

/*:VRX         InitDescribe
*/
InitDescribe:
    Globals.!Windows = 0
    Globals.!WPCaption = "DeScribe" Initargs.1
    Globals.!WPName = "Describe"
    Globals.!WPDDEName = "DeScribe"
    this = VRGet( "Application", "Program" )
    Globals.!SampleDocument = VRParseFileName( this, "DP" ) || "sample.dsc"
return


/*:VRX         OpenFile
*/
OpenFile:procedure expose Globals.
    parse arg file
    call Status "Opening File" file "through DDE"

    if \WPRunning() then do
        error = "WordProcessor not running"
        signal OpenFile_Error
    end

    WPCtrl = VRGet( "DDEC_WPCtrl", "Self" )
    WPData = VRGet( "DDEC_WPData", "Self" )

    call Status "Connecting to"  Globals.!WPName 

    success = DDEInit( WPCtrl, Globals.!WPDDEName, "System" )
    if word( success, 1 )<>"Success:" then do
        error = "Cannot connect to System Topic"
        signal OpenFile_Error
    end

    if \VRFileExists( file ) then do
        error = "Cannot find file" file
        signal OpenFile_Error
    end

    call Status "Loading document" file
    call DDEExecB WPCtrl, 'Open("' || file || '")'

    /*  Establish a conversation with the document
    */
    call Status "Connecting to" file
    success = DDEInit( WPData, Globals.!WPDDEName, file )
    if word( success, 1 ) <> "Success:" then do
        error = "Could not connect to file topic."
        signal OpenFile_Error
    end
    Globals.!WPOpenFile = file
    call Status "Connected to" file
return 1


  OpenFile_Error:
    call Status error
return 0
/*:VRX         OpenWP
*/
OpenWP:procedure expose Globals.
    parse arg wpPath

    wp = Globals.!WPName

    call Status "Opening" wp

    if \VRFileExists( wpPath ) then do
        error = wp "not found at:" wpPath
        signal OpenWP_error
    end

    if WPRunning() then do
        error = "Window Already Exists!"
        signal OpenWP_error
    end

    objectid = "<___"wp"___>"
    setup = "EXENAME="wpPath";"||, 
            "OPEN=DEFAULT;"||,
            "OBJECTID="objectid";"

    if Globals.!Windows=1 then do
        setup = setup || "PROGTYPE=WINDOWEDWIN;"
    end

    ok = SysCreateObject( "WPProgram", wp , "<WP_NOWHERE>", setup, "R" )
    if \ok then do
        error = "Create failed"
        signal OpenWP_error
    end

    window = ""
    do i = 30 to 0 by -1 while window=""
        call Status "Waiting for" wp "at" wpPath "to open:" i
        call syssleep 2
        window = VRMethod( "Screen", "FindWindow", Globals.!WPCaption, "Desktop")
    end
    call status "Opened" wp 
return 1

  OpenWP_error:
     call Status error
return 0
/*:VRX         PrintFile
*/
PrintFile: 
    call DDEExecB "DDEC_WPData", 'Print("' || Globals.!WPOpenFile || '")'
    call SendKeys "Print Options", "{Alt}P", 10
    call SendKeys "Print Options", "{Enter}", 10
return

/*:VRX         Quit
*/
Quit:
    ok = CloseWP()
    if ok then do
        window = VRWindow()
        call VRSet window, "Shutdown", 1
        drop window
    end
return

/*:VRX         SendKeys
*/
SendKeys:procedure
/*
    ok = SendKeys( caption, keys, timeout )

    - Wait for a window with caption "caption" to become
    active then send keys "keys".
*/
    parse arg targetCaption, keys, timeout
    retVal = 0
    if targetCaption \= "" then do
        ok = SKWait( targetCaption, timeout )
        if \ok then do
            call Error 'Unable to send "' || keys || '" to' targetCaption 'in' timeout 'seconds.'
            signal SendKeysDone
        end
    end
    ok = VRMethod( "Application", "SendKeyString", '', keys )
    if \ok then signal SendKeysDone
    call SysSleep 1
    retVal = 1
SendKeysDone:
exit retVal

/*:VRX         SendText
*/
SendText:procedure expose Globals.
    parse arg text

    if VRParseFileName( translate(Globals.!WPOpenFile), "DPNE" ),
       <>VRParseFileName( translate( Globals.!SampleDocument), "DPNE" ) then do
        call VRMessage VRWindow(), "This feature only works with sample document."
        error = "Requires Sample Document"
        signal SendText_error
    end

    WPData = VRGet( "DDEC_WPData", "Self" )
    ok = VRMethod( WPData, "Poke", "Text", text )

    if ok<>"OK" then do
        error = "Error sending text."
        signal SendText_Error
    end
    
    call status "Sent Text"
return 1

  SendText_Error:
    call status error
return 0
/*:VRX         SKWait
*/
/*  
    ok = SKWait( caption, timeout )

    - Wait for a specified window to become active
    - Only compares up to length of <caption> so titles that change when MDI
    windows are maximized are still found.
*/
SKWait: procedure
    parse arg targetCaption, timeout
    ok = 0

    do timeout
        hwnd = VRMethod( "Screen", "FindWindow", targetCaption, "Desktop", "descendents", "mixed", "substring" )

        call SysSleep 1
        if hwnd<> "" then do
            ok=1
            call VRMethod hwnd, "Activate"
            signal SKWFound
        end
    end

SKWFound:
return ok

return

/*:VRX         Status
*/
Status: 
    call VRSet "DT_1", "Caption", arg(1)
return

/*:VRX         WPRunning
*/
WPRunning:procedure expose Globals.
    handle = FindWPWin()
return handle<>""
