/*
 *  MERGREC.C   - Merge two Nethack record files
 *
 *                Jukka Lahtinen 1993-2002
 *
 *  MERGREC infile1 [infile2 [outfile]]
 *
 *              - infile1 & infile 2 : files to be merged
 *              - if only one file specified, use the file 'record' in
 *	              the current work directory as infile2
 *              - if outfile is not specified, write to stdout
 *              - As a result of infile2 being optional, outfile may only be
 *                specified when infile2 is also specified. Otherwise you may
 *    	          redirect or pipe the output with > or |.
 *
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#if defined (__MSDOS__) || defined (__OS2__)
  #include <conio.h>
#endif
#ifdef unix
  #define stricmp strcasecmp
  #include <curses.h>
#endif

#define MAXDUP 3     /* How many scores of one name/character */
#define SCORECNT 100 /* Max number of scores in output file */

long lue (FILE *in,char rivi1[],size_t pit,FILE *out,
	  int *take, int *pass,char *rivi2,int *sama);

int main (int argc, char *argv[])
{
 FILE *in1,
      *in2,
      *out;

#if defined(__unix__)
 char *fin2 = "/usr/games/lib/nethackdir/record";
#else
 char *fin2 = "record";
#endif

 char rivi1[256]={0},
      rivi2[256]={0};
 long score1,
      score2;
 int  pass1=0,
      pass2=0,
      sama1=0,
      sama2=0,
      take1=0,
      take2=0,
      outlkm=0;

 if (argc < 2 || argv[1][0]=='?' || argv[1][1]=='?' || argc > 4) {
   printf ("%s infile1 [infile2 [outfile]]\n\n", argv[0]);
   printf ("Merge Nethack 3.3 record files infile1 and infile2\n");
   printf ("If infile2 is not specified, record is used.\n");
   printf ("If outfile is not specified, stdout is used.\n");
   exit (1);
 }

 if (argc > 2)
    fin2 = argv [2];

 if (!(in1=fopen(argv[1],"r"))) {
    fprintf (stderr,"Can't open input file %s\n",argv[1]);
    exit (2);
 }
 if (!(in2=fopen(fin2,"r"))) {
    fprintf (stderr,"Can't open input file %s\n",fin2);
    exit (2);
 }

 if (argc > 3) {
    if (!(out=fopen(argv[3],"w"))) {
       fprintf (stderr,"Can't open output file %s\n", argv[3]);
       exit (4);
    }
 }
 else
     out=stdout;
 score1= lue(in1,rivi1,sizeof(rivi1),out,&take1,&pass1,rivi2,&sama1);
 score2= lue(in2,rivi2,sizeof(rivi2),out,&take2,&pass2,rivi1,&sama2);

 while (!(feof(in1) && feof(in2)) && outlkm<SCORECNT) {
    if (score1 > score2 && !feof(in1)) {
       score1= lue(in1,rivi1,sizeof(rivi1),out,&take1,&pass1,rivi2,&sama1);
    }
    else if (!feof(in2)) {
       score2= lue(in2,rivi2,sizeof(rivi2),out,&take2,&pass2,rivi1,&sama2);
    }
    outlkm++;
 }

 fclose (in1);
 fclose (in2);
 if (argc > 3)
    fclose (out);

 fprintf (stderr,"%s: selected %d",argv[1],take1);
 if (pass1)
    fprintf (stderr,", smaller passed %d",pass1);
 if (sama1)
    fprintf (stderr,", identical passed %d",sama1);
 fprintf (stderr,"\n%s: selected %d",fin2,take2);
 if (pass2)
    fprintf (stderr,", smaller passed %d",pass2);
 if (sama2)
    fprintf (stderr,", identical passed %d",sama2);
 fprintf (stderr,"\n");
 return 0;
}


/* Read the next output line from either input file */

long lue (FILE *in,char rivi[],size_t pit,FILE *out,
         int *take,int *pass,char *rivi2,int *sama)
{
 long score=0;
 char hahmo[4],
      nimi[21];
 int  i,j;
 int  vermaj,vermin;
 struct alkio {    /* Count scores of each name/character here */
   char tnimi[21]; /* not to write more than 3 (or whatever)   */
   char thahmo[4];
   long minscore;
   int  kpl;
 };

 static struct alkio taulu[SCORECNT]={{0,0,0,0,0}};

 if (feof(in)) {
    return -1L;
 }

 /* Increment the counter and output the previous line */
 /* sscanf (rivi,"%*ld %*d %*d %*d %*d %*d %*d %ld %c%*c",
        &score,&hahmo);    3.1 */
 if (rivi[0]) {
   /* sscanf (rivi,"%*9s %ld %*d %*d %*d %*d %*d %*d %*ld %*ld %*d %c",
      &score,&hahmo); */       /* 3.2 */
   sscanf(rivi,
   "%d.%d.%*d %ld %*d %*d %*d %*d %*d %*d %*ld %*ld %*d %3s %*s %*s %*s %[^,]",
	  &vermaj,&vermin,&score,hahmo,nimi);  /* 3.3 */
 }

 if (score>0L && vermaj==3 && vermin>=3) {
   i=0;
   while ((strcmp(taulu[i].tnimi,nimi) || (strcmp(taulu[i].thahmo,hahmo)))
	  && i < SCORECNT-1)
     i++;
   if (taulu[i].kpl++ >= MAXDUP)
     (*pass)++;
   else {
     fprintf (out,"%s\n",rivi);
     (*take)++;
   }
 }

 while (1) {
    fgets(rivi,pit,in);
    if (feof(in)) {
       score=-1L;
       return score;
    }
    sscanf(rivi,
   "%d.%d.%*d %ld %*d %*d %*d %*d %*d %*d %*ld %*ld %*d %3s %*s %*s %*s %[^,]",
	  &vermaj,&vermin,&score,hahmo,nimi);  /* 3.3 */
    /* sscanf (rivi,"%*9s %ld %*d %*d %*d %*d %*d %*d %*ld %*ld %*d %c",
       &score,&hahmo);  */      /* 3.2 */
    if (vermaj != 3 || vermin > 4) {    /* NOT 3.3 or 3.4 */
      printf ("Not a 3.3 version scorefile!\n%s\n",rivi);
      score=0L;
    }


    /* Search for the name & character in the table */
    /* If 'kpl' becomes zero, an empty item was found in the table */
    i=0;
    while (i < SCORECNT-1 && taulu[i].thahmo[0] &&
        (strcmp(taulu[i].tnimi,nimi) || taulu[i].thahmo != hahmo))
          i++;

    if (taulu[i].kpl >= MAXDUP) {
       (*pass)++;
       continue;
    }

    /* Entries from a dos version end with \r\n, and those from a unix
       version end with just \n. So let's remove all whitespaces from
       the end of the line */
    j=strlen(rivi)-1;
    while (j>5 && isspace(rivi[j])) {
      rivi[j]=0;
      j--;
    }

    if (!strcmp(rivi,rivi2)) {
       (*sama)++;
       continue;
    }

    break;
 }

 if (!taulu[i].kpl) {
    strcpy (taulu[i].tnimi,nimi);
    strcpy (taulu[i].thahmo,hahmo);
 }

 return score;
}
