/***
 This file belongs to the Xened distribution.
 Copyright (C) 1995-2001 Thorsten Thielen <thth@gmx.net>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ***/
/*
 * misc.c - Xened
 */

#include "xened.h"

/*************************************************************************/

extern PTILEBOX   ptboxFont;

/*************************************************************************/

VOID draw_stone (USHORT x1, USHORT y1, USHORT x2, USHORT y2, USHORT col3,
                 USHORT col1, USHORT col2)
{
    GFX_BOX (x1+1, y1+1, x2-1, y2-1, col3);
    ShadowRect (x1, y1, x2, y2, col1, col2);
}
/*************************************************************************/

VOID ShadowRect (USHORT x1, USHORT y1, USHORT x2, USHORT y2, USHORT col1,
                 USHORT col2)
{
    GFX_LINE (x1,y1,x2,y1,col1);
    GFX_LINE (x2,y1,x2,y2-1,col1);

    GFX_LINE (x2,y2,x1,y2,col2);
    GFX_LINE (x1,y2,x1,y1+1,col2);
}
/*************************************************************************/

VOID Rect (USHORT x1, USHORT y1, USHORT x2, USHORT y2, USHORT col)
{
    GFX_LINE (x1,y1,x2,y1,col);
    GFX_LINE (x2,y1,x2,y2,col);
    GFX_LINE (x2,y2,x1,y2,col);
    GFX_LINE (x1,y2,x1,y1,col);
}
/*************************************************************************/

VOID write_anz (USHORT anz, FILE *map_file)
{
    if (anz > 255)
    {
        while (anz > 255)
        {
            fputc (0x00, map_file);
            fputc (0xff, map_file);
            anz -= 0xff;
        }
        fputc (0x00, map_file);
        fputc (anz, map_file);
    }
    else
        fputc (anz,map_file);
}
/*************************************************************************/

BOOL message (PSZ psz, USHORT usColor, USHORT xo, USHORT yo)
{
    BOOL     fNoSave = FALSE;
    PBYTE    pb;
    SHORT    kcode;
    USHORT   x, y;

    if (! (pb = (PBYTE) malloc (MSG_XS*MSG_YS)))
        fNoSave = TRUE;
    else
    {
        /*** Save background ***/
        GFX_LOCK ();
        for (y = 0; y < MSG_YS; y++)
            for (x = 0; x < MSG_XS; x++)
                pb[y*MSG_XS+x] = GFX_GET (xo+x, yo+y);
        GFX_UNLOCK ();
    }
    
    /*** Draw window & text ***/
    GFX_LOCK ();
    draw_stone (0+xo, 0+yo, MSG_XS-1+xo, MSG_YS-1+yo, LIGHTGRAY,
                WHITE, DARKGRAY);
    draw_stone (4+xo, 4+yo, MSG_XS-4+xo, MSG_YS-4+yo, usColor, DARKGRAY, WHITE);
    draw_stone (8+xo, 8+yo, MSG_XS-8+xo, MSG_YS-8+yo, BLACK, WHITE, DARKGRAY);

    show_string (ptboxFont, psz, 11+xo, 10+yo, MSG_XS-20);
    GFX_UNLOCK ();

#ifdef __LINUX__
    do { } while (_read_kbd (0, 0, 0) != 13);
#else
    kcode = _read_kbd (0, 1, 0);
    if (kcode == 0)
        kcode = _read_kbd (0, 0, 0);
#endif

    if (! fNoSave)
    {
        /*** Restore background ***/
        GFX_LOCK ();
        for (y = 0; y < MSG_YS; y++)
            for (x = 0; x < MSG_XS; x++)
                GFX_SET (xo+x, yo+y, pb[y*MSG_XS+x]);
        GFX_UNLOCK ();
        free (pb);
    }
    
    if (fNoSave)
        return (FALSE);

    return (TRUE);
}
/*************************************************************************/
