/* Flight Planning Database Structure */

struct _waypoint {
    char name[25];
    char state[3];
    char abbrev[4];
    char lat[10];
    char lng[10];
    char elev[4];
    char categ[3];
    char var[5];
    char atis[5];
    char afis[5];
    char pal[5];
    char vor[5];
    char dmei[5];
    char dme[2];
    char ndb[3];
    char bcst[4];
    char rwinfo[30];
};

typedef struct _waypoint *PWAYPOINT;

typedef struct _aircraft {
    char Callsign[6];
    char type[11];
    char Tas[3];
    char Clias[3];
    char Navaids[25];
    char HireRate[7];
    char Seats[2];
    char CapacityMains[6];
    char CapacityAuxs[6];
    char CapacityTips[6];
    char CapacityOther[6];
    char ConsumCruise[5];
    char ConsumClimb[5];
    char ConsumTaxi[5];
    char ConsumHold[5];
    char FuelType[6];
    char EmptyWeight[8];
    char MaxAllUpWeight[8];
    char MaxTakeoffWeight[8];
    char MaxLandingWeight[8];
    char MaxBaggageWeight[3][6];
    char VHFRadio[2];
    char HFRadio[2];
    char Xpdr;
    char SurvivalEquipment[14];
    char ELB[2];
    char RateOfClimb[4];
    char Company[18];
    char OperatingCategory[2];
} AIRCRAFT;

typedef AIRCRAFT *PAIRCRAFT;

typedef struct _wind {
    int Dir;
    char Strength;
} WIND;

typedef WIND *PWIND;

typedef struct {
    WIND a020;
    WIND a050;
    WIND a070;
    WIND a100;
    WIND a140;
    WIND a185;
} WINDS;

typedef WINDS *PWINDS;

typedef struct {
    PWAYPOINT from;
    PWAYPOINT to;
    USHORT lsalt;
    USHORT floralt;
    USHORT tas;
    double track;
    WIND wind;
    double heading;
    double gs;
    double eti;
    char FltProc[25];
} SEGMENT;

typedef SEGMENT *PSEGMENT;

typedef struct _plan {
    HWND hwndFrame;
    PAIRCRAFT Aircraft;
    char Category[2];
    char OperationType[3];
    char Priority[3];
    PSEGMENT DeparturePoint;
    char FlightNumber[8];
    char etd[10];
    char OtherInfo[128];
    int POB;
    char Captain[16];
} PLAN;

typedef PLAN *NPPLAN;

#define NPPLANFROMCLIENT(hwndClient) ((NPPLAN)WinQueryWindowUShort(\
	hwndClient,QWS_USER))
