/* A sample PM application showing use of an object window */
/* operated by thread 2 for time-consuming tasks */

/* OS/2 includes */
#define INCL_DOSPROCESS
#define INCL_WIN
#include <os2.h>

/* C includes */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

/* App includes */
#include "ows.h"
#include "pmassert.h"

/* Main entry point for thread 1 */
int main(void)
{
    APIRET      rc;
    BOOL        fSuccess;
    HAB         hab;
    HMQ         hmq;
    HWND        hwndClient;
    HWND        hwndFrame;
    QMSG        qmsg;
    ULONG       flCreate;
    PGLOBALS    pg;

    /* PM App initialization */
    hab = WinInitialize(0);
    hmq = WinCreateMsgQueue(hab,0);
    assert(hmq);

    /* Register client window class with 4 bytes of window words to hold a pointer
        to globals */
    fSuccess = WinRegisterClass(hab, OWS_CLASS_CLIENT, (PFNWP)ClientWinProc,
                CS_SIZEREDRAW | CS_CLIPCHILDREN, sizeof(PGLOBALS));
    pmassert(hab, fSuccess);

    /* Standard window create; returns after WM_CREATE processing finishes */
    flCreate = FCF_STANDARD &~FCF_ACCELTABLE /* & ~FCF_ICON */;

    hwndFrame = WinCreateStdWindow(HWND_DESKTOP,
                    WS_VISIBLE,
                    &flCreate,
                    OWS_CLASS_CLIENT,
                    OWS_TITLE,
                    0,
                    0,
                    ID_OWS,
                    &hwndClient);

    pmassert(hab, hwndFrame);
    pmassert(hab, hwndClient);
    pg = (PGLOBALS) WinQueryWindowULong(hwndClient, QWL_USER);

    while(WinGetMsg(hab, &qmsg, 0, 0, 0))
        WinDispatchMsg(hab, &qmsg);

    /* Wrap up */
    WinDestroyWindow(hwndFrame);
    WinDestroyMsgQueue(hmq);
    WinTerminate(hab);

    rc = DosWaitThread(&pg->tidObject, DCWW_WAIT);
    assert(rc == 0);

    return 0;
}


/* Client window procedure */
MRESULT EXPENTRY ClientWinProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    HAB         hab;
    HPS         hps;
    PGLOBALS    pg;
    RECTL       rectl;
    ULONG       ulWork;

    /* Get pointer to globals from window words */
    pg = (PGLOBALS)WinQueryWindowULong(hwnd, QWL_USER);

    switch(msg) {
        case WM_CLOSE:
            /* Tell object window to quit, then exit its thread */
            WinPostMsg(pg->hwndObject, WM_QUIT, 0, 0);
            return (MRESULT) 0;
            break;

        case WM_COMMAND:
            switch(SHORT1FROMMP(mp1)) {
                case IDM_SLEEP:     /* Disable client for this lengthy task */
                    WinSendMsg(hwnd, WM_USER_DISABLE, 0L, 0L);
                    /* Object window is busy now */
                    pg->fBusy = TRUE;
                    /* Tell object window to perform lengthy task */
                    WinPostMsg(pg->hwndObject, WM_USER_SLEEP, (MPARAM)hwnd, 0);
                    /* Wait for acknowledgement */
                    break;
            }
            return (MRESULT) 0;
            break;

        case WM_CREATE:
            hab = WinQueryAnchorBlock(hwnd);
            /* Allocate memory for global variables */
            pg = (PGLOBALS) malloc(sizeof(GLOBALS));
            pmassert(hab, pg);

            /* Initialize globals to zero */
            memset(pg, 0, sizeof(GLOBALS));
            /* Store globals pointer into client window words */
            WinSetWindowULong(hwnd, QWL_USER, (ULONG)pg);

            /* Disable until object window initializes */
            WinSendMsg(hwnd, WM_USER_DISABLE, 0, 0);

            /* *LAB* Initialize globals with important data */





            /* *LAB* Create thread 2 for object window; pass pointer to globals */

            pmassert(hab, pg->tidObject);
            return (MRESULT) 0;
            break;

        case WM_MOUSEMOVE:
            /* If busy, display the wait pointer, else the arrow pointer */
            ulWork = pg->fBusy ? SPTR_WAIT : SPTR_ARROW;
            WinSetPointer(HWND_DESKTOP, WinQuerySysPointer(HWND_DESKTOP, ulWork, FALSE));
            return (MRESULT) TRUE;
            break;

        case WM_PAINT:
            hps = WinBeginPaint(hwnd, 0, &rectl);
            WinFillRect(hps, &rectl, SYSCLR_WINDOW);
            WinEndPaint(hps);
            return (MRESULT) 0;
            break;

        case WM_USER_ACK:
            /* Object window has completed which task? */
            switch ((ULONG) mp1) {
                case WM_USER_SLEEP:
                    WinMessageBox(HWND_DESKTOP,
                        pg->hwndFrame,
                        "Done",
                        OWS_TITLE,
                        0,
                        MB_CANCEL);
                    break;
            }
            WinSendMsg(hwnd, WM_USER_ENABLE, 0, 0);
            /* Object window is not busy any more */
            pg->fBusy = FALSE;
            return (MRESULT) 0;
            break;

        case WM_USER_DISABLE:
            /* This message sent by client */
            WinEnableWindow(pg->hwndClient, FALSE);
            /* This is a macro defined in pmwin.h */
            WinEnableMenuItem(pg->hwndMenubar, IDM_SLEEP, FALSE);
            return (MRESULT) 0;
            break;

        case WM_USER_ENABLE:
            /* This message sent by client */
            WinEnableWindow(pg->hwndClient, TRUE);
            /* This is a macro defined in pmwin.h */
            WinEnableMenuItem(pg->hwndMenubar, IDM_SLEEP, TRUE);
            return (MRESULT) 0;
            break;

        default:
            return WinDefWindowProc(hwnd, msg, mp1, mp2);
    }
}


