/* subclass.c - Subclass a list box to use it as a main window and process */
/* menu selections */

#define INCL_WIN

#include <os2.h>

#include "subclass.h"

static PFNWP pfnListBox;
static PFNWP pfnwpOldFrame;
#define WC_UDFPLAN "UDFplan"

MRESULT EXPENTRY UDFplanWndProc(HWND hwnd, ULONG ulMessage, MPARAM mp1, MPARAM mp2);
MRESULT EXPENTRY UDFrameWndProc(HWND hwnd, ULONG ulMessage, MPARAM mp1, MPARAM mp2);

/* Use these strings to fill the list box */
char *strings[] = {"Bankstown",
    "West Maitland",
    "Port Maquarie",
    "Coffs Harbour",
    "Grafton",
    "Coolangatta",
    "Brisbane",
    "Gladstone",
    "Rockhampton",
    "Cairns",
    NULL};

main()
{
    SHORT i;
    HAB hab;
    HMQ hmq;
    QMSG qmsg;
    HWND hwndFrame, hwndClient;

    ULONG fcflags = FCF_STANDARD & ~FCF_ACCELTABLE & ~FCF_ICON;

    hab = WinInitialize(0);

    hmq = WinCreateMsgQueue(hab, 0);

    /* *LAB* Create a regular frame and client window */











    /* *LAB* Now subclass both the client and frame windows */



    /* *LAB* Set the frame as the owner of the client */

    /* Fill the list box with items */
    i = 0;
    while(strings[i]) {
	WinPostMsg(hwndClient,LM_INSERTITEM, MPFROMSHORT(i),MPFROMP((PSZ)strings[i]));
	i++;
    }

    while (WinGetMsg(hab, &qmsg, NULL, 0, 0))
	WinDispatchMsg(hab, &qmsg);

    WinDestroyWindow(hwndFrame);
    WinDestroyMsgQueue(hmq);
    WinTerminate(hab);
}

MRESULT EXPENTRY UDFplanWndProc(HWND hwnd, ULONG ulMessage, MPARAM mp1, MPARAM mp2)
{

    USHORT sel;

    switch(ulMessage) {
	case WM_COMMAND:
	    switch((USHORT)SHORT1FROMMP(mp1)) {
		case IDM_EXIT:
		    WinPostMsg(hwnd, WM_QUIT, mp1, mp2);
		    break;
		case IDM_WPTDEL:
		    sel = (USHORT)WinSendMsg(hwnd,
			    LM_QUERYSELECTION,
			    MPFROMSHORT(LIT_NONE),
			    0L);
		    WinPostMsg(hwnd, LM_DELETEITEM, MPFROMSHORT(sel), 0L);
		    /* Code to delete item from underlying data structure goes here */
		    break;
		default:
		    return pfnListBox(hwnd, ulMessage, mp1, mp2);
	    }
	default:
	    return pfnListBox(hwnd, ulMessage, mp1, mp2);
    }
    return 0L;
}

/* Subclass the frame as control messages from the dialog box will be sent to it */

MRESULT EXPENTRY UDFrameWndProc(HWND hwnd, ULONG ulMessage, MPARAM mp1, MPARAM mp2)
{
    USHORT id;

    switch(ulMessage) {
	case WM_CLOSE:
	    WinPostMsg(hwnd, WM_QUIT, mp1, mp2);
	    break;
	case WM_CONTROL:
	    switch((USHORT)SHORT2FROMMP(mp1)) {
		case LN_ENTER:
		    id = SHORT1FROMMP(mp1);
		    id = (USHORT)WinSendMsg(WinWindowFromID(hwnd, id), LM_QUERYSELECTION, 0, 0);
		    WinMessageBox(hwnd,
				    hwnd,
				    strings[id],
				    "User Selected",
				    IDW_DEBUG,
				    MB_ICONASTERISK | MB_ENTER);
		default:
		    return pfnwpOldFrame(hwnd, ulMessage, mp1, mp2);
	    }
	default:
	    return pfnwpOldFrame(hwnd, ulMessage, mp1, mp2);
    }
}
