#define PROGNAME "Chart/2"
#define VERNUM  "Version 0.5"

#define WC_CHART2 "Chart2"
#define WC_CHART  "Chart"
#define WC_SCRLCHART "ScrlChart"

/* Constants */
#define TOOLBARHEIGHT   60
#define TOOLBARWIDTH    80
#define CTOOLS          8

/* Window and control identifiers */
#define ID_MAIN             0x0100
#define ID_TOOLBAR          0x0200
#define ID_CHART            0x0300
#define ID_VERTSCROLL       0x0301
#define ID_HORZSCROLL       0x0302
#define ID_AUSTRALIA_SEG    0x0380
#define ID_NAME_SEG         0x0381
#define ID_APT_SEG          0x0382

/* Menu ID's */
#define IDM_FILE            0x0101
#define IDM_NEW             0x0102
#define IDM_OPEN            0x0103
#define IDM_SAVE            0x0104
#define IDM_EXIT            0x0105
#define IDM_EDIT            0x0110
#define IDM_UNDO            0x0111
#define IDM_CUT             0x0112
#define IDM_COPY            0x0113
#define IDM_PASTE           0x0114
#define IDM_INSERT          0x0115
#define IDM_DELETE          0x0116

#define IDM_HELP            0x01F0
#define IDM_HINDEX          0x01F1
#define IDM_HGENERAL        0x01F2
#define IDM_HUSING          0x01F3
#define IDM_HEXTENDED       0x01F4
#define IDM_HABOUT          0x01F5

/* Popup menu ID's */
#define IDMP_AFTER          0x0401
#define IDMP_BEFORE         0x0402
#define IDMP_DELETE         0x0403
#define IDMP_EDIT           0x0404

#define   MID_TOOLBAR    200
#define   MID_TB_1       201
#define   MID_TB_2       202
#define   MID_TB_3       203
#define   MID_TB_4       204
#define   MID_TB_5       205
#define   MID_TB_6       206
#define   MID_TB_7       207
#define   MID_TB_8       208
#define   MID_TB_9       209
#define   MID_TB_10      210

/* Bitmap ID's */
#define IDBM_APT            0x0500

/* User-defined messages */
#define UM_INITSIZE     WM_USER
#define UM_ZOOM         WM_USER+1
#define UM_MOOZ         WM_USER+2

typedef struct _PLAN {
    HWND hwndToolbar;
    HWND hwndChart;
    HWND hwndVScroll;
    HWND hwndHScroll;
} PLAN, *PPLAN;

#define PPLANFROMHWND(hwnd) (PPLAN)WinQueryWindowPtr((hwnd), 0)

typedef struct
{
    PSZ     to;                         // Next waypoint
    ULONG   lsalt;                      // Lowest safe altitude
    PSZ     fl;                         // Flight level
    PSZ     tas;                        // True airspeed
    PSZ     trmag;                      // Track (magnetic)
    PSZ     wind;                       // Wind
    PSZ     hdgmag;                     // Heading (magnetic)
    PSZ     gs;                         // Ground speed
    PSZ     dist;                       // Distance
    PSZ     eti;                        // Estimated time interval
    PSZ     plnest;                     // Planned eta
    PSZ     routequal;                  // Route qualifier
}  PLANREC, *PPLANREC;

